/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.lib.java.Assert;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;

public class EOSectionAndPlanModifications
extends EOEncodableObject {
    public static final String XML_NAME = "frame.sectionandplanmodification";
    private static final String XML_ROLE_ADDED_SECTIONS = "addedSections";
    private static final String XML_ROLE_MODIFIED_SECTIONS = "modifiedSections";
    private static final String XML_ROLE_DELETED_SECTIONS = "deletedSections";
    private EOList<EOSection> addedSections = new EOList("addedSections");
    private EOList<EOSection> modifiedSections = new EOList("modifiedSections");
    private EOList<EOSection> deletedSections = new EOList("deletedSections");
    private EOFrameDataModification<EOPlan> planModifications = new EOFrameDataModification("com.arcway.cockpit.plan", new EOList(), new EOList(), new EOList());

    public EOSectionAndPlanModifications() {
        super(XML_NAME);
    }

    public EOSectionAndPlanModifications(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    protected boolean setAttributeFromXML(String name, String value) {
        return true;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.addedSections.writeXMLBody(writeContext, depth);
        this.modifiedSections.writeXMLBody(writeContext, depth);
        this.deletedSections.writeXMLBody(writeContext, depth);
        if (this.planModifications != null) {
            this.planModifications.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        assert (newChild instanceof EOList || newChild instanceof EOFrameDataModification);
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            String role = list.getRole();
            if (role.equals(XML_ROLE_ADDED_SECTIONS)) {
                this.addedSections = list;
            } else if (role.equals(XML_ROLE_MODIFIED_SECTIONS)) {
                this.modifiedSections = list;
            } else if (role.equals(XML_ROLE_DELETED_SECTIONS)) {
                this.deletedSections = list;
            }
        } else if (newChild instanceof EOFrameDataModification) {
            this.planModifications = (EOFrameDataModification)newChild;
        }
        return true;
    }

    public Collection<EOPlan> getAllExistingAndModifiedPlans() {
        ArrayList<EOPlan> allPlans = new ArrayList<EOPlan>();
        if (this.planModifications != null) {
            allPlans.addAll((Collection<EOPlan>)this.planModifications.getCreatedData());
            allPlans.addAll((Collection<EOPlan>)this.planModifications.getModifiedData());
        }
        return allPlans;
    }

    public EOList<EOSection> getAddedSections() {
        return this.addedSections;
    }

    public void setAddedSections(EOList<EOSection> addedSections) {
        assert (Assert.checkArgumentBeeingNotNull(addedSections));
        addedSections.setRole(XML_ROLE_ADDED_SECTIONS);
        this.addedSections = addedSections;
    }

    public EOList<EOSection> getModifiedSections() {
        return this.modifiedSections;
    }

    public void setModifiedSections(EOList<EOSection> modifiedSections) {
        assert (Assert.checkArgumentBeeingNotNull(modifiedSections));
        modifiedSections.setRole(XML_ROLE_MODIFIED_SECTIONS);
        this.modifiedSections = modifiedSections;
    }

    public EOList<EOSection> getDeletedSections() {
        return this.deletedSections;
    }

    public void setDeletedSections(EOList<EOSection> deletedSections) {
        assert (Assert.checkArgumentBeeingNotNull(deletedSections));
        deletedSections.setRole(XML_ROLE_DELETED_SECTIONS);
        this.deletedSections = deletedSections;
    }

    public EOFrameDataModification<EOPlan> getPlanModifications() {
        return this.planModifications;
    }

    public void setPlanModifications(EOFrameDataModification<EOPlan> planModifications) {
        assert (Assert.checkArgumentBeeingNotNull(planModifications));
        assert (planModifications.getRole().equals("com.arcway.cockpit.plan"));
        this.planModifications = planModifications;
    }
}

