/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.interFace;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.clientadapter.interFace.ILabel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;

public class Label
implements ILabel {
    private static final ILogger logger = Logger.getLogger(Label.class);
    public static final Locale[] LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN};
    private final Locale locale;
    private final String label;
    private final IStreamResource icon16x16;

    public static ILabel[] createLabels(Class<?> messagesClass, String labelID, IStreamResource icon16x16) {
        ArrayList<Label> labels = new ArrayList<Label>(LOCALES.length);
        Locale[] localeArray = LOCALES;
        int n = LOCALES.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            try {
                Method getString = messagesClass.getMethod("getString", String.class, Locale.class);
                String label = (String)getString.invoke(messagesClass, labelID, locale);
                labels.add(new Label(locale, label, icon16x16));
            }
            catch (SecurityException e) {
                logger.error("can't call getString()", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("can't call getString()", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error("can't call getString()", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("can't call getString()", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error("can't call getString()", (Throwable)e);
            }
            ++n2;
        }
        ILabel[] labelsAsArray = labels.toArray(new ILabel[0]);
        return labelsAsArray;
    }

    public Label(Locale locale, String label, IStreamResource icon16x16) {
        this.locale = locale;
        this.label = label;
        this.icon16x16 = icon16x16;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public IStreamResource getIcon16x16() {
        return this.icon16x16;
    }
}

