/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.manager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeRegistration;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTBoolean;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTCounter64Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDateUTC64Bitmsec;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDisplayName;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDuration64Bitmsec;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFile;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFloat64BitIEEE754;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeString;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeText;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTInteger32Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTInteger64Bit;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTLocale;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTMultipleChoice;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTPrefixIDFormat;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTSingleChoice;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTUID;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTURL;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTUserReference;
import com.arcway.frontend.definition.lib.interFace.declaration.IFrontendDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.IFrontendNonLocalizedModuleTypeDeclaration;
import com.arcway.frontend.definition.lib.interFace.declaration.label.FrontendLabel;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.arrays.ArrayUtils;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.repository.clientadapter.implementation.adapter.CustomPropertyTypeID;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterModuleTypeDeclaration;
import com.arcway.repository.clientadapter.implementation.manager.FENonLocalizedModuleTypeDeclaration;
import com.arcway.repository.clientadapter.implementation.manager.GMModuleTypeDeclaration;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterDataType;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterDataTypeID;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterRootModule;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.interFace.IRelationContributionType;
import com.arcway.repository.clientadapter.interFace.IRelationTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeRegistration;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import com.arcway.repository.lib.high.genericmodifications.interFace.declaration.GenericModificationModuleTypeDeclaration;
import com.arcway.repository.lib.high.genericmodifications.interFace.declaration.IGenericModificationDeclaration;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTCounter64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTPrefixIDFormat;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import com.arcway.repository.lib.high.registration.data.lib.RDTUserReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PlatformAdapterModuleManager
implements IFrontendDeclaration,
IGenericModificationDeclaration {
    private static final ILogger LOGGER = Logger.getLogger(PlatformAdapterModuleManager.class);
    private final IFrameProjectAgent projectAgent;
    private final Collection<IPlatformAdapterModule> adapterModules;
    private final Map<PlatformAdapterDataTypeID, PlatformAdapterDataType> dataTypeIDsToDataTypes;
    private final Locale projectLanguage;
    private ICollection_<IRepositoryDataTypeRegistration> dataTypeRegistrations;
    private IRepositoryTypeDeclaration rootRepositoryModuleTypeDeclaration;
    private ICollection_<IRepositoryModuleTypeDeclaration> dependentRepositoryModuleTypeDeclarations;
    private IMap_<IRepositoryModuleType, IFrontendNonLocalizedModuleTypeDeclaration> nonLocalizedModuleTypeDeclarations;
    private IMap_<IRepositoryModuleTypeID, GenericModificationModuleTypeDeclaration> genericModificationModuleTypeDeclarations;
    private final IPlatformAdapterRootModule rootModule;
    private final Map<String, Set<IDataManagerAdapter>> cockpitDataTypeIDToSetOfDataManagerAdapters;
    private final Map<String, IRepositoryObjectTypeID> cockpitDataTypeIDToMostAbstractRepositoryObjectType;
    private final Map<String, ISetRW_<IRepositoryObjectTypeID>> cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes;
    private final Map<IRepositoryPropertyType, IPropertyType> repositoryPropertyType2propertyTypeCache;
    private final IMapRW_<IRepositoryObjectTypeID, IObjectTypeDeclaration> iRepositoryObjectTypeID2dataManagerAdapterCache;
    private final IMapRW_<IRepositoryRelationTypeID, IRelationTypeDeclaration> iRepositoryRelationTypeID2relationTypeDeclarationCache;
    private IMap_<IRepositoryRelationTypeID, IOccurrenceManager> repositoryRelationTypeID2occurenceManagerCache = null;

    public PlatformAdapterModuleManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.projectLanguage = new Locale(projectAgent.getLanguage());
        IPlatformAdapterModule[] adapterModulesAsArray = projectAgent.getPlatformAdapterModules();
        this.adapterModules = new ArrayList<IPlatformAdapterModule>(adapterModulesAsArray.length);
        IPlatformAdapterModule[] iPlatformAdapterModuleArray = adapterModulesAsArray;
        int n = adapterModulesAsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformAdapterModule adapterModule = iPlatformAdapterModuleArray[n2];
            this.adapterModules.add(adapterModule);
            ++n2;
        }
        this.rootModule = this.calculateAdapterRootModule();
        this.dataTypeIDsToDataTypes = this.createDataTypes();
        this.repositoryPropertyType2propertyTypeCache = new HashMap<IRepositoryPropertyType, IPropertyType>();
        this.iRepositoryObjectTypeID2dataManagerAdapterCache = new HashMap_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        this.iRepositoryRelationTypeID2relationTypeDeclarationCache = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
        this.cockpitDataTypeIDToMostAbstractRepositoryObjectType = new HashMap<String, IRepositoryObjectTypeID>();
        this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes = new HashMap<String, ISetRW_<IRepositoryObjectTypeID>>();
        this.updateDeclarations();
        this.cockpitDataTypeIDToSetOfDataManagerAdapters = new HashMap<String, Set<IDataManagerAdapter>>();
        for (IPlatformAdapterModule adapterModule : this.adapterModules) {
            IDataManagerAdapter[] dataManagerAdapters;
            IDataManagerAdapter[] iDataManagerAdapterArray = dataManagerAdapters = this.getDataManagerAdaptersOfModule(adapterModule);
            int n3 = dataManagerAdapters.length;
            int n4 = 0;
            while (n4 < n3) {
                IDataManagerAdapter currentDataManagerAdapter = iDataManagerAdapterArray[n4];
                String cockpitDataTypeID = currentDataManagerAdapter.getCockpitDataTypeID();
                Set<IDataManagerAdapter> setOfDataManagerAdapters = this.cockpitDataTypeIDToSetOfDataManagerAdapters.get(cockpitDataTypeID);
                if (setOfDataManagerAdapters == null) {
                    setOfDataManagerAdapters = new HashSet<IDataManagerAdapter>();
                    this.cockpitDataTypeIDToSetOfDataManagerAdapters.put(cockpitDataTypeID, setOfDataManagerAdapters);
                }
                setOfDataManagerAdapters.add(currentDataManagerAdapter);
                ++n4;
            }
        }
    }

    private void updateDeclarations() {
        ArrayList_ dataTypeRegistrationsRW = new ArrayList_();
        for (PlatformAdapterDataType dataType : this.dataTypeIDsToDataTypes.values()) {
            dataTypeRegistrationsRW.add((Object)dataType.getRepositoryDataTypeRegistration());
        }
        this.dataTypeRegistrations = dataTypeRegistrationsRW;
        IPlatformAdapterRootModule adapterRootModule = this.getAdapterRootModule();
        IRepositoryAttributeSetTypeID basePropertiesAttributeSetTypeID = adapterRootModule.getBaseObjectTypeDeclaration().getPropertiesAttributeSetTypeID();
        this.rootRepositoryModuleTypeDeclaration = new PlatformAdapterModuleTypeDeclaration(adapterRootModule, this);
        ArrayList_ dependentRepositoryModuleTypeDeclarationsRW = new ArrayList_(this.adapterModules.size());
        for (IPlatformAdapterModule adapterModule : this.adapterModules) {
            if (adapterModule instanceof IPlatformAdapterRootModule) continue;
            dependentRepositoryModuleTypeDeclarationsRW.add((Object)new PlatformAdapterModuleTypeDeclaration(adapterModule, this, basePropertiesAttributeSetTypeID));
        }
        this.dependentRepositoryModuleTypeDeclarations = dependentRepositoryModuleTypeDeclarationsRW;
    }

    public ICollection_<IRepositoryDataTypeRegistration> getRepositoryDataTypeRegistrations() {
        return this.dataTypeRegistrations;
    }

    public void setup() {
        this.updateFrontendDeclarations();
        this.updateGenericModificationDeclarations();
    }

    private void updateFrontendDeclarations() {
        IRepositoryTypeManagerRO typeManager = this.projectAgent.getRepositoryInterface().getTypeManager();
        HashMap_ nonLocalizedModuleTypeDeclarationsRW = new HashMap_(IRepositoryModuleType.EQUAL_MODULE_TYPE_ID_HASHER);
        IPlatformAdapterRootModule adapterRootModule = this.getAdapterRootModule();
        nonLocalizedModuleTypeDeclarationsRW.put((Object)typeManager.getRootModuleType(), (Object)new FENonLocalizedModuleTypeDeclaration(this, adapterRootModule, typeManager));
        ArrayList_ dependentRepositoryModuleTypeDeclarationsRW = new ArrayList_(this.adapterModules.size());
        for (IPlatformAdapterModule adapterModule : this.adapterModules) {
            if (adapterModule instanceof IPlatformAdapterRootModule) continue;
            nonLocalizedModuleTypeDeclarationsRW.put((Object)typeManager.getModuleType(adapterModule.getRepositoryModuleTypeID()), (Object)new FENonLocalizedModuleTypeDeclaration(this, adapterModule, typeManager));
        }
        this.dependentRepositoryModuleTypeDeclarations = dependentRepositoryModuleTypeDeclarationsRW;
        ArrayList_ frontendDataTypeRegistrations = new ArrayList_();
        for (PlatformAdapterDataType dataType : this.dataTypeIDsToDataTypes.values()) {
            frontendDataTypeRegistrations.add((Object)dataType.getFrontendDataTypeRegistration());
        }
        this.nonLocalizedModuleTypeDeclarations = nonLocalizedModuleTypeDeclarationsRW;
        new FrontendTypeManager(typeManager, (IFrontendDeclaration)this, this.projectLanguage, (ICollection_)frontendDataTypeRegistrations);
    }

    private void updateGenericModificationDeclarations() {
        IRepositoryTypeManagerRO typeManager = this.projectAgent.getRepositoryInterface().getTypeManager();
        HashMap_ genericModificationModuleTypeDeclarationsRW = new HashMap_(IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER);
        IPlatformAdapterRootModule adapterRootModule = this.getAdapterRootModule();
        genericModificationModuleTypeDeclarationsRW.put((Object)adapterRootModule.getRepositoryModuleTypeID(), (Object)new GMModuleTypeDeclaration(this, adapterRootModule));
        ArrayList_ dependentRepositoryModuleTypeDeclarationsRW = new ArrayList_(this.adapterModules.size());
        for (IPlatformAdapterModule adapterModule : this.adapterModules) {
            if (adapterModule instanceof IPlatformAdapterRootModule) continue;
            genericModificationModuleTypeDeclarationsRW.put((Object)adapterModule.getRepositoryModuleTypeID(), (Object)new GMModuleTypeDeclaration(this, adapterModule, adapterRootModule.getBaseObjectTypeDeclaration()));
        }
        this.dependentRepositoryModuleTypeDeclarations = dependentRepositoryModuleTypeDeclarationsRW;
        this.genericModificationModuleTypeDeclarations = genericModificationModuleTypeDeclarationsRW;
        new GenericModificationTypeManager(typeManager, (IGenericModificationDeclaration)this);
    }

    private Map<PlatformAdapterDataTypeID, PlatformAdapterDataType> createDataTypes() {
        HashMap<PlatformAdapterDataTypeID, PlatformAdapterDataType> newDataTypes = new HashMap<PlatformAdapterDataTypeID, PlatformAdapterDataType>();
        RDTUID.RepositoryDataTypeRegistration rdtr = new RDTUID.RepositoryDataTypeRegistration();
        FDTUID.FrontendDataTypeRegistration fdtr = new FDTUID.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTUID.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTCounter64Bit.RepositoryDataTypeRegistration();
        fdtr = new FDTCounter64Bit.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTCounter64Bit.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTBoolean.RepositoryDataTypeRegistration();
        fdtr = new FDTBoolean.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTBoolean.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTInteger32Bit.RepositoryDataTypeRegistration();
        fdtr = new FDTInteger32Bit.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTInteger32Bit.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTInteger64Bit.RepositoryDataTypeRegistration();
        fdtr = new FDTInteger64Bit.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTInteger64Bit.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTFloat64BitIEEE754.RepositoryDataTypeRegistration();
        fdtr = new FDTFloat64BitIEEE754.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTFloat64BitIEEE754.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTDateUTC64Bitmsec.RepositoryDataTypeRegistration();
        fdtr = new FDTDateUTC64Bitmsec.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTDateUTC64Bitmsec.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTDuration64Bitmsec.RepositoryDataTypeRegistration();
        fdtr = new FDTDuration64Bitmsec.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTDuration64Bitmsec.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTDisplayName.RepositoryDataTypeRegistration();
        fdtr = new FDTDisplayName.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTDisplayName.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTFreeString.RepositoryDataTypeRegistration();
        fdtr = new FDTFreeString.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTFreeString.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTFreeText.RepositoryDataTypeRegistration();
        fdtr = new FDTFreeText.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTFreeText.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTLocale.RepositoryDataTypeRegistration();
        fdtr = new FDTLocale.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTLocale.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTURL.RepositoryDataTypeRegistration();
        fdtr = new FDTURL.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTURL.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTFile.RepositoryDataTypeRegistration();
        fdtr = new FDTFile.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTFile.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTUserReference.RepositoryDataTypeRegistration();
        fdtr = new FDTUserReference.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTUserReference.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTPrefixIDFormat.RepositoryDataTypeRegistration();
        fdtr = new FDTPrefixIDFormat.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTPrefixIDFormat.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTSingleChoice.RepositoryDataTypeRegistration();
        fdtr = new FDTSingleChoice.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTSingleChoice.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        rdtr = new RDTMultipleChoice.RepositoryDataTypeRegistration();
        fdtr = new FDTMultipleChoice.FrontendDataTypeRegistration();
        newDataTypes.put(new PlatformAdapterDataTypeID((IRepositoryDataTypeID)RDTMultipleChoice.DATA_TYPE_ID), new PlatformAdapterDataType((IRepositoryDataTypeRegistration)rdtr, null, (IFrontendDataTypeRegistration)fdtr, null));
        return newDataTypes;
    }

    private IPlatformAdapterRootModule calculateAdapterRootModule() {
        IPlatformAdapterRootModule adapterRootModule = null;
        for (IPlatformAdapterModule adapterModule : this.adapterModules) {
            if (!(adapterModule instanceof IPlatformAdapterRootModule)) continue;
            adapterRootModule = (IPlatformAdapterRootModule)adapterModule;
        }
        Assert.checkArgumentBeeingNotNull(adapterRootModule);
        return adapterRootModule;
    }

    private IPlatformAdapterRootModule getAdapterRootModule() {
        return this.rootModule;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public IObjectTypeDeclaration getObjectTypeDeclaration(IRepositoryObjectType objectType) {
        IObjectTypeDeclaration objectTypeDeclaration = this.findObjectTypeDeclaration(objectType.getRepositoryObjectTypeID());
        Assert.checkArgumentBeeingNotNull((Object)objectTypeDeclaration);
        return objectTypeDeclaration;
    }

    public synchronized IPropertyType getPropertyType(IRepositoryPropertyType repositoryPropertyType) {
        this.ensureRepositoryPropertyType2PropertyTypeCacheIsFilled(repositoryPropertyType);
        IPropertyType propertyType = this.repositoryPropertyType2propertyTypeCache.get(repositoryPropertyType);
        Assert.checkArgumentBeeingNotNull((Object)propertyType);
        return propertyType;
    }

    private void ensureRepositoryPropertyType2PropertyTypeCacheIsFilled(IRepositoryPropertyType repositoryPropertyType) {
        if (this.repositoryPropertyType2propertyTypeCache.isEmpty()) {
            IPropertyType[] propertyTypes;
            IRepositoryObjectType repositoryObjectType = repositoryPropertyType.getAttributeSetType().getObjectType();
            IObjectTypeDeclaration objectTypeDeclaration = this.getObjectTypeDeclaration(repositoryObjectType);
            IPropertyType[] iPropertyTypeArray = propertyTypes = objectTypeDeclaration.getFixPropertyTypes();
            int n = propertyTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyType currentPropertyType = iPropertyTypeArray[n2];
                IRepositoryPropertyType currentRepositoryPropertyType = repositoryObjectType.getAttributeSetType(currentPropertyType.getPropertyTypeID()).getPropertyType(currentPropertyType.getPropertyTypeID());
                this.repositoryPropertyType2propertyTypeCache.put(currentRepositoryPropertyType, currentPropertyType);
                ++n2;
            }
        }
    }

    public synchronized IOccurrenceManager getOccurrenceManager(IOccurrenceRepositoryRelationType occurenceRelationType) {
        this.ensureRepositoryPropertyType2OccurrenceManagerCacheIsFilled(occurenceRelationType.getRepositoryTypeManagerRO());
        IOccurrenceManager occurenceManager = (IOccurrenceManager)this.repositoryRelationTypeID2occurenceManagerCache.getByKey((Object)occurenceRelationType.getRepositoryRelationTypeID());
        return occurenceManager;
    }

    private void ensureRepositoryPropertyType2OccurrenceManagerCacheIsFilled(IRepositoryTypeManagerRO typeManager) {
        if (this.repositoryRelationTypeID2occurenceManagerCache == null) {
            HashMap_ repositoryRelationTypeID2occurenceManagerCacheRW = new HashMap_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
            for (IPlatformAdapterModule adapterModule : this.adapterModules) {
                IObjectTypeDeclaration[] allObjectTypeDeclarations;
                Object[] abstractObjectTypeDeclarations = this.getObjectTypeDeclarationOfModule(adapterModule);
                Object[] concreteDataManagerAdapters = this.getDataManagerAdaptersOfModule(adapterModule);
                IObjectTypeDeclaration[] iObjectTypeDeclarationArray = allObjectTypeDeclarations = (IObjectTypeDeclaration[])ArrayUtils.concatenateArrays((Object[])abstractObjectTypeDeclarations, (Object[])concreteDataManagerAdapters, IObjectTypeDeclaration.class);
                int n = allObjectTypeDeclarations.length;
                int n2 = 0;
                while (n2 < n) {
                    IObjectTypeDeclaration currentObjectTypeDeclaration = iObjectTypeDeclarationArray[n2];
                    IRepositoryObjectType occurenceObjectType = typeManager.getObjectType(currentObjectTypeDeclaration.getRepositoryObjectTypeID());
                    for (IEntry_ entry : currentObjectTypeDeclaration.getOccurrenceManagers()) {
                        IRepositoryPropertyTypeID propertyTypeID = (IRepositoryPropertyTypeID)entry.getKey();
                        IOccurrenceRepositoryRelationType occurenceRelationType = occurenceObjectType.getAttributeSetType(propertyTypeID).getPropertyType(propertyTypeID).getOccuringRelationContributionType().getRelatedRelationType();
                        IOccurrenceManager occurenceManager = (IOccurrenceManager)entry.getValue();
                        IRepositoryRelationTypeID relationTypeID = occurenceRelationType.getRepositoryRelationTypeID();
                        repositoryRelationTypeID2occurenceManagerCacheRW.put((Object)relationTypeID, (Object)occurenceManager);
                    }
                    ++n2;
                }
            }
            this.repositoryRelationTypeID2occurenceManagerCache = repositoryRelationTypeID2occurenceManagerCacheRW;
        }
    }

    public synchronized IObjectTypeDeclaration findObjectTypeDeclaration(IRepositoryObjectTypeID objectTypeID) {
        this.ensureIRepositoryObjectTypeID2dataManagerAdapterCacheIsFilled();
        IObjectTypeDeclaration objectTypeDeclaration = (IObjectTypeDeclaration)this.iRepositoryObjectTypeID2dataManagerAdapterCache.getByKey((Object)objectTypeID);
        return objectTypeDeclaration;
    }

    private void ensureCockpitDataTypeID2RepositoryObjectTyoeCachesAreFilled() {
        if (this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes.isEmpty()) {
            for (IPlatformAdapterModule adapterModule : this.adapterModules) {
                IDataManagerAdapter[] dataManagerAdapters;
                IDataManagerAdapter[] iDataManagerAdapterArray = dataManagerAdapters = this.getDataManagerAdaptersOfModule(adapterModule);
                int n = dataManagerAdapters.length;
                int n2 = 0;
                while (n2 < n) {
                    IDataManagerAdapter currentDataManagerAdapter = iDataManagerAdapterArray[n2];
                    String cockpitDataTypeID = currentDataManagerAdapter.getCockpitDataTypeID();
                    HashSet_ setOfConcreteRepositoryObjectTypes = this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes.get(cockpitDataTypeID);
                    if (setOfConcreteRepositoryObjectTypes == null) {
                        setOfConcreteRepositoryObjectTypes = new HashSet_(IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
                        this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes.put(cockpitDataTypeID, (ISetRW_<IRepositoryObjectTypeID>)setOfConcreteRepositoryObjectTypes);
                    }
                    setOfConcreteRepositoryObjectTypes.add((Object)currentDataManagerAdapter.getRepositoryObjectTypeID());
                    ++n2;
                }
                IRepositoryTypeManagerRO typeManager = this.projectAgent.getRepositoryInterface().getTypeManager();
                block2: for (Map.Entry<String, ISetRW_<IRepositoryObjectTypeID>> entry : this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes.entrySet()) {
                    String cockpitDataTypeID = entry.getKey();
                    ISetRW_<IRepositoryObjectTypeID> concreteObjectTypes = entry.getValue();
                    if (concreteObjectTypes.size() == 1) {
                        this.cockpitDataTypeIDToMostAbstractRepositoryObjectType.put(cockpitDataTypeID, (IRepositoryObjectTypeID)concreteObjectTypes.iterator().next());
                        continue;
                    }
                    ArrayList<IRepositoryObjectType> listOfConcreteObjectTypes = new ArrayList<IRepositoryObjectType>(concreteObjectTypes.size());
                    for (IRepositoryObjectTypeID concreteObjectTypeID : concreteObjectTypes) {
                        listOfConcreteObjectTypes.add(typeManager.getObjectType(concreteObjectTypeID));
                    }
                    IRepositoryObjectType potentialAbstractSuperType = (IRepositoryObjectType)listOfConcreteObjectTypes.get(0);
                    while (true) {
                        boolean isSuperTypeOfAllConcreteTypes = true;
                        int index = 1;
                        while (index < listOfConcreteObjectTypes.size()) {
                            if (!((IRepositoryObjectType)listOfConcreteObjectTypes.get(index)).isSubTypeOf(potentialAbstractSuperType)) {
                                isSuperTypeOfAllConcreteTypes = false;
                            }
                            ++index;
                        }
                        if (isSuperTypeOfAllConcreteTypes) {
                            this.cockpitDataTypeIDToMostAbstractRepositoryObjectType.put(cockpitDataTypeID, potentialAbstractSuperType.getRepositoryObjectTypeID());
                            continue block2;
                        }
                        if ((potentialAbstractSuperType = potentialAbstractSuperType.getAbstractSuperObjectType()) != null) continue;
                        LOGGER.warn("No common super repository object type found for cockpit data type: " + cockpitDataTypeID);
                        Assert.checkState((boolean)false);
                    }
                }
            }
        }
    }

    public IRepositoryObjectTypeID getMostAbstractRepositoryObjectType(String cockpitDataTypeID) {
        this.ensureCockpitDataTypeID2RepositoryObjectTyoeCachesAreFilled();
        IRepositoryObjectTypeID mostAbstractRepositoryObjectType = this.cockpitDataTypeIDToMostAbstractRepositoryObjectType.get(cockpitDataTypeID);
        Assert.checkArgumentBeeingNotNull((Object)mostAbstractRepositoryObjectType);
        return mostAbstractRepositoryObjectType;
    }

    public ISet_<IRepositoryObjectTypeID> getConcreteRepositoryObjectTypes(String cockpitDataTypeID) {
        this.ensureCockpitDataTypeID2RepositoryObjectTyoeCachesAreFilled();
        ISet_ setOfConcreteRepositoryObjectTypes = (ISet_)this.cockpitDataTypeIDToSetOfConcreteRepositoryObjectTypes.get(cockpitDataTypeID);
        Assert.checkArgumentBeeingNotNull((Object)setOfConcreteRepositoryObjectTypes);
        return setOfConcreteRepositoryObjectTypes;
    }

    private void ensureIRepositoryObjectTypeID2dataManagerAdapterCacheIsFilled() {
        if (this.iRepositoryObjectTypeID2dataManagerAdapterCache.isEmpty()) {
            for (IPlatformAdapterModule adapterModule : this.adapterModules) {
                IObjectTypeDeclaration[] allObjectTypeDeclarations;
                Object[] abstractObjectTypeDeclarations = this.getObjectTypeDeclarationOfModule(adapterModule);
                Object[] concreteDataManagerAdapters = this.getDataManagerAdaptersOfModule(adapterModule);
                IObjectTypeDeclaration[] iObjectTypeDeclarationArray = allObjectTypeDeclarations = (IObjectTypeDeclaration[])ArrayUtils.concatenateArrays((Object[])abstractObjectTypeDeclarations, (Object[])concreteDataManagerAdapters, IObjectTypeDeclaration.class);
                int n = allObjectTypeDeclarations.length;
                int n2 = 0;
                while (n2 < n) {
                    IObjectTypeDeclaration currentObjectTypeDeclaration = iObjectTypeDeclarationArray[n2];
                    this.iRepositoryObjectTypeID2dataManagerAdapterCache.put((Object)currentObjectTypeDeclaration.getRepositoryObjectTypeID(), (Object)currentObjectTypeDeclaration);
                    ++n2;
                }
            }
        }
    }

    public synchronized IDataManagerAdapter getDataManagerAdapter(IRepositoryObjectType concreteObjectType) {
        IDataManagerAdapter dataManagerAdapter = (IDataManagerAdapter)this.findObjectTypeDeclaration(concreteObjectType.getRepositoryObjectTypeID());
        Assert.checkArgumentBeeingNotNull((Object)dataManagerAdapter);
        return dataManagerAdapter;
    }

    public IDataManagerAdapter getDataManagerAdapter(ICockpitProjectData cockpitData) {
        CockpitDataID cockpitDataID = new CockpitDataID(cockpitData.getTypeID(), cockpitData.getUID());
        IDataManagerAdapter dataManagerAdapter = this.getDataManagerAdapter(cockpitDataID);
        return dataManagerAdapter;
    }

    public IDataManagerAdapter findDataManagerAdapter(ICockpitDataID cockpitDataID) {
        IDataManagerAdapter dataManagerAdapter;
        String cockpitDataTypeID = cockpitDataID.getCockpitDataTypeID();
        String cockpitDataUID = cockpitDataID.getCockpitDataUID();
        Set<IDataManagerAdapter> setOfDataManagerAdapters = this.cockpitDataTypeIDToSetOfDataManagerAdapters.get(cockpitDataTypeID);
        if (setOfDataManagerAdapters != null) {
            dataManagerAdapter = null;
            Iterator<IDataManagerAdapter> i = setOfDataManagerAdapters.iterator();
            while (dataManagerAdapter == null && i.hasNext()) {
                IDataManagerAdapter currentDataManagerAdapter = i.next();
                if (currentDataManagerAdapter.findData(cockpitDataUID) == null) continue;
                dataManagerAdapter = currentDataManagerAdapter;
            }
        } else {
            dataManagerAdapter = null;
        }
        return dataManagerAdapter;
    }

    public IDataManagerAdapter getDataManagerAdapter(ICockpitDataID cockpitDataID) {
        IDataManagerAdapter dataManagerAdapter = this.findDataManagerAdapter(cockpitDataID);
        Assert.checkArgumentBeeingNotNull((Object)dataManagerAdapter);
        return dataManagerAdapter;
    }

    private IDataManagerAdapter[] getDataManagerAdaptersOfModule(IPlatformAdapterModule adapterModule) {
        Object[] dataManagerAdapters = adapterModule.getConcreteObjectTypeDataManagers();
        if (adapterModule instanceof IPlatformAdapterRootModule) {
            IPlatformAdapterRootModule adapterRootModule = (IPlatformAdapterRootModule)adapterModule;
            dataManagerAdapters = (IDataManagerAdapter[])ArrayUtils.concatenateArrays((Object[])new IDataManagerAdapter[]{adapterRootModule.getRootObjectTypeDataManager()}, (Object[])dataManagerAdapters);
        }
        return dataManagerAdapters;
    }

    private IObjectTypeDeclaration[] getObjectTypeDeclarationOfModule(IPlatformAdapterModule adapterModule) {
        Object[] dataManagerAdapters = adapterModule.getAbstractObjectTypeDeclarations();
        if (adapterModule instanceof IPlatformAdapterRootModule) {
            IPlatformAdapterRootModule adapterRootModule = (IPlatformAdapterRootModule)adapterModule;
            dataManagerAdapters = (IObjectTypeDeclaration[])ArrayUtils.concatenateArrays((Object[])new IObjectTypeDeclaration[]{adapterRootModule.getBaseObjectTypeDeclaration()}, (Object[])dataManagerAdapters);
        }
        return dataManagerAdapters;
    }

    public synchronized ILinkManagerAdapter getLinkManagerAdapter(ICrossLinkRepositoryRelationType conreteRelationType) {
        ILinkManagerAdapter linkManagerAdapter = (ILinkManagerAdapter)this.findRelationTypeDeclaration(conreteRelationType.getRepositoryRelationTypeID());
        Assert.checkArgumentBeeingNotNull((Object)linkManagerAdapter);
        return linkManagerAdapter;
    }

    public IRelationTypeDeclaration findRelationTypeDeclaration(IRepositoryRelationTypeID relationTypeID) {
        this.ensureIRepositoryRelationTypeID2relationTypeDeclarationCacheIsFilled();
        IRelationTypeDeclaration relationTypeDeclaration = (IRelationTypeDeclaration)this.iRepositoryRelationTypeID2relationTypeDeclarationCache.getByKey((Object)relationTypeID);
        return relationTypeDeclaration;
    }

    private void ensureIRepositoryRelationTypeID2relationTypeDeclarationCacheIsFilled() {
        if (this.iRepositoryRelationTypeID2relationTypeDeclarationCache.isEmpty()) {
            for (IPlatformAdapterModule adapterModule : this.adapterModules) {
                IRelationTypeDeclaration[] allRelationTypeDeclarations;
                Object[] abstractRelationTypeDeclarations = this.getRelationTypeDeclarationOfModule(adapterModule);
                Object[] concreteLinkManagerAdapters = this.getLinkManagerAdaptersOfModule(adapterModule);
                IRelationTypeDeclaration[] iRelationTypeDeclarationArray = allRelationTypeDeclarations = (IRelationTypeDeclaration[])ArrayUtils.concatenateArrays((Object[])abstractRelationTypeDeclarations, (Object[])concreteLinkManagerAdapters, IRelationTypeDeclaration.class);
                int n = allRelationTypeDeclarations.length;
                int n2 = 0;
                while (n2 < n) {
                    IRelationTypeDeclaration currentRelationTypeDeclaration = iRelationTypeDeclarationArray[n2];
                    this.iRepositoryRelationTypeID2relationTypeDeclarationCache.put((Object)currentRelationTypeDeclaration.getRepositoryRelationTypeID(), (Object)currentRelationTypeDeclaration);
                    ++n2;
                }
            }
        }
    }

    private ILinkManagerAdapter[] getLinkManagerAdaptersOfModule(IPlatformAdapterModule adapterModule) {
        ILinkManagerAdapter[] linkManagerAdapters = adapterModule.getConcreteRelationTypeLinkManagers();
        return linkManagerAdapters;
    }

    private IRelationTypeDeclaration[] getRelationTypeDeclarationOfModule(IPlatformAdapterModule adapterModule) {
        IRelationTypeDeclaration[] relationTypeDeclarations = adapterModule.getAbstractRelationTypeDeclarations();
        return relationTypeDeclarations;
    }

    public IRepositoryTypeDeclaration getRootRepositoryModuleTypeDeclaration() {
        return this.rootRepositoryModuleTypeDeclaration;
    }

    public ICollection_<IRepositoryModuleTypeDeclaration> getDependentRepositoryModuleTypeDeclarations() {
        return this.dependentRepositoryModuleTypeDeclarations;
    }

    public IMap_<IRepositoryModuleType, IFrontendNonLocalizedModuleTypeDeclaration> getNonLocalizedModuleTypeDeclarations() {
        return this.nonLocalizedModuleTypeDeclarations;
    }

    public IMap_<IRepositoryModuleTypeID, GenericModificationModuleTypeDeclaration> getModuleTypeDeclarations() {
        return this.genericModificationModuleTypeDeclarations;
    }

    FrontendLabel createFrontendDeclaration(ILabel[] labels, Locale locale) {
        ArrayList_ locales = new ArrayList_(labels.length);
        ILabel[] iLabelArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            ILabel label = iLabelArray[n2];
            locales.add((Object)label.getLocale());
            ++n2;
        }
        Locale nearestLocale = LocaleHelper.findNearestLocale((ICollection_)locales, (Locale)locale);
        FrontendLabel frontendLabelDeclaration = new FrontendLabel(null, null);
        ILabel[] iLabelArray2 = labels;
        int n3 = labels.length;
        int n4 = 0;
        while (n4 < n3) {
            ILabel label = iLabelArray2[n4];
            if (label.getLocale().equals(nearestLocale)) {
                frontendLabelDeclaration = new FrontendLabel(label.getLabel(), label.getIcon16x16());
            }
            ++n4;
        }
        return frontendLabelDeclaration;
    }

    FrontendLabel getInheritedObjectTypeLabel(IObjectTypeDeclaration objectTypeDeclaration, Locale projectLanguageForLabel) {
        String label = null;
        IStreamResource icon16x16 = null;
        IObjectTypeDeclaration currentObjectTypeDeclaration = objectTypeDeclaration;
        while ((label == null || icon16x16 == null) && currentObjectTypeDeclaration != null) {
            FrontendLabel childLabelDeclaration = this.createFrontendDeclaration(currentObjectTypeDeclaration.getLabels(), projectLanguageForLabel);
            String childLabel = childLabelDeclaration.getText();
            if (label == null && childLabel != null) {
                label = childLabel;
            }
            IStreamResource childIcon16x16 = childLabelDeclaration.getIcon16x16();
            if (icon16x16 == null && childIcon16x16 != null) {
                icon16x16 = childIcon16x16;
            }
            currentObjectTypeDeclaration = this.findObjectTypeDeclaration(currentObjectTypeDeclaration.getRepositorySuperObjectTypeID());
        }
        FrontendLabel parentAttributeSetLabel = new FrontendLabel(label, icon16x16);
        return parentAttributeSetLabel;
    }

    FrontendLabel getInheritedRelationTypeLabel(IRelationTypeDeclaration relationTypeDeclaration, Locale projectLanguageForLabel) {
        String label = null;
        IStreamResource icon16x16 = null;
        IRelationTypeDeclaration currentRelationTypeDeclaration = relationTypeDeclaration;
        while ((label == null || icon16x16 == null) && currentRelationTypeDeclaration != null) {
            FrontendLabel childLabelDeclaration = this.createFrontendDeclaration(currentRelationTypeDeclaration.getLabels(), projectLanguageForLabel);
            String childLabel = childLabelDeclaration.getText();
            if (label == null && childLabel != null) {
                label = childLabel;
            }
            IStreamResource childIcon16x16 = childLabelDeclaration.getIcon16x16();
            if (icon16x16 == null && childIcon16x16 != null) {
                icon16x16 = childIcon16x16;
            }
            currentRelationTypeDeclaration = this.findRelationTypeDeclaration(currentRelationTypeDeclaration.getRepositorySuperRelationTypeID());
        }
        FrontendLabel parentAttributeSetLabel = new FrontendLabel(label, icon16x16);
        return parentAttributeSetLabel;
    }

    FrontendLabel getInheritedRelationContributionTypeLabel(IRelationTypeDeclaration relationTypeDeclaration, IRepositoryRelationContributionRoleID relationContributionRoleID, Locale projectLanguageForLabel) {
        String label = null;
        IStreamResource icon16x16 = null;
        IRelationTypeDeclaration currentRelationTypeDeclaration = relationTypeDeclaration;
        while ((label == null || icon16x16 == null) && currentRelationTypeDeclaration != null) {
            IRelationContributionType[] relationContributionTypes;
            IRelationContributionType[] iRelationContributionTypeArray = relationContributionTypes = currentRelationTypeDeclaration.getRelationContributionTypes();
            int n = relationContributionTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IRelationContributionType relationContributionType = iRelationContributionTypeArray[n2];
                if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relationContributionType.getRepositoryRelationContributionRoleID(), (Object)relationContributionRoleID)) {
                    FrontendLabel childLabelDeclaration = this.createFrontendDeclaration(relationContributionType.getLabels(), projectLanguageForLabel);
                    String childLabel = childLabelDeclaration.getText();
                    if (label == null && childLabel != null) {
                        label = childLabel;
                    }
                    IStreamResource childIcon16x16 = childLabelDeclaration.getIcon16x16();
                    if (icon16x16 == null && childIcon16x16 != null) {
                        icon16x16 = childIcon16x16;
                    }
                }
                ++n2;
            }
            currentRelationTypeDeclaration = this.findRelationTypeDeclaration(currentRelationTypeDeclaration.getRepositorySuperRelationTypeID());
        }
        FrontendLabel parentAttributeSetLabel = new FrontendLabel(label, icon16x16);
        return parentAttributeSetLabel;
    }

    List<WidgetSpecification> getWidgetsForCustomProperties(IRepositoryTypeManagerRO typeManager, IDataManagerAdapter dataManagerAdapter) {
        IList_<IRepositoryPropertyTypeID> customPropertyTypeIDs = this.getCustomPropertyTypeIDs(typeManager, dataManagerAdapter);
        ArrayList<WidgetSpecification> widgets = new ArrayList<WidgetSpecification>();
        if (!customPropertyTypeIDs.isEmpty()) {
            for (IRepositoryPropertyTypeID propertyTypeID : customPropertyTypeIDs) {
                List<String> propertyTypeIDs = Collections.singletonList(propertyTypeID.toCanonicalString());
                WidgetSpecification widgetSpecification = new WidgetSpecification(false, propertyTypeIDs, new HashMap(), null, null);
                widgets.add(widgetSpecification);
            }
        }
        return widgets;
    }

    private IList_<IRepositoryPropertyTypeID> getCustomPropertyTypeIDs(IRepositoryTypeManagerRO typeManager, IDataManagerAdapter dataManagerAdapter) {
        String cockpitDataTypeID = dataManagerAdapter.getCockpitDataTypeID();
        IRepositoryObjectTypeID objectTypeID = dataManagerAdapter.getRepositoryObjectTypeID();
        IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
        ArrayList<IAttributeType> userDefinedAttributes = new ArrayList<IAttributeType>(this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(cockpitDataTypeID));
        Collections.sort(userDefinedAttributes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType o1, IAttributeType o2) {
                IAttributeType t1 = o1;
                IAttributeType t2 = o2;
                return t1.getSortCriterium().compareTo((Object)t2.getSortCriterium());
            }
        });
        ArrayList_ customPropertyTypeIDs = new ArrayList_(userDefinedAttributes.size());
        for (IAttributeType userDefinedAttributeType : userDefinedAttributes) {
            CustomPropertyTypeID customPropertyTypeFound = null;
            IRepositoryObjectType objectTypeToCheck = objectType;
            while (objectTypeToCheck != null) {
                CustomPropertyTypeID propertyTypeID = new CustomPropertyTypeID(objectTypeToCheck.getRepositoryObjectTypeID(), userDefinedAttributeType);
                if (objectType.findAttributeSetType((IRepositoryPropertyTypeID)propertyTypeID) != null) {
                    customPropertyTypeFound = propertyTypeID;
                    break;
                }
                objectTypeToCheck = objectTypeToCheck.getAbstractSuperObjectType();
            }
            if (customPropertyTypeFound != null) {
                customPropertyTypeIDs.add(customPropertyTypeFound);
                continue;
            }
            assert (false);
        }
        return customPropertyTypeIDs;
    }

    Locale getProjectLanguage() {
        return this.projectLanguage;
    }

    public Map<PlatformAdapterDataTypeID, PlatformAdapterDataType> getDataTypeIDsToDataTypes() {
        return this.dataTypeIDsToDataTypes;
    }
}

