/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.manager;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.clientadapter.implementation.adapter.CustomPropertyTypeID;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.manager.GMPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.IBaseObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IObjectTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.lib.high.genericmodifications.interFace.declaration.GenericModificationAttributeSetTypeDeclaration;
import com.arcway.repository.lib.high.genericmodifications.interFace.declaration.GenericModificationPropertyTypeDeclaration;
import java.util.List;

class GMAttributeSetTypeDeclaration
extends GenericModificationAttributeSetTypeDeclaration {
    private final PlatformAdapterModuleManager platformAdapterModuleManager;
    private final ICollectionRW_<GenericModificationPropertyTypeDeclaration> propertyTypeDeclarations = new ArrayList_();
    private final boolean isModifiableCenerically;

    public GMAttributeSetTypeDeclaration(PlatformAdapterModuleManager manager, IObjectTypeDeclaration objectTypeDeclaration, IBaseObjectTypeDeclaration baseObjectTypeDeclaration) {
        super(baseObjectTypeDeclaration.getPropertiesAttributeSetTypeID());
        this.platformAdapterModuleManager = manager;
        this.isModifiableCenerically = false;
        this.determinePropertyTypeDeclarations(objectTypeDeclaration);
    }

    public GMAttributeSetTypeDeclaration(PlatformAdapterModuleManager manager, IDataManagerAdapter dataManagerAdapter, IBaseObjectTypeDeclaration baseObjectTypeDeclaration) {
        super(baseObjectTypeDeclaration.getPropertiesAttributeSetTypeID());
        this.platformAdapterModuleManager = manager;
        this.isModifiableCenerically = dataManagerAdapter.isModifiableGenerically();
        this.determinePropertyTypeDeclarations(dataManagerAdapter);
    }

    private void determinePropertyTypeDeclarations(IObjectTypeDeclaration objectTypeDeclaration) {
        IPropertyType[] propertyTypes;
        IPropertyType[] iPropertyTypeArray = propertyTypes = objectTypeDeclaration.getFixPropertyTypes();
        int n = propertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyType propertyType = iPropertyTypeArray[n2];
            this.propertyTypeDeclarations.add((Object)new GMPropertyTypeDeclaration(this.platformAdapterModuleManager, propertyType));
            ++n2;
        }
        String cockpitDataTypeID = objectTypeDeclaration.getCockpitTypeThatProvidesCustomProperties();
        if (cockpitDataTypeID != null) {
            List<IAttributeType> userDefinedAttributes = this.platformAdapterModuleManager.getProjectAgent().getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(cockpitDataTypeID);
            IRepositoryObjectTypeID objectTypeID = objectTypeDeclaration.getRepositoryObjectTypeID();
            for (IAttributeType userDefinedAttributeType : userDefinedAttributes) {
                IRepositoryData defaultValueSample;
                FrameDataConverter.DataTypeIDWithParameters dataTypeIDWithParameters;
                CustomPropertyTypeID propertyTypeID = new CustomPropertyTypeID(objectTypeID, userDefinedAttributeType);
                try {
                    dataTypeIDWithParameters = FrameDataConverter.convertCockpitAttributeTypeDataTypeToRepositoryDataType(this.platformAdapterModuleManager.getProjectAgent(), userDefinedAttributeType.getDataType(), userDefinedAttributeType.getValueRange());
                    defaultValueSample = FrameDataConverter.convertCockpitValueToRepositoryDataSample(userDefinedAttributeType.getDataType(), userDefinedAttributeType.getDataType().getDefaultValue(), dataTypeIDWithParameters.repositoryDataTypeID);
                }
                catch (UnsupportedOperationException e) {
                    dataTypeIDWithParameters = null;
                    defaultValueSample = null;
                }
                if (dataTypeIDWithParameters == null) continue;
                GMPropertyTypeDeclaration genericModificationPropertyTypeDeclaration = new GMPropertyTypeDeclaration(this.platformAdapterModuleManager, propertyTypeID, defaultValueSample);
                this.propertyTypeDeclarations.add((Object)genericModificationPropertyTypeDeclaration);
            }
        }
    }

    public boolean arePropertiesModifiableGenerically() {
        return this.isModifiableCenerically;
    }

    public ICollection_<GenericModificationPropertyTypeDeclaration> getPropertyTypeDeclarations() {
        return this.propertyTypeDeclarations;
    }
}

