/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.section;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ISectionAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISectionRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.cockpit.frame.declaration.common.icons16x16.CommonIcons16x16;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDisplayName;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeText;
import com.arcway.lib.java.arrays.ArrayUtils;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.editor.WidgetTypeID;
import com.arcway.lib.ui.editor.datatype.IWidgetTypeID;
import com.arcway.lib.ui.editor.layoutspecification.CustomPropertySpecification;
import com.arcway.lib.ui.editor.layoutspecification.IWidgetSpecification;
import com.arcway.lib.ui.editor.layoutspecification.WidgetSpecification;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.parameters.importdialog.PageWidgetParameters;
import com.arcway.lib.ui.editor.specification.sequential.EntrySpecification;
import com.arcway.lib.ui.editor.specification.sequential.PageSpecification;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AbstractDataManagerAdapter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AttributeTypeID2PropertyTypeMap;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.interFace.Label;
import com.arcway.repository.clientadapter.lib.IDOrNamePropertyComparator;
import com.arcway.repository.clientadapter.lib.NameOrIDPropertyTypeDeclaration;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsProject;
import com.arcway.repository.cockpit.interFace.declaration.frame.section.COTIDsSection;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryNoneBaseObjectTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class DataManagerAdapterSection
extends AbstractDataManagerAdapter {
    private static final String PROPERTY_LABEL_NAME = "Section.Section.Name";
    private static final String PROPERTY_LABEL_DESCRIPTION = "Section.Section.Description";
    private static final IPropertyType[] nonInheritedPropertyTypes = new IPropertyType[]{new IPropertyType(){
        private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Section.Section.Name", null);

        @Override
        public IRepositoryPropertyTypeID getPropertyTypeID() {
            return COTIDsSection.PROPERTY_TYPE_ID_NAME;
        }

        @Override
        public IRepositoryDataTypeID getDataTypeID() {
            return RDTDisplayName.DATA_TYPE_ID;
        }

        @Override
        public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
            return RDTDisplayName.Parameters.PARAMETERS__IS_SET_ALWAYS__NOT_EMPTY;
        }

        @Override
        public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
            return FDTDisplayName.Parameters.DEFAULTS;
        }

        @Override
        public ILabel[] getLabels() {
            return this.propertyLabels;
        }

        @Override
        public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
            return null;
        }
    }, new IPropertyType(){
        private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Section.Section.Description", null);

        @Override
        public IRepositoryPropertyTypeID getPropertyTypeID() {
            return COTIDsSection.PROPERTY_TYPE_ID_DESCRIPTION;
        }

        @Override
        public IRepositoryDataTypeID getDataTypeID() {
            return RDTFreeText.DATA_TYPE_ID;
        }

        @Override
        public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
            return RDTFreeText.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY;
        }

        @Override
        public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
            return FDTFreeText.Parameters.DEFAULTS;
        }

        @Override
        public ILabel[] getLabels() {
            return this.propertyLabels;
        }

        @Override
        public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
            return null;
        }
    }};
    private static final IAttributeTypeID[] nonInheritedAttributeTypeIDs = new IAttributeTypeID[]{SectionAttributeTypesProvider.ATTRID_NAME, SectionAttributeTypesProvider.ATTRID_DESCRIPTION};
    public static final IPropertyType[] allPropertyTypes = (IPropertyType[])ArrayUtils.concatenateArrays((Object[])nonInheritedPropertyTypes, (Object[])new IPropertyType[0]);
    public static final IAttributeTypeID[] allAttributeTypeIDs = (IAttributeTypeID[])ArrayUtils.concatenateArrays((Object[])nonInheritedAttributeTypeIDs, (Object[])new IAttributeTypeID[0]);
    private static final INameOrIDPropertyTypeDeclaration NAME_PROPERTY_DECLARATION = new NameOrIDPropertyTypeDeclaration((IRepositoryPropertyTypeID)COTIDsSection.PROPERTY_TYPE_ID_NAME, IDOrNamePropertyComparator.COMPARATOR_LOWER_CASE_TRIM_NORMALIZATION);
    private final SectionManager sectionManager;
    private final ICollection_<? extends IParentRelationshipAdapter> parentRelationshipAdapters;

    public DataManagerAdapterSection(IFrameProjectAgent projectAgent) {
        super(projectAgent, projectAgent.getFrameSectionManager());
        this.sectionManager = (SectionManager)projectAgent.getFrameSectionManager();
        ArrayList_ parentRelationshipAdaptersRW = new ArrayList_(1);
        parentRelationshipAdaptersRW.add((Object)new FrameParentRelationshipAdapter((IRepositoryObjectTypeID)COTIDsProject.OBJECT_TYPE_ID, CardinalityType.C0_n_NOT_CONFLICTING));
        parentRelationshipAdaptersRW.add((Object)new FrameParentRelationshipAdapter((IRepositoryObjectTypeID)COTIDsSection.OBJECT_TYPE_ID, CardinalityType.C0_n_NOT_CONFLICTING));
        this.parentRelationshipAdapters = parentRelationshipAdaptersRW;
    }

    @Override
    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return COTIDsSection.OBJECT_TYPE_ID;
    }

    @Override
    public IRepositoryObjectTypeID getRepositorySuperObjectTypeID() {
        return COTIDsCockpitData.OBJECT_TYPE_ID;
    }

    @Override
    public ICollection_<? extends IParentRelationshipAdapter> getParentRelationshipAdapters() {
        return this.parentRelationshipAdapters;
    }

    @Override
    public ILabel[] getLabels() {
        return Label.createLabels(Messages.class, "Section.AbstractSection", CommonIcons16x16.FOLDER);
    }

    @Override
    public IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration getCategorySupportTypeDeclaration() {
        return FrameDataTypes.getDataType("com.arcway.cockpit.section").isSupportingCategories() ? IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.YES : IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.NO;
    }

    @Override
    public IPropertyType[] getFixPropertyTypes() {
        return nonInheritedPropertyTypes;
    }

    @Override
    public String getCockpitDataTypeID() {
        return "com.arcway.cockpit.section";
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        return NAME_PROPERTY_DECLARATION;
    }

    @Override
    protected AttributeTypeID2PropertyTypeMap createAttributeTypeID2PropertyTypeMap() {
        return new AttributeTypeID2PropertyTypeMap(allAttributeTypeIDs, allPropertyTypes);
    }

    private ISection getAsParentSection(ICockpitProjectData parent) {
        ISection parentSection = parent instanceof ICockpitProject ? this.sectionManager.getRootSection() : (ISection)parent;
        return parentSection;
    }

    private ICockpitProjectData getParent(ISection childSection) {
        Object parent = this.sectionManager.getParentSection(childSection);
        if (parent == this.sectionManager.getRootSection()) {
            parent = this.sectionManager.getProjectAgent().getProject();
        }
        return parent;
    }

    @Override
    protected IAttributeOwnerRW findAttributeOwnerRW(String cockpitDataUID) {
        ISection section;
        ISectionRW sectionRW = this.sectionManager.getSectionRW(cockpitDataUID);
        if (sectionRW != null && (section = this.sectionManager.getSection(cockpitDataUID)).isRootSection()) {
            sectionRW = null;
        }
        return sectionRW;
    }

    @Override
    protected ICockpitProjectData getParentCockpitData(IAttributeOwner child) {
        return this.getParent((ISection)child);
    }

    @Override
    protected Collection<? extends IAttributeOwner> getChildCockpitDatas(IAttributeOwner parent) {
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parent);
        return this.sectionManager.getChildSections(parentSection);
    }

    @Override
    protected ICockpitProjectData getChildCockpitData(IAttributeOwner parent, String name) {
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parent);
        return this.sectionManager.getChildSection(parentSection, name);
    }

    protected Collection<ISection> getAllCockpitDatas() {
        HashSet<ISection> sections = new HashSet<ISection>(this.sectionManager.getSections());
        sections.remove(this.sectionManager.getRootSection());
        return sections;
    }

    @Override
    protected IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        IAttributeTypesProvider attributeTypesProv = this.getProjectAgent().getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
        return attributeTypesProv.getAttributeType(attributeTypeID);
    }

    @Override
    protected ICockpitProjectData createCockpitData(String cockpitDataUID, String name, IAttributeOwner parentCockpitData, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> cockpitAttributes) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        ISection parentSection = this.getAsParentSection((ICockpitProjectData)parentCockpitData);
        ISectionAddID addID = this.sectionManager.requestSectionAdditionPermission(cockpitDataUID, name, parentSection, objectTypeCategoryID, cockpitAttributes);
        DataManagerAdapterSection.handleModificationProblem(addID.getModificationProblem());
        ISection createdCockpitData = null;
        try {
            createdCockpitData = this.sectionManager.addSection(addID);
        }
        catch (EXNoPermission e) {
            throw new RuntimeException(e);
        }
        return createdCockpitData;
    }

    @Override
    public boolean isCreatableGenerically() {
        return true;
    }

    @Override
    public boolean isDeletableGenerically() {
        return true;
    }

    @Override
    public boolean isModifiableGenerically() {
        return true;
    }

    @Override
    public void checkPermissionForCreate(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection parentSection = this.getAsParentSection(parentCockpitData);
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        transactionController.addPermission("modifyFolders", null, this.getProjectAgent().getFrameSectionManager().getOperandTree(parentSection));
    }

    @Override
    public void checkPermissionForMove(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection newParentSection = this.getAsParentSection(newParentCockpitData);
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        this.getProjectAgent().getFrameSectionManager().requestMovePermission(cockpitData, (IAttributeOwner)newParentSection, transactionController);
    }

    @Override
    public void checkPermissionForModifyProperty(IAttributeOwner cockpitData, IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        SectionAttributeModificationManager sectionAttributeModificationManager = new SectionAttributeModificationManager(this.getProjectAgent());
        assert (cockpitData instanceof Section);
        sectionAttributeModificationManager.setSection((Section)cockpitData);
        sectionAttributeModificationManager.checkGeneralModificationPermissions(attributeType, transactionController);
    }

    @Override
    protected void checkPermissionForModifyObjectTypeCategory(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        ISection section = this.getAsParentSection((ICockpitProjectData)cockpitData);
        transactionController.addPermission("modifyFolders", null, this.getProjectAgent().getFrameSectionManager().getOperandTree(section));
    }

    @Override
    public void checkPermissionForDelete(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection section = (ISection)cockpitData;
        transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        this.getProjectAgent().getFrameSectionManager().requestDeleteSectionPermission(section.getUID(), transactionController);
    }

    @Override
    protected void getLockForCreateCockpitData(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection parentSection = this.getAsParentSection(parentCockpitData);
        transactionController.addLockToTest(parentSection, "delete");
        transactionController.addLock(parentSection, "add");
    }

    @Override
    protected void getLockForMoveCockpitData(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection newParentSection = this.getAsParentSection(newParentCockpitData);
        this.getProjectAgent().getFrameSectionManager().requestMovePermission(cockpitData, (IAttributeOwner)newParentSection, transactionController);
    }

    @Override
    protected void getLockForModifyCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockToTest((ILockable)cockpitData, "modify");
        transactionController.addLock((ILockable)cockpitData, "modify");
    }

    @Override
    protected void getLockForDeleteCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ISection section = (ISection)cockpitData;
        this.getProjectAgent().getFrameSectionManager().requestDeleteSectionPermission(section.getUID(), transactionController);
    }

    @Override
    public Sequence getSequentialLayoutSpecification(Locale contentLocale) {
        ArrayList<PageSpecification> pageSpecifications = new ArrayList<PageSpecification>();
        ArrayList<EntrySpecification> entrySpecifications = new ArrayList<EntrySpecification>();
        WidgetSpecification widgetSpec_objectTypeCategory = WidgetSpecification.getObjectTypeCategoryWidgetSpecification();
        entrySpecifications.add(new EntrySpecification((IWidgetSpecification)widgetSpec_objectTypeCategory, true));
        WidgetSpecification widgetSpec_horizontalLine = WidgetSpecification.getDecoratorWidgetSpecification((WidgetTypeID)WidgetTypeID.HORIZONTAL_SEPARATOR);
        entrySpecifications.add(new EntrySpecification((IWidgetSpecification)widgetSpec_horizontalLine, true));
        ArrayList<String> propertyTypeIds = new ArrayList<String>();
        propertyTypeIds.add(COTIDsSection.PROPERTY_TYPE_ID_NAME.toCanonicalString());
        WidgetParameters widgetParams = new WidgetParameters(Messages.getString(PROPERTY_LABEL_NAME, contentLocale), Messages.getString(PROPERTY_LABEL_NAME, contentLocale), true);
        WidgetSpecification widgetSpec = new WidgetSpecification(false, propertyTypeIds, new HashMap(), (IWidgetTypeID)WidgetTypeID.FREESTRING, widgetParams);
        EntrySpecification entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        entrySpecifications.add(entrySpec);
        propertyTypeIds = new ArrayList();
        propertyTypeIds.add(COTIDsSection.PROPERTY_TYPE_ID_DESCRIPTION.toCanonicalString());
        widgetParams = new WidgetParameters(Messages.getString(PROPERTY_LABEL_DESCRIPTION, contentLocale), Messages.getString(PROPERTY_LABEL_DESCRIPTION, contentLocale), true);
        widgetSpec = new WidgetSpecification(false, propertyTypeIds, new HashMap(), (IWidgetTypeID)WidgetTypeID.FREETEXT, widgetParams);
        entrySpec = new EntrySpecification((IWidgetSpecification)widgetSpec, true);
        entrySpecifications.add(entrySpec);
        WidgetParameters widgetParas = new WidgetParameters(Messages.getString("ImportDialogueLayout.CockpitData.CustomProperties.Label"), Messages.getString("ImportDialogueLayout.CockpitData.CustomProperties.Tooltip"), true);
        CustomPropertySpecification widgetSpec2 = new CustomPropertySpecification(widgetParas);
        EntrySpecification entrySpec2 = new EntrySpecification((IWidgetSpecification)widgetSpec2, true);
        entrySpecifications.add(entrySpec2);
        PageWidgetParameters pageParams = new PageWidgetParameters(Messages.getString("ImportDialogueLayout.CockpitData.Properties.Label"), Messages.getString("ImportDialogueLayout.CockpitData.Properties.Tooltip"), true, 0);
        PageSpecification pageSpec = new PageSpecification(entrySpecifications, (WidgetParameters)pageParams);
        pageSpecifications.add(pageSpec);
        Sequence editor = new Sequence(pageSpecifications, null);
        return editor;
    }
}

