/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyCopyrightAndLogo;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.ProjectMetaDataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.cockpit.frame.declaration.common.icons16x16.CommonIcons16x16;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTDisplayName;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFile;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeString;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTFreeText;
import com.arcway.frontend.definition.lib.interFace.datatype.lib.FDTLocale;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AbstractDataManagerAdapter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AttributeTypeID2PropertyTypeMap;
import com.arcway.repository.clientadapter.implementation.adapter.frame.IFrameFilePropertyType;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.IDataManagerRootAdapter;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.interFace.Label;
import com.arcway.repository.clientadapter.lib.IDOrNamePropertyComparator;
import com.arcway.repository.clientadapter.lib.NameOrIDPropertyTypeDeclaration;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsCockpitData;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsProject;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryDataTypeID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryNoneBaseObjectTypeDeclaration;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;

public class DataManagerAdapterProject
extends AbstractDataManagerAdapter
implements IDataManagerRootAdapter {
    private static final INameOrIDPropertyTypeDeclaration NAME_PROPERTY_DECLARATION = new NameOrIDPropertyTypeDeclaration((IRepositoryPropertyTypeID)COTIDsProject.PROPERTY_TYPE_ID_NAME, IDOrNamePropertyComparator.COMPARATOR_LOWER_CASE_NORMALIZATION);
    private final ProjectMetaDataManager projectMetaDataManager;
    private static final ICollection_<? extends IParentRelationshipAdapter> parentRelationshipAdapters = new ArrayList_(0);

    public DataManagerAdapterProject(IFrameProjectAgent projectAgent) {
        super(projectAgent, projectAgent.getProjectMetaDataManager());
        this.projectMetaDataManager = projectAgent.getProjectMetaDataManager();
    }

    @Override
    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return COTIDsProject.OBJECT_TYPE_ID;
    }

    @Override
    public IRepositoryObjectTypeID getRepositorySuperObjectTypeID() {
        return COTIDsCockpitData.OBJECT_TYPE_ID;
    }

    @Override
    public ICollection_<? extends IParentRelationshipAdapter> getParentRelationshipAdapters() {
        return parentRelationshipAdapters;
    }

    @Override
    public ILabel[] getLabels() {
        return Label.createLabels(Messages.class, "Project.Project", CommonIcons16x16.PROJECT_CLOSED);
    }

    @Override
    public IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration getCategorySupportTypeDeclaration() {
        return FrameDataTypes.getDataType("frame.project").isSupportingCategories() ? IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.YES : IRepositoryNoneBaseObjectTypeDeclaration.EnumCategorySupportTypeDeclaration.NO;
    }

    @Override
    public IPropertyType[] getFixPropertyTypes() {
        return this.getAttributeTypeID2PropertyTypeMap().getPropertyTypes();
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        return NAME_PROPERTY_DECLARATION;
    }

    @Override
    public String getCockpitDataTypeID() {
        return "frame.project";
    }

    @Override
    protected AttributeTypeID2PropertyTypeMap createAttributeTypeID2PropertyTypeMap() {
        return new AttributeTypeID2PropertyTypeMap(new IAttributeTypeID[]{ProjectAttributeTypeProvider.ATTRID_NAME, ProjectAttributeTypeProvider.ATTRID_DESCRIPTION, ProjectAttributeTypeProvider.ATTRID_COPYRIGHT, ProjectAttributeTypeProvider.ATTRID_LANGUAGE, ProjectAttributeTypeProvider.ATTRID_LOGO}, new IPropertyType[]{new IPropertyType(){
            private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Project.Project.Name", null);

            @Override
            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return COTIDsProject.PROPERTY_TYPE_ID_NAME;
            }

            @Override
            public IRepositoryDataTypeID getDataTypeID() {
                return RDTDisplayName.DATA_TYPE_ID;
            }

            @Override
            public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
                return RDTDisplayName.Parameters.PARAMETERS__IS_SET_ALWAYS__NOT_EMPTY;
            }

            @Override
            public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
                return FDTDisplayName.Parameters.DEFAULTS;
            }

            @Override
            public ILabel[] getLabels() {
                return this.propertyLabels;
            }

            @Override
            public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
                return null;
            }
        }, new IPropertyType(){
            private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Project.Project.Description", null);

            @Override
            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return COTIDsProject.PROPERTY_TYPE_ID_DESCRIPTION;
            }

            @Override
            public IRepositoryDataTypeID getDataTypeID() {
                return RDTFreeText.DATA_TYPE_ID;
            }

            @Override
            public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
                return RDTFreeText.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY;
            }

            @Override
            public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
                return FDTFreeText.Parameters.DEFAULTS;
            }

            @Override
            public ILabel[] getLabels() {
                return this.propertyLabels;
            }

            @Override
            public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
                return null;
            }
        }, new IPropertyType(){
            private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Project.Project.Copyright", null);

            @Override
            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return COTIDsProject.PROPERTY_TYPE_ID_COPYRIGHT;
            }

            @Override
            public IRepositoryDataTypeID getDataTypeID() {
                return RDTFreeString.DATA_TYPE_ID;
            }

            @Override
            public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
                return RDTFreeString.Parameters.PARAMETERS__IS_SET_ALWAYS__POTENTIALLY_EMPTY;
            }

            @Override
            public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
                return FDTFreeString.Parameters.DEFAULTS;
            }

            @Override
            public ILabel[] getLabels() {
                return this.propertyLabels;
            }

            @Override
            public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
                return RDTFreeString.getInstance().createData(Messages.getString("Project.Project.Copyright.Default", repositoryLocale));
            }
        }, new IPropertyType(){
            private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Project.Project.Language", null);

            @Override
            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return COTIDsProject.PROPERTY_TYPE_ID_LANGUAGE;
            }

            @Override
            public IRepositoryDataTypeID getDataTypeID() {
                return RDTLocale.DATA_TYPE_ID;
            }

            @Override
            public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
                return RDTLocale.Parameters.PARAMETERS__IS_SET_ALWAYS__LANUGAGE;
            }

            @Override
            public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
                return FDTLocale.Parameters.DEFAULTS;
            }

            @Override
            public ILabel[] getLabels() {
                return this.propertyLabels;
            }

            @Override
            public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
                return RDTLocale.getInstance().createData(Locale.getDefault());
            }
        }, new IFrameFilePropertyType(){
            private final ILabel[] propertyLabels = Label.createLabels(Messages.class, "Project.Project.Logo", null);

            @Override
            public IRepositoryPropertyTypeID getPropertyTypeID() {
                return COTIDsProject.PROPERTY_TYPE_ID_LOGO;
            }

            @Override
            public IRepositoryDataTypeID getDataTypeID() {
                return RDTFile.DATA_TYPE_ID;
            }

            @Override
            public IRepositoryDataTypeParameters getRepositoryDataTypeParameters() {
                return RDTFile.Parameters.PARAMETERS__IS_SET_POTENTIALLY__ALLOW_IMAGE_FILENAME_POSTFIXES;
            }

            @Override
            public IFrontendDataTypeParameters getFrontendDataTypeParameters() {
                return FDTFile.Parameters.PARAMETERS__SHOW_FILECONTENT_AS_IMAGE;
            }

            @Override
            public ILabel[] getLabels() {
                return this.propertyLabels;
            }

            @Override
            public IRepositoryData getDefaultValueSample(Locale repositoryLocale) {
                return null;
            }

            @Override
            public String getAttributeTypeDataTypeID() {
                return "image";
            }
        }});
    }

    @Override
    protected IAttributeOwnerRW findAttributeOwnerRW(String cockpitDataUID) {
        Project project = this.projectMetaDataManager.getProject();
        if (!project.getUID().equals(cockpitDataUID)) {
            project = null;
        }
        return project;
    }

    @Override
    protected ICockpitProjectData getParentCockpitData(IAttributeOwner child) {
        return null;
    }

    protected Collection<IAttributeOwner> getChildCockpitDatas(IAttributeOwner parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ICockpitProjectData getChildCockpitData(IAttributeOwner parent, String name) {
        throw new UnsupportedOperationException();
    }

    protected Collection<ICockpitProject> getAllCockpitDatas() {
        return Collections.singleton(this.getProjectAgent().getProject());
    }

    @Override
    protected IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        return this.projectMetaDataManager.getProject().getAttributeType(attributeTypeID);
    }

    @Override
    protected ICockpitProjectData createCockpitData(String cockpitDataUID, String name, IAttributeOwner parentCockpitData, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> cockpitAttributes) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getRootData() {
        Project project = this.projectMetaDataManager.getProject();
        return project;
    }

    @Override
    public boolean isCreatableGenerically() {
        return false;
    }

    @Override
    public boolean isDeletableGenerically() {
        return false;
    }

    @Override
    public boolean isModifiableGenerically() {
        return true;
    }

    @Override
    protected void checkPermissionForCreate(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot create projects."));
    }

    @Override
    protected void checkPermissionForMove(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot move project."));
    }

    @Override
    protected void checkPermissionForModifyProperty(IAttributeOwner cockpitData, IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_COPYRIGHT) || attributeType.getAttributeTypeID().equals(ProjectAttributeTypeProvider.ATTRID_LOGO)) {
            transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyCopyrightAndLogo.getInstance());
        } else {
            transactionController.addClientLicenseType(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
        }
        ProjectAttributeModificationManager projectAttributeModificationManager = new ProjectAttributeModificationManager(this.getProjectAgent());
        assert (cockpitData instanceof Project);
        projectAttributeModificationManager.setProject((Project)cockpitData);
        projectAttributeModificationManager.checkGeneralModificationPermissions(attributeType, transactionController);
    }

    @Override
    protected void checkPermissionForModifyObjectTypeCategory(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "No object type categories for projects."));
    }

    @Override
    protected void checkPermissionForDelete(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot delete project."));
    }

    @Override
    protected void getLockForCreateCockpitData(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot create projects."));
    }

    @Override
    protected void getLockForMoveCockpitData(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot move project."));
    }

    @Override
    protected void getLockForModifyCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockToTest(this.getProjectAgent(), "modify");
        transactionController.addLock(this.getProjectAgent(), "modify");
    }

    @Override
    protected void getLockForDeleteCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem(new UnsupportedOperationException(), "Cannot delete project."));
    }
}

