/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.plan;

import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IImportedPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.planagents.EXWriteAccessDeniedExceptionCausedByModificationProblems;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.IOccurrence;
import com.arcway.repository.clientadapter.interFace.IOccurrenceChangeRequest;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.Occurrence;
import com.arcway.repository.cockpit.interFace.declaration.frame.modelelement.COTIDsModelElement;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import de.plans.lib.util.gui.IProgressDisplay;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osgi.util.NLS;

public class PlanOccurrenceManager
implements IOccurrenceManager {
    private static final ILogger LOGGER = Logger.getLogger(PlanOccurrenceManager.class);
    private final IFrameProjectAgent projectAgent;

    public PlanOccurrenceManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public IRepositoryObjectTypeID getObjectTypeIDOfOccurringObjects() {
        return COTIDsModelElement.OBJECT_TYPE_ID;
    }

    @Override
    public String getCockpitDataUIDOfOccurringData(String planUID, String planElementUID) {
        IFrameUniqueElementManager uniqueElementManager = this.projectAgent.getFrameUniqueElementMgr();
        IUniqueElementOccurrence occurence = uniqueElementManager.getUniqueElementOccurrence1(planUID, planElementUID);
        String cockpitDataUIDOfOccuringData = occurence != null ? occurence.getElementUID() : null;
        return cockpitDataUIDOfOccuringData;
    }

    @Override
    public Collection<IOccurrence> getOccurrencesOfOccurringData(String uniqueElementUID) {
        IFrameUniqueElementManager uniqueElementManager = this.projectAgent.getFrameUniqueElementMgr();
        OccurrenceList occurenceList = uniqueElementManager.getUniqueElementOccurrences(uniqueElementUID);
        return this.convertOccurrences(occurenceList);
    }

    @Override
    public Collection<IOccurrence> getOccurrencesOfOccurrenceContainingData(String planUID) {
        IFrameUniqueElementManager uniqueElementManager = this.projectAgent.getFrameUniqueElementMgr();
        OccurrenceList occurenceList = uniqueElementManager.getUniqueElementOccurrencesForPlan(planUID);
        return this.convertOccurrences(occurenceList);
    }

    private Collection<IOccurrence> convertOccurrences(OccurrenceList occurenceList) {
        ArrayList<IOccurrence> occurences = new ArrayList<IOccurrence>(occurenceList.size());
        for (IUniqueElementOccurrence occurence : occurenceList) {
            occurences.add(new Occurrence(occurence));
        }
        return occurences;
    }

    @Override
    public void changeOccurrences(String planUID, IOccurrenceChangeRequest occurenceChangeRequest) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        IFrameSectionManager sectionManager = this.projectAgent.getFrameSectionManager();
        IFrameUniqueElementManager uniqueElementManager = this.projectAgent.getFrameUniqueElementMgr();
        IPlan plan = sectionManager.getPlan(planUID);
        try {
            IImportedPlan importedPlan = uniqueElementManager.openPlan(plan, IProgressDisplay.DUMMY);
            importedPlan.modifyUniqueElementOccurencesByUIDs(occurenceChangeRequest.getOccurrenceIDsOfOccurencesToDelete(), occurenceChangeRequest.getOccurrenceIDOfOccurencesToCreate_2_occuringCockpitDataUID());
        }
        catch (PlanAgentManager.EXPlanAgentLaunchException e) {
            LOGGER.error((Throwable)e);
            throw new EXCockpitPermissionDenied(new String[]{NLS.bind((String)"Unknown plan type {0}.", (Object)plan.getPlantypeUID())});
        }
        catch (EXWriteAccessDeniedExceptionCausedByModificationProblems e) {
            ModificationProblem.interpretateAsPlatformProblem(e.getModificationProblems());
            throw new EXCockpitPermissionDenied(new String[]{"Unknown error."});
        }
        catch (EXWriteAccessDeniedException e) {
            LOGGER.error((Throwable)e);
            String detailedMessage = e.getLocalizedMessage();
            String errorMessage = String.valueOf(NLS.bind((String)Messages.getString("PlanOccurrenceManager.EXWriteAccessDeniedException"), (Object)plan.getPlanName())) + detailedMessage;
            throw new EXCockpitPermissionDenied(new String[]{errorMessage});
        }
        catch (EXModificationProblem e) {
            ModificationProblem.interpretateAsPlatformProblem(e.getModificationProblems());
            throw new EXCockpitPermissionDenied(new String[]{"Unknown error."});
        }
    }

    @Override
    public ILock allocateOccurrenceLocks(String planUID, IOccurrenceChangeRequest occurenceChangeRequest) throws EXCockpitLockDenied {
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        IFrameSectionManager sectionManager = this.projectAgent.getFrameSectionManager();
        IFrameUniqueElementManager uniqueElementManager = this.projectAgent.getFrameUniqueElementMgr();
        if (!(occurenceChangeRequest.getOccurrenceIDsOfOccurencesToDelete().isEmpty() && occurenceChangeRequest.getOccurrenceIDOfOccurencesToCreate_2_occuringCockpitDataUID().isEmpty() || !sectionManager.itemExistsOnServer(planUID))) {
            EOLock modLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "modify", planUID, "com.arcway.cockpit.plan", null, null, new Timestamp(System.currentTimeMillis()));
            locksToBeChecked.add(modLock);
            locksToBeSet.add(modLock);
        }
        for (String uniqueElementUID : occurenceChangeRequest.getOccurrenceIDOfOccurencesToCreate_2_occuringCockpitDataUID().values()) {
            if (!uniqueElementManager.itemExistsOnServer(uniqueElementUID)) continue;
            EOLock addLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "add", uniqueElementUID, "com.arcway.cockpit.uniqueelement", null, null, new Timestamp(System.currentTimeMillis()));
            EOLock delLock = new EOLock(UUIDGenerator.getUniqueID(), this.projectAgent.getProjectUID(), "delete", uniqueElementUID, "com.arcway.cockpit.uniqueelement", null, null, new Timestamp(System.currentTimeMillis()));
            locksToBeChecked.add(delLock);
            locksToBeSet.add(addLock);
        }
        final IFrameLockManager lockManager = this.projectAgent.getFrameLockManager();
        final LockResult lockResult = lockManager.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        if (lockResult.getPossibleServerException() != null) {
            String message = NLS.bind((String)Messages.getString("PlanOccurrenceManager.OccurrenceLockDeniedDueToServerException"), (Object)lockResult.getPossibleServerException().getLocalizedMessage());
            throw new EXCockpitLockDenied(new String[]{message});
        }
        Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
        if (!conflictingLocks.isEmpty()) {
            throw new EXCockpitLockDenied(conflictingLocks.toArray(new EOLock[conflictingLocks.size()]));
        }
        assert (lockResult.wasSuccessful());
        return new ILock(){

            @Override
            public void release() {
                lockManager.releaseLocks(lockResult.getAllRequestedLocks());
            }
        };
    }
}

