/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.frame;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AbstractDataManagerAdapter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AttributeTypeID2PropertyTypeMap;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameParentRelationshipAdapter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.IFrameDataTypeDescriptionForPlatformAdapter;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IParentRelationshipAdapter;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import java.util.Collection;
import java.util.Iterator;

public abstract class DataManagerAdpaterFrameData
extends AbstractDataManagerAdapter {
    private final IFrameDataTypeDescriptionForPlatformAdapter frameDataTypeDescription = this.getFrameDataTypeDescription();
    private final DataManager frameDataManager;
    private final ICollection_<? extends IParentRelationshipAdapter> parentRelationshipAdapters;

    public static final ICockpitProjectData getEqualCockpitDataByAttribute(Collection<IAttributeOwner> frameDataCollection, IAttributeTypeID sourceAttributeTypeID, IAttribute sourceAttribute) {
        IAttribute attributeFromFrameData = null;
        for (IAttributeOwner frameData : frameDataCollection) {
            Object sourceValue;
            attributeFromFrameData = frameData.getAttribute(sourceAttributeTypeID);
            Object valueFromFrameData = attributeFromFrameData.getAttributeValue();
            if (!valueFromFrameData.equals(sourceValue = sourceAttribute.getAttributeValue())) continue;
            return frameData;
        }
        return null;
    }

    public DataManagerAdpaterFrameData(IFrameProjectAgent projectAgent, IFrameDataManager responsibleFrameDataManager) {
        super(projectAgent, responsibleFrameDataManager);
        this.frameDataManager = (DataManager)projectAgent.getDataManager(this.frameDataTypeDescription.getCockpitDataTypeID());
        ArrayList_ parentRelationshipAdaptersRW = new ArrayList_(1);
        parentRelationshipAdaptersRW.add((Object)new FrameParentRelationshipAdapter(this.frameDataTypeDescription));
        this.parentRelationshipAdapters = parentRelationshipAdaptersRW;
    }

    @Override
    public IRepositoryObjectTypeID getRepositoryObjectTypeID() {
        return this.frameDataTypeDescription.getRepositoryObjectTypeID();
    }

    @Override
    public IRepositoryObjectTypeID getRepositorySuperObjectTypeID() {
        return this.frameDataTypeDescription.getRepositorySuperObjectTypeID();
    }

    @Override
    public ICollection_<? extends IParentRelationshipAdapter> getParentRelationshipAdapters() {
        return this.parentRelationshipAdapters;
    }

    @Override
    public ILabel[] getLabels() {
        return this.frameDataTypeDescription.getLabels();
    }

    @Override
    public IPropertyType[] getFixPropertyTypes() {
        return this.frameDataTypeDescription.getNonInheritedPropertyTypes();
    }

    @Override
    public INameOrIDPropertyTypeDeclaration getNamePropertyTypeDeclaration() {
        return this.frameDataTypeDescription.getNamePropertyTypeID();
    }

    @Override
    public String getCockpitDataTypeID() {
        return this.frameDataTypeDescription.getCockpitDataTypeID();
    }

    @Override
    protected AttributeTypeID2PropertyTypeMap createAttributeTypeID2PropertyTypeMap() {
        return new AttributeTypeID2PropertyTypeMap(this.frameDataTypeDescription.getAllCockpitAttributeTypeIDs(), this.frameDataTypeDescription.getAllPropertyTypes());
    }

    @Override
    public IAttributeOwnerRW findAttributeOwnerRW(String cockpitDataUID) {
        IAttributeOwnerRW attributeOwnerRW = (IAttributeOwnerRW)this.frameDataManager.getCockpitProjectData(cockpitDataUID);
        if (attributeOwnerRW != null && !this.frameDataManager.getParent(attributeOwnerRW).getTypeID().equals(this.frameDataTypeDescription.getParentCockpitDataTypeID())) {
            attributeOwnerRW = null;
        }
        return attributeOwnerRW;
    }

    @Override
    protected ICockpitProjectData getParentCockpitData(IAttributeOwner child) {
        IAttributeOwner parentData = this.frameDataManager.getParent(child);
        return parentData;
    }

    protected Collection<IAttributeOwner> getChildCockpitDatas(IAttributeOwner parent) {
        return this.getProjectAgent().getChildRelationsManager().getChildren(parent, this.frameDataTypeDescription.getCockpitDataTypeID());
    }

    @Override
    protected Collection<? extends IAttributeOwner> getAllCockpitDatas() {
        return this.frameDataManager.getData();
    }

    @Override
    protected ICockpitProjectData getChildCockpitData(IAttributeOwner parent, String name) {
        Collection<IAttributeOwner> children = this.getChildCockpitDatas(parent);
        IAttributeOwner child = null;
        Iterator<IAttributeOwner> i = children.iterator();
        while (child == null && i.hasNext()) {
            IAttributeOwner currentChild = i.next();
            INameOrIDPropertyTypeDeclaration nameOrIDPropertyTypeDeclaration = this.getNamePropertyTypeDeclaration();
            IAttributeTypeID nameAttributeTypeID = this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDByPropertyTypeID(nameOrIDPropertyTypeDeclaration.getPropertyTypeID());
            Assert.checkArgumentBeeingNotNull((Object)nameAttributeTypeID);
            String currentName = (String)parent.getAttribute(nameAttributeTypeID).getAttributeValue();
            if (!name.equals(currentName)) continue;
            child = currentChild;
        }
        return child;
    }

    @Override
    protected IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) {
        IAttributeTypesProvider attributeTypesProvider = this.frameDataTypeDescription.getAttributeTypesProvider();
        return attributeTypesProvider.getAttributeType(attributeTypeID);
    }

    @Override
    protected ICockpitProjectData createCockpitData(String cockpitDataUID, String name, IAttributeOwner parentCockpitData, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> cockpitAttributes) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        ICockpitProjectData createdCockpitData;
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.frameDataManager.requestAddPermission(name, objectTypeCategoryID, cockpitAttributes, parentCockpitData, false, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.execute();
        DataManagerAdpaterFrameData.handleModificationProblems(modProblems);
        try {
            Collection<IAttributeOwner> addedData = this.frameDataManager.addData(transactionController);
            createdCockpitData = (ICockpitProjectData)addedData.iterator().next();
        }
        catch (EXNoPermission e) {
            throw new RuntimeException(e);
        }
        return createdCockpitData;
    }

    protected abstract IFrameDataTypeDescriptionForPlatformAdapter getFrameDataTypeDescription();

    @Override
    public void checkPermissionForCreate(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        for (IClientFunctionLicenseType clientLicenseType : this.frameDataManager.getNeededLicenseTypesForAdd()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
        transactionController.addPermission("addChild", this.getCockpitDataTypeID(), DataManager.getParentOperandTree((IAttributeOwner)parentCockpitData, this.getProjectAgent()));
    }

    @Override
    public void checkPermissionForMove(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        for (IClientFunctionLicenseType clientLicenseType : this.frameDataManager.getNeededLicenseTypesForAdd()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
        IAttributeOwner newParentAttributeOwner = (IAttributeOwner)newParentCockpitData;
        this.frameDataManager.requestMovePermission(cockpitData, newParentAttributeOwner, transactionController);
    }

    @Override
    public void checkPermissionForModifyProperty(IAttributeOwner cockpitData, IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        for (IClientFunctionLicenseType clientLicenseType : this.frameDataManager.getNeededLicenseTypesForAdd()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
        transactionController.addAttributeModificationPermission(attributeType, DataManager.getParentOperandTree(cockpitData, this.getProjectAgent()), false);
    }

    @Override
    protected void checkPermissionForModifyObjectTypeCategory(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        for (IClientFunctionLicenseType clientLicenseType : this.frameDataManager.getNeededLicenseTypesForAdd()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
        this.frameDataManager.requestDataDeletePermission(cockpitData, transactionController);
    }

    @Override
    public void checkPermissionForDelete(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        for (IClientFunctionLicenseType clientLicenseType : this.frameDataManager.getNeededLicenseTypesForDelete()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
        transactionController.addPermission("deleteChild", this.getCockpitDataTypeID(), DataManager.getParentOperandTree(this.frameDataManager.getParent(cockpitData), this.getProjectAgent()));
    }

    @Override
    protected void getLockForCreateCockpitData(ICockpitProjectData parentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        ILockable parentLockable = (ILockable)parentCockpitData;
        transactionController.addLockToTest(parentLockable, "delete");
        transactionController.addLock(parentLockable, "add");
    }

    @Override
    protected void getLockForMoveCockpitData(IAttributeOwner cockpitData, ICockpitProjectData newParentCockpitData, ILocksAndPermissionsTransactionController transactionController) {
        IAttributeOwner newParentAttributeOwner = (IAttributeOwner)newParentCockpitData;
        this.frameDataManager.requestMovePermission(cockpitData, newParentAttributeOwner, transactionController);
    }

    @Override
    protected void getLockForModifyCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockToTest((ILockable)cockpitData, "modify");
        transactionController.addLock((ILockable)cockpitData, "modify");
    }

    @Override
    protected void getLockForDeleteCockpitData(IAttributeOwner cockpitData, ILocksAndPermissionsTransactionController transactionController) {
        this.frameDataManager.requestDataDeletePermission(cockpitData, transactionController);
    }

    protected abstract IAttributeModificationManager createAttributeModificationManager();
}

