/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter.frame;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Icon;
import com.arcway.frontend.definition.lib.interFace.declaration.label.IconObject;
import com.arcway.frontend.definition.lib.interFace.declaration.label.Text;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.specification.editor.Editor;
import com.arcway.lib.ui.editor.specification.sequential.Sequence;
import com.arcway.repository.clientadapter.implementation.adapter.frame.AttributeTypeID2PropertyTypeMap;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameProperty;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IIDSampleAndLock;
import com.arcway.repository.clientadapter.interFace.ILock;
import com.arcway.repository.clientadapter.interFace.INameOrIDPropertyTypeDeclaration;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.IPropertyType;
import com.arcway.repository.clientadapter.lib.LockHelper;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractDataManagerAdapter
implements IDataManagerAdapter {
    private final IFrameProjectAgent projectAgent;
    private final IFrameDataManager dataManager;
    private AttributeTypeID2PropertyTypeMap attributeTypeID2PropertyTypeMap;

    private static final IProperty findPropertyOfType(IRepositoryPropertyTypeID propertyTypeid, IProperty[] allProperties) {
        IProperty[] iPropertyArray = allProperties;
        int n = allProperties.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty element = iPropertyArray[n2];
            IRepositoryPropertyTypeID propertyTypeIDFromArray = element.getPropertyTypeID();
            if (IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER.isEqual((Object)propertyTypeIDFromArray, (Object)propertyTypeid)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    public AbstractDataManagerAdapter(IFrameProjectAgent projectAgent, IFrameDataManager dataManager) {
        Assert.checkArgumentBeeingNotNull((Object)projectAgent);
        this.projectAgent = projectAgent;
        this.dataManager = dataManager;
    }

    protected IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    protected AttributeTypeID2PropertyTypeMap getAttributeTypeID2PropertyTypeMap() {
        if (this.attributeTypeID2PropertyTypeMap == null) {
            this.attributeTypeID2PropertyTypeMap = this.createAttributeTypeID2PropertyTypeMap();
            Assert.checkArgumentBeeingNotNull((Object)this.attributeTypeID2PropertyTypeMap);
        }
        return this.attributeTypeID2PropertyTypeMap;
    }

    @Override
    public Text getObjectLabelText() {
        return null;
    }

    @Override
    public Icon getObjectLabelIcon() {
        return new IconObject();
    }

    @Override
    public String getCockpitTypeThatProvidesCustomProperties() {
        return this.getCockpitDataTypeID();
    }

    @Override
    public final INameOrIDPropertyTypeDeclaration getIDPropertyTypeDeclaration() {
        return null;
    }

    @Override
    public final ICockpitProjectData findData(String cockpitDataUID) {
        return this.findAttributeOwnerRW(cockpitDataUID);
    }

    @Override
    public final ICockpitDataID getParentCockpitDataID(ICockpitProjectData childCockpitData) {
        ICockpitProjectData parentCockpitData = this.getParentCockpitData((IAttributeOwner)childCockpitData);
        CockpitDataID cockpitDataID = new CockpitDataID(parentCockpitData.getTypeID(), parentCockpitData.getUID());
        return cockpitDataID;
    }

    @Override
    public final ICockpitProjectData[] getChildren(ICockpitProjectData parentCockpitData) {
        Collection<? extends IAttributeOwner> childCockpitDatas = this.getChildCockpitDatas((IAttributeOwner)parentCockpitData);
        return childCockpitDatas.toArray(new ICockpitProjectData[childCockpitDatas.size()]);
    }

    @Override
    public final ICockpitProjectData[] getAllData() {
        Collection<? extends IAttributeOwner> allData = this.getAllCockpitDatas();
        return allData.toArray(new ICockpitProjectData[allData.size()]);
    }

    @Override
    public final ICockpitProjectData findDataByNameProperty(IProperty nameProperty, ICockpitProjectData parent) {
        String name = this.getPropertyAsStringValue(nameProperty);
        return this.getChildCockpitData((IAttributeOwner)parent, name);
    }

    @Override
    public final ICockpitProjectData findDataByIDProperty(IProperty idProperty) {
        throw new UnsupportedOperationException();
    }

    private String getPropertyAsStringValue(IProperty property) {
        IAttributeTypeID sourceAttributeTypeID = this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDByPropertyTypeID(property.getPropertyTypeID());
        Assert.checkArgumentBeeingNotNull((Object)sourceAttributeTypeID);
        IAttributeType sourceAttributeType = this.getAttributeType(sourceAttributeTypeID);
        IRepositoryData sourceRepositoryData = property.getValue();
        IAttribute sourceAttribute = FrameProperty.convertRepositoryDataToCockpitAttribute(sourceRepositoryData, sourceAttributeType);
        String name = (String)sourceAttribute.getAttributeValue();
        return name;
    }

    @Override
    public ObjectTypeCategory getObjectTypeCategory(ICockpitProjectData cockpitData) {
        AbstractFrameData frameData = (AbstractFrameData)cockpitData;
        ObjectTypeCategoryID categoryID = frameData.getCategoryID();
        if (categoryID != null) {
            return this.projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
        }
        return null;
    }

    @Override
    public final IProperty getCockpitDataProperty(ICockpitProjectData cockpitData, IRepositoryPropertyTypeID repositoryPropertyTypeID) {
        IAttributeOwner frameData = (IAttributeOwner)cockpitData;
        IPropertyType propertyType = this.getAttributeTypeID2PropertyTypeMap().getPropertyTypeByPropertyTypeID(repositoryPropertyTypeID);
        IAttributeTypeID attributeTypeID = this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDByPropertyTypeID(repositoryPropertyTypeID);
        FrameProperty property = new FrameProperty(this.projectAgent, frameData, attributeTypeID, propertyType);
        return property;
    }

    @Override
    public final ICockpitProjectData createCockpitData(ICockpitProjectData parentCockpitData, String cockpitDataUID, String objectTypeCategoryIDString, IProperty[] properties) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        String name = this.getName(properties);
        ObjectTypeCategoryID objectTypeCategoryID = objectTypeCategoryIDString != null ? ObjectTypeCategoryID.getObjectTypeCategoryID((String)objectTypeCategoryIDString) : null;
        Collection<IAttribute> cockpitAttributes = this.getAttributes(properties);
        ICockpitProjectData createdCockpitData = this.createCockpitData(cockpitDataUID, name, (IAttributeOwner)parentCockpitData, objectTypeCategoryID, cockpitAttributes);
        return createdCockpitData;
    }

    @Override
    public IAttributeOwnerRW getAttributeOwnerRW(ICockpitProjectData cockpitProjectData) {
        return (IAttributeOwnerRW)cockpitProjectData;
    }

    private String getName(IProperty[] properties) {
        String name;
        IRepositoryPropertyTypeID namePropertyTypeID = RepositoryObjectTypes.findNamePropertyTypeID((IRepositoryObjectType)this.projectAgent.getRepositoryInterface().getTypeManager().getObjectType(this.getRepositoryObjectTypeID()));
        if (namePropertyTypeID != null) {
            IProperty nameProperty = AbstractDataManagerAdapter.findPropertyOfType(namePropertyTypeID, properties);
            Assert.checkArgumentBeeingNotNull((Object)nameProperty);
            IRepositoryData sourceRepositoryData = nameProperty.getValue();
            DataTypeString targetCockpitDataType = DataTypeString.getInstanceString();
            IValueRange targetCockpitValueRange = null;
            Object cockpitValue = FrameDataConverter.convertRepositoryDataToCockpitAttribute(sourceRepositoryData, targetCockpitDataType, targetCockpitValueRange);
            name = (String)cockpitValue;
        } else {
            name = null;
        }
        return name;
    }

    private Collection<IAttribute> getAttributes(IProperty[] properties) {
        IPropertyType[] allPropertyTypes;
        ArrayList<IAttribute> cockpitAttributes = new ArrayList<IAttribute>();
        IPropertyType[] iPropertyTypeArray = allPropertyTypes = this.getAttributeTypeID2PropertyTypeMap().getPropertyTypes();
        int n = allPropertyTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyType element = iPropertyTypeArray[n2];
            IProperty property = AbstractDataManagerAdapter.findPropertyOfType(element.getPropertyTypeID(), properties);
            Assert.checkArgumentBeeingNotNull((Object)property);
            cockpitAttributes.add(this.getAttribute(property));
            ++n2;
        }
        return cockpitAttributes;
    }

    private IAttribute getAttribute(IProperty property) {
        IRepositoryData sourceRepositoryData = property.getValue();
        IAttributeTypeID attributeTypeID = this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDByPropertyTypeID(property.getPropertyTypeID());
        IAttributeType attributeType = this.getAttributeType(attributeTypeID);
        return FrameProperty.convertRepositoryDataToCockpitAttribute(sourceRepositoryData, attributeType);
    }

    @Override
    public final void moveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData newParentCockpitData) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        IAttributeOwnerRW attributeOwnerToMove = (IAttributeOwnerRW)cockpitData;
        IAttributeOwnerRW newParentAttributeOwner = (IAttributeOwnerRW)newParentCockpitData;
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        IFrameDataManager dataManager_ = this.getProjectAgent().getDataManager(this.getCockpitDataTypeID());
        dataManager_.requestMovePermission(attributeOwnerToMove, newParentAttributeOwner, transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.execute();
        ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        try {
            dataManager_.moveData(transactionController);
        }
        catch (EXNoPermission e) {
            throw new RuntimeException(e);
        }
        catch (EXNoLock e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ICockpitProjectData modifyCockpitDataObjectTypeCategory(ICockpitProjectData cockpitData, String newCategoryID) throws EXCockpitLockDenied, EXCockpitPermissionDenied {
        AbstractFrameData dataToModify = (AbstractFrameData)cockpitData;
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForModifyObjectTypeCategory(dataToModify, transactionController);
        this.getLockForModifyCockpitData(dataToModify, transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.execute();
        ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        ObjectTypeCategoryID newCategoryIDObject = newCategoryID != null ? ObjectTypeCategoryID.getObjectTypeCategoryID((String)newCategoryID) : null;
        dataToModify.setCategoryID(newCategoryIDObject);
        this.dataManager.dataModified(dataToModify);
        return dataToModify;
    }

    @Override
    public final ICockpitProjectData modifyCockpitData(ICockpitProjectData cockpitData, IProperty[] newProperties) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        IAttributeOwnerRW dataToModify = (IAttributeOwnerRW)cockpitData;
        IPropertyType[] allPropertyTypes = this.getAttributeTypeID2PropertyTypeMap().getPropertyTypes();
        IAttributeTypeID[] allAttributeTypeIDs = this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDs();
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>(allAttributeTypeIDs.length);
        int i = 0;
        while (i < allPropertyTypes.length) {
            IAttributeTypeID attributeTypeID = allAttributeTypeIDs[i];
            IProperty propertyOfCurrentType = AbstractDataManagerAdapter.findPropertyOfType(allPropertyTypes[i].getPropertyTypeID(), newProperties);
            if (propertyOfCurrentType != null) {
                IRepositoryData sourceRepositoryData = propertyOfCurrentType.getValue();
                IAttributeType attributeType = this.getAttributeType(attributeTypeID);
                IAttribute cockpitAttribute = FrameProperty.convertRepositoryDataToCockpitAttribute(sourceRepositoryData, attributeType);
                dataToModify.requestAttributeModificationPermission(cockpitAttribute, transactionController);
                attributes.add(cockpitAttribute);
            }
            ++i;
        }
        Collection<IModificationProblem> modificationProblems = transactionController.execute();
        ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        for (IAttribute cockpitAttribute : attributes) {
            try {
                dataToModify.setAttribute(cockpitAttribute);
            }
            catch (EXNoPermission e) {
                throw new RuntimeException(e);
            }
            catch (EXNoLock e) {
                throw new RuntimeException(e);
            }
        }
        return dataToModify;
    }

    @Override
    public void deleteCockpitData(ICockpitProjectData cockpitData) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        IAttributeOwnerRW attributeOwnerToDelete = (IAttributeOwnerRW)cockpitData;
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        IFrameDataManager dataManager_ = this.getProjectAgent().getDataManager(this.getCockpitDataTypeID());
        dataManager_.requestDataDeletePermission(attributeOwnerToDelete, transactionController);
        Collection<IModificationProblem> modificationProblems = transactionController.execute();
        ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        try {
            dataManager_.deleteData(transactionController);
        }
        catch (EXNoPermission e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void checkPermissionForCreateCockpitData(ICockpitProjectData parentCockpitData) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForCreate(parentCockpitData, transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public final void checkPermissionForMoveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData newParentCockpitData) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForMove((IAttributeOwner)cockpitData, newParentCockpitData, transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public final void checkPermissionForModifyCockpitDataProperty(ICockpitProjectData cockpitData, IRepositoryPropertyTypeID propertyTypeID) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForModifyProperty((IAttributeOwner)cockpitData, this.getAttributeType(this.getAttributeTypeID2PropertyTypeMap().getAttributeTypeIDByPropertyTypeID(propertyTypeID)), transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public final void checkPermissionForModifyCockpitDataProperty(ICockpitProjectData cockpitData, IAttributeType customPropertyType) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForModifyProperty((IAttributeOwner)cockpitData, customPropertyType, transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public final void checkPermissionForModifyCockpitDataObjectTypeCategory(ICockpitProjectData cockpitData) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForModifyObjectTypeCategory((IAttributeOwner)cockpitData, transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public final void checkPermissionForDeleteCockpitData(ICockpitProjectData cockpitData) throws EXCockpitPermissionDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.checkPermissionForDelete((IAttributeOwner)cockpitData, transactionController);
        AbstractDataManagerAdapter.checkPermissions(transactionController);
    }

    @Override
    public ILock getLockForCreateCockpitData(ICockpitProjectData parentCockpitData) throws EXCockpitLockDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.getLockForCreateCockpitData(parentCockpitData, transactionController);
        return AbstractDataManagerAdapter.getLock(transactionController);
    }

    @Override
    public ILock getLockForMoveCockpitData(ICockpitProjectData cockpitData, ICockpitProjectData newParentCockpitData) throws EXCockpitLockDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.getLockForMoveCockpitData((IAttributeOwner)cockpitData, newParentCockpitData, transactionController);
        return AbstractDataManagerAdapter.getLock(transactionController);
    }

    @Override
    public ILock getLockForModifyCockpitData(ICockpitProjectData cockpitData) throws EXCockpitLockDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.getLockForModifyCockpitData((IAttributeOwner)cockpitData, transactionController);
        return AbstractDataManagerAdapter.getLock(transactionController);
    }

    @Override
    public ILock getLockForDeleteCockpitData(ICockpitProjectData cockpitData) throws EXCockpitLockDenied {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.getProjectAgent());
        this.getLockForDeleteCockpitData((IAttributeOwner)cockpitData, transactionController);
        return AbstractDataManagerAdapter.getLock(transactionController);
    }

    @Override
    public ILock getLockForUniqueID(String id) throws EXCockpitLockDenied {
        throw new UnsupportedOperationException();
    }

    protected abstract AttributeTypeID2PropertyTypeMap createAttributeTypeID2PropertyTypeMap();

    protected abstract IAttributeOwnerRW findAttributeOwnerRW(String var1);

    protected abstract ICockpitProjectData getParentCockpitData(IAttributeOwner var1);

    protected abstract Collection<? extends IAttributeOwner> getChildCockpitDatas(IAttributeOwner var1);

    protected abstract ICockpitProjectData getChildCockpitData(IAttributeOwner var1, String var2);

    protected abstract Collection<? extends IAttributeOwner> getAllCockpitDatas();

    protected abstract IAttributeType getAttributeType(IAttributeTypeID var1);

    @Override
    public IIDSampleAndLock sampleNextFreeID(ICockpitProjectData parentCockpitData, boolean checkOnClientOnly) {
        return null;
    }

    protected abstract ICockpitProjectData createCockpitData(String var1, String var2, IAttributeOwner var3, ObjectTypeCategoryID var4, Collection<IAttribute> var5) throws EXCockpitPermissionDenied, EXCockpitLockDenied;

    protected abstract void checkPermissionForCreate(ICockpitProjectData var1, ILocksAndPermissionsTransactionController var2);

    protected abstract void checkPermissionForMove(IAttributeOwner var1, ICockpitProjectData var2, ILocksAndPermissionsTransactionController var3);

    protected abstract void checkPermissionForModifyProperty(IAttributeOwner var1, IAttributeType var2, ILocksAndPermissionsTransactionController var3);

    protected abstract void checkPermissionForModifyObjectTypeCategory(IAttributeOwner var1, ILocksAndPermissionsTransactionController var2);

    protected abstract void checkPermissionForDelete(IAttributeOwner var1, ILocksAndPermissionsTransactionController var2);

    protected abstract void getLockForCreateCockpitData(ICockpitProjectData var1, ILocksAndPermissionsTransactionController var2);

    protected abstract void getLockForMoveCockpitData(IAttributeOwner var1, ICockpitProjectData var2, ILocksAndPermissionsTransactionController var3);

    protected abstract void getLockForModifyCockpitData(IAttributeOwner var1, ILocksAndPermissionsTransactionController var2);

    protected abstract void getLockForDeleteCockpitData(IAttributeOwner var1, ILocksAndPermissionsTransactionController var2);

    protected static final void handleModificationProblem(IModificationProblem modificationProblem) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        if (modificationProblem != null) {
            ModificationProblem.interpretateAsPlatformProblem(Collections.singleton(modificationProblem));
            throw new RuntimeException("line cannot be reached");
        }
    }

    protected static final void handleModificationProblems(Collection<IModificationProblem> modificationProblems) throws EXCockpitPermissionDenied, EXCockpitLockDenied {
        if (modificationProblems != null && !modificationProblems.isEmpty()) {
            ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
            throw new RuntimeException("line cannot be reached");
        }
    }

    private static void checkPermissions(ILocksAndPermissionsTransactionController transactionController) throws EXCockpitPermissionDenied {
        Collection<IModificationProblem> modificationProblems = transactionController.checkConditions(false, true);
        try {
            ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        }
        catch (EXCockpitLockDenied e) {
            throw new RuntimeException(e);
        }
    }

    private static ILock getLock(ILocksAndPermissionsTransactionController transactionController) throws EXCockpitLockDenied {
        Collection<IModificationProblem> modificationProblems = transactionController.allocateLocks();
        try {
            ModificationProblem.interpretateAsPlatformProblem(modificationProblems);
        }
        catch (EXCockpitPermissionDenied exPermissionDenied) {
            throw new EXCockpitLockDenied(exPermissionDenied.getLocalizedUserHints());
        }
        return LockHelper.getILock(transactionController);
    }

    @Override
    public Editor getFormEditorLayoutSpecification() {
        return null;
    }

    @Override
    public Sequence getSequentialLayoutSpecification(Locale contentLocale) {
        return null;
    }

    @Override
    public IMap_<IRepositoryPropertyTypeID, IOccurrenceManager> getOccurrenceManagers() {
        return NO_OCCURENCE_MANAGERS;
    }

    @Override
    public String getAuthorOfObject(ICockpitProjectData object) {
        IAttributeType attributeType = ((AbstractFrameData)object).getAttributeType(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        IAttribute attribute = ((AbstractFrameData)object).getAttribute(AbstractAttributeTypesProvider.ATTRID_CREATOR);
        Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(((AbstractFrameData)object).getProjectUID()).getLanguage());
        return attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), null, null, projectLanguage);
    }

    @Override
    public Date getCreationDateOfObject(ICockpitProjectData object) {
        IAttribute attribute = ((AbstractFrameData)object).getAttribute(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        return DataTypeDate.getValueAsDate(attribute.getAttributeValue());
    }

    @Override
    public String getLastModifierOfObject(ICockpitProjectData object) {
        IAttributeType attributeType = ((AbstractFrameData)object).getAttributeType(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        IAttribute attribute = ((AbstractFrameData)object).getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(((AbstractFrameData)object).getProjectUID()).getLanguage());
        return attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), null, null, projectLanguage);
    }

    @Override
    public Date getDateOfLastModificationOfObject(ICockpitProjectData object) {
        IAttribute attribute = ((AbstractFrameData)object).getAttribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        return DataTypeDate.getValueAsDate(attribute.getAttributeValue());
    }
}

