/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.EXConnectionLost;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterInterface;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.locks.EXConcurrentCommit;
import com.arcway.repository.clientadapter.implementation.adapter.locks.EXConcurrentLocks;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.EOWorkspaceInformation;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.interFace.chassis.IRepositoryChassis;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchiveRW;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.implementation.workspace.EXConcurrentRepositoryModification;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceListener;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.implementation.workstation.EXNotOnline;
import com.arcway.repository.interFace.implementation.workstation.IRepositoryWorkstationListener;
import com.arcway.repository.interFace.implementation.workstation.IRepositoryWorkstationRO;
import com.arcway.repository.interFace.implementation.workstation.RepositoryWorkstationConnectionState;
import com.arcway.repository.interFace.plugin.extensions.IRepositoryChassisClient;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.ITransactionExecutionWrapper;
import java.util.Collection;

public class PlatformAdapterWorkspace
implements IRepositoryWorkspaceRW {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterWorkspace.class);
    private static final IRepositoryChassis REPOSITORY_CHASSIS = IRepositoryChassisClient.REPOSITORY_CHASSIS;
    private final PlatformAdapterWorkstation workstation;
    private final PlatformAdapterInterface repositoryInterface;
    private final IRepositoryTransactionManager transactionManager;
    private final ListenerKey workstationListenerKey = new ListenerKey();
    private final IRepositoryWorkstationListener workstationListener = new IRepositoryWorkstationListener(){

        public void dispose() {
            PlatformAdapterWorkspace.this.shutdown();
        }

        public void availableWorkspaceInformationsChanged() {
        }

        public void connectionStateChanged(RepositoryWorkstationConnectionState newConnectionState) {
        }

        public void workspaceLocksChanged(IRepositoryObjectSample workspaceInformation) {
        }
    };
    private final ListenerManager<IRepositoryWorkspaceListener> listenerManager = new ListenerManager();

    public PlatformAdapterWorkspace(PlatformAdapterWorkstation workstation) {
        Assert.checkArgumentBeeingNotNull((Object)workstation);
        this.workstation = workstation;
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": setting up");
        }
        workstation.getListenerManager().addListener(this.workstationListenerKey, (IDisposeListener)this.workstationListener);
        this.repositoryInterface = new PlatformAdapterInterface(workstation.getCockpitController().getPlatformAdapterModuleManager(), (IRepositoryWorkspaceRO)this);
        this.transactionManager = REPOSITORY_CHASSIS.createRepositoryTransactionManager(this.getRepositoryInterfaceRO(), new ITransactionExecutionWrapper(){

            public void run(Runnable runnable) {
                PlatformAdapterWorkspace.this.getCockpitController().deactivatePropertyChangesListening();
                try {
                    PlatformAdapterWorkspace.this.getCockpitController().getProjectAgent().getModelTransactionManager().executeTransaction(runnable);
                }
                finally {
                    PlatformAdapterWorkspace.this.getCockpitController().activatePropertyChangesListening();
                }
            }
        });
        workstation.registerWorkspace(this);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": set up");
        }
    }

    public PlatformAdapterWorkstation getWorkstationImplementation() {
        return this.workstation;
    }

    public PlatformAdapterInterface getRepositoryInterfaceImplementation() {
        return this.repositoryInterface;
    }

    public IRepositoryTypeManagerRO getTypeManagerRO() {
        return this.getWorkstationRO().getTypeManagerRO();
    }

    public IRepositoryWorkstationRO getWorkstationRO() {
        return this.getWorkstationImplementation();
    }

    public IRepositoryInterfaceRO getRepositoryInterfaceRO() {
        return this.getRepositoryInterfaceImplementation();
    }

    public ListenerManager<IRepositoryWorkspaceListener> getListenerManager() {
        return this.listenerManager;
    }

    public void shutdown() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": shutting down");
        }
        this.transactionManager.shutdown();
        this.listenerManager.dispose();
        this.workstation.getListenerManager().removeListener(this.workstationListenerKey);
        this.workstation.unregisterWorkspace(this);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": shut down");
        }
    }

    public IRepositoryTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public IFrameCockpitController getCockpitController() {
        return this.getWorkstationImplementation().getCockpitController();
    }

    public ILockManager getLockManager() {
        return this.getWorkstationImplementation().getLockManager();
    }

    public IRepositoryObjectSample getWorkspaceInformation() {
        EOWorkspaceInformation eoWorkspaceInformation = this.getCockpitController().getWorkspaceInformation();
        IRepositoryObjectSample workspaceInformation = this.getWorkstationImplementation().createWorkspaceInformation(eoWorkspaceInformation);
        return workspaceInformation;
    }

    public void allocateWorkspaceLocks(ISet_<AbstractRepositoryLockSample> locksToCheck, ISet_<AbstractRepositoryLockSample> locksToRelease, ISet_<AbstractRepositoryLockSample> locksToAllocate) throws EXNotOnline, EXConcurrentRepositoryModification, com.arcway.repository.interFace.implementation.workspace.EXConcurrentLocks {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": allocating locks");
        }
        Collection<EOPlatformLock> eoLocksToCheck = this.getWorkstationImplementation().createEOLocks(locksToCheck);
        Collection<EOPlatformLock> eoLocksToRelease = this.getWorkstationImplementation().createEOLocks(locksToRelease);
        Collection<EOPlatformLock> eoLocksToAllocate = this.getWorkstationImplementation().createEOLocks(locksToAllocate);
        try {
            this.getLockManager().allocateLocks(eoLocksToCheck, eoLocksToRelease, eoLocksToAllocate);
            this.getWorkstationImplementation().workspaceLocksChanged(this.getWorkstationImplementation().createEOWorkspaceInformation(this.getWorkspaceInformation()));
        }
        catch (EXConnectionLost e) {
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "^ Workspace " + To.string((Object)this) + ": allocating locks failed due to offline mode");
            }
            throw new EXNotOnline();
        }
        catch (EXConcurrentCommit e) {
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "^ Workspace " + To.string((Object)this) + ": allocating locks failed due to concurrent commit");
            }
            throw new EXConcurrentRepositoryModification();
        }
        catch (EXConcurrentLocks e) {
            Collection<EOPlatformLock> eoTakenLocks = e.getTakenLocks();
            ISet_<AbstractRepositoryLockSample> takenLocks = this.getWorkstationImplementation().createLocks(eoTakenLocks);
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "^ Workspace " + To.string((Object)this) + ": allocating locks failed due to concurrent locks");
            }
            throw new com.arcway.repository.interFace.implementation.workspace.EXConcurrentLocks(takenLocks);
        }
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": locks allocated");
        }
    }

    public IRepositoryFileArchiveRW getFileArchiveImplementation() {
        return this.getCockpitController().getFileArchiveImplementation();
    }

    public IRepositoryFileArchiveRW getFileArchiveRW() {
        return this.getFileArchiveImplementation();
    }

    public void workspaceDiscarded() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": discarding workspace");
        }
        this.getRepositoryInterfaceImplementation().localChangesDone(null);
        this.getTransactionManager().clearModifications();
        this.getRepositoryInterfaceImplementation().snapshotChanged();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": workspace discarded");
        }
    }

    public void workspaceCommited(EOWorkspaceInformation workspaceInformation, EOCommitInformation commit) {
        To.makeNotNull((Object)commit);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": committing workspace");
        }
        this.getRepositoryInterfaceImplementation().localChangesDone(null);
        if (this.getCockpitController().getWorkspaceInformation().getWorkspaceUID().equals(workspaceInformation.getWorkspaceUID())) {
            this.getTransactionManager().clearModifications();
        } else {
            this.getTransactionManager().merge();
        }
        this.getRepositoryInterfaceImplementation().snapshotChanged();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": workspace committed");
        }
    }

    public void concurrentLocalModifications() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Workspace " + To.string((Object)this) + ": concurrent local modifcations");
        }
        this.getRepositoryInterfaceImplementation().localChangesDone(null);
        this.getTransactionManager().merge();
        this.getRepositoryInterfaceImplementation().snapshotChanged();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Workspace " + To.string((Object)this) + ": concurrent local modifcations");
        }
    }
}

