/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.InstanceCache;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterAttributeSet;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCategory;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCockpitCrossLinkIterator;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCockpitObjectIterator;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterCrossLinkRelation;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterInterface;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterOccurrenceChangeRequest;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterOccurrenceRelation;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkspace;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.frame.FrameDataConverter;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.CockpitObjectTypeCategoryID;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.ICockpitObjectTypeCategoryID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IDataManagerRootAdapter;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IOccurrence;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.clientadapter.interFace.IProperty;
import com.arcway.repository.clientadapter.interFace.IRelation;
import com.arcway.repository.clientadapter.interFace.IRelationContribution;
import com.arcway.repository.clientadapter.interFace.Occurrence;
import com.arcway.repository.clientadapter.lib.RelationContribution;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelation;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.IOccurrenceRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceListener;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotListener;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRW;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.attributeset.IRepositoryAttributeSetTypeID;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.registration.type.relationcontribution.IParentRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.OccurrenceRelationContribution;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.DataValidationException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PlatformAdapterSnapshot
implements IRepositorySnapshotRW {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterSnapshot.class);
    private final PlatformAdapterInterface repositoryInterface;
    private IRepositoryObjectSample snapshotInformation;
    private String cacheForSnapshotUID;
    private final PlatformAdapterObject rootObject;
    private final ListenerKey interfaceListenerKey = new ListenerKey();
    private final IRepositoryInterfaceListener interfaceListener = new IRepositoryInterfaceListener(){

        public void dispose() {
            if (PlatformAdapterSnapshot.this.isOpen()) {
                PlatformAdapterSnapshot.this.abortSnapshot();
            }
        }

        public void repositoryNewCurrentSnapshot(IRepositoryObjectSample newCurrentSnapshotInformation) {
        }

        public void repositorySnapshotListModified() {
        }
    };
    private final ListenerManager<IRepositorySnapshotListener> listenerManager = new ListenerManager();
    private final InstanceCache<ICockpitDataID, PlatformAdapterObject> objectCache = new InstanceCache();
    private final InstanceCache<ICockpitObjectTypeCategoryID, PlatformAdapterCategory> categoryCache = new InstanceCache();

    public PlatformAdapterSnapshot(PlatformAdapterInterface cockpitClientAdapterModuleManager, IRepositoryObjectSample snapshotInformation) throws EXNotReproducibleSnapshot {
        Assert.checkArgumentBeeingNotNull((Object)cockpitClientAdapterModuleManager);
        if (snapshotInformation == null) {
            throw new EXNotReproducibleSnapshot();
        }
        this.repositoryInterface = cockpitClientAdapterModuleManager;
        this.snapshotInformation = snapshotInformation;
        this.cacheForSnapshotUID = this.repositoryInterface.getWorkstationImplementation().getCommitUID(snapshotInformation);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Snapshot " + To.string((Object)this) + ": setting up");
        }
        this.repositoryInterface.getListenerManager().addListener(this.interfaceListenerKey, (IDisposeListener)this.interfaceListener);
        this.checkSnapshotIDIsStillCurrent();
        IDataManagerRootAdapter dataManagerRootAdapter = this.getDataManagerRootAdapter();
        this.rootObject = this.fetchObject(dataManagerRootAdapter.getRootData());
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Snapshot " + To.string((Object)this) + ": set up");
        }
    }

    public ListenerManager<IRepositorySnapshotListener> getListenerManager() {
        return this.listenerManager;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.repositoryInterface.getProjectAgent();
    }

    public IDataManagerRootAdapter getDataManagerRootAdapter() {
        return this.getRepositoryInterfaceImplementation().getDataManagerRootAdapter();
    }

    public IDataManagerAdapter getDataManagerAdapter(IRepositoryObjectType concreteObjectType) {
        return this.getRepositoryInterfaceImplementation().getDataManagerAdapter(concreteObjectType);
    }

    public ILinkManagerAdapter getLinkManagerAdapter(ICrossLinkRepositoryRelationType concreteRelationType) {
        return this.getRepositoryInterfaceImplementation().getLinkManagerAdapter(concreteRelationType);
    }

    public IRepositoryObjectType getRootObjectType() {
        return this.getRepositoryInterfaceImplementation().getRootObjectType();
    }

    private PlatformAdapterCrossLinkRelation createRelationObject(ICrossLinkRepositoryRelationType concreteRelationType, IRelation cockpitRelation) {
        IRelationContribution cockpitRelationContribution;
        HashMap<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject> adapterRelationContributions = new HashMap<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject>();
        IRelationContribution[] iRelationContributionArray = cockpitRelation.getKnownRelationContributions();
        int n = iRelationContributionArray.length;
        int n2 = 0;
        while (n2 < n) {
            cockpitRelationContribution = iRelationContributionArray[n2];
            if (cockpitRelationContribution.getRelatedObject() instanceof PlatformAdapterObject) {
                ICrossLinkRepositoryRelationContributionType relationContributionType = concreteRelationType.getRelationContributionType(cockpitRelationContribution.getRepositoryRelationContributionRoleID());
                adapterRelationContributions.put(relationContributionType, (PlatformAdapterObject)cockpitRelationContribution.getRelatedObject());
            } else {
                this.fetchRelatedObjectAndStoreItInContributionTypeMap(concreteRelationType, cockpitRelationContribution, adapterRelationContributions);
            }
            ++n2;
        }
        iRelationContributionArray = cockpitRelation.getUnknownRelationContributions();
        n = iRelationContributionArray.length;
        n2 = 0;
        while (n2 < n) {
            cockpitRelationContribution = iRelationContributionArray[n2];
            this.fetchRelatedObjectAndStoreItInContributionTypeMap(concreteRelationType, cockpitRelationContribution, adapterRelationContributions);
            ++n2;
        }
        PlatformAdapterCrossLinkRelation adapterRelation = new PlatformAdapterCrossLinkRelation(this, concreteRelationType, adapterRelationContributions);
        return adapterRelation;
    }

    private void fetchRelatedObjectAndStoreItInContributionTypeMap(ICrossLinkRepositoryRelationType concreteRelationType, IRelationContribution cockpitRelationContribution, Map<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject> adapterRelationContributions) {
        ICrossLinkRepositoryRelationContributionType relationContributionType = concreteRelationType.getRelationContributionType(cockpitRelationContribution.getRepositoryRelationContributionRoleID());
        IRepositoryObjectType objectType = relationContributionType.getRelatedObjectType();
        String cockpitDataUID = cockpitRelationContribution.getCockpitDataUID();
        IRepositoryPropertySetSample objectID = this.getWorkstationImplementation().getObjectID(cockpitDataUID);
        PlatformAdapterObject relatedRepositoryObject = this.findRepositoryObjectImplementation(objectType, objectID);
        Assert.checkArgumentBeeingNotNull((Object)relatedRepositoryObject);
        adapterRelationContributions.put(relationContributionType, relatedRepositoryObject);
    }

    private PlatformAdapterOccurrenceRelation createRelationObject(IOccurrenceRepositoryRelationType concreteRelationType, IOccurrence cockpitRelation) throws EXNotReproducibleSnapshot {
        IRepositoryObjectType objectType = concreteRelationType.getOccurringRelationContributionType().getRelatedObjectType();
        String cockpitDataUID = cockpitRelation.getCockpitDataUIDOfOccurringData();
        IRepositoryPropertySetSample objectID = this.getWorkstationImplementation().getObjectID(cockpitDataUID);
        PlatformAdapterObject occuringObject = this.findRepositoryObjectImplementation(objectType, objectID);
        Assert.checkArgumentBeeingNotNull((Object)occuringObject);
        IRepositoryPropertyType propertyType = concreteRelationType.getOccurrenceRelationContributionType().getRelatedPropertyType();
        IRepositoryObjectType objectType2 = propertyType.getAttributeSetType().getObjectType();
        String cockpitDataUID2 = cockpitRelation.getCockpitDataUIDOfOccurrenceContainingData();
        IRepositoryPropertySetSample objectID2 = this.getWorkstationImplementation().getObjectID(cockpitDataUID2);
        PlatformAdapterObject occurenceContainingObject = this.findRepositoryObjectImplementation(objectType2, objectID2);
        IRepositoryAttributeSetType attributeSetType = propertyType.getAttributeSetType();
        PlatformAdapterAttributeSet attributeSet = occurenceContainingObject.getAttributeSetImplementation(attributeSetType);
        IRepositoryProperty occurenceProperty = attributeSet.getProperty(propertyType);
        Assert.checkArgumentBeeingNotNull((Object)occuringObject);
        String occurenceID = cockpitRelation.getOccurrenceUID();
        PlatformAdapterOccurrenceRelation adapterRelation = new PlatformAdapterOccurrenceRelation(this, concreteRelationType, occuringObject, occurenceProperty, occurenceID);
        return adapterRelation;
    }

    public PlatformAdapterInterface getRepositoryInterfaceImplementation() {
        return this.repositoryInterface;
    }

    public PlatformAdapterWorkspace getWorkspaceImplementation() {
        return this.getRepositoryInterfaceImplementation().getWorkspaceImplementation();
    }

    public PlatformAdapterWorkstation getWorkstationImplementation() {
        return this.getRepositoryInterfaceImplementation().getWorkstationImplementation();
    }

    public IFrameCockpitController getCockpitController() {
        return this.getRepositoryInterfaceImplementation().getCockpitController();
    }

    public ILockManager getLockManager() {
        return this.getRepositoryInterfaceImplementation().getLockManager();
    }

    public IRepositoryInterfaceRO getRepositoryInterface() {
        return this.getRepositoryInterfaceImplementation();
    }

    public synchronized IOccurrenceManager getOccurrenceManager(IOccurrenceRepositoryRelationType occurenceRelationType) {
        return this.getRepositoryInterfaceImplementation().getOccurrenceManager(occurenceRelationType);
    }

    IRepositoryObjectTypeCategory fetchCategory(final ObjectTypeCategory category) {
        CockpitObjectTypeCategoryID cockpitObjectTypeCategoryID = new CockpitObjectTypeCategoryID(category);
        PlatformAdapterCategory platformAdapterCategory = (PlatformAdapterCategory)this.categoryCache.getInstance((Object)cockpitObjectTypeCategoryID, (InstanceCache.IInstanceFactory)new InstanceCache.IInstanceFactory<PlatformAdapterCategory>(){

            public PlatformAdapterCategory createObject() {
                return new PlatformAdapterCategory(category, PlatformAdapterSnapshot.this.getTypeManager(), PlatformAdapterSnapshot.this);
            }
        });
        return platformAdapterCategory;
    }

    public IList_<IRepositoryObjectTypeCategory> getAllObjectTypeCategoriesForObjectType(IRepositoryObjectType repObjectType) {
        ArrayList_ platformCategories = new ArrayList_();
        List<ObjectTypeCategory> allObjectTypeCategoriesForObjectType = this.getWorkstationImplementation().getAllObjectTypeCategoriesForObjectType(repObjectType);
        for (ObjectTypeCategory objectTypeCategory : allObjectTypeCategoriesForObjectType) {
            platformCategories.add((Object)this.fetchCategory(objectTypeCategory));
        }
        return platformCategories;
    }

    public IRepositoryObjectTypeCategory getObjectTypeCategory(IRepositoryObjectTypeCategoryID repObjectTypeCategoryID) {
        ObjectTypeCategory objectTypeCategory = this.getWorkstationImplementation().getObjectTypeCategory(repObjectTypeCategoryID);
        return objectTypeCategory != null ? this.fetchCategory(objectTypeCategory) : null;
    }

    public PlatformAdapterObject fetchObject(ICockpitDataID cockpitDataID) throws EXNotReproducibleSnapshot {
        PlatformAdapterObject object = this.findObject(cockpitDataID);
        Assert.checkArgumentBeeingNotNull((Object)object);
        return object;
    }

    PlatformAdapterObject fetchObject(ICockpitProjectData cockpitObject) {
        IDataManagerAdapter dataManagerAdapter = this.getRepositoryInterfaceImplementation().getDataManagerAdapter(cockpitObject);
        return this.fetchObject(cockpitObject, dataManagerAdapter);
    }

    PlatformAdapterObject fetchObject(final ICockpitProjectData cockpitObject, final IDataManagerAdapter dataManagerAdapter) {
        CockpitDataID cockpitDataID = new CockpitDataID(cockpitObject);
        PlatformAdapterObject platformAdapterObject = (PlatformAdapterObject)this.objectCache.getInstance((Object)cockpitDataID, (InstanceCache.IInstanceFactory)new InstanceCache.IInstanceFactory<PlatformAdapterObject>(){

            public PlatformAdapterObject createObject() {
                return PlatformAdapterSnapshot.this.createObjectObject(dataManagerAdapter, cockpitObject);
            }
        });
        return platformAdapterObject;
    }

    private PlatformAdapterObject createObjectObject(IDataManagerAdapter objectManager, ICockpitProjectData relatedCockpitObject) {
        PlatformAdapterObject objectImplementation = new PlatformAdapterObject(this, objectManager, relatedCockpitObject);
        return objectImplementation;
    }

    public PlatformAdapterObject findObject(ICockpitDataID cockpitDataID) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        ICockpitProjectData cockpitObject = this.getWorkstationImplementation().findCockpitProjectData(cockpitDataID);
        PlatformAdapterObject object = cockpitObject != null ? this.fetchObject(cockpitObject) : null;
        return object;
    }

    public IRepositoryIterator_IRepositoryObject findAllObjectOfType(IRepositoryObjectType repObjectType) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        return new PlatformAdapterCockpitObjectIterator(repObjectType, this);
    }

    public IRepositoryObject findObjectByNameProperty(IRepositoryPropertyType namePropertyType, IRepositoryData propertyValue, IRepositoryObject parentObject) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        PlatformAdapterObject foundObject = null;
        if (PlatformAdapterSnapshot.isDataValid(propertyValue, namePropertyType)) {
            final IRepositoryPropertyType namePropertyTypeInternal = namePropertyType;
            final IRepositoryData propertyValueInternal = propertyValue;
            IRepositoryObjectType concreteParentObjectType = parentObject.getObjectType();
            PlatformAdapterObject object = (PlatformAdapterObject)parentObject;
            ICockpitProjectData parentCockpitObject = object.getCockpitData();
            ICollection_ allObjectTypes = namePropertyTypeInternal.getAttributeSetType().getObjectType().getAllInstanciableObjectTypesOfThisType();
            IIterator_ objectTypeIterator = allObjectTypes.iterator();
            while (foundObject == null && objectTypeIterator.hasNext()) {
                IProperty nameProperty;
                IDataManagerAdapter dataMangerAdapter;
                ICockpitProjectData foundCockpitData;
                IRepositoryObjectType objectType = (IRepositoryObjectType)objectTypeIterator.next();
                IParentRepositoryRelationContributionType possibleParentRelationContributionType = concreteParentObjectType.findParentRelationContributionTypeOfChildObjectType(objectType);
                if (possibleParentRelationContributionType == null || (foundCockpitData = (dataMangerAdapter = this.getDataManagerAdapter(objectType)).findDataByNameProperty(nameProperty = new IProperty(){

                    @Override
                    public IRepositoryData getValue() {
                        return propertyValueInternal;
                    }

                    @Override
                    public IRepositoryPropertyTypeID getPropertyTypeID() {
                        return namePropertyTypeInternal.getRepositoryPropertyTypeID();
                    }
                }, parentCockpitObject)) == null) continue;
                foundObject = this.fetchObject(foundCockpitData);
            }
        }
        return foundObject;
    }

    public IRepositoryObject findObjectByIDProperty(IRepositoryPropertyType idPropertyType, IRepositoryData propertyValue) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        PlatformAdapterObject foundObject = null;
        if (PlatformAdapterSnapshot.isDataValid(propertyValue, idPropertyType)) {
            final IRepositoryPropertyType idPropertyTypeInternal = idPropertyType;
            final IRepositoryData propertyValueInternal = propertyValue;
            ICollection_ allObjectTypes = idPropertyTypeInternal.getAttributeSetType().getObjectType().getAllInstanciableObjectTypesOfThisType();
            for (IRepositoryObjectType objectType : allObjectTypes) {
                IProperty idProperty;
                IDataManagerAdapter dataMangerAdapter;
                ICockpitProjectData foundCockpitData;
                if (!objectType.canBeInstanciated() || (foundCockpitData = (dataMangerAdapter = this.getDataManagerAdapter(objectType)).findDataByIDProperty(idProperty = new IProperty(){

                    @Override
                    public IRepositoryData getValue() {
                        return propertyValueInternal;
                    }

                    @Override
                    public IRepositoryPropertyTypeID getPropertyTypeID() {
                        return idPropertyTypeInternal.getRepositoryPropertyTypeID();
                    }
                })) == null) continue;
                foundObject = this.fetchObject(foundCockpitData);
            }
        }
        return foundObject;
    }

    private static boolean isDataValid(IRepositoryData propertyValue, IRepositoryPropertyType propertyType) {
        boolean dataValid = true;
        IRepositoryDataType dataType = propertyValue.getDataType();
        try {
            dataType.checkData(propertyValue, propertyType.getDataTypeParameters());
        }
        catch (DataValidationException e) {
            dataValid = false;
        }
        return dataValid;
    }

    public PlatformAdapterModuleManager getPlatformAdapterModuleManager() {
        return this.getCockpitController().getPlatformAdapterModuleManager();
    }

    PlatformAdapterCrossLinkRelation fetchRelation(ICrossLinkRepositoryRelationType concreteRelationType, IRelation cockpitRelation) {
        return this.createRelationObject(concreteRelationType, cockpitRelation);
    }

    ICollection_<PlatformAdapterOccurrenceRelation> fetchRelations(IOccurrenceRepositoryRelationType concreteRelationType, Collection<IOccurrence> cockpitRelations) throws EXNotReproducibleSnapshot {
        ArrayList_ relations = new ArrayList_(cockpitRelations.size());
        for (IOccurrence occurence : cockpitRelations) {
            relations.add((Object)this.fetchRelation(concreteRelationType, occurence));
        }
        return relations;
    }

    PlatformAdapterOccurrenceRelation fetchRelation(IOccurrenceRepositoryRelationType concreteRelationType, IOccurrence cockpitRelation) throws EXNotReproducibleSnapshot {
        return this.createRelationObject(concreteRelationType, cockpitRelation);
    }

    PlatformAdapterObject getRootObjectImplementation() {
        return this.rootObject;
    }

    public IRepositoryObject getRepositoryRootObject() throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        return this.getRootObjectImplementation();
    }

    public IRepositoryObject findRepositoryObject(IRepositoryObjectType objectType, IRepositoryPropertySetSample objectID) throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
        return this.findRepositoryObjectImplementation(objectType, objectID);
    }

    PlatformAdapterObject findRepositoryObjectImplementation(IRepositoryObjectType objectType, IRepositoryPropertySetSample objectID) {
        ICollection_ concreteObjectTypes = objectType.getAllInstanciableObjectTypesOfThisType();
        PlatformAdapterObject foundObject = null;
        IIterator_ i = concreteObjectTypes.iterator();
        while (foundObject == null && i.hasNext()) {
            IRepositoryObjectType currentObjectType = (IRepositoryObjectType)i.next();
            foundObject = this.findRepositoryObjectOfConcreteType(currentObjectType, objectID);
        }
        return foundObject;
    }

    private PlatformAdapterObject findRepositoryObjectOfConcreteType(IRepositoryObjectType objectType, IRepositoryPropertySetSample objectID) {
        PlatformAdapterObject foundObject = null;
        String cockpitDataUID = this.getWorkstationImplementation().getObjectUID(objectID);
        IDataManagerAdapter dataManagerAdapter = this.getDataManagerAdapter(objectType);
        ICockpitProjectData cockpitProjectData = dataManagerAdapter.findData(cockpitDataUID);
        if (cockpitProjectData != null) {
            foundObject = this.fetchObject(cockpitProjectData, dataManagerAdapter);
        }
        return foundObject;
    }

    public boolean isOpen() {
        return this.repositoryInterface.getProjectAgent().isOpened() && this.repositoryInterface.getListenerManager().getListener(this.interfaceListenerKey) == this.interfaceListener;
    }

    public void closeSnapshot() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Snapshot " + To.string((Object)this) + ": closing snapshot");
        }
        this.listenerManager.dispose();
        this.repositoryInterface.getListenerManager().removeListener(this.interfaceListenerKey);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Snapshot " + To.string((Object)this) + ": closed");
        }
    }

    private String getSnapshotUID() {
        return this.cacheForSnapshotUID;
    }

    public void checkSnapshotIDIsStillCurrent() throws EXNotReproducibleSnapshot {
        if (!this.isOpen()) {
            throw new EXNotReproducibleSnapshot();
        }
        String currentSnapshotID = this.getRepositoryInterfaceImplementation().getCurrentSnapshotUID();
        String thisSnapshotID = this.getSnapshotUID();
        if (!thisSnapshotID.equals(currentSnapshotID)) {
            throw new EXNotReproducibleSnapshot();
        }
    }

    public void checkSnapshotIDIsStillModifiable() throws EXNotReproducibleSnapshot {
        this.checkSnapshotIDIsStillCurrent();
    }

    public void abortSnapshot() {
        this.closeSnapshot();
    }

    public void updateSnapshotInformation(IRepositoryObjectSample newSnapshotInformation) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Snapshot " + To.string((Object)this) + ": updating snapshot information");
        }
        this.snapshotInformation = newSnapshotInformation;
        this.objectCache.clear();
        this.categoryCache.clear();
        this.cacheForSnapshotUID = this.repositoryInterface.getWorkstationImplementation().getCommitUID(this.snapshotInformation);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Snapshot " + To.string((Object)this) + ": snapshot information updated");
        }
    }

    /*
     * Unable to fully structure code
     */
    public IRepositoryObject createObject(IRepositoryObject parentObject, IRepositoryObjectSample objectToCreate) throws EXNotReproducibleSnapshot, EXLockDenied, EXPermissionDenied {
        block11: {
            if (PlatformAdapterSnapshot.logger.isDebugEnabled(34)) {
                PlatformAdapterSnapshot.logger.debug(34, "  Snapshot " + To.string((Object)this) + ": create object " + To.string((Object)objectToCreate));
            }
            this.checkSnapshotIDIsStillModifiable();
            objectTypeID = objectToCreate.getObjectTypeID();
            objectType = this.getTypeManager().getObjectType(objectTypeID);
            dataManagerAdapter = this.getDataManagerAdapter(objectType);
            parentObjectImplementation = (PlatformAdapterObject)parentObject;
            newCockpitUID = this.getWorkstationImplementation().getObjectUID(objectToCreate.getObjectID(this.getTypeManager()));
            propertiesAttributeSetSample = RepositorySamples.getPropertySetSampleForAttributeSet((IRepositoryObjectSample)objectToCreate, (IRepositoryAttributeSetTypeID)this.getWorkstationImplementation().getPropertiesAttributeSetTypeID(), (IRepositoryTypeManagerRO)this.getTypeManager());
            remainingPropertySamples = PlatformAdapterAttributeSet.createAllPropertiesMap(propertiesAttributeSetSample);
            standardProperties = PlatformAdapterAttributeSet.extractStandardProperties(this.getWorkstationImplementation(), objectType, propertiesAttributeSetSample, remainingPropertySamples);
            objectTypeCategoryID = objectToCreate.getObjectTypeCategoryID();
            objectTypeCategoryIDString = objectTypeCategoryID != null ? objectTypeCategoryID.toCanonicalString() : null;
            try {
                createdCockpitData = dataManagerAdapter.createCockpitData(parentObjectImplementation.getCockpitData(), newCockpitUID, objectTypeCategoryIDString, standardProperties);
            }
            catch (EXCockpitLockDenied e) {
                throw FrameDataConverter.convertEXCockpitLockDenied(e);
            }
            catch (EXCockpitPermissionDenied e) {
                throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
            }
            createdObject = this.fetchObject(createdCockpitData);
            propertiesAttributeSet = createdObject.getAttributeSetImplementation(objectType.getAttributeSetType(this.getWorkstationImplementation().getPropertiesAttributeSetTypeID()));
            try {
                propertiesAttributeSet.modifyCustomProperties(remainingPropertySamples);
                break block11;
            }
            catch (EXCockpitLockDenied e) {
                try {
                    createdObject.delete();
                }
                catch (EXLockDenied e1) {
                    throw new RuntimeException(e1);
                }
                catch (EXPermissionDenied e1) {
                    throw new RuntimeException(e1);
                }
                throw FrameDataConverter.convertEXCockpitLockDenied(e);
            }
            catch (EXCockpitPermissionDenied e) {
                var21_23 = localizedUserHints = e.getLocalizedUserHints();
                var20_24 = localizedUserHints.length;
                var19_25 = 0;
                ** while (var19_25 < var20_24)
            }
lbl-1000:
            // 1 sources

            {
                element = var21_23[var19_25];
                PlatformAdapterSnapshot.logger.info(element);
                ++var19_25;
                continue;
            }
        }
        return createdObject;
    }

    public void modifyObjectTypeCategory(IRepositoryObject objectToModify, IRepositoryObjectTypeCategoryID newCategoryID) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": modify object type category " + To.string((Object)objectToModify));
        }
        this.checkSnapshotIDIsStillModifiable();
        PlatformAdapterObject objectToModifyImplementation = (PlatformAdapterObject)objectToModify;
        objectToModifyImplementation.modifyObjectTypeCategory(newCategoryID);
        this.getRepositoryInterfaceImplementation().localChangesDone(this);
    }

    public void modifyAttributeSet(IRepositoryAttributeSet attributeSetToModify, IRepositoryPropertySetSample newAttributeSetValue) throws EXNotReproducibleSnapshot, EXPermissionDenied, EXLockDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": modify attribute set " + To.string((Object)attributeSetToModify));
        }
        this.checkSnapshotIDIsStillModifiable();
        PlatformAdapterAttributeSet attributeSet = (PlatformAdapterAttributeSet)attributeSetToModify;
        attributeSet.modify(newAttributeSetValue);
        this.getRepositoryInterfaceImplementation().localChangesDone(this);
    }

    public void deleteObject(IRepositoryObject objectToDelete) throws EXNotReproducibleSnapshot, EXLockDenied, EXPermissionDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": delete object " + To.string((Object)objectToDelete));
        }
        this.checkSnapshotIDIsStillModifiable();
        PlatformAdapterObject objectToDeleteImplementation = (PlatformAdapterObject)objectToDelete;
        objectToDeleteImplementation.delete();
        this.getRepositoryInterfaceImplementation().localChangesDone(this);
    }

    public void moveObject(IRepositoryObject objectToMove, IRepositoryObject newParentObject) throws EXNotReproducibleSnapshot, EXLockDenied, EXPermissionDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": move object " + To.string((Object)objectToMove));
        }
        this.checkSnapshotIDIsStillModifiable();
        IRepositoryObjectType concreteObjectTypeOfObjectToMove = objectToMove.getObjectType();
        IDataManagerAdapter dataManagerAdapterOfObjectToMove = this.getDataManagerAdapter(concreteObjectTypeOfObjectToMove);
        PlatformAdapterObject objectToMoveImplementation = (PlatformAdapterObject)objectToMove;
        PlatformAdapterObject newParentObjectImplementation = (PlatformAdapterObject)newParentObject;
        ICockpitProjectData cockpitDataToMove = objectToMoveImplementation.getCockpitData();
        try {
            dataManagerAdapterOfObjectToMove.moveCockpitData(cockpitDataToMove, newParentObjectImplementation.getCockpitData());
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
    }

    public void createRelation(ICrossLinkRepositoryRelationSample relationSample) throws EXNotReproducibleSnapshot, EXLockDenied, EXPermissionDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": create relation " + To.string((Object)relationSample));
        }
        this.checkSnapshotIDIsStillModifiable();
        ICrossLinkRepositoryRelationType relationType = this.getTypeManager().getCrossLinkRelationType(relationSample.getRelationTypeID());
        ILinkManagerAdapter linkManagerAdapter = this.getLinkManagerAdapter(relationType);
        IRelationContribution[] relationContributions = this.getWorkstationImplementation().getCockpitRelationContributions(relationSample);
        try {
            linkManagerAdapter.createLink(relationContributions);
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
    }

    public void deleteRelation(ICrossLinkRepositoryRelation relation) throws EXNotReproducibleSnapshot, EXLockDenied, EXPermissionDenied {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": delete relation " + To.string((Object)relation));
        }
        this.checkSnapshotIDIsStillModifiable();
        ICrossLinkRepositoryRelationType relationType = relation.getRelationType();
        ILinkManagerAdapter linkManagerAdapter = this.getLinkManagerAdapter(relationType);
        ICollection_ relationContributionTypes = relation.getRelationType().getAllRelationContributionTypes();
        IRelationContribution[] relationContributions = new IRelationContribution[relationContributionTypes.size()];
        int index = 0;
        for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
            String uidAsString;
            try {
                PlatformAdapterObject concreteObject = (PlatformAdapterObject)relation.getRelationContribution(relationContributionType).getAttributeSet().getObject();
                uidAsString = concreteObject.getCockpitDataUID();
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new RuntimeException(e);
            }
            relationContributions[index] = new RelationContribution(relationContributionType.getRepositoryRelationContributionRoleID(), uidAsString);
            ++index;
        }
        try {
            linkManagerAdapter.deleteLink(relationContributions);
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
    }

    public IRepositoryIterator_ICrossLinkRepositoryRelation findCrossLinkRelations(ICrossLinkRepositoryRelationType relationType, IMap_<IRepositoryRelationContributionRoleID, IRepositoryPropertySetSample> roleID2ObjectID) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget {
        this.checkSnapshotIDIsStillCurrent();
        return new PlatformAdapterCockpitCrossLinkIterator(relationType, roleID2ObjectID, this);
    }

    public IRepositoryObjectSample getSnapshotInformation() {
        return this.snapshotInformation;
    }

    public IRepositoryTypeManagerRO getTypeManager() {
        return this.getRepositoryInterfaceImplementation().getTypeManager();
    }

    public IRepositoryWorkspaceRW getRepositoryWorkspace() {
        return this.getWorkspaceImplementation();
    }

    public void consistentStateReached() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Snapshot " + To.string((Object)this) + ": consistent state reached");
        }
        this.getRepositoryInterfaceImplementation().snapshotChanged();
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Snapshot " + To.string((Object)this) + ": consistent state reached");
        }
    }

    public IOccurrenceRepositoryRelation findOccurrenceRelation(IOccurrenceRepositoryRelationType occurenceRelationType, IRepositoryPropertySetSample occurenceContainingObjectID, String occurenceID) throws EXNotReproducibleSnapshot {
        PlatformAdapterOccurrenceRelation occurenceRelation;
        IOccurrenceManager occurenceManager = this.getOccurrenceManager(occurenceRelationType);
        if (occurenceManager != null) {
            String cockpitDataUIDOfOccurenceContainingData = this.getWorkstationImplementation().getCockpitDataUID(occurenceContainingObjectID);
            String cockpitDataUIDOfOccuringData = occurenceManager.getCockpitDataUIDOfOccurringData(cockpitDataUIDOfOccurenceContainingData, occurenceID);
            if (cockpitDataUIDOfOccuringData != null) {
                Occurrence occurence = new Occurrence(cockpitDataUIDOfOccuringData, cockpitDataUIDOfOccurenceContainingData, occurenceID);
                occurenceRelation = this.fetchRelation(occurenceRelationType, occurence);
            } else {
                occurenceRelation = null;
            }
        } else {
            occurenceRelation = null;
        }
        return occurenceRelation;
    }

    public void modifyOccurrences(OccurrenceRelationContribution occRelationContribution, ICollection_<IOccurrenceRepositoryRelationReference> occurenceRelationsToDelete, ICollection_<IOccurrenceRepositoryRelationSample> occurenceRelationsToCreate) throws EXLockDenied, EXPermissionDenied, EXNotReproducibleSnapshot {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "  Snapshot " + To.string((Object)this) + ": modify occurence relations of property " + To.string((Object)occRelationContribution));
        }
        this.checkSnapshotIDIsStillModifiable();
        IOccurrenceRepositoryRelationType occurenceRepositoryRelationType = occRelationContribution.getOccurrenceRCType().getRelatedRelationType();
        String occurenceContainingObjectUID = this.getWorkstationImplementation().getCockpitDataUID(occRelationContribution.getOccurrenceContainingObjectObjectID());
        PlatformAdapterOccurrenceChangeRequest occurenceChangeRequest = new PlatformAdapterOccurrenceChangeRequest(occRelationContribution, occurenceRelationsToDelete, occurenceRelationsToCreate, this.getWorkstationImplementation());
        IOccurrenceManager occurenceManager = this.getOccurrenceManager(occurenceRepositoryRelationType);
        try {
            occurenceManager.changeOccurrences(occurenceContainingObjectUID, occurenceChangeRequest);
        }
        catch (EXCockpitLockDenied e) {
            throw FrameDataConverter.convertEXCockpitLockDenied(e);
        }
        catch (EXCockpitPermissionDenied e) {
            throw FrameDataConverter.convertEXCockpitPermissionDenied(e);
        }
        this.getRepositoryInterfaceImplementation().localChangesDone(this);
    }
}

