/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.interFace.data.IRepositoryDataItem;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySample;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertySetSample;
import com.arcway.repository.lib.high.registration.data.AbstractRepositoryDataType;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.EXValueInvalid;

public abstract class PlatformAdapterItem
implements IRepositoryDataItem {
    private final PlatformAdapterSnapshot snapshot;

    public static IRepositoryPropertySetSample createIDAttributeSetSample(IRepositoryObjectType repositoryObjectType, String uid) {
        RepositoryPropertySetSample idAttributeSetSample;
        if (uid == null) {
            idAttributeSetSample = null;
        } else {
            IRepositoryData snapshotUID;
            RDTUID rdtuid = RDTUID.getInstance();
            IRepositoryAttributeSetType snapshotIDAttributeSetType = repositoryObjectType.getIDAttributeSetType();
            IIterator_ snapshotIDPropertyTypeIterator = snapshotIDAttributeSetType.getPropertyTypes().iterator();
            if (!snapshotIDPropertyTypeIterator.hasNext()) {
                throw new IllegalArgumentException();
            }
            IRepositoryPropertyType snapshotIDPropertyType = (IRepositoryPropertyType)snapshotIDPropertyTypeIterator.next();
            if (snapshotIDPropertyTypeIterator.hasNext()) {
                throw new IllegalArgumentException();
            }
            Assert.checkArgument((boolean)snapshotIDPropertyType.getDataType().equals(rdtuid));
            IRepositoryPropertyTypeID snapshotIDPropertyTypeID = snapshotIDPropertyType.getRepositoryPropertyTypeID();
            IRepositoryDataTypeParameters dataTypeParameters = snapshotIDPropertyType.getDataTypeParameters();
            try {
                snapshotUID = rdtuid.createData(uid);
                rdtuid.snapAndCheckData(snapshotUID, dataTypeParameters);
            }
            catch (AbstractRepositoryDataType.EXValueNotSet e) {
                throw new RuntimeException(e);
            }
            catch (EXValueInvalid e) {
                throw new RuntimeException(e);
            }
            RepositoryPropertySample snapshotUIDPropertySample = new RepositoryPropertySample(snapshotUID);
            HashMap_ properties = new HashMap_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
            properties.put((Object)snapshotIDPropertyTypeID, (Object)snapshotUIDPropertySample);
            idAttributeSetSample = new RepositoryPropertySetSample((IMap_)properties);
        }
        return idAttributeSetSample;
    }

    public PlatformAdapterItem(PlatformAdapterSnapshot snapshot) {
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        this.snapshot = snapshot;
    }

    public PlatformAdapterSnapshot getSnapshotImplementation() {
        return this.snapshot;
    }

    public IRepositoryTypeManagerRO getTypeManager() {
        return this.getSnapshotImplementation().getRepositoryInterface().getTypeManager();
    }

    public IRepositoryModuleType getRootModuleType() {
        return this.getTypeManager().getRootModuleType();
    }

    public IRepositoryObjectType getSnapshotObjectType() {
        return this.getRootModuleType().getSnapshotObjectType();
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.snapshot.getProjectAgent();
    }

    public IFrameCockpitController getCockpitController() {
        return this.getProjectAgent().getCockpitController();
    }

    public PlatformAdapterModuleManager getPlatformAdapterModuleManager() {
        return this.getCockpitController().getPlatformAdapterModuleManager();
    }

    public ILockManager getLockManager() {
        return this.getCockpitController().getLockManager();
    }

    public PlatformAdapterWorkstation getWorkstationImplementation() {
        return this.getSnapshotImplementation().getWorkstationImplementation();
    }

    public synchronized IOccurrenceManager getOccurrenceManager(IOccurrenceRepositoryRelationType occurenceRelationType) {
        return this.getSnapshotImplementation().getOccurrenceManager(occurenceRelationType);
    }

    public PlatformAdapterObject fetchObject(ICockpitDataID cockpitDataID) throws EXNotReproducibleSnapshot {
        PlatformAdapterObject object = this.snapshot.fetchObject(cockpitDataID);
        return object;
    }

    public void checkSnapshotIDIsStillCurrent() throws EXNotReproducibleSnapshot {
        this.snapshot.checkSnapshotIDIsStillCurrent();
    }

    public IRepositorySnapshotRO getSnapshot() {
        return this.snapshot;
    }

    public IRepositoryPropertySetSample createSnapshotIDAttributeSetSample(String commitUID) {
        return PlatformAdapterItem.createIDAttributeSetSample(this.getSnapshotObjectType(), commitUID);
    }
}

