/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.global.profiling.CockpitProfiler;
import com.arcway.cockpit.frame.client.project.IFrameCockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.listener.ListenerManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.Messages;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterLocksAndPermissionsManagerDeprecated;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkspace;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterWorkstation;
import com.arcway.repository.clientadapter.implementation.adapter.locks.ILockManager;
import com.arcway.repository.clientadapter.implementation.manager.PlatformAdapterModuleManager;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.clientadapter.interFace.IDataManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IDataManagerRootAdapter;
import com.arcway.repository.clientadapter.interFace.ILinkManagerAdapter;
import com.arcway.repository.clientadapter.interFace.IOccurrenceManager;
import com.arcway.repository.cockpit.interFace.declaration.frame.project.COTIDsSnapshot;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.cockpitadapter.EOUserInformation;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchive;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceListener;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceListener;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relation.IOccurrenceRepositoryRelationType;
import com.arcway.repository.lib.high.registration.data.lib.RDTUserReference;
import com.arcway.repository.lib.high.registration.data.lib.UserReference;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PlatformAdapterInterface
implements IRepositoryInterfaceRO {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterInterface.class);
    private static final ListenerKey WORKSPACE_LISTENER_KEY = new ListenerKey();
    private final IRepositoryWorkspaceListener workspaceListener = new IRepositoryWorkspaceListener(){

        public void dispose() {
            PlatformAdapterInterface.this.shutdown();
        }

        public void workspaceInformationChanged(IRepositoryObjectSample newWorkspaceInformation) {
        }
    };
    private final PlatformAdapterModuleManager moduleManager;
    private final PlatformAdapterLocksAndPermissionsManagerDeprecated platformAdapterLocksAndPermissionsManagerDeprecated;
    private final IRepositoryWorkspaceRO workspace;
    private final ListenerManager<IRepositoryInterfaceListener> listenerManager = new ListenerManager();
    private IRepositoryObjectSample currentLocalSnapshotInformation;
    private String cacheForCurrentSnapshotUID;
    private Locale contentLocale = null;

    public PlatformAdapterInterface(PlatformAdapterModuleManager moduleManager, IRepositoryWorkspaceRO workspace) {
        Assert.checkArgumentBeeingNotNull((Object)moduleManager);
        Assert.checkArgumentBeeingNotNull((Object)workspace);
        this.moduleManager = moduleManager;
        this.workspace = workspace;
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Interface " + To.string((Object)this) + ": setting up");
        }
        workspace.getListenerManager().addListener(WORKSPACE_LISTENER_KEY, (IDisposeListener)this.workspaceListener);
        this.platformAdapterLocksAndPermissionsManagerDeprecated = new PlatformAdapterLocksAndPermissionsManagerDeprecated(this);
        this.localChangesDone(null);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Interface " + To.string((Object)this) + ": set up");
        }
    }

    public ListenerManager<IRepositoryInterfaceListener> getListenerManager() {
        return this.listenerManager;
    }

    public PlatformAdapterModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public IRepositorySnapshotRO openSnapshot(IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        String desiredCommitUID = this.getWorkstationImplementation().getCommitUID(snapshotID);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Interface " + To.string((Object)this) + ": open snapshot " + desiredCommitUID);
        }
        IRepositoryObjectSample currentlyActiveSnapshotInformation = this.sampleCurrentSnapshotInformation();
        String currentCommitUID = this.getWorkstationImplementation().getCommitUID(currentlyActiveSnapshotInformation);
        if (!desiredCommitUID.equals(currentCommitUID)) {
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "^ Interface " + To.string((Object)this) + ": open snapshot failed; the wished snapshot " + desiredCommitUID + " is not equal to the current snapshot " + currentCommitUID);
            }
            throw new EXNotReproducibleSnapshot();
        }
        PlatformAdapterSnapshot snapshot = new PlatformAdapterSnapshot(this, currentlyActiveSnapshotInformation);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Interface " + To.string((Object)this) + ": snapshot opened " + To.string((Object)snapshot));
        }
        return snapshot;
    }

    public void shutdown() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Interface " + To.string((Object)this) + ": shutting down");
        }
        this.listenerManager.dispose();
        this.workspace.getListenerManager().removeListener(WORKSPACE_LISTENER_KEY);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Interface " + To.string((Object)this) + ": shut down");
        }
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.moduleManager.getProjectAgent();
    }

    public IDataManagerRootAdapter getDataManagerRootAdapter() {
        return (IDataManagerRootAdapter)this.moduleManager.getDataManagerAdapter(this.getRootObjectType());
    }

    public IDataManagerAdapter getDataManagerAdapter(IRepositoryObjectType concreteObjectType) {
        return this.moduleManager.getDataManagerAdapter(concreteObjectType);
    }

    public IDataManagerAdapter getDataManagerAdapter(ICockpitProjectData cockpitData) {
        return this.moduleManager.getDataManagerAdapter(cockpitData);
    }

    public IDataManagerAdapter getDataManagerAdapter(ICockpitDataID cockpitDataID) {
        return this.moduleManager.getDataManagerAdapter(cockpitDataID);
    }

    public ILinkManagerAdapter getLinkManagerAdapter(ICrossLinkRepositoryRelationType conreteRelationType) {
        return this.moduleManager.getLinkManagerAdapter(conreteRelationType);
    }

    public IOccurrenceManager getOccurrenceManager(IOccurrenceRepositoryRelationType relationType) {
        return this.moduleManager.getOccurrenceManager(relationType);
    }

    public IRepositoryObjectType getRootObjectType() {
        return this.getTypeManager().getRootModuleType().getRootObjectType();
    }

    public IRepositoryTypeManagerRO getTypeManager() {
        return this.workspace.getTypeManagerRO();
    }

    public IRepositoryWorkspaceRO getWorkspace() {
        return this.workspace;
    }

    public PlatformAdapterWorkspace getWorkspaceImplementation() {
        return (PlatformAdapterWorkspace)this.getWorkspace();
    }

    public PlatformAdapterWorkstation getWorkstationImplementation() {
        return this.getWorkspaceImplementation().getWorkstationImplementation();
    }

    public ILocksAndPermissionsManagerDeprecated getLocksAndPermissionsManagerDeprecatedImplementation() {
        return this.platformAdapterLocksAndPermissionsManagerDeprecated;
    }

    public IFrameCockpitController getCockpitController() {
        return this.getWorkspaceImplementation().getCockpitController();
    }

    public ILockManager getLockManager() {
        return this.getWorkspaceImplementation().getLockManager();
    }

    public IList_<IRepositoryObjectSample> getAvailableSnapshotInformations() {
        List<EOCommitCountAndCommitInformation> commitInformations = this.getCockpitController().getCommitInformations();
        ArrayList_ snapshotInformations = new ArrayList_(commitInformations.size());
        for (EOCommitCountAndCommitInformation commitInformation : commitInformations) {
            snapshotInformations.add((Object)this.getWorkstationImplementation().createSnapshotInformation(commitInformation.getCommitInformation()));
        }
        if (this.currentLocalSnapshotInformation != null) {
            snapshotInformations.add((Object)this.currentLocalSnapshotInformation);
        }
        return snapshotInformations;
    }

    public UserReference getUserReferenceFromSnapshot(IRepositoryObjectSample snapshotInformation) {
        IRepositoryData data = snapshotInformation.getPropertySetSample().getPropertySample((IRepositoryPropertyTypeID)COTIDsSnapshot.PROPERTY_TYPE_ID_MODIFIER).getValue();
        return RDTUserReference.getInstance().dataToValue(data);
    }

    public IRepositoryObjectSample sampleCurrentSnapshotInformation() {
        IRepositoryObjectSample currentSnapshotInformation = this.currentLocalSnapshotInformation != null ? this.currentLocalSnapshotInformation : this.sampleCurrentServerStateSnapshotInformation();
        return currentSnapshotInformation;
    }

    private IRepositoryObjectSample sampleCurrentServerStateSnapshotInformation() {
        EOCommitInformation currentCommitInformation = this.sampleCurrentServerStateCommitInformation();
        return this.getWorkstationImplementation().createSnapshotInformation(currentCommitInformation);
    }

    private EOCommitInformation sampleCurrentServerStateCommitInformation() {
        List<EOCommitCountAndCommitInformation> commitInformations = this.getCockpitController().getCommitInformations();
        int numberOfCommitInformations = commitInformations.size();
        EOCommitInformation currentCommitInformation = numberOfCommitInformations > 0 ? commitInformations.get(numberOfCommitInformations - 1).getCommitInformation() : this.createCommitInformationForLocalChange();
        return currentCommitInformation;
    }

    public void localChangesDone(PlatformAdapterSnapshot changingSnapshotRW) {
        IRepositoryObjectSample newSnapshotInformation;
        EOCommitInformation newCommitInformation;
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Interface " + To.string((Object)this) + ": doing local changes on snapshot " + To.string((Object)changingSnapshotRW));
        }
        if (this.getCockpitController().hasLocalModifications()) {
            newCommitInformation = this.createCommitInformationForLocalChange();
            this.currentLocalSnapshotInformation = newSnapshotInformation = this.getWorkstationImplementation().createSnapshotInformation(newCommitInformation);
        } else {
            this.currentLocalSnapshotInformation = null;
            newCommitInformation = this.sampleCurrentServerStateCommitInformation();
            newSnapshotInformation = this.getWorkstationImplementation().createSnapshotInformation(newCommitInformation);
        }
        this.cacheForCurrentSnapshotUID = newCommitInformation.getCommitUID();
        if (changingSnapshotRW != null) {
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "> Interface " + To.string((Object)this) + ": update information on snapshot " + To.string((Object)changingSnapshotRW));
            }
            changingSnapshotRW.updateSnapshotInformation(newSnapshotInformation);
            if (logger.isDebugEnabled(34)) {
                logger.debug(34, "< Interface " + To.string((Object)this) + ":  information on snapshot " + To.string((Object)changingSnapshotRW) + " updated");
            }
        }
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Interface " + To.string((Object)this) + ": local changes done on snapshot " + To.string((Object)changingSnapshotRW));
        }
    }

    private EOCommitInformation createCommitInformationForLocalChange() {
        String commitUID = UUIDGenerator.getUniqueID();
        Date date = new Date();
        EOUserInformation userInformation = this.getCockpitController().getWorkspaceInformation().getLastUserInformation();
        EOCommitInformation newCommitInformation = new EOCommitInformation(commitUID, date, userInformation, Messages.getString("PlatformAdapterInterface.LocalChange", new Locale(this.getCockpitController().getProjectAgent().getLanguage())));
        return newCommitInformation;
    }

    String getCurrentSnapshotUID() {
        return this.cacheForCurrentSnapshotUID;
    }

    public void snapshotChanged() {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v Interface " + To.string((Object)this) + ": changing snapshot");
        }
        CockpitProfiler.addCurrentCallStack();
        final IRepositoryObjectSample currentSnapshotInformation = this.sampleCurrentSnapshotInformation();
        this.listenerManager.callListeners((IListenerCaller)new IListenerCaller<IRepositoryInterfaceListener>(){

            public void callListener(IRepositoryInterfaceListener listener) {
                listener.repositorySnapshotListModified();
                listener.repositoryNewCurrentSnapshot(currentSnapshotInformation);
            }
        });
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ Interface " + To.string((Object)this) + ": snapshot changed");
        }
    }

    public Locale getContentLocale() {
        if (this.contentLocale == null) {
            this.contentLocale = new Locale(this.getCockpitController().getProjectAgent().getLanguage());
        }
        return this.contentLocale;
    }

    public IRepositoryFileArchive getFileArchive() {
        return this.getWorkspaceImplementation().getFileArchiveImplementation();
    }

    public ILocksAndPermissionsManagerDeprecated getLocksAndPermissionsManagerDeprecated() {
        return this.getLocksAndPermissionsManagerDeprecatedImplementation();
    }
}

