/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.frame.client.project.CockpitController;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationFromSourceProject;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItemBody;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.IInputStreamCloseListener;
import com.arcway.lib.io.InputStreamWithCloseListener;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.clientadapter.implementation.adapter.frame.RepositoryFileID;
import com.arcway.repository.cockpitadapter.EOCommitInformation;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryFile;
import com.arcway.repository.interFace.dataaccess.IRepositoryFileArchiveRW;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.InputStream;
import java.util.Date;

public class PlatformAdapterFileArchive
implements IRepositoryFileArchiveRW {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterFileArchive.class);
    private final CockpitController cockpitController;

    public PlatformAdapterFileArchive(CockpitController cockpitController) {
        Assert.checkArgumentBeeingNotNull((Object)cockpitController);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": setting up");
        }
        this.cockpitController = cockpitController;
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": set up");
        }
    }

    private IFrameProjectAgent getProjectAgent() {
        return this.cockpitController.getProjectAgent();
    }

    private IFilesManager getFilesManager() {
        return this.getProjectAgent().getFilesManager();
    }

    public IRepositoryFile getRepositoryFile(IRepositoryFileID fileID) throws EXNotReproducibleSnapshot {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": get repository file " + To.string((Object)fileID));
        }
        RepositoryFileID repositoryFileID = RepositoryFileID.convertRepositoryFileID(fileID);
        final FileID cockpitFileID = repositoryFileID.getFileID();
        final IFilesManager filesManager = this.getProjectAgent().getFilesManager();
        final FileMetaInformationItem metaInformation = filesManager.getFileMetaInformation(cockpitFileID);
        assert (metaInformation != null);
        String originalFileName = metaInformation.getOriginalFileName();
        final String fileName = originalFileName != null ? originalFileName : "";
        IRepositoryFile repositoryFile = new IRepositoryFile(){

            public String getName() {
                return fileName;
            }

            public Date getCreationDate() {
                if (filesManager.hasFile(cockpitFileID)) {
                    return new Date(metaInformation.getCreationDate());
                }
                FileMetaInformationFromSourceProject metaInformationFromSourceProject = filesManager.getFileMetaInformationFromSourceProject(cockpitFileID);
                if (metaInformationFromSourceProject != null && metaInformationFromSourceProject.getCreationDate() != 0L) {
                    return new Date(metaInformationFromSourceProject.getCreationDate());
                }
                return new Date(metaInformation.getCreationDate());
            }

            public IRepositoryObjectSample getCreationSnapshotInformation() {
                EOCommitInformation commitInformation;
                if (filesManager.hasFile(cockpitFileID)) {
                    commitInformation = metaInformation.getCommitCount() >= 1 ? PlatformAdapterFileArchive.this.getProjectAgent().getCockpitController().getCommitInformation(metaInformation.getCommitCount()) : new EOCommitInformation(UUIDGenerator.getUniqueID(), new Date(System.currentTimeMillis()), PlatformAdapterFileArchive.this.getProjectAgent().getCockpitController().getWorkspaceInformation().getLastUserInformation(), "");
                } else {
                    FileMetaInformationFromSourceProject metaInformationFromSourceProject = filesManager.getFileMetaInformationFromSourceProject(cockpitFileID);
                    if (metaInformationFromSourceProject != null && metaInformationFromSourceProject.getSnapshotInformation() != null) {
                        IRepositoryObjectSample sourceSnapshotInformation = metaInformationFromSourceProject.getSnapshotInformation();
                        return sourceSnapshotInformation;
                    }
                    commitInformation = new EOCommitInformation(UUIDGenerator.getUniqueID(), new Date(System.currentTimeMillis()), PlatformAdapterFileArchive.this.getProjectAgent().getCockpitController().getWorkspaceInformation().getLastUserInformation(), "");
                }
                return PlatformAdapterFileArchive.this.getProjectAgent().getRepositoryPlattformController().createSnapshotInformation(commitInformation);
            }

            public boolean isTemporaryFile() {
                return !filesManager.hasFile(cockpitFileID);
            }

            public InputStream toInputStream() throws EXNotReproducibleSnapshot, JvmExternalResourceInteractionException {
                try {
                    final File file = filesManager.getFile(cockpitFileID);
                    if (file != null) {
                        InputStream inputStream = FileHelper.fileToInputStream((File)file);
                        InputStreamWithCloseListener inputStreamWrapper = new InputStreamWithCloseListener(inputStream, new IInputStreamCloseListener(){

                            public void inputStreamWasClosed() {
                                try {
                                    FileHelper.deleteExistingFileOrDirectory((File)file);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    logger.warn("Could not delete file retrieved from file archive.", (Throwable)e);
                                }
                            }
                        });
                        return inputStreamWrapper;
                    }
                    return null;
                }
                catch (ServerNotAvailableException e) {
                    throw new EXNotReproducibleSnapshot();
                }
                catch (EXServerException e) {
                    throw new EXNotReproducibleSnapshot();
                }
                catch (LoginCanceledException e) {
                    throw new EXNotReproducibleSnapshot();
                }
                catch (UnknownServerException e) {
                    throw new EXNotReproducibleSnapshot();
                }
                catch (ExPrematureEndOfTransfer e) {
                    throw new EXNotReproducibleSnapshot();
                }
            }
        };
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": get repository file " + To.string((Object)fileID) + "/" + repositoryFile.getName());
        }
        return repositoryFile;
    }

    public IRepositoryFileID loadFileIntoTemporaryStorage(IStreamResource file) throws JvmExternalResourceInteractionException {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": load file into temporary storage " + file.getName());
        }
        IFilesManager filesManager = this.getFilesManager();
        FileID newFileID = filesManager.loadFileIntoTemporaryStorage(file);
        RepositoryFileID repositoryFileID = new RepositoryFileID(newFileID);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": load file into temporary storage " + To.string((Object)repositoryFileID));
        }
        return repositoryFileID;
    }

    public boolean loadFileIntoTemporaryStorage(IStreamResource file, IRepositoryFileID originalFileID, IRepositoryObjectSample sourceCreationSnapshotInformation, long sourceCreationDate) throws JvmExternalResourceInteractionException {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": load imported file into temporary storage: file name = " + file.getName() + " / file id = " + originalFileID.toCanonicalString());
        }
        IFilesManager filesManager = this.getFilesManager();
        FileMetaInformationFromSourceProject sourceMetaInformation = null;
        if (sourceCreationSnapshotInformation != null) {
            sourceMetaInformation = new FileMetaInformationFromSourceProject(new FileMetaInformationItemBody(file.getName(), sourceCreationDate), sourceCreationSnapshotInformation);
        }
        boolean isNew = filesManager.loadFileIntoTemporaryStorage(file, RepositoryFileID.convertRepositoryFileID(originalFileID).getFileID(), sourceMetaInformation);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": load imported file into temporary storage: is new = " + Boolean.valueOf(isNew));
        }
        return isNew;
    }

    public void markFileAsBeingPermanent(IRepositoryFileID fileID) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": mark file as beeing local " + To.string((Object)fileID));
        }
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": mark file as beeing local " + To.string((Object)fileID));
        }
    }

    public void markFileAsBeingTemporary(IRepositoryFileID fileID) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": mark file as beeing temporary " + To.string((Object)fileID));
        }
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": mark file as beeing temporary " + To.string((Object)fileID));
        }
    }

    public void removeFileFromTemporaryStorage(IRepositoryFileID fileID) {
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "v FileArchive " + To.string((Object)this) + ": remove file from temporary storage " + To.string((Object)fileID));
        }
        IFilesManager filesManager = this.getFilesManager();
        FileID cockpitFileID = RepositoryFileID.convertRepositoryFileID(fileID).getFileID();
        filesManager.removeFileFromTemporaryStorage(cockpitFileID);
        if (logger.isDebugEnabled(34)) {
            logger.debug(34, "^ FileArchive " + To.string((Object)this) + ": remove file from temporary storage " + To.string((Object)fileID));
        }
    }
}

