/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.lib.java.Assert;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterRelationContribution;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.cockpitadapter.locks.EOPlatformLock;
import com.arcway.repository.implementation.lock.CrossLinkRepositoryRelationLockSample;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.lock.AbstractRepositoryLockSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.item.IRepositoryItemType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationSample;
import java.util.HashMap;
import java.util.Map;

public class PlatformAdapterCrossLinkRelation
extends PlatformAdapterItem
implements ICrossLinkRepositoryRelation {
    private final ICrossLinkRepositoryRelationType repositoryRelationType;
    private final Map<ICrossLinkRepositoryRelationContributionType, PlatformAdapterRelationContribution> repositoryRelationContributions;

    public PlatformAdapterCrossLinkRelation(PlatformAdapterSnapshot snapshot, ICrossLinkRepositoryRelationType repositoryRelationType, Map<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject> adapterRelationContributions) {
        super(snapshot);
        Assert.checkArgumentBeeingNotNull((Object)repositoryRelationType);
        this.repositoryRelationType = repositoryRelationType;
        this.repositoryRelationContributions = this.initializeRepositoryRelationContribution(snapshot, adapterRelationContributions);
    }

    private Map<ICrossLinkRepositoryRelationContributionType, PlatformAdapterRelationContribution> initializeRepositoryRelationContribution(PlatformAdapterSnapshot snapshot, Map<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject> adapterRelationContributions) {
        HashMap<ICrossLinkRepositoryRelationContributionType, PlatformAdapterRelationContribution> createdRepositoryRelationContributions = new HashMap<ICrossLinkRepositoryRelationContributionType, PlatformAdapterRelationContribution>(adapterRelationContributions.size());
        for (Map.Entry<ICrossLinkRepositoryRelationContributionType, PlatformAdapterObject> entry : adapterRelationContributions.entrySet()) {
            ICrossLinkRepositoryRelationContributionType relationContributionType = entry.getKey();
            PlatformAdapterObject object = entry.getValue();
            PlatformAdapterRelationContribution adapterRelationContribution = new PlatformAdapterRelationContribution(snapshot, this, relationContributionType, object);
            createdRepositoryRelationContributions.put(relationContributionType, adapterRelationContribution);
        }
        return createdRepositoryRelationContributions;
    }

    public IRepositoryDeclarationItem getType() {
        return this.getItemType();
    }

    public IRepositoryItemType getItemType() {
        return this.getRelationType();
    }

    public ICrossLinkRepositoryRelationType getRelationType() {
        return this.repositoryRelationType;
    }

    public PlatformAdapterRelationContribution getRelationContributionImplementation(ICrossLinkRepositoryRelationContributionType relationContributionType) {
        PlatformAdapterRelationContribution relationContribution = this.repositoryRelationContributions.get(relationContributionType);
        Assert.checkArgumentBeeingNotNull((Object)relationContribution);
        return relationContribution;
    }

    public ICrossLinkRepositoryRelationContribution getRelationContribution(ICrossLinkRepositoryRelationContributionType relationContributionType) throws EXNotReproducibleSnapshot {
        return this.getRelationContributionImplementation(relationContributionType);
    }

    public ICrossLinkRepositoryRelationSample sample() throws EXNotReproducibleSnapshot {
        return new CrossLinkRepositoryRelationSample((ICrossLinkRepositoryRelation)this);
    }

    public IRepositoryPropertySetSample getSnapshotIDOfLastModification() {
        CrossLinkRepositoryRelationReference relationReference;
        try {
            relationReference = new CrossLinkRepositoryRelationReference((ICrossLinkRepositoryRelation)this);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new RuntimeException("cannot happen");
        }
        CrossLinkRepositoryRelationLockSample relationLockSample = new CrossLinkRepositoryRelationLockSample((ICrossLinkRepositoryRelationReference)relationReference, RepositorySamples.getSnapshotID((IRepositoryObjectSample)this.getSnapshotImplementation().getSnapshotInformation(), (IRepositoryTypeManagerRO)this.getTypeManager()));
        EOPlatformLock eoLock = this.getSnapshotImplementation().getWorkstationImplementation().createEOLock((AbstractRepositoryLockSample)relationLockSample);
        String commitUID = this.getLockManager().getCommitUID(eoLock);
        return this.getWorkstationImplementation().getSnapshotID(commitUID);
    }
}

