/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import java.util.Collection;
import java.util.Iterator;

public class PlatformAdapterCockpitRelationContributionIterator
implements IRepositoryIterator_ICrossLinkRepositoryRelationContribution {
    private static final ILogger logger = Logger.getLogger(PlatformAdapterCockpitRelationContributionIterator.class);
    private final Iterator<PlatformAdapterRelationContribution> javaIterator;
    private boolean isDisposed = false;

    public PlatformAdapterCockpitRelationContributionIterator(Collection<PlatformAdapterRelationContribution> relationContributions) {
        Assert.checkArgumentBeeingNotNull(relationContributions);
        Assert.checkCollectionArgumentToContainACertainType(relationContributions, PlatformAdapterRelationContribution.class);
        this.javaIterator = relationContributions.iterator();
    }

    public boolean hasNext() throws EXNotReproducibleSnapshot {
        boolean hasNext = this.javaIterator.hasNext();
        this.isDisposed |= !hasNext;
        return hasNext;
    }

    public ICrossLinkRepositoryRelationContribution nextIRepositoryRelationContribution() {
        return this.javaIterator.next();
    }

    public void abortIteration() {
        this.isDisposed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isDisposed) {
            logger.error("Iterator was finalized, but not disposed.");
        }
        super.finalize();
    }
}

