/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.clientadapter.implementation.adapter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.clientadapter.implementation.adapter.CustomPropertyTypeID;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterItem;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterSnapshot;
import com.arcway.repository.clientadapter.implementation.adapter.frame.RepositoryFileID;
import com.arcway.repository.clientadapter.interFace.CockpitObjectTypeCategoryID;
import com.arcway.repository.clientadapter.interFace.ICockpitObjectTypeCategoryID;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategorySample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryDeclarationItem;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectTypeCategorySample;
import com.arcway.repository.lib.high.implementation.filearchive.FileResourceForFileInFileArchive;

public class PlatformAdapterCategory
extends PlatformAdapterItem
implements IRepositoryObjectTypeCategory,
ICockpitObjectTypeCategoryID {
    private final IRepositoryTypeManagerRO typeManager;
    private final IRepositoryDeclarationItem declarationItem;
    private final ObjectTypeCategory category;
    private final ICockpitObjectTypeCategoryID cockpitCategoryID;
    private final IRepositoryObjectTypeCategoryID categoryID;
    private final IRepositoryObjectType objectType;
    private boolean iconDetermined = false;
    private IStreamResource icon = null;
    private final ISet_<IRepositoryPropertyTypeID> visibleProperties;

    public PlatformAdapterCategory(ObjectTypeCategory category, IRepositoryTypeManagerRO typeManager, PlatformAdapterSnapshot snapshot) {
        super(snapshot);
        this.typeManager = typeManager;
        this.declarationItem = typeManager.getObjectTypeCategoryMetaType();
        this.category = category;
        this.cockpitCategoryID = new CockpitObjectTypeCategoryID(category);
        this.categoryID = new IRepositoryObjectTypeCategoryID(){

            public String toCanonicalString() {
                return PlatformAdapterCategory.this.category.getObjectTypeCategoryID().getUID();
            }
        };
        IRepositoryObjectTypeID objectTypeID = this.getPlatformAdapterModuleManager().getMostAbstractRepositoryObjectType(category.getCockpitDataTypeID());
        this.objectType = typeManager.getObjectType(objectTypeID);
        assert (this.objectType.isRootTypeForCategoryDefinition());
        HashSet_ visibleProperties_ = new HashSet_(IRepositoryPropertyTypeID.IS_EQUAL_PROPERTY_TYPE_ID_HASHER);
        for (IRepositoryPropertyType propertyType : RepositoryObjectTypes.getAllPropertyTypesExceptObjectIDProperties((IRepositoryObjectType)typeManager.getObjectType(objectTypeID))) {
            if (propertyType.isCategoryIndependentlyFixProperty()) continue;
            IRepositoryPropertyTypeID propertyTypeID = propertyType.getRepositoryPropertyTypeID();
            if (propertyTypeID instanceof CustomPropertyTypeID) {
                CustomPropertyTypeID customPropertyTypeID = (CustomPropertyTypeID)propertyTypeID;
                if (!category.getAttributeList().contains(customPropertyTypeID.getAttributeTypeID())) continue;
                visibleProperties_.add((Object)propertyTypeID);
                continue;
            }
            assert (false);
        }
        this.visibleProperties = visibleProperties_;
    }

    public IRepositoryDeclarationItem getType() {
        return this.declarationItem;
    }

    public IRepositoryObjectTypeCategoryID getObjectTypeCategoryID() {
        return this.categoryID;
    }

    public String getHumanReadableID() {
        return this.category.getHumanReadableID();
    }

    public IRepositoryObjectType getObjectType() {
        return this.objectType;
    }

    public int getSortPosition() {
        return this.category.getSortPosition();
    }

    public String getDisplayName() {
        return this.category.getDisplayName();
    }

    public IStreamResource getIcon() throws EXNotReproducibleSnapshot {
        if (!this.iconDetermined) {
            if (this.category.getIcon() != null && !this.category.getIcon().equals(FileID.NO_FILE)) {
                this.icon = new FileResourceForFileInFileArchive((IRepositoryFileID)new RepositoryFileID(this.category.getIcon()), this.typeManager);
            }
            this.iconDetermined = true;
        }
        return this.icon;
    }

    public ISet_<IRepositoryPropertyTypeID> getVisibleProperties() {
        return this.visibleProperties;
    }

    @Override
    public ObjectTypeCategoryID getCockpitObjectTypeCategoryID() {
        return this.category.getObjectTypeCategoryID();
    }

    public int hashCode() {
        return this.cockpitCategoryID.hashCode();
    }

    public boolean equals(Object obj) {
        return this.cockpitCategoryID.equals(obj);
    }

    public IRepositoryObjectTypeCategorySample sample() {
        return new RepositoryObjectTypeCategorySample(this.categoryID, this.category.getHumanReadableID(), this.objectType.getRepositoryObjectTypeID(), this.category.getSortPosition(), this.category.getDisplayName(), (IRepositoryFileID)new RepositoryFileID(this.category.getIcon()), this.visibleProperties);
    }
}

