/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.log;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainerEncoder;
import com.arcway.cockpit.frame.shared.dump.IBaseDumpLogFileProcessor;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.lib.xml.encoding.sequential.processing.EOConcatenatingContainerReader;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;
import de.plans.lib.xml.encoding.sequential.write.EOContainerBodyWriter;
import de.plans.lib.xml.encoding.sequential.write.EOContainerWriter;
import java.io.InputStream;
import java.io.OutputStream;

public class DumpLogFileEncoder<TE extends EncodableObjectBase, TC extends EOEncodableObject> {
    private final EOContainerWriter<EOList<TC>, TC> logContainersWriter;
    private final ContainerFactory<TC> containerFactory;

    public static <SE extends EncodableObjectBase, SC extends EncodableObjectBase> void decodeDumpLogFile(InputStream inputStream, XMLDecoder xmlDecoder, IEncodableObjectFactory eoFactory, IBaseDumpLogFileProcessor<SE> dumpLogFileProcessor, ContainerReader<SC> containerReader) throws EXDecoderException {
        EOConcatenatingContainerReader<EOList<SE>, SE> itemsReader = DumpLogFileEncoder.createDumpLogFileReader(dumpLogFileProcessor, containerReader);
        itemsReader.readContainer(inputStream, xmlDecoder, eoFactory);
    }

    public static <SE extends EncodableObjectBase, SC extends EncodableObjectBase> EOConcatenatingContainerReader<EOList<SE>, SE> createDumpLogFileReader(IBaseDumpLogFileProcessor<SE> dumpLogFileProcessor, ContainerReader<SC> containerReader) {
        EOConcatenatingContainerReader moduleDataContainerListReader = new EOConcatenatingContainerReader(DumpLogFileEncoder.createModuleDataContainerListProcessor(dumpLogFileProcessor));
        EOConcatenatingContainerReader moduleDataContainerReader = moduleDataContainerListReader.createChildProcessor(DumpLogFileEncoder.createModuleDataContainerProcessor(dumpLogFileProcessor, containerReader));
        EOConcatenatingContainerReader itemsReader = moduleDataContainerReader.createChildProcessor(DumpLogFileEncoder.createItemsProcessor(dumpLogFileProcessor));
        return itemsReader;
    }

    private static <SE extends EncodableObjectBase, SC extends EncodableObjectBase> IEOContainerProcessor<EOList<SC>, SC> createModuleDataContainerListProcessor(final IBaseDumpLogFileProcessor<SE> dumpLogFileProcessor) {
        return new IEOContainerProcessor<EOList<SC>, SC>(){

            public void beginContainer(EOList<SC> emptyContainer) {
            }

            public void processEO(SC container) {
            }

            public void endContainer() {
                try {
                    dumpLogFileProcessor.end();
                }
                catch (EXEncoderException e) {
                    throw e.toNewRuntimeException(null);
                }
            }
        };
    }

    private static <SE extends EncodableObjectBase, SC extends EncodableObjectBase> IEOContainerProcessor<SC, EOList<SE>> createModuleDataContainerProcessor(final IBaseDumpLogFileProcessor<SE> dumpLogFileProcessor, final ContainerReader<SC> containerReader) {
        return new IEOContainerProcessor<SC, EOList<SE>>(){

            public void beginContainer(SC emptyContainer) {
                try {
                    String dataTypeUID = containerReader.getDataTypeID(emptyContainer);
                    dumpLogFileProcessor.nextModuleDataContainer(dataTypeUID);
                }
                catch (EXEncoderException e) {
                    throw e.toNewRuntimeException(null);
                }
            }

            public void processEO(EOList<SE> encodableObject) {
            }

            public void endContainer() {
            }
        };
    }

    private static <SE extends EncodableObjectBase> IEOContainerProcessor<EOList<SE>, SE> createItemsProcessor(final IBaseDumpLogFileProcessor<SE> dumpLogFileProcessor) {
        return new IEOContainerProcessor<EOList<SE>, SE>(){

            public void beginContainer(EOList<SE> emptyContainer) {
            }

            public void processEO(SE encodableObject) {
                try {
                    dumpLogFileProcessor.nextItem(encodableObject);
                }
                catch (EXEncoderException e) {
                    throw e.toNewRuntimeException(null);
                }
            }

            public void endContainer() {
            }
        };
    }

    public DumpLogFileEncoder(OutputStream outputStream, ContainerFactory<TC> containerFactory) throws EXEncoderException {
        this.logContainersWriter = new EOContainerWriter((EncodableObjectBase)new EOList(), outputStream, true);
        this.containerFactory = containerFactory;
    }

    public EOModuleDataContainerEncoder<TE, TC> beginModuleDataContainer(String dataTypeUID) throws EXEncoderException {
        EOContainerBodyWriter containerWriter = this.logContainersWriter.beginSubContainer((EncodableObjectBase)((EOEncodableObject)this.containerFactory.createContainer(dataTypeUID)));
        return new EOModuleDataContainerEncoder(containerWriter);
    }

    public void end() throws EXEncoderException {
        this.logContainersWriter.end();
    }

    public static interface ContainerFactory<C extends EncodableObjectBase> {
        public C createContainer(String var1);
    }

    public static interface ContainerReader<C extends EncodableObjectBase> {
        public String getDataTypeID(C var1);
    }
}

