/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.sequences;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkTypeLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.ILockTypeProvider;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.modules.ModuleDataManager;
import com.arcway.cockpit.frame.client.project.sequences.ISequencer;
import com.arcway.cockpit.frame.client.project.sequences.SequencerManager;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.New;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Sequencer
implements ISequencer {
    private static final ILogger logger = Logger.getLogger(Sequencer.class);
    private static final int LOGGER_DEBUG_CATEGORY = 32;
    private static final String LOCK_OPERATION_CHANGE_ORDER = "changeOrder";
    private final IFrameProjectAgent projectAgent;
    private final IFrameDataManager childrenDataManager;
    private final IFrameDataManager parentDataManager;
    private final ICockpitDataType childrenDataType;
    private final ICockpitDataType parentDataType;
    private final IAttributeOwner parent;
    private final ILinkTypeLinkAccessFacade linkFacade;
    private final String linkTypeID;
    private final Comparator<ICockpitProjectData> sequencerComparator;
    private Collection<ILockTypeProvider> lockTypeProviders;
    private List<ICockpitProjectData> sortedElementsBeforeAsynchronousUpdate;

    protected Sequencer(IAttributeOwner parent, ICockpitDataType dataType, IFrameProjectAgent projectAgent, ILinkTypeLinkAccessFacade linkFacade, String linkTypeID) {
        assert (linkFacade != null);
        this.projectAgent = projectAgent;
        this.childrenDataType = dataType;
        this.childrenDataManager = projectAgent.getDataManager(dataType.getCockpitDataTypeID());
        this.parentDataManager = projectAgent.getDataManager(parent.getTypeID());
        this.parent = parent;
        this.parentDataType = FrameDataTypes.getDataType(parent.getTypeID());
        this.linkFacade = linkFacade;
        this.linkTypeID = linkTypeID;
        this.sequencerComparator = new SequencerComparator();
        this.logCurrentState("initial order");
    }

    private IAttributeOwner getAttributeOwner(ICockpitProjectData item) {
        if (item instanceof IAttributeOwner) {
            return (IAttributeOwner)item;
        }
        IFMCAModule module = this.projectAgent.getModuleController().getModuleForData(item);
        return module.getAttributeOwner(item);
    }

    public void setLockTypeProviders(Collection<ILockTypeProvider> lockTypeProviders) {
        this.lockTypeProviders = lockTypeProviders;
    }

    protected void asynchronousUpdateStarted() {
        if (this.projectAgent.getFrameLockManager().clientAlreadyHasLock((ILockable)this.parent, LOCK_OPERATION_CHANGE_ORDER)) {
            this.sortedElementsBeforeAsynchronousUpdate = this.createHealedSortedListOfSortedElements();
        }
    }

    private List<ICockpitProjectData> createHealedSortedListOfSortedElements() {
        Collection<? extends IAttributeOwner> allAttributeOwners = this.getAllAttributeOwners();
        int nrOfElements = allAttributeOwners.size();
        ArrayList<ICockpitProjectData> sortedElements = new ArrayList<ICockpitProjectData>(nrOfElements);
        HashSet processedUIDs = New.hashSet((int)nrOfElements);
        for (IAttributeOwner iAttributeOwner : allAttributeOwners) {
            String elementUID = iAttributeOwner.getUID();
            ICockpitProjectData element = this.getElement(elementUID);
            if (processedUIDs.contains(elementUID)) continue;
            processedUIDs.add(elementUID);
            Set<EOLink> predecessorLinks = this.getPredecessorLinks(elementUID);
            if (!this.isSorted(element, predecessorLinks)) continue;
            this.addElementAndItsPredecessorsToHealedSortedListOfSortedElements(element, predecessorLinks, sortedElements, processedUIDs);
        }
        return sortedElements;
    }

    private void addElementAndItsPredecessorsToHealedSortedListOfSortedElements(ICockpitProjectData element, Set<EOLink> predecessorLinks, List<ICockpitProjectData> sortedElements, Set<String> processedUIDs) {
        this.addPredecessorsToHealedSortedListOfSortedElements(element, predecessorLinks, sortedElements, processedUIDs);
        sortedElements.add(element);
    }

    private void addPredecessorsToHealedSortedListOfSortedElements(ICockpitProjectData element, Set<EOLink> predecessorLinks, List<ICockpitProjectData> sortedElements, Set<String> processedUIDs) {
        String elementUID = element.getUID();
        for (EOLink predecessorLink : predecessorLinks) {
            String predecessorUID = Sequencer.getPredecessorUID(predecessorLink);
            if (processedUIDs.contains(predecessorUID)) continue;
            processedUIDs.add(predecessorUID);
            boolean isFirst = predecessorUID.equals(elementUID);
            if (isFirst) {
                assert (false) : "cannot happen, as UID of current element must already be contained in processedUIDs";
                continue;
            }
            Set<EOLink> predecessorLinksOfPredecessor = this.getPredecessorLinks(predecessorUID);
            ICockpitProjectData predecessor = this.getElement(predecessorUID);
            this.addElementAndItsPredecessorsToHealedSortedListOfSortedElements(predecessor, predecessorLinksOfPredecessor, sortedElements, processedUIDs);
        }
    }

    private static String getPredecessorUID(EOLink predecessorLink) {
        return predecessorLink.getLinkableObjectUID();
    }

    private Collection<? extends IAttributeOwner> getAllAttributeOwners() {
        return this.parentDataManager.getChildren(this.parent);
    }

    protected void asynchronousUpdateEnded() {
        if (this.sortedElementsBeforeAsynchronousUpdate != null) {
            this.recreateLinks(this.sortedElementsBeforeAsynchronousUpdate);
        }
        this.sortedElementsBeforeAsynchronousUpdate = null;
    }

    private void recreateLinks(List<ICockpitProjectData> sortedElementsToBeRestored) {
        this.deleteLinks();
        ICockpitProjectData lastElement = null;
        for (ICockpitProjectData elementToInsert : sortedElementsToBeRestored) {
            if (this.getElement(elementToInsert.getUID()) == null) continue;
            IAttributeOwner newParent = null;
            if (elementToInsert instanceof IAttributeOwner) {
                newParent = this.childrenDataManager.getParent((IAttributeOwner)elementToInsert);
            } else {
                ModuleDataManager moduleDataManager = (ModuleDataManager)this.childrenDataManager;
                newParent = moduleDataManager.getParent(elementToInsert);
            }
            if (newParent == null || !newParent.equals(this.parent)) continue;
            if (lastElement == null) {
                EOLink linkToItself = this.createLink(elementToInsert, elementToInsert);
                this.linkFacade.addLink(linkToItself);
            } else {
                EOLink link = this.createLink(lastElement, elementToInsert);
                this.linkFacade.addLink(link);
            }
            lastElement = elementToInsert;
        }
    }

    private void deleteLinks() {
        Collection<? extends IAttributeOwner> allAttributeOwners = this.getAllAttributeOwners();
        for (IAttributeOwner iAttributeOwner : allAttributeOwners) {
            String elementUID = iAttributeOwner.getUID();
            for (EOLink link : this.linkFacade.getLinksForLinkableObject(elementUID)) {
                this.linkFacade.deleteLink(link);
            }
            for (EOLink link : this.linkFacade.getLinksForModuleDataItem(elementUID)) {
                this.linkFacade.deleteLink(link);
            }
        }
    }

    private ICockpitProjectData getElement(String elementUID) {
        return this.childrenDataManager.getCockpitProjectData(elementUID);
    }

    @Override
    public ICockpitProjectData getSuccessor(ICockpitProjectData element) {
        Collection<ICockpitProjectData> successors = this.linkFacade.getModuleData(element.getUID());
        for (ICockpitProjectData successor : successors) {
            if (successor.getUID().equals(element.getUID())) continue;
            return successor;
        }
        return null;
    }

    @Override
    public Comparator<ICockpitProjectData> getComparator() {
        return this.sequencerComparator;
    }

    @Override
    public void requestSequenceChangePermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockToTest((ILockable)this.parent, LOCK_OPERATION_CHANGE_ORDER);
        transactionController.addLock((ILockable)this.parent, LOCK_OPERATION_CHANGE_ORDER);
        for (ILockTypeProvider lockTypeProvider : this.lockTypeProviders) {
            if (lockTypeProvider.checkOnly()) {
                transactionController.addLockToTest(lockTypeProvider.getLockableToLock(), lockTypeProvider.getOperation());
                continue;
            }
            transactionController.addLock(lockTypeProvider.getLockableToLock(), lockTypeProvider.getOperation());
        }
    }

    @Override
    public void setFirstElement(ICockpitProjectData firstElement) {
        if (!this.isFirstElement(firstElement)) {
            this.removeElement(firstElement.getUID());
            ICockpitProjectData oldFirstElement = this.getFirstElement();
            ArrayList<EOLink> linksToDelete = new ArrayList<EOLink>();
            if (oldFirstElement != null) {
                for (EOLink link : this.linkFacade.getLinksForLinkableObject(oldFirstElement.getUID())) {
                    if (!link.getModuleDataUID().equals(oldFirstElement.getUID())) continue;
                    linksToDelete.add(link);
                }
            }
            for (EOLink link : linksToDelete) {
                this.linkFacade.deleteLink(link);
            }
            if (oldFirstElement != null) {
                this.linkFacade.addLink(this.createLink(firstElement, oldFirstElement));
            }
            EOLink linkToItself = this.createLink(firstElement, firstElement);
            this.linkFacade.addLink(linkToItself);
            this.logCurrentState("set first element " + this.childrenDataType.getDisplayName(firstElement));
            this.performHealingAndRemoveLocksIfNotNeeded();
        }
    }

    private EOLink createLink(ICockpitProjectData predecessor, ICockpitProjectData successor) {
        return new EOLink(this.projectAgent.getProjectUID(), predecessor.getUID(), successor.getUID(), "frame", this.linkTypeID);
    }

    @Override
    public ICockpitProjectData getFirstElement() {
        for (IAttributeOwner iAttributeOwner : this.getAllAttributeOwners()) {
            Collection<ICockpitProjectData> predecessors = this.getPredecessors(iAttributeOwner.getUID());
            if (predecessors.size() != 1) continue;
            ICockpitProjectData predecessor = predecessors.iterator().next();
            ICockpitProjectData data = this.getElement(iAttributeOwner.getUID());
            if (!data.equals(predecessor)) continue;
            return data;
        }
        return null;
    }

    @Override
    public ICockpitProjectData getLastElement() {
        Collection<? extends IAttributeOwner> childAttributeOwners = this.getAllAttributeOwners();
        for (IAttributeOwner iAttributeOwner : childAttributeOwners) {
            Collection<ICockpitProjectData> predecessors = this.getPredecessors(iAttributeOwner.getUID());
            if (predecessors.isEmpty()) continue;
            ICockpitProjectData data = this.getElement(iAttributeOwner.getUID());
            return this.getLastElementOfSequence(data);
        }
        return null;
    }

    private ICockpitProjectData getLastElementOfSequence(ICockpitProjectData itemToStart) {
        ICockpitProjectData currentItem = itemToStart;
        ICockpitProjectData successor;
        while ((successor = this.getSuccessor(currentItem)) != null) {
            currentItem = successor;
        }
        return currentItem;
    }

    @Override
    public boolean isSorted(ICockpitProjectData element) {
        String elementUID = element.getUID();
        return this.isSorted(element, this.getPredecessorLinks(elementUID));
    }

    private boolean isSorted(ICockpitProjectData element, Collection<EOLink> predecessorLinks) {
        return !predecessorLinks.isEmpty() && this.getAllAttributeOwners().contains(this.getAttributeOwner(element));
    }

    @Override
    public void insertElement(ICockpitProjectData elementToInsert, ICockpitProjectData predecessor) {
        assert (!elementToInsert.equals(predecessor));
        assert (this.isSorted(predecessor));
        boolean execute = true;
        Collection<ICockpitProjectData> oldPredecessors = this.getPredecessors(elementToInsert.getUID());
        Iterator<ICockpitProjectData> i = oldPredecessors.iterator();
        while (i.hasNext() && execute) {
            ICockpitProjectData oldPredecessor = i.next();
            if (!oldPredecessor.equals(predecessor)) continue;
            execute = false;
        }
        if (execute) {
            EOLink link2;
            this.removeElement(elementToInsert.getUID());
            for (EOLink link2 : this.linkFacade.getLinksForLinkableObject(predecessor.getUID())) {
                if (Sequencer.getPredecessorUID(link2).equals(link2.getModuleDataUID())) continue;
                this.linkFacade.deleteLink(link2);
                link2 = new EOLink(link2);
                link2.setLinkableObjectUID(elementToInsert.getUID());
                this.linkFacade.addLink(link2);
            }
            link2 = this.createLink(predecessor, elementToInsert);
            this.linkFacade.addLink(link2);
            this.performHealingAndRemoveLocksIfNotNeeded();
            this.logCurrentState("inserted " + this.childrenDataType.getDisplayName(elementToInsert) + " after " + this.childrenDataType.getDisplayName(predecessor));
        }
    }

    @Override
    public void removeElement(ICockpitProjectData elementToRemove) {
        this.removeElement(elementToRemove.getUID());
    }

    private void removeElement(String idOfElementToRemove) {
        boolean foundAndRemoved = SequencerManager.removeElementFromSorting(this.linkFacade, idOfElementToRemove);
        if (foundAndRemoved) {
            this.performHealingAndRemoveLocksIfNotNeeded();
            this.logCurrentState("removed element " + idOfElementToRemove);
        }
    }

    private boolean isPredecessor(String predecessorCandidateUID, String successorUID, Collection<EOLink> predecessorLinksOfSuccessor, Collection<String> checked) {
        for (EOLink currentPredecessorLinkOfSuccessor : predecessorLinksOfSuccessor) {
            String currentPredecessorUID = Sequencer.getPredecessorUID(currentPredecessorLinkOfSuccessor);
            if (currentPredecessorUID.equals(predecessorCandidateUID)) {
                return true;
            }
            if (currentPredecessorUID.equals(successorUID) || checked.contains(currentPredecessorUID)) continue;
            checked.add(currentPredecessorUID);
            if (!this.isPredecessor(predecessorCandidateUID, currentPredecessorUID, this.getPredecessorLinks(currentPredecessorUID), checked)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICockpitProjectData getPredecessor(ICockpitProjectData element) {
        Collection<ICockpitProjectData> predecessors = this.getPredecessors(element.getUID());
        for (ICockpitProjectData existing : predecessors) {
            if (existing.equals(element)) continue;
            return existing;
        }
        return null;
    }

    private Collection<ICockpitProjectData> getPredecessors(String elementUID) {
        return this.linkFacade.getLinkableObjects(elementUID);
    }

    @Override
    public boolean isFirstElement(ICockpitProjectData element) {
        String elementUID = element.getUID();
        return this.getAllAttributeOwners().contains(this.getAttributeOwner(element)) && Sequencer.isFirstElement(elementUID, this.getPredecessorLinks(elementUID));
    }

    private Set<EOLink> getPredecessorLinks(String elementUID) {
        return this.linkFacade.getLinksForModuleDataItem(elementUID);
    }

    private static boolean isFirstElement(String elementUID, Collection<EOLink> predecessorLinks) {
        EOLink predecessorLink;
        if (predecessorLinks.size() == 1 && (predecessorLink = predecessorLinks.iterator().next()) != null) {
            return Sequencer.getPredecessorUID(predecessorLink).equals(elementUID);
        }
        return false;
    }

    private void performHealingAndRemoveLocksIfNotNeeded() {
        if (this.sortedElementsBeforeAsynchronousUpdate == null) {
            List<ICockpitProjectData> healedSortedListOfSortedElements = this.createHealedSortedListOfSortedElements();
            this.recreateLinks(healedSortedListOfSortedElements);
            this.removeIfLocksNotNeeded();
        }
    }

    private void removeIfLocksNotNeeded() {
        if (!this.projectAgent.getLinkManager().hasModifiedLinks(this.linkTypeID)) {
            IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
            Collection<EOLock> locksToRelease = lockMgr.findClientLocksByILockable((ILockable)this.parent, LOCK_OPERATION_CHANGE_ORDER);
            if (locksToRelease != null) {
                lockMgr.releaseLocks(locksToRelease);
                logger.debug(32, "Lock removed because original order was restored.");
            } else {
                logger.warn("Lock to be released not found.");
            }
        }
    }

    private void logCurrentState(String performedAction) {
        if (logger.isDebugEnabled(32)) {
            logger.debug(32, "-------Sequence of " + this.parentDataType.getDisplayName((ICockpitProjectData)this.parent) + " (" + this.parentDataType.getDisplayName() + ")" + "-------------");
            logger.debug(32, "       " + performedAction);
            Collection<? extends IAttributeOwner> childAttributeOwners = this.getAllAttributeOwners();
            boolean first = false;
            for (IAttributeOwner iAttributeOwner : childAttributeOwners) {
                String childrenTypeID = this.childrenDataType.getCockpitDataTypeID();
                if (!iAttributeOwner.getTypeID().equals(childrenTypeID)) continue;
                Collection<ICockpitProjectData> predecessors = this.linkFacade.getLinkableObjects(iAttributeOwner.getUID());
                ICockpitProjectData child = this.getElement(iAttributeOwner.getUID());
                for (ICockpitProjectData predecessor : predecessors) {
                    if (!child.equals(predecessor)) continue;
                    if (first) {
                        logger.error("AMBIGOUS FIRST ELEMENT DETECTED: " + this.childrenDataType.getDisplayName(child));
                    }
                    this.logCurrentState(child);
                    first = true;
                }
            }
            logger.debug(32, "---------------------------------------");
            logger.debug(32, "");
        }
    }

    private void logCurrentState(ICockpitProjectData firstElement) {
        logger.debug(32, "                   " + this.childrenDataType.getDisplayName(firstElement));
        this.logSuccessors(Collections.singleton(firstElement), new ArrayList<ICockpitProjectData>());
    }

    private void logSuccessors(Collection<ICockpitProjectData> predecessors, Collection<ICockpitProjectData> loggedElements) {
        ArrayList<ICockpitProjectData> successors = new ArrayList<ICockpitProjectData>();
        String logText = "";
        for (ICockpitProjectData predecessor : predecessors) {
            int nrSuccessors = 0;
            if (predecessor != null) {
                if (loggedElements.contains(predecessor)) {
                    logger.error("LOOP DETECTED: " + this.childrenDataType.getDisplayName(predecessor));
                } else {
                    Collection<ICockpitProjectData> successorsOfCurrentPredecessor = this.linkFacade.getModuleData(predecessor.getUID());
                    for (ICockpitProjectData successor : successorsOfCurrentPredecessor) {
                        if (predecessor.equals(successor)) continue;
                        successors.add(successor);
                        ++nrSuccessors;
                    }
                    loggedElements.add(predecessor);
                    logText = String.valueOf(logText) + this.getLogText(predecessor);
                }
            }
            if (nrSuccessors <= true) continue;
            logger.error("MULTIPLE SUCCESSORS DETECTED: " + this.childrenDataType.getDisplayName(predecessor));
        }
        logger.debug(32, logText);
        if (!successors.isEmpty()) {
            this.logSuccessors(successors, loggedElements);
        }
    }

    private String getLogText(ICockpitProjectData predecessor) {
        String logText = "";
        for (ICockpitProjectData successor : this.linkFacade.getModuleData(predecessor.getUID())) {
            if (successor == null || predecessor.equals(successor)) continue;
            logText = String.valueOf(logText) + "                   " + this.childrenDataType.getDisplayName(successor);
        }
        return logText;
    }

    protected void desctruct() {
    }

    private class SequencerComparator
    implements Comparator<ICockpitProjectData> {
        private SequencerComparator() {
        }

        @Override
        public int compare(ICockpitProjectData data0, ICockpitProjectData data1) {
            if (data0 == data1) {
                return 0;
            }
            String dataUid0 = data0.getUID();
            String dataUid1 = data1.getUID();
            if (data0.getProjectUID().equals(data1.getProjectUID()) && dataUid0.equals(dataUid1)) {
                return 0;
            }
            Set<EOLink> predecessorLinks0 = Sequencer.this.linkFacade.getLinksForModuleDataItem(dataUid0);
            Set<EOLink> predecessorLinks1 = Sequencer.this.linkFacade.getLinksForModuleDataItem(dataUid1);
            boolean data0First = Sequencer.isFirstElement(dataUid0, predecessorLinks0);
            boolean data1First = Sequencer.isFirstElement(dataUid1, predecessorLinks1);
            if (data0First && data1First) {
                return 0;
            }
            if (data0First) {
                return -1;
            }
            if (data1First) {
                return 1;
            }
            HashSet tmpList = new HashSet((int)(1.5 * (double)Math.max(predecessorLinks0.size(), predecessorLinks1.size())));
            boolean is0PredecessorOf1 = Sequencer.this.isPredecessor(dataUid0, dataUid1, predecessorLinks1, tmpList);
            tmpList.clear();
            boolean is1PredecessorOf0 = Sequencer.this.isPredecessor(dataUid1, dataUid0, predecessorLinks0, tmpList);
            if (is0PredecessorOf1 && !is1PredecessorOf0) {
                return -1;
            }
            if (is1PredecessorOf0 && !is0PredecessorOf1) {
                return 1;
            }
            if (!Sequencer.this.isSorted(data0, predecessorLinks0) && Sequencer.this.isSorted(data1, predecessorLinks1)) {
                return 1;
            }
            if (Sequencer.this.isSorted(data0, predecessorLinks0) && !Sequencer.this.isSorted(data1, predecessorLinks1)) {
                return -1;
            }
            return 0;
        }
    }
}

