/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.propertychanges;

import com.arcway.cockpit.client.base.interfaces.frame.ICommitAgent;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IGlobalPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListenerManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesProviderManager;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.lib.java.Assert;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PropertyChangesManager
implements IPropertyChangesListenerManager,
IPropertyChangesProviderManager {
    private static final ILogger logger = Logger.getLogger(PropertyChangesManager.class);
    private final Map<Class<?>, Set<PropertyChangesListenerWithPriority>> listenerMap;
    private final Set<IGlobalPropertyChangesListener> globalListeners;
    private final String projectUID;
    private static final int propertyEventsDisabledCountInitialValue = 0;
    private int propertyEventsDisabledCount;
    private final LinkedList<PropertyChangeWrapper> collectedPropertyEvents;
    private HashSet<Class<?>> unsignalledGlobalRefreshClasses;
    private static final Comparator<PropertyChangesListenerWithPriority> PROPERTY_CHANGES_LISTENER_PRIORITY_COMPARATOR = new Comparator<PropertyChangesListenerWithPriority>(){

        @Override
        public int compare(PropertyChangesListenerWithPriority o1, PropertyChangesListenerWithPriority o2) {
            return o1.getPriority() - o2.getPriority();
        }
    };

    public PropertyChangesManager(IFrameProjectAgent projectAgent) {
        this.projectUID = projectAgent.getProjectUID();
        this.listenerMap = new HashMap();
        this.globalListeners = new HashSet<IGlobalPropertyChangesListener>();
        this.propertyEventsDisabledCount = 0;
        this.collectedPropertyEvents = new LinkedList();
        this.unsignalledGlobalRefreshClasses = null;
    }

    public void doOpenProjectWithSuspendedPropertyEventPropagation(IProjectOpenRunnable todo) throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage {
        this.suspendPropertyEvents();
        try {
            todo.run();
        }
        finally {
            this.resumePropertyEvents();
        }
    }

    public synchronized void register(IPropertyChangesListener listener, Class<?> clazz) {
        this.register(listener, clazz, 0);
    }

    public synchronized void register(IPropertyChangesListener listener, Class<?> clazz, int priority) {
        PropertyChangesListenerWithPriority listenerWrapper;
        Collection listeners;
        Assert.checkArgumentBeeingNotNull((Object)listener);
        if (!this.listenerMap.containsKey(clazz)) {
            this.listenerMap.put(clazz, new HashSet());
        }
        if (!(listeners = (Collection)this.listenerMap.get(clazz)).contains(listenerWrapper = new PropertyChangesListenerWithPriority(listener, priority))) {
            listeners.add(listenerWrapper);
        }
    }

    public synchronized void deregister(IPropertyChangesListener listener) {
        HashSet clazzes = new HashSet(this.listenerMap.keySet());
        for (Class clazz : clazzes) {
            this.deregisterListenerForClass(listener, clazz);
        }
    }

    public synchronized void deregister(IPropertyChangesListener listener, Class<?> clazz) {
        this.deregisterListenerForClass(listener, clazz);
    }

    private void deregisterListenerForClass(IPropertyChangesListener listener, Class<?> clazz) {
        Collection listeners = this.listenerMap.get(clazz);
        if (listeners != null) {
            PropertyChangesListenerWithPriority listenerWrapper = new PropertyChangesListenerWithPriority(listener, 0);
            listeners.remove(listenerWrapper);
            if (listeners.isEmpty()) {
                this.listenerMap.remove(clazz);
            }
        }
    }

    private void sendGlobalRefresh(Collection<Class<?>> clazzes) {
        for (IGlobalPropertyChangesListener listener : this.globalListeners) {
            listener.modelRefreshed(clazzes);
        }
    }

    public void runWithDeferredPropertyChangePropagation(Runnable runnable) {
        this.doWithSuspendedPropertyEventPropagation(runnable);
    }

    public void runWithDeferredPropertyChangePropagation(ICommitAgent commitAgent) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        this.suspendPropertyEvents();
        try {
            commitAgent.performCommit();
        }
        finally {
            this.resumePropertyEvents();
        }
    }

    public synchronized void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz) {
        assert (PropertyChangesManager.checkPropertyChangeTypeConsistency(changes, clazz));
        if (this.propertyEventsDisabledCount == 0) {
            if (this.collectedPropertyEvents.isEmpty()) {
                assert (this.unsignalledGlobalRefreshClasses == null);
                this.sendGlobalRefresh(Collections.singleton(clazz));
                this.doSignalPropertyChanges(changes, clazz);
            } else {
                assert (false) : "New property event arrived while collected property events were present - resume not yet completed? - What to do? Add the new event to the list of collected events and do nothing else?";
                this.storePropertyEvent(changes, clazz);
            }
        } else {
            this.storePropertyEvent(changes, clazz);
        }
    }

    private static boolean checkPropertyChangeTypeConsistency(IPropertyChanges<?> changes, Class<?> clazz) {
        if (changes.getCreatedElements() != null) {
            for (Object addedItem : changes.getCreatedElements()) {
                clazz.cast(addedItem);
            }
        }
        if (changes.getModifiedElements() != null) {
            for (Object modifiedItem : changes.getModifiedElements()) {
                clazz.cast(modifiedItem);
            }
        }
        if (changes.getDeletedElements() != null) {
            for (Object deletedItem : changes.getDeletedElements()) {
                clazz.cast(deletedItem);
            }
        }
        return true;
    }

    public void doWithSuspendedPropertyEventPropagation(Runnable todo) {
        this.suspendPropertyEvents();
        try {
            todo.run();
        }
        finally {
            this.resumePropertyEvents();
        }
    }

    private void storePropertyEvent(IPropertyChanges<?> changes, Class<?> clazz) {
        PropertyChangeWrapper wrapper = new PropertyChangeWrapper(changes, clazz);
        this.collectedPropertyEvents.add(wrapper);
        if (this.unsignalledGlobalRefreshClasses == null) {
            this.unsignalledGlobalRefreshClasses = new HashSet();
        }
        this.unsignalledGlobalRefreshClasses.add(clazz);
        assert (this.collectedPropertyEvents.size() < 5000) : "This estimated size maybe too small but we do not expect arbitrary high numbers here.";
    }

    private synchronized void suspendPropertyEvents() {
        ++this.propertyEventsDisabledCount;
        assert (this.propertyEventsDisabledCount > 0);
    }

    private synchronized void resumePropertyEvents() {
        if (this.propertyEventsDisabledCount > 0) {
            --this.propertyEventsDisabledCount;
        } else assert (false);
        if (this.propertyEventsDisabledCount == 0) {
            while (!this.collectedPropertyEvents.isEmpty()) {
                if (this.unsignalledGlobalRefreshClasses != null) {
                    HashSet<Class<?>> _unsignalledGlobalRefreshClasses = this.unsignalledGlobalRefreshClasses;
                    this.unsignalledGlobalRefreshClasses = null;
                    this.sendGlobalRefresh(_unsignalledGlobalRefreshClasses);
                }
                PropertyChangeWrapper changes = this.collectedPropertyEvents.removeFirst();
                this.doSignalPropertyChanges(changes.propertyChanges, changes.clazz);
            }
        }
    }

    private synchronized void doSignalPropertyChanges(IPropertyChanges<?> changes, Class<?> clazz) {
        HashSet matchingListeners = new HashSet();
        HashSet matchingClasses = new HashSet();
        for (Map.Entry<Class<?>, Set<PropertyChangesListenerWithPriority>> entry : this.listenerMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            matchingClasses.add(entry.getKey());
            matchingListeners.addAll(entry.getValue());
        }
        ArrayList sortedMatchingListeners = new ArrayList(matchingListeners);
        Collections.sort(sortedMatchingListeners, PROPERTY_CHANGES_LISTENER_PRIORITY_COMPARATOR);
        for (PropertyChangesListenerWithPriority listenerWrapper : sortedMatchingListeners) {
            if (!this.isListenerStillRegisteredForAnyClass(listenerWrapper, matchingClasses)) continue;
            try {
                listenerWrapper.getPropertyChangesListener().modelRefreshed(changes, clazz, this.projectUID);
            }
            catch (Throwable t) {
                logger.error("Error while distributing model refresh.", t);
            }
        }
    }

    private boolean isListenerStillRegisteredForAnyClass(PropertyChangesListenerWithPriority listenerWrapper, Set<Class<?>> possibleClasses) {
        for (Class<?> possibleClass : possibleClasses) {
            Set<PropertyChangesListenerWithPriority> stillActiveListenersOfThisType = this.listenerMap.get(possibleClass);
            if (stillActiveListenersOfThisType == null || !stillActiveListenersOfThisType.contains(listenerWrapper)) continue;
            return true;
        }
        return false;
    }

    public void projectClosed() {
        assert (this.listenerMap.isEmpty()) : "At least one listener has not been deregistered as property changes listener";
    }

    public void deregisterGlobalPropertyChangeListener(IGlobalPropertyChangesListener listener) {
        this.globalListeners.remove(listener);
    }

    public void registerGlobalPropertyChangeListener(IGlobalPropertyChangesListener listener) {
        this.globalListeners.add(listener);
    }

    public static interface IProjectOpenRunnable {
        public void run() throws LoginCanceledException, ServerNotAvailableException, UnknownServerException, EXServerException, ExProjectOpenAbortWithMessage;
    }

    private static class PropertyChangeWrapper {
        public final IPropertyChanges<?> propertyChanges;
        public final Class<?> clazz;

        public PropertyChangeWrapper(IPropertyChanges<?> changes, Class<?> _clazz) {
            this.propertyChanges = changes;
            this.clazz = _clazz;
        }
    }

    private static class PropertyChangesListenerWithPriority {
        private final IPropertyChangesListener propertyChangesListener;
        private final int priority;

        public PropertyChangesListenerWithPriority(IPropertyChangesListener propertyChangesListener, int priority) {
            this.propertyChangesListener = propertyChangesListener;
            this.priority = priority;
        }

        public IPropertyChangesListener getPropertyChangesListener() {
            return this.propertyChangesListener;
        }

        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return this.propertyChangesListener == null ? 0 : this.propertyChangesListener.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PropertyChangesListenerWithPriority && this.propertyChangesListener == ((PropertyChangesListenerWithPriority)obj).getPropertyChangesListener();
        }
    }
}

