/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planviewers.planexport;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planviewers.planexport.PlanExporterControllerExtension;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverEMF;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverWMF;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverMetafile;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.print.EXEmptyResult;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.IPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.IVariablePageSizeDeviceDriver;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import com.arcway.lib.graphics.print.VariablePageSizePrinter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FactoryInput;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentControllerExtension;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInputExtension;
import com.arcway.planagent.controllinginterface.planexporter.PlanExporterFactoryInput;
import com.arcway.planagent.controllinginterface.planexporter.PlanExporterInputExtension;
import com.arcway.planagent.controllinginterface.planviewer.PageSetup;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PlanExporter {
    private static final ILogger logger = Logger.getLogger(PlanExporter.class);
    private static final Insets EXPORT_INSETS = new Insets(1.0);
    private static final PageSetup EXPORT_PAGE_SETUP;

    static {
        int pageCountX = 1;
        int pageCountY = 1;
        Alignment alignment = new Alignment();
        float zoom = 1.0f;
        boolean fitHorizontal = true;
        boolean fitVertical = true;
        EXPORT_PAGE_SETUP = new PageSetup(pageCountX, pageCountY, alignment, (double)zoom, fitHorizontal, fitVertical, EXPORT_INSETS);
    }

    public static boolean createWMFImage(IPlan plan, boolean showMetaInformation, ICockpitProjectData elementToHighlight, File targetFile, IProgressDisplay progressDisplay) {
        boolean success;
        block7: {
            success = false;
            try {
                VariablePageSizePrinter printer = (VariablePageSizePrinter)PlanExporter.createPlanImage(plan, showMetaInformation, elementToHighlight, progressDisplay, new IPrinterFactory(){

                    @Override
                    public IPrinter createPrinter(Dimension planSizeInMM) {
                        Rectangle pageInMM = new Rectangle(Point.ORIGIN, planSizeInMM).expand(EXPORT_INSETS);
                        DeviceDriverWMF wmfDeviceDriver = new DeviceDriverWMF();
                        IPageDescription pageDescription = PageDescription.createPrintInfoInMM((double)pageInMM.w(), (double)pageInMM.h(), (Insets)EXPORT_INSETS);
                        return new VariablePageSizePrinter((IVariablePageSizeDeviceDriver)wmfDeviceDriver, pageDescription);
                    }
                });
                if (printer == null) break block7;
                try {
                    BufferedOutputStream targetOutputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                    IDeviceDriverMetafile deviceDriverWMF = (IDeviceDriverMetafile)printer.getVariablePageSizeDeviceDriver();
                    deviceDriverWMF.saveImageDirectly((OutputStream)targetOutputStream);
                    success = true;
                }
                finally {
                    printer.dispose();
                }
            }
            catch (EXEmptyResult e1) {
                logger.debug("empty plan.", (Throwable)e1);
            }
            catch (PrintingFailure e1) {
                logger.error("WMF generation failed.", (Throwable)e1);
            }
            catch (FileNotFoundException e1) {
                logger.error("WMF generation failed.", (Throwable)e1);
            }
        }
        return success;
    }

    public static boolean createEMFImage(IPlan plan, boolean showMetaInformation, ICockpitProjectData elementToHighlight, File targetFile, IProgressDisplay progressDisplay) {
        boolean success;
        block7: {
            success = false;
            try {
                VariablePageSizePrinter printer = (VariablePageSizePrinter)PlanExporter.createPlanImage(plan, showMetaInformation, elementToHighlight, progressDisplay, new IPrinterFactory(){

                    @Override
                    public IPrinter createPrinter(Dimension planSizeInMM) {
                        Rectangle pageInMM = new Rectangle(Point.ORIGIN, planSizeInMM).expand(EXPORT_INSETS);
                        DeviceDriverEMF emfDeviceDriver = new DeviceDriverEMF();
                        IPageDescription pageDescription = PageDescription.createPrintInfoInMM((double)pageInMM.w(), (double)pageInMM.h(), (Insets)EXPORT_INSETS);
                        return new VariablePageSizePrinter((IVariablePageSizeDeviceDriver)emfDeviceDriver, pageDescription);
                    }
                });
                if (printer == null) break block7;
                try {
                    BufferedOutputStream targetOutputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                    IDeviceDriverMetafile deviceDriverEMF = (IDeviceDriverMetafile)printer.getVariablePageSizeDeviceDriver();
                    deviceDriverEMF.saveImageDirectly((OutputStream)targetOutputStream);
                    success = true;
                }
                finally {
                    printer.dispose();
                }
            }
            catch (EXEmptyResult e1) {
                logger.debug("empty plan.", (Throwable)e1);
            }
            catch (PrintingFailure e1) {
                logger.error("EMF generation failed.", (Throwable)e1);
            }
            catch (FileNotFoundException e1) {
                logger.error("EMF generation failed.", (Throwable)e1);
            }
        }
        return success;
    }

    public static boolean createPNGImage(IPlan plan, final double wishedDPI, final int maxWidthOrHeightInPixel, boolean showMetaInformation, ICockpitProjectData elementToHighlight, File targetFile, IProgressDisplay progressDisplay) {
        boolean success = false;
        ImagePrinter printer = (ImagePrinter)PlanExporter.createPlanImage(plan, showMetaInformation, elementToHighlight, progressDisplay, new IPrinterFactory(){

            @Override
            public IPrinter createPrinter(Dimension planSizeInMM) {
                int wishedWidthInPixels = Math.min(maxWidthOrHeightInPixel, (int)Math.round(planSizeInMM.width / 25.4 * wishedDPI));
                int wishedHeightInPixels = Math.min(maxWidthOrHeightInPixel, (int)Math.round(planSizeInMM.height / 25.4 * wishedDPI));
                double horDPI = (double)wishedWidthInPixels / (planSizeInMM.width / 25.4);
                double vertDPI = (double)wishedHeightInPixels / (planSizeInMM.height / 25.4);
                double dpi = Math.min(horDPI, vertDPI);
                int widthInPixels = (int)Math.round(planSizeInMM.width / 25.4 * dpi);
                int heightInPixels = (int)Math.round(planSizeInMM.height / 25.4 * dpi);
                double realHorDPI = (double)widthInPixels / (planSizeInMM.width / 25.4);
                double realVertDPI = (double)heightInPixels / (planSizeInMM.height / 25.4);
                int insetsInPixels = 1;
                IImagePrinterPageDescription imageInfo = ImagePrinterPageDescription.createImageInfoInPixels((int)widthInPixels, (int)heightInPixels, (int)insetsInPixels, (double)realHorDPI, (double)realVertDPI, (Color)Color.WHITE);
                return new ImagePrinter(imageInfo);
            }
        });
        if (printer != null) {
            try {
                try {
                    printer.saveImageDirectly(targetFile, ImageCoDec.PNG);
                    success = true;
                }
                catch (PrintingFailure e) {
                    logger.error("Printing failed.", (Throwable)e);
                    printer.disposeImages();
                }
                catch (EXEmptyResult e) {
                    logger.debug("Empty plan.", (Throwable)e);
                    printer.disposeImages();
                }
            }
            finally {
                printer.disposeImages();
            }
        }
        return success;
    }

    private static IPrinter createPlanImage(IPlan plan, boolean showMetaInformation, ICockpitProjectData elementToHighlight, IProgressDisplay progressDisplay, IPrinterFactory printerFactory) {
        PlanExporterControllerExtension planExporterControllerExtension;
        IPrinter printer = null;
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
        PlanExporterControllerExtension externalPlanExporterExtension = planExporterControllerExtension = new PlanExporterControllerExtension(projectAgent);
        if (PlanExporter.launchPlanExportAgent(projectAgent, plan, planExporterControllerExtension, progressDisplay)) {
            externalPlanExporterExtension.setup(showMetaInformation, elementToHighlight);
            Rectangle planSizeInMM = externalPlanExporterExtension.getDrawingSizeInMM();
            if (planSizeInMM != null && planSizeInMM.w() > 1.0E-10 && planSizeInMM.h() > 1.0E-10) {
                printer = printerFactory.createPrinter(planSizeInMM.getDimension());
                try {
                    externalPlanExporterExtension.export(printer, EXPORT_PAGE_SETUP);
                }
                catch (PrintingFailure e) {
                    logger.error("Plan image export failed.", (Throwable)e);
                }
            }
            externalPlanExporterExtension.close();
        }
        return printer;
    }

    private static boolean launchPlanExportAgent(IPlanAgentProjectAgent projectAgent, IPlan plan, PlanExporterControllerExtension planAgentControllerExtension, IProgressDisplay pDisplay) {
        boolean launched = false;
        try {
            PlanAgentManager planAgentManager = projectAgent.getPlanAgentManager();
            String planAgentTypeID = "com.arcway.planagent.planexporter";
            PlanExporterFactoryInput factoryInput = new PlanExporterFactoryInput();
            PlanExporterInputExtension planAgentInputExtension = new PlanExporterInputExtension((IPlanAgentControllerExtension)planAgentControllerExtension);
            PlanDisplayParameters planDisplayParameters = new PlanDisplayParameters();
            planAgentManager.launchPlanAgent(plan, planDisplayParameters, planAgentTypeID, planAgentControllerExtension, (FactoryInput)factoryInput, (PlanAgentInputExtension)planAgentInputExtension, planAgentManager, pDisplay);
            launched = true;
        }
        catch (PlanAgentManager.EXPlanAgentLaunchException e) {
            logger.error("addPlan() - Unable to launch plan agent export controller extension", (Throwable)e);
        }
        catch (EXWriteAccessDeniedException e) {
            logger.error("addPlan() - Write access denied: unable to launch plan export controller extension", (Throwable)e);
        }
        return launched;
    }

    private static interface IPrinterFactory {
        public IPrinter createPrinter(Dimension var1);
    }
}

