/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planviewers;

import com.arcway.cockpit.frame.client.project.modules.IUniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElementsHighlighter;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IPlanViewerExtension;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PlanViewerManager {
    private PlanAgentManager planAgentManager;

    public void construct(PlanAgentManager newPlanAgentManager) {
        this.planAgentManager = newPlanAgentManager;
    }

    public PlanAgentManager getPlanAgentManager() {
        return this.planAgentManager;
    }

    public static void highlightElements(IPlanAgentProjectAgent projectAgent, String planUID, IPlanViewerExtension planViewerExtension, ICockpitProjectData elementToHighlight) {
        List<Object> requests;
        if (elementToHighlight != null && elementToHighlight.getProjectUID().equals(projectAgent.getProjectUID())) {
            Collection<IUniqueElementHighlightRequest> uniqueElementHightlights = PlanElementsHighlighter.createUniqueElementHighlightRequests(elementToHighlight);
            requests = PlanElementsHighlighter.getUniqueElementHighlightRequests(projectAgent, uniqueElementHightlights, planUID);
        } else {
            requests = Collections.emptyList();
        }
        planViewerExtension.highlightPlanElements(HighlightLevel.SELECTION, requests);
    }
}

