/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementChildHighlightRequest;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementParentHighlightRequest;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightHint;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.repository.cockpit.interFace.declaration.frame.infolink.CRTIDsInfoLink;
import com.arcway.repository.cockpit.interFace.declaration.frame.modules.COTIDsModuleData;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class PlanElementsHighlighter
implements IWindowListener,
ISelectionListener,
IProjectCloseListener,
IRefreshableDisplay,
IPropertyChangesListener {
    private static final ILogger logger = Logger.getLogger(PlanElementsHighlighter.class);
    private final IFrameProjectAgent projectAgent;
    private final DeferredRefresher refresher;
    private IStructuredSelection lastSelection;
    private IWorkbenchPart selectionPart;

    public PlanElementsHighlighter(IFrameProjectAgent projectAgent) {
        IWorkbenchWindow[] windows;
        this.projectAgent = projectAgent;
        projectAgent.addProjectCloseListener(this);
        projectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, EOLink.class);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            CockpitSelectionManager.getSelectionService(window.getSelectionService()).addSelectionListener(this);
            ++n2;
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        this.refresher = new DeferredRefresher((IRefreshableDisplay)this);
        this.refresher.start();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection newSelection;
            this.lastSelection = newSelection = (IStructuredSelection)selection;
            this.selectionPart = part;
            this.refresher.scheduleDeferredRefresh();
        }
    }

    public void refresh() {
        boolean relevantItemSelected = false;
        if (this.projectAgent.isOpened()) {
            IStructuredSelection sel = this.lastSelection;
            ArrayList<IUniqueElementHighlightRequest> uniqueHighlightRequests = new ArrayList<IUniqueElementHighlightRequest>();
            for (Object obj : sel) {
                if (obj instanceof IPlan) {
                    IPlan plan = (IPlan)obj;
                    IWorkbenchWindow window = this.selectionPart.getSite().getWorkbenchWindow();
                    relevantItemSelected |= this.projectAgent.getPlanEditorManager().hasTimeStampsChangedInPlanEditors(window, plan);
                    continue;
                }
                if (obj instanceof IUniqueElement) {
                    relevantItemSelected = true;
                    IUniqueElement uE = (IUniqueElement)obj;
                    if (!uE.getProjectUID().equals(this.projectAgent.getProjectUID())) continue;
                    UniqueElementHighlightRequest request = new UniqueElementHighlightRequest(uE.getUID());
                    uniqueHighlightRequests.add(request);
                    continue;
                }
                if (!(obj instanceof ICockpitProjectData)) continue;
                relevantItemSelected = true;
                ICockpitProjectData data = (ICockpitProjectData)obj;
                if (!this.projectAgent.getProjectUID().equals(data.getProjectUID())) continue;
                uniqueHighlightRequests.addAll(PlanElementsHighlighter.getUniqueElementHighlightRequestsForModuleData(this.projectAgent, data));
            }
            if (relevantItemSelected) {
                this.projectAgent.highlightElements(this.selectionPart.getSite().getWorkbenchWindow(), uniqueHighlightRequests);
            }
        }
    }

    public static Collection<IUniqueElementHighlightRequest> createUniqueElementHighlightRequests(ICockpitProjectData cockpitProjectData) {
        ArrayList<IUniqueElementHighlightRequest> uniqueHighlightRequests = new ArrayList<IUniqueElementHighlightRequest>();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(cockpitProjectData.getProjectUID());
        if (projectAgent != null && !(cockpitProjectData instanceof IPlan)) {
            if (cockpitProjectData instanceof IUniqueElement) {
                IUniqueElement uE = (IUniqueElement)cockpitProjectData;
                UniqueElementHighlightRequest request = new UniqueElementHighlightRequest(uE.getUID());
                uniqueHighlightRequests.add(request);
            } else {
                uniqueHighlightRequests.addAll(PlanElementsHighlighter.getUniqueElementHighlightRequestsForModuleData(projectAgent, cockpitProjectData));
            }
        }
        return uniqueHighlightRequests;
    }

    private static Collection<IUniqueElementHighlightRequest> getUniqueElementHighlightRequestsForModuleData(final IFrameProjectAgent projectAgent, final ICockpitProjectData moduleData) {
        final ArrayList<IUniqueElementHighlightRequest> allUniqueElementHighlightRequests = new ArrayList<IUniqueElementHighlightRequest>();
        if (projectAgent != null) {
            IRepositoryInterfaceRO repositoryInterface = projectAgent.getRepositoryInterface();
            final IRepositoryPropertySetSample repositoryObjectID = projectAgent.getRepositoryObjectID(moduleData.getUID());
            try {
                RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                    public void doWithCurrentSnapshot(IRepositorySnapshotRO snapshot) throws EXNotReproducibleSnapshot {
                        try {
                            RepositoryObjectReference objectReference = new RepositoryObjectReference((IRepositoryObjectTypeID)COTIDsModuleData.OBJECT_TYPE_ID, repositoryObjectID);
                            RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectReference, (IRepositorySnapshotRO)snapshot);
                        }
                        catch (EXObjectReferenceCannotBeResolved eORCNBR) {
                            return;
                        }
                        IRepositoryIterator_ICrossLinkRepositoryRelation relations = null;
                        try {
                            ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)CRTIDsInfoLink.RELATION_TYPE_ID, (IRepositoryRelationContributionRoleID)CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODULEDATA, (IRepositoryPropertySetSample)repositoryObjectID);
                            relations = RepositoryReferences.getAllRelationsFromReference((ICrossLinkRepositoryRelationsReference)relationsReference, (IRepositorySnapshotRO)snapshot);
                            while (relations.hasNext()) {
                                ICrossLinkRepositoryRelation relation = relations.nextIRepositoryRelation();
                                ICrossLinkRepositoryRelationContributionType relationContributionType = relation.getRelationType().getRelationContributionType((IRepositoryRelationContributionRoleID)CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODELELEMENT);
                                ICrossLinkRepositoryRelationContribution relationContribution = relation.getRelationContribution(relationContributionType);
                                IRepositoryObject modelElement = relationContribution.getAttributeSet().getObject();
                                String modelElementUID = projectAgent.getRepositoryPlattformController().getCockpitDataUID(modelElement.sample().getPropertySetSample());
                                UniqueElementHighlightRequest hr = new UniqueElementHighlightRequest(modelElementUID);
                                allUniqueElementHighlightRequests.add(hr);
                            }
                        }
                        catch (EXMissingCrossLinkTarget ex) {
                            logger.warn("Module data item (" + moduleData.getTypeID() + " / " + moduleData.getUID() + ") not found.", (Throwable)ex);
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return allUniqueElementHighlightRequests;
    }

    @Override
    public void closeProject(IFrameProjectAgent p_projectAgent) {
        IWorkbenchWindow[] windows;
        assert (p_projectAgent == this.projectAgent);
        this.refresher.halt();
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        this.projectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            CockpitSelectionManager.getSelectionService(window.getSelectionService()).removeSelectionListener(this);
            ++n2;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        CockpitSelectionManager.getSelectionService(window.getSelectionService()).removeSelectionListener(this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        CockpitSelectionManager.getSelectionService(window.getSelectionService()).addSelectionListener(this);
    }

    public boolean isDisposed() {
        return false;
    }

    public Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        for (Object o : changes.getCreatedElements()) {
            if (!(o instanceof EOLink) || !this.isInLastSelection((EOLink)o)) continue;
            this.refresher.scheduleDeferredRefresh();
            return;
        }
        for (Object o : changes.getDeletedElements()) {
            if (!(o instanceof EOLink) || !this.isInLastSelection((EOLink)o)) continue;
            this.refresher.scheduleDeferredRefresh();
            return;
        }
    }

    private boolean isInLastSelection(EOLink link) {
        if (this.lastSelection != null) {
            for (Object o : this.lastSelection) {
                ICockpitProjectData cpd;
                if (!(o instanceof ICockpitProjectData) || !(cpd = (ICockpitProjectData)o).getUID().equals(link.getLinkableObjectUID()) && !cpd.getUID().equals(link.getModuleDataUID())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<IHighlightRequest> getUniqueElementHighlightRequests(IPlanAgentProjectAgent projectAgent, Collection<? extends IUniqueElementHighlightRequest> uniqueElementHiglightRequests, String planUID) {
        ArrayList<IHighlightRequest> requests = new ArrayList<IHighlightRequest>();
        for (IUniqueElementHighlightRequest iUniqueElementHighlightRequest : uniqueElementHiglightRequests) {
            requests.addAll(PlanElementsHighlighter.getUniqueElementHighlightRequest(projectAgent, iUniqueElementHighlightRequest, planUID));
        }
        return requests;
    }

    private static Collection<UEOccurrenceHighLightRequest> getUniqueElementHighlightRequest(IPlanAgentProjectAgent projectAgent, IUniqueElementHighlightRequest request, String planUID) {
        ArrayList<UEOccurrenceHighLightRequest> requests;
        Collection<? extends IUniqueElementOccurrence> occurrences = projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrencesOnPlan(request.getUniqueElementUID(), planUID);
        if (!occurrences.isEmpty()) {
            requests = new ArrayList<UEOccurrenceHighLightRequest>(occurrences.size());
            for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
                requests.add(new UEOccurrenceHighLightRequest(request, iUniqueElementOccurrence));
            }
        } else {
            occurrences = PlanElementsHighlighter.getParentOccurencesOnPlan(projectAgent, request.getUniqueElementUID(), planUID, new HashSet<IUniqueElement>());
            if (!occurrences.isEmpty()) {
                requests = new ArrayList(occurrences.size());
                for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
                    UniqueElementParentHighlightRequest parentRequest = new UniqueElementParentHighlightRequest(iUniqueElementOccurrence.getElementUID());
                    requests.add(new UEOccurrenceHighLightRequest(parentRequest, iUniqueElementOccurrence));
                }
            } else {
                occurrences = PlanElementsHighlighter.getChildOccurencesOnPlan(projectAgent, request.getUniqueElementUID(), planUID, new HashSet<IUniqueElement>());
                requests = new ArrayList(occurrences.size());
                for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
                    UniqueElementChildHighlightRequest childRequest = new UniqueElementChildHighlightRequest(iUniqueElementOccurrence.getElementUID());
                    requests.add(new UEOccurrenceHighLightRequest(childRequest, iUniqueElementOccurrence));
                }
            }
        }
        return requests;
    }

    private static Collection<IUniqueElementOccurrence> getParentOccurencesOnPlan(IPlanAgentProjectAgent projectAgent, String uniqueElementUID, String planUID, Set<IUniqueElement> checkedParents) {
        ArrayList<IUniqueElementOccurrence> allOccurences = new ArrayList<IUniqueElementOccurrence>();
        Collection<IUniqueElement> parents = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider().getPreviousUniqueElements(uniqueElementUID);
        for (IUniqueElement parent : parents) {
            boolean parentWasNotAlreadyContained = checkedParents.add(parent);
            if (!parentWasNotAlreadyContained) continue;
            Collection<? extends IUniqueElementOccurrence> occurences = projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrencesOnPlan(parent.getUID(), planUID);
            if (!occurences.isEmpty()) {
                allOccurences.addAll(occurences);
                continue;
            }
            allOccurences.addAll(PlanElementsHighlighter.getParentOccurencesOnPlan(projectAgent, parent.getUID(), planUID, checkedParents));
        }
        return allOccurences;
    }

    private static Collection<IUniqueElementOccurrence> getChildOccurencesOnPlan(IPlanAgentProjectAgent projectAgent, String uniqueElementUID, String planUID, Set<IUniqueElement> checkedChildren) {
        ArrayList<IUniqueElementOccurrence> allOccurences = new ArrayList<IUniqueElementOccurrence>();
        Collection<IUniqueElement> children = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider().getNextUniqueElements(uniqueElementUID);
        for (IUniqueElement child : children) {
            boolean childWasNotAlreadyContained = checkedChildren.add(child);
            if (!childWasNotAlreadyContained) continue;
            Collection<? extends IUniqueElementOccurrence> occurences = projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrencesOnPlan(child.getUID(), planUID);
            if (!occurences.isEmpty()) {
                allOccurences.addAll(occurences);
                continue;
            }
            allOccurences.addAll(PlanElementsHighlighter.getChildOccurencesOnPlan(projectAgent, child.getUID(), planUID, checkedChildren));
        }
        return allOccurences;
    }

    private static class UEOccurrenceHighLightRequest
    implements IHighlightRequest,
    IHighlightHint {
        private final String planElementUID;
        private final Color fillColor;
        private final double fillOpacity;
        private final Color lineColor;
        private final double colorWeight;
        private final Color coronaColor;
        private final double coronaWidth;
        private final boolean showGuidelines;

        public UEOccurrenceHighLightRequest(IUniqueElementHighlightRequest request, IUniqueElementOccurrence occurence) {
            Color highlightColor = new Color(request.getRed(), request.getGreen(), request.getBlue());
            this.planElementUID = occurence.getPlanElementUID();
            this.fillColor = highlightColor.gotoWhite(0.7);
            this.fillOpacity = 1.0;
            this.lineColor = null;
            this.colorWeight = 1.0;
            this.coronaColor = highlightColor;
            this.coronaWidth = 0.5;
            this.showGuidelines = false;
        }

        public String getPlanElementUID() {
            return this.planElementUID;
        }

        public IHighlightHint getHighlightHint() {
            return this;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public double getFillOpacity() {
            return this.fillOpacity;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public double getColorWeight() {
            return this.colorWeight;
        }

        public Color getCoronaColor() {
            return this.coronaColor;
        }

        public double getCoronaWidth() {
            return this.coronaWidth;
        }

        public boolean showGuidelines() {
            return this.showGuidelines;
        }
    }
}

