/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planeditors;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.InvalidPlanElementAction;
import com.arcway.cockpit.frame.client.global.gui.dialogs.PlanChooserDialog;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.selection.PlanTimestampManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.editors.InvalidPlanElement;
import com.arcway.cockpit.frame.client.project.editors.UniqueElementOccurrenceListTransfer;
import com.arcway.cockpit.frame.client.project.modules.IUniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.modules.UniqueElementHighlightRequest;
import com.arcway.cockpit.frame.client.project.planagents.EXWriteAccessDeniedExceptionCausedByModificationProblems;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.IModulePlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorLauncher;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElementsHighlighter;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.client.project.planviewers.PlanViewerManager;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.transfer.MultipleObjectTransferAgent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FactoryInput;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInputExtension;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentExtensionTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeNotSupported;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.PlanAgentTimestamp;
import com.arcway.planagent.controllinginterface.planeditor.PlanEditorFactoryInput;
import com.arcway.planagent.controllinginterface.planeditor.PlanEditorInputExtension;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PlanEditorManager
extends PlanViewerManager
implements IModulePlanEditorManager {
    private static final ILogger logger = Logger.getLogger(PlanEditorManager.class);
    private final IPlanAgentProjectAgent projectAgent;

    public static IExternalPlanEditorControllerExtension findPlanEditorControllerExtensionInAllProjects(IEditorPart editorPart) {
        ProjectAgent[] projectAgents;
        ProjectAgent[] projectAgentArray = projectAgents = ProjectMgr.getProjectMgr().getOpenedProjects();
        int n = projectAgents.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAgent element = projectAgentArray[n2];
            IExternalPlanEditorControllerExtension ctrl = element.getPlanEditorControllerExtension(editorPart);
            if (ctrl != null) {
                return ctrl;
            }
            ++n2;
        }
        return null;
    }

    public PlanEditorManager(IPlanAgentProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        MultipleObjectTransferAgent.getInstance().getSupportedTypes();
        UniqueElementOccurrenceListTransfer.getInstance().getSupportedTypes();
    }

    public IPlanAgentProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public void highlightElementsOnPlanEditors(IWorkbenchWindow window, Collection<? extends IUniqueElementHighlightRequest> uniqueElementHightlights) {
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (planEditorControllerExtension.getWorkbenchPage().getWorkbenchWindow() != window) continue;
            ArrayList<IHighlightRequest> requests = new ArrayList<IHighlightRequest>();
            requests.addAll(PlanElementsHighlighter.getUniqueElementHighlightRequests(this.projectAgent, uniqueElementHightlights, planEditorControllerExtension.getPlanUID()));
            planEditorControllerExtension.highlightElements(HighlightLevel.SELECTION, requests);
            PlanAgentTimestamp currentTimestampInEditor = planEditorControllerExtension.getTimestamp();
            PlanTimestampManager.updateTimestamp(planEditorControllerExtension, currentTimestampInEditor);
        }
    }

    public boolean hasTimeStampsChangedInPlanEditors(IWorkbenchWindow window, IPlan plan) {
        boolean changed = false;
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (planEditorControllerExtension.getWorkbenchPage().getWorkbenchWindow() != window) continue;
            PlanAgentTimestamp currentTimestampInEditor = planEditorControllerExtension.getTimestamp();
            PlanAgentTimestamp lastTimestampInEditor = PlanTimestampManager.getTimestampForPlan(planEditorControllerExtension);
            changed |= currentTimestampInEditor == null || currentTimestampInEditor != lastTimestampInEditor;
        }
        return changed;
    }

    public void deleteSelectionOnPlansInProjectionMode(IPlan exception, IWorkbenchWindow window) {
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (planEditorControllerExtension.getWorkbenchPage().getWorkbenchWindow() != window || planEditorControllerExtension.getWorkingMode() != 3 || exception != null && planEditorControllerExtension.getPlan().getUID().equals(exception.getUID())) continue;
            planEditorControllerExtension.selectElements(Collections.emptyList());
        }
    }

    public void deleteSelectionOnPlansInProjectionMode(IWorkbenchWindow window) {
        this.deleteSelectionOnPlansInProjectionMode(null, window);
    }

    public void updatePlanElementTooltip(String planUID, String planElementUID, String planElementName, String planElementDescription) {
        assert (planUID != null);
        assert (planElementUID != null);
        for (PlanEditorControllerExtension controllerExtension : this.getPlanEditorControllerExtensions(planUID)) {
            controllerExtension.updateToolTip(planElementUID, planElementName, planElementDescription);
        }
    }

    public void updateDecorators() {
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            planEditorControllerExtension.updateDecorators();
        }
    }

    public void updateInvalidPlanElements() {
        for (IPlan plan : this.getOpenPlans()) {
            IPlanAgentUniqueElementManager uniqueElementManager = this.projectAgent.getPlanAgentUniqueElementManager();
            ArrayList<InvalidPlanElement> invalidPlanElements = new ArrayList<InvalidPlanElement>();
            for (IUniqueElement uniqueElement : uniqueElementManager.getUniqueElementsOfPlan(plan)) {
                IUniqueElementRelationshipProvider relationshipProvider = this.projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
                boolean isPartOfCycle = relationshipProvider.isPartOfCycle(uniqueElement.getUID());
                if (!isPartOfCycle) continue;
                Collection<? extends IUniqueElementOccurrence> occurrences = uniqueElementManager.getUniqueElementOccurrencesOnPlan(uniqueElement.getUID(), plan.getUID());
                for (IUniqueElementOccurrence iUniqueElementOccurrence : occurrences) {
                    invalidPlanElements.add(new InvalidPlanElement(plan.getUID(), iUniqueElementOccurrence.getPlanElementUID(), (IAction)new InvalidPlanElementAction(this.projectAgent.getProjectUID(), uniqueElement.getUID())));
                }
            }
            for (PlanEditorControllerExtension e : this.getPlanEditorControllerExtensions(plan)) {
                e.setInvalidPlanElements(invalidPlanElements);
            }
        }
    }

    public String checkPlanAgentAvailability(String planTypeID) {
        try {
            this.getPlanAgentManager().checkPlanAgentAvailability("com.arcway.planagent.planeditor", planTypeID);
        }
        catch (EXPlanAgentTypeUnknown e) {
            return Messages.getString("PlanEditorManager.unknowntype");
        }
        catch (EXPlanAgentExtensionTypeUnknown e) {
            return Messages.getString("PlanEditorManager.unknowntype");
        }
        catch (EXPlanTypeNotSupported e) {
            return Messages.getString("PlanEditorManager.unsupported");
        }
        catch (EXPlanTypeUnknown e) {
            return Messages.getString("PlanEditorManager.unsupported");
        }
        return null;
    }

    public Collection<PlanEditorControllerExtension> getPlanEditorControllerExtensions(IPlan plan) {
        return this.getPlanEditorControllerExtensions(plan.getUID());
    }

    public Collection<PlanEditorControllerExtension> getPlanEditorControllerExtensions(String planUID) {
        ArrayList<PlanEditorControllerExtension> result = new ArrayList<PlanEditorControllerExtension>();
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (!planEditorControllerExtension.getPlanUID().equals(planUID)) continue;
            result.add(planEditorControllerExtension);
        }
        return result;
    }

    public IExternalPlanEditorControllerExtension getPlanEditorControllerExtension(IWorkbenchPart part) {
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (planEditorControllerExtension.getEditorPart() != part) continue;
            return planEditorControllerExtension;
        }
        return null;
    }

    public Collection<IExternalPlanEditorControllerExtension> getPlanEditorControllerExtensions(IPlan plan, IWorkbenchPage page, PlanDisplayParameters planDisplayParameters) {
        ArrayList<IExternalPlanEditorControllerExtension> extensions = new ArrayList<IExternalPlanEditorControllerExtension>();
        for (IExternalPlanEditorControllerExtension iExternalPlanEditorControllerExtension : this.getPlanEditorControllerExtensions(plan)) {
            if (iExternalPlanEditorControllerExtension.getWorkbenchPage() != page) continue;
            boolean found = false;
            if (iExternalPlanEditorControllerExtension.getVersion() == null && !plan.isHistoricItem()) {
                found = true;
            } else if (iExternalPlanEditorControllerExtension.getVersion() != null && plan.isHistoricItem()) {
                found = iExternalPlanEditorControllerExtension.getVersion().equals(plan.getModificationCount());
            }
            if (found) {
                found = planDisplayParameters.isEqual(iExternalPlanEditorControllerExtension.getPlanDisplayParameters());
            }
            if (!found) continue;
            extensions.add(iExternalPlanEditorControllerExtension);
        }
        return extensions;
    }

    public Collection<IExternalPlanEditorControllerExtension> getPlanEditorControllerExtensionsInEditMode(IPlan plan, IWorkbenchPage page, PlanDisplayParameters planDisplayParameters) {
        Collection<IExternalPlanEditorControllerExtension> openPlanEditors = this.getPlanEditorControllerExtensions(plan, page, planDisplayParameters);
        ArrayList<IExternalPlanEditorControllerExtension> openPlanEditorsInEditmode = new ArrayList<IExternalPlanEditorControllerExtension>(openPlanEditors.size());
        for (IExternalPlanEditorControllerExtension openPlanEditor : openPlanEditors) {
            if (openPlanEditor.getWorkingMode() != 1) continue;
            openPlanEditorsInEditmode.add(openPlanEditor);
        }
        return openPlanEditorsInEditmode;
    }

    public Set<String> getOpenPlansUIDs() {
        HashSet<String> result = new HashSet<String>();
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            result.add(planEditorControllerExtension.getPlanUID());
        }
        return result;
    }

    public Collection<IPlan> getOpenPlans() {
        ArrayList<IPlan> openedPlans = new ArrayList<IPlan>();
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            openedPlans.add(planEditorControllerExtension.getPlan());
        }
        return openedPlans;
    }

    public static IExternalPlanEditorControllerExtension getToppedPlanEditorControllerExtension(IWorkbenchPage page) {
        IEditorPart part = page.getActiveEditor();
        if (part != null) {
            return PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(part);
        }
        return null;
    }

    private Collection<? extends PlanEditorControllerExtension> getAllPlanEditorControllerExtensions() {
        return this.getPlanAgentManager().getAllPlanAgentControllerExtensionsByLauncherKey(this);
    }

    public void openSinglePlanEditorInEditmode(IWorkbenchPage page, IPlan plan, boolean switchModeIfOpen) {
        PlanEditorLauncher launcher = new PlanEditorLauncher(1, switchModeIfOpen);
        launcher.openOrShowPlanEditor(page, this, plan);
    }

    public void openSinglePlanEditorAndHighlightUniqueElement(IWorkbenchPage page, IPlan plan, IUniqueElement uniqueElement) {
        this.openSinglePlanEditorInProjectorMode(page, plan, false);
        UniqueElementHighlightRequest request = new UniqueElementHighlightRequest(uniqueElement.getUID());
        this.projectAgent.highlightElements(page.getWorkbenchWindow(), Collections.singletonList(request));
    }

    public void openSinglePlanEditorInProjectorMode(IWorkbenchPage page, IPlan plan, boolean switchModeIfOpen) {
        PlanEditorLauncher launcher = new PlanEditorLauncher(3, switchModeIfOpen);
        launcher.openOrShowPlanEditor(page, this, plan);
    }

    public void openSinglePlanEditorForOldPlanVersion(IWorkbenchPage page, IPlan plan) {
        PlanEditorLauncher launcher = new PlanEditorLauncher();
        launcher.openOrShowPlanEditor(page, this, plan);
    }

    public void openSinglePlanEditorWithPlanDisplayParameters(IWorkbenchPage page, IPlan plan, PlanDisplayParameters planDisplayParameters) {
        PlanEditorLauncher launcher = new PlanEditorLauncher(planDisplayParameters);
        launcher.openOrShowPlanEditor(page, this, plan);
    }

    List<IModificationProblem> launchPlan(IWorkbenchPage page, IPlan planToOpen, int mode, boolean switchModeIfOpen, PlanDisplayParameters planDisplayParameters) {
        ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
        if (this.projectAgent.getPlanAgentSectionManager().getPlan(planToOpen.getUID()) == null) {
            logger.warn("Tried to open a plan editor for a plan, which does not exist in the section manager: " + planToOpen.getPlanName() + " (Mod Count: " + planToOpen.getModificationCount() + ")");
            modificationProblems.add(new ModificationProblem(Messages.getString("PlanEditorManager.UnknownPlanInProject"), Messages.getString("PlanEditorManager.CannotOpenPlan.Message")));
        } else {
            Collection<IExternalPlanEditorControllerExtension> openEditors = this.getPlanEditorControllerExtensions(planToOpen, page, planDisplayParameters);
            if (openEditors.isEmpty()) {
                try {
                    this.openEditorPart(page, planToOpen, mode, planDisplayParameters);
                }
                catch (EXWriteAccessDeniedExceptionCausedByModificationProblems e) {
                    modificationProblems.addAll(e.getModificationProblems());
                }
                catch (Exception e) {
                    modificationProblems.add(new ModificationProblem(e, NLS.bind((String)Messages.getString("PlanEditorManager.CannotOpenPlan.Exception"), (Object)planToOpen.getPlanName())));
                }
            } else {
                Collection<IExternalPlanEditorControllerExtension> editorsInEditMode = this.getPlanEditorControllerExtensionsInEditMode(planToOpen, page, planDisplayParameters);
                HashSet<IExternalPlanEditorControllerExtension> editorsInViewMode = new HashSet<IExternalPlanEditorControllerExtension>(openEditors);
                editorsInViewMode.removeAll(editorsInEditMode);
                IExternalPlanEditorControllerExtension editorToTopLast = mode != 1 && !editorsInViewMode.isEmpty() ? (IExternalPlanEditorControllerExtension)editorsInViewMode.iterator().next() : (mode == 1 && !editorsInEditMode.isEmpty() ? editorsInEditMode.iterator().next() : openEditors.iterator().next());
                HashSet<IExternalPlanEditorControllerExtension> editorsToTopFirst = new HashSet<IExternalPlanEditorControllerExtension>(openEditors);
                editorsToTopFirst.remove(editorToTopLast);
                for (IExternalPlanEditorControllerExtension editorToTop : editorsToTopFirst) {
                    if (switchModeIfOpen && editorToTop.getWorkingMode() != mode && mode != 1) {
                        modificationProblems.addAll(this.setWorkingMode_internal(editorToTop, mode));
                    }
                    editorToTop.updatePlanDisplayParameters(planDisplayParameters);
                    page.bringToTop((IWorkbenchPart)editorToTop.getEditorPart());
                }
                if (switchModeIfOpen && editorToTopLast.getWorkingMode() != mode) {
                    modificationProblems.addAll(this.setWorkingMode_internal(editorToTopLast, mode));
                }
                editorToTopLast.updatePlanDisplayParameters(planDisplayParameters);
                page.bringToTop((IWorkbenchPart)editorToTopLast.getEditorPart());
                page.activate((IWorkbenchPart)editorToTopLast.getEditorPart());
            }
        }
        return modificationProblems;
    }

    public void setWorkingMode(IExternalPlanEditorControllerExtension controllerExtension, int mode) {
        List<IModificationProblem> modificationProblems = this.setWorkingMode_internal(controllerExtension, mode);
        PlanEditorManager.showSwitchModeProblems(controllerExtension.getWorkbenchPage(), modificationProblems);
    }

    private static void showSwitchModeProblems(IWorkbenchPage page, List<IModificationProblem> modificationProblems) {
        if (!modificationProblems.isEmpty()) {
            String title = Messages.getString("PlanEditorManager.CannotSwitchPlan.Title");
            String message = Messages.getString("PlanEditorManager.CannotSwitchPlan.Message");
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(modificationProblems, title, message, page.getWorkbenchWindow().getShell());
            mpDialog.open();
        }
    }

    private List<IModificationProblem> setWorkingMode_internal(IExternalPlanEditorControllerExtension editor, int mode) {
        ArrayList<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
        try {
            editor.setWorkingMode(mode);
        }
        catch (EXWriteAccessDeniedExceptionCausedByModificationProblems e) {
            modificationProblems.addAll(e.getModificationProblems());
        }
        catch (EXWriteAccessDeniedException e) {
            IPlan plan = editor.getPlan();
            modificationProblems.add(new ModificationProblem((Exception)((Object)e), NLS.bind((String)Messages.getString("PlanEditorManager.CannotSwitchPlan.Exception"), (Object)plan.getPlanName())));
        }
        return modificationProblems;
    }

    private void openEditorPart(final IWorkbenchPage page, final IPlan plan, final int mode, final PlanDisplayParameters planDisplayParameters) throws Exception {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(page.getWorkbenchWindow().getShell());
        IRunnableWithProgress rwp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    int initMode;
                    PlanEditorManager manager = PlanEditorManager.this;
                    JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                    Image image = new ProjectTreeContentProvider(null).getImage(plan);
                    ImageDescriptor imgDescriptor = ImageDescriptor.createFromImage((Image)image);
                    PlanEditorFactoryInput factoryInput = new PlanEditorFactoryInput(page, imgDescriptor);
                    PlanEditorControllerExtension planEditorControllerExtension = new PlanEditorControllerExtension(manager);
                    if (mode == 1) {
                        initMode = 2;
                    } else if (mode == 3) {
                        initMode = 3;
                    } else {
                        logger.error("unkown working mode " + mode);
                        initMode = 3;
                    }
                    PlanEditorInputExtension planEditorInputExtension = new PlanEditorInputExtension((IPlanEditorControllerExtension)planEditorControllerExtension, initMode);
                    PlanEditorManager.this.getPlanAgentManager().launchPlanAgent(plan, planDisplayParameters, "com.arcway.planagent.planeditor", planEditorControllerExtension, (FactoryInput)factoryInput, (PlanAgentInputExtension)planEditorInputExtension, manager, (IProgressDisplay)pDisplay);
                }
                catch (PlanAgentManager.EXPlanAgentLaunchException e) {
                    throw new InvocationTargetException(e);
                }
                catch (EXWriteAccessDeniedException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        pmd.setOpenOnRun(true);
        try {
            pmd.run(false, false, rwp);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof EXPlanTypeUnknown) {
                EXPlanTypeUnknown typedTargetException = (EXPlanTypeUnknown)targetException;
                throw typedTargetException;
            }
            if (targetException instanceof PlanAgentManager.EXPlanAgentLaunchException) {
                PlanAgentManager.EXPlanAgentLaunchException typedTargetException = (PlanAgentManager.EXPlanAgentLaunchException)targetException;
                throw typedTargetException;
            }
            if (targetException instanceof EXWriteAccessDeniedException) {
                EXWriteAccessDeniedException typedTargetException = (EXWriteAccessDeniedException)targetException;
                throw typedTargetException;
            }
            throw new Exception(targetException);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setAllEditorsToProjectorMode() {
        for (IExternalPlanEditorControllerExtension iExternalPlanEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            try {
                iExternalPlanEditorControllerExtension.setWorkingMode(3);
            }
            catch (EXWriteAccessDeniedException e) {
                logger.error("Write access denied when switching to projector mode. Could not happen!", (Throwable)e);
            }
        }
    }

    public Collection<IEditorPart> getAllEditorParts() {
        ArrayList<IEditorPart> allEditors = new ArrayList<IEditorPart>();
        for (IExternalPlanEditorControllerExtension iExternalPlanEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            allEditors.add(iExternalPlanEditorControllerExtension.getEditorPart());
        }
        return allEditors;
    }

    public Collection<IEditorPart> getAllDirtyEditorParts() {
        ArrayList<IEditorPart> dirtyEditors = new ArrayList<IEditorPart>();
        for (IExternalPlanEditorControllerExtension iExternalPlanEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (!iExternalPlanEditorControllerExtension.isDirty()) continue;
            dirtyEditors.add(iExternalPlanEditorControllerExtension.getEditorPart());
        }
        return dirtyEditors;
    }

    public Set<IPlan> getAllDirtyPlans() {
        HashSet<IPlan> result = new HashSet<IPlan>();
        for (PlanEditorControllerExtension planEditorControllerExtension : this.getAllPlanEditorControllerExtensions()) {
            if (!planEditorControllerExtension.isDirty()) continue;
            result.add(planEditorControllerExtension.getPlan());
        }
        return result;
    }

    public static IProjectionReceiver getToppedProjectionReceiverOfAllProjects(IWorkbenchPage page) {
        IExternalPlanEditorControllerExtension ctrl = PlanEditorManager.getToppedPlanEditorControllerExtension(page);
        if (ctrl == null || ctrl.getWorkingMode() != 3) {
            ctrl = null;
        }
        return ctrl;
    }

    @Override
    @Deprecated
    public IProjectionReceiver getToppedProjectionReceiver(IWorkbenchPage page) {
        IExternalPlanEditorControllerExtension ctrl = PlanEditorManager.getToppedPlanEditorControllerExtension(page);
        if (ctrl != null && ctrl.getProjectAgent().getProjectUID().equals(this.getProjectAgent().getProjectUID())) {
            return ctrl;
        }
        return null;
    }

    @Override
    public Collection<IProjectionReceiver> getToppedProjectionReceivers() {
        IWorkbenchWindow[] windows;
        ArrayList<IProjectionReceiver> l = new ArrayList<IProjectionReceiver>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow element = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = element.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IExternalPlanEditorControllerExtension ctrl;
                IWorkbenchPage element2 = iWorkbenchPageArray[n4];
                IEditorPart part = element2.getActiveEditor();
                if (part != null && (ctrl = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(part)) != null && ctrl.getProjectAgent().getProjectUID().equals(this.getProjectAgent().getProjectUID())) {
                    l.add(PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(part));
                }
                ++n4;
            }
            ++n2;
        }
        return l;
    }

    public void choosePlanToOpen(Collection<? extends IPlan> planSet, Collection<? extends IPlan> refiningPlans, IUniqueElement uniqueElementToHighlight, IWorkbenchPage page, String message) {
        ArrayList<? extends IPlan> plans = new ArrayList<IPlan>(planSet);
        IPlan planToOpen = null;
        if (plans.size() == 1) {
            planToOpen = (IPlan)plans.iterator().next();
        } else {
            PlanChooserDialog dialog = new PlanChooserDialog(plans, refiningPlans, message, this.getProjectAgent(), page.getWorkbenchWindow().getShell());
            dialog.setBlockOnOpen(true);
            int answer = dialog.open();
            if (answer == 0) {
                planToOpen = dialog.getSelectedPlan();
            }
        }
        if (planToOpen != null) {
            this.getProjectAgent().getPlanEditorManager().openSinglePlanEditorAndHighlightUniqueElement(page, planToOpen, uniqueElementToHighlight);
        }
    }
}

