/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planagents;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.global.gui.actions.OpenPlanWithPlanDisplayParametersAction;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.planagents.DTPlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planagents.DTPlanElementsCreationRequest;
import com.arcway.cockpit.frame.client.project.planagents.IInternalAbstractPlanAgentController;
import com.arcway.cockpit.frame.client.project.planagents.PlanElementsCreationRequest;
import com.arcway.lib.codec.Base64;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLDecodingFailed;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.java.Equals;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.planagent.controllinginterface.planagent.HighlightLevel;
import com.arcway.planagent.controllinginterface.planviewer.IHighlightRequest;
import com.arcway.planagent.controllinginterface.planviewer.IPlanDataProvider;
import com.arcway.planagent.controllinginterface.planviewer.IPlanViewerExtension;
import com.arcway.planagent.controllinginterface.planviewer.IProjectionRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PlanDisplayParameters {
    private final IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute;
    private final IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute;
    private final IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute;
    private final String individualVersionName;
    private Map<String, String> planElementUID2individualNameReplacement;
    private Map<String, String> planElementUID2individualDescriptionReplacement;
    private Map<String, String> planElementUID2individualCommentReplacement;
    private final Collection<String> planElementUIDsOfPlanElementsToDelete;
    private final PlanElementsCreationRequest planElementsCreationRequest;
    private Collection<? extends IHighlightRequest> highlightRequests;
    private List<? extends IProjectionRequest> projectionRequests;

    public static String encodeIntoString(PlanDisplayParameters planDisplayParameters) {
        String string;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLCoDecForData.encodeIntoOutputStream((OutputStream)byteArrayOutputStream, (Object)planDisplayParameters, (IDataType)DTPlanDisplayParameters.getInstance(), (String)"planDisplayParameters", null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION);
            byte[] xmlData = byteArrayOutputStream.toByteArray();
            byte[] base64Data = Base64.encodeBytes((byte[])xmlData, (boolean)false);
            string = new String(base64Data, Charset.defaultCharset());
        }
        catch (EXXMLEncodingFailed e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    public static PlanDisplayParameters decodeFromString(String encodedPlanDisplayParameters) throws EXDecoderException, EXXMLDecodingFailed {
        byte[] xmlData = Base64.decode((String)encodedPlanDisplayParameters);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlData);
        PlanDisplayParameters planDisplayParameters = (PlanDisplayParameters)XMLCoDecForData.decodeIntoObject((InputStream)byteArrayInputStream, (IDataType)DTPlanDisplayParameters.getInstance());
        return planDisplayParameters;
    }

    public PlanDisplayParameters(IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute, IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute, IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute, String individualVersionName, Map<String, String> planElementUID2individualNameReplacement, Map<String, String> planElementUID2individualDescriptionReplacement, Map<String, String> planElementUID2individualCommentReplacement, Collection<String> planElementUIDsOfPlanElementsToDelete, PlanElementsCreationRequest planElementsCreationRequest, Collection<? extends IHighlightRequest> highlightRequests, List<? extends IProjectionRequest> projectionRequests) {
        this.uniqueElementAttributeTypeIDofNameAttribute = uniqueElementAttributeTypeIDofNameAttribute;
        this.uniqueElementAttributeTypeIDofDescriptionAttribute = uniqueElementAttributeTypeIDofDescriptionAttribute;
        this.uniqueElementAttributeTypeIDofCommentAttribute = uniqueElementAttributeTypeIDofCommentAttribute;
        this.individualVersionName = individualVersionName;
        this.setPlanElementUID2individualNameReplacement(planElementUID2individualNameReplacement);
        this.setPlanElementUID2individualDescriptionReplacement(planElementUID2individualDescriptionReplacement);
        this.setPlanElementUID2individualCommentReplacement(planElementUID2individualCommentReplacement);
        this.planElementUIDsOfPlanElementsToDelete = planElementUIDsOfPlanElementsToDelete != null && !planElementUIDsOfPlanElementsToDelete.isEmpty() ? planElementUIDsOfPlanElementsToDelete : null;
        this.planElementsCreationRequest = planElementsCreationRequest;
        this.setHighlightAndProjectionRequests(highlightRequests, projectionRequests);
    }

    private void setHighlightAndProjectionRequests(Collection<? extends IHighlightRequest> highlightRequests, List<? extends IProjectionRequest> projectionRequests) {
        this.highlightRequests = highlightRequests != null ? highlightRequests : Collections.emptyList();
        this.projectionRequests = projectionRequests != null ? projectionRequests : Collections.emptyList();
    }

    public PlanDisplayParameters(IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute, IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute, IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute, String individualVersionName, Map<String, String> planElementUID2individualNameReplacement, Map<String, String> planElementUID2individualDescriptionReplacement, Map<String, String> planElementUID2individualCommentReplacement, Collection<String> planElementUIDsOfPlanElementsToDelete, PlanElementsCreationRequest planElementsCreationRequest) {
        this(uniqueElementAttributeTypeIDofNameAttribute, uniqueElementAttributeTypeIDofDescriptionAttribute, uniqueElementAttributeTypeIDofCommentAttribute, individualVersionName, planElementUID2individualNameReplacement, planElementUID2individualDescriptionReplacement, planElementUID2individualCommentReplacement, planElementUIDsOfPlanElementsToDelete, planElementsCreationRequest, null, null);
    }

    public PlanDisplayParameters() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public IAttributeTypeID getUniqueElementAttributeTypeIDofNameAttribute() {
        return this.uniqueElementAttributeTypeIDofNameAttribute;
    }

    public IAttributeTypeID getUniqueElementAttributeTypeIDofDescriptionAttribute() {
        return this.uniqueElementAttributeTypeIDofDescriptionAttribute;
    }

    public IAttributeTypeID getUniqueElementAttributeTypeIDofCommentAttribute() {
        return this.uniqueElementAttributeTypeIDofCommentAttribute;
    }

    public String getIndividualVersionName() {
        return this.individualVersionName;
    }

    public Map<String, String> getPlanElementUID2individualNameReplacement() {
        return this.planElementUID2individualNameReplacement;
    }

    public Map<String, String> getPlanElementUID2individualDescriptionReplacement() {
        return this.planElementUID2individualDescriptionReplacement;
    }

    public Map<String, String> getPlanElementUID2individualCommentReplacement() {
        return this.planElementUID2individualCommentReplacement;
    }

    public Collection<String> getPlanElementUIDsOfPlanElementsToDelete() {
        return this.planElementUIDsOfPlanElementsToDelete;
    }

    public PlanElementsCreationRequest getPlanElementsCreationRequest() {
        return this.planElementsCreationRequest;
    }

    public Collection<? extends IHighlightRequest> getHighlightRequests() {
        return this.highlightRequests;
    }

    public List<? extends IProjectionRequest> getProjectionRequests() {
        return this.projectionRequests;
    }

    private void setPlanElementUID2individualNameReplacement(Map<String, String> planElementUID2individualNameReplacement) {
        this.planElementUID2individualNameReplacement = planElementUID2individualNameReplacement == null || planElementUID2individualNameReplacement.isEmpty() ? null : new HashMap<String, String>(planElementUID2individualNameReplacement);
    }

    private void setPlanElementUID2individualDescriptionReplacement(Map<String, String> planElementUID2individualDescriptionReplacement) {
        this.planElementUID2individualDescriptionReplacement = planElementUID2individualDescriptionReplacement == null || planElementUID2individualDescriptionReplacement.isEmpty() ? null : new HashMap<String, String>(planElementUID2individualDescriptionReplacement);
    }

    private void setPlanElementUID2individualCommentReplacement(Map<String, String> planElementUID2individualCommentReplacement) {
        this.planElementUID2individualCommentReplacement = planElementUID2individualCommentReplacement == null || planElementUID2individualCommentReplacement.isEmpty() ? null : new HashMap<String, String>(planElementUID2individualCommentReplacement);
    }

    public String calculateLabelExtension(String projectUID) {
        IAttributeTypeID commentAttributeTypeID;
        String label;
        String translationLanguage;
        IAttributeTypeID nameAttributeTypeID = this.getUniqueElementAttributeTypeIDofNameAttribute();
        if (nameAttributeTypeID != null) {
            String languageLocalized;
            String nameLanguageLocalized;
            String nameAttributeLanguage = OpenPlanWithPlanDisplayParametersAction.getNameAttributeLanguage(projectUID, nameAttributeTypeID);
            if (nameAttributeLanguage != null) {
                Locale locale = new Locale(nameAttributeLanguage);
                nameLanguageLocalized = LocaleHelper.getDisplayLanguage((Locale)locale);
                if (nameLanguageLocalized != null && nameLanguageLocalized.trim().length() == 0) {
                    nameLanguageLocalized = null;
                }
            } else {
                nameLanguageLocalized = null;
            }
            if (nameLanguageLocalized != null) {
                languageLocalized = nameLanguageLocalized;
                translationLanguage = nameAttributeLanguage;
            } else {
                languageLocalized = null;
                translationLanguage = null;
            }
            label = languageLocalized != null ? String.valueOf(Messages.getString("PlanDisplayParameters.Translation")) + " " + languageLocalized : String.valueOf(OpenPlanWithPlanDisplayParametersAction.getAttributeName(projectUID, nameAttributeTypeID)) + " - " + Messages.getString("PlanDisplayParameters.NameReplacement");
        } else {
            translationLanguage = null;
            label = null;
        }
        IAttributeTypeID descriptionAttributeTypeID = this.getUniqueElementAttributeTypeIDofDescriptionAttribute();
        if (descriptionAttributeTypeID != null) {
            String descriptionAttributeLanguage = OpenPlanWithPlanDisplayParametersAction.getDescriptionAttributeLanguage(projectUID, descriptionAttributeTypeID);
            if (translationLanguage == null || !Equals.equals((Object)translationLanguage, (Object)descriptionAttributeLanguage)) {
                String label2 = String.valueOf(OpenPlanWithPlanDisplayParametersAction.getAttributeName(projectUID, descriptionAttributeTypeID)) + " - " + Messages.getString("PlanDisplayParameters.DescriptionReplacement");
                String string = label = label == null ? label2 : String.valueOf(label) + ", " + label2;
            }
        }
        if ((commentAttributeTypeID = this.getUniqueElementAttributeTypeIDofCommentAttribute()) != null) {
            String CommentAttributeLanguage = OpenPlanWithPlanDisplayParametersAction.getCommentAttributeLanguage(projectUID, descriptionAttributeTypeID);
            if (translationLanguage == null || !Equals.equals((Object)translationLanguage, (Object)CommentAttributeLanguage)) {
                String label2 = String.valueOf(OpenPlanWithPlanDisplayParametersAction.getAttributeName(projectUID, commentAttributeTypeID)) + " - " + Messages.getString("PlanDisplayParameters.CommentReplacement");
                String string = label = label == null ? label2 : String.valueOf(label) + ", " + label2;
            }
        }
        if (label != null && label.length() == 0) {
            label = null;
        }
        return label;
    }

    public boolean isCurrentVersion() {
        return this.uniqueElementAttributeTypeIDofNameAttribute == null && this.uniqueElementAttributeTypeIDofDescriptionAttribute == null && this.uniqueElementAttributeTypeIDofCommentAttribute == null && this.individualVersionName == null && this.planElementUID2individualNameReplacement == null && this.planElementUID2individualDescriptionReplacement == null && this.planElementUID2individualCommentReplacement == null && this.planElementUIDsOfPlanElementsToDelete == null && this.planElementsCreationRequest == null;
    }

    public boolean isEqual(PlanDisplayParameters parametersToCompare) {
        boolean isEqual = true;
        if (isEqual) {
            isEqual = parametersToCompare.getUniqueElementAttributeTypeIDofNameAttribute() == null && this.uniqueElementAttributeTypeIDofNameAttribute == null ? true : (parametersToCompare.getUniqueElementAttributeTypeIDofNameAttribute() != null && this.uniqueElementAttributeTypeIDofNameAttribute != null ? parametersToCompare.getUniqueElementAttributeTypeIDofNameAttribute().equals(this.uniqueElementAttributeTypeIDofNameAttribute) : false);
        }
        if (isEqual) {
            isEqual = parametersToCompare.getUniqueElementAttributeTypeIDofDescriptionAttribute() == null && this.uniqueElementAttributeTypeIDofDescriptionAttribute == null ? true : (parametersToCompare.getUniqueElementAttributeTypeIDofDescriptionAttribute() != null && this.uniqueElementAttributeTypeIDofDescriptionAttribute != null ? parametersToCompare.getUniqueElementAttributeTypeIDofDescriptionAttribute().equals(this.uniqueElementAttributeTypeIDofDescriptionAttribute) : false);
        }
        if (isEqual) {
            isEqual = parametersToCompare.getUniqueElementAttributeTypeIDofCommentAttribute() == null && this.uniqueElementAttributeTypeIDofCommentAttribute == null ? true : (parametersToCompare.getUniqueElementAttributeTypeIDofCommentAttribute() != null && this.uniqueElementAttributeTypeIDofCommentAttribute != null ? parametersToCompare.getUniqueElementAttributeTypeIDofCommentAttribute().equals(this.uniqueElementAttributeTypeIDofCommentAttribute) : false);
        }
        if (isEqual) {
            isEqual = parametersToCompare.getIndividualVersionName() == null && this.individualVersionName == null ? true : (parametersToCompare.getIndividualVersionName() != null && this.individualVersionName != null ? parametersToCompare.getIndividualVersionName().equals(this.individualVersionName) : false);
        }
        if (isEqual) {
            Map<String, String> ctrl_planElementUID2individualNameReplacement = parametersToCompare.getPlanElementUID2individualNameReplacement();
            isEqual = ctrl_planElementUID2individualNameReplacement == null && this.planElementUID2individualNameReplacement == null ? true : ctrl_planElementUID2individualNameReplacement != null && this.planElementUID2individualNameReplacement != null;
        }
        if (isEqual) {
            Map<String, String> ctrl_planElementUID2individualDescriptionReplacement = parametersToCompare.getPlanElementUID2individualDescriptionReplacement();
            isEqual = ctrl_planElementUID2individualDescriptionReplacement == null && this.planElementUID2individualDescriptionReplacement == null ? true : ctrl_planElementUID2individualDescriptionReplacement != null && this.planElementUID2individualDescriptionReplacement != null;
        }
        if (isEqual) {
            Map<String, String> ctrl_planElementUID2individualCommentReplacement = parametersToCompare.getPlanElementUID2individualCommentReplacement();
            isEqual = ctrl_planElementUID2individualCommentReplacement == null && this.planElementUID2individualCommentReplacement == null ? true : ctrl_planElementUID2individualCommentReplacement != null && this.planElementUID2individualCommentReplacement != null;
        }
        if (isEqual) {
            Collection<String> ctrl_planElementUIDsOfPlanElementsToDelete = parametersToCompare.getPlanElementUIDsOfPlanElementsToDelete();
            if (ctrl_planElementUIDsOfPlanElementsToDelete == null && this.planElementUIDsOfPlanElementsToDelete == null) {
                isEqual = true;
            } else if (ctrl_planElementUIDsOfPlanElementsToDelete != null && this.planElementUIDsOfPlanElementsToDelete != null) {
                HashSet<String> s1 = new HashSet<String>(ctrl_planElementUIDsOfPlanElementsToDelete);
                s1.removeAll(this.planElementUIDsOfPlanElementsToDelete);
                HashSet<String> s2 = new HashSet<String>(this.planElementUIDsOfPlanElementsToDelete);
                s2.removeAll(ctrl_planElementUIDsOfPlanElementsToDelete);
                isEqual = s1.isEmpty() && s2.isEmpty();
            } else {
                isEqual = false;
            }
        }
        if (isEqual) {
            PlanElementsCreationRequest ctrl_planElementsCreationRequest = parametersToCompare.getPlanElementsCreationRequest();
            if (ctrl_planElementsCreationRequest == null && this.planElementsCreationRequest == null) {
                isEqual = true;
            } else if (ctrl_planElementsCreationRequest != null && this.planElementsCreationRequest != null) {
                String ctrl_String = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)DTPlanElementsCreationRequest.getInstance(), (Object)ctrl_planElementsCreationRequest);
                String incoming_String = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)DTPlanElementsCreationRequest.getInstance(), (Object)this.planElementsCreationRequest);
                isEqual = ctrl_String.equals(incoming_String);
            } else {
                isEqual = false;
            }
        }
        return isEqual;
    }

    public void update(IInternalAbstractPlanAgentController abstractPlanAgentController, IPlanViewerExtension planAgentExtension, PlanDisplayParameters incomingPlanDisplayParameters) {
        Map<String, String> newPlanElementUID2individualNameReplacement = incomingPlanDisplayParameters.getPlanElementUID2individualNameReplacement();
        this.setPlanElementUID2individualNameReplacement(newPlanElementUID2individualNameReplacement);
        Map<String, String> newPlanElementUID2individualDescriptionReplacement = incomingPlanDisplayParameters.getPlanElementUID2individualDescriptionReplacement();
        this.setPlanElementUID2individualDescriptionReplacement(newPlanElementUID2individualDescriptionReplacement);
        Map<String, String> newPlanElementUID2individualCommentReplacement = incomingPlanDisplayParameters.getPlanElementUID2individualCommentReplacement();
        this.setPlanElementUID2individualCommentReplacement(newPlanElementUID2individualCommentReplacement);
        abstractPlanAgentController.planElementNamesChanged();
        Collection<? extends IHighlightRequest> newHighlightRequests = incomingPlanDisplayParameters.getHighlightRequests();
        List<? extends IProjectionRequest> newProjectionRequests = incomingPlanDisplayParameters.getProjectionRequests();
        this.setHighlightAndProjectionRequests(newHighlightRequests, newProjectionRequests);
        this.updateHighlightsAndProjections(planAgentExtension);
    }

    public void execute(IPlanViewerExtension planAgentExtension) {
        if (this.planElementUIDsOfPlanElementsToDelete != null && !this.planElementUIDsOfPlanElementsToDelete.isEmpty()) {
            planAgentExtension.removePlanElements(this.planElementUIDsOfPlanElementsToDelete);
        }
        if (this.planElementsCreationRequest != null) {
            double anchoringTolerance = this.planElementsCreationRequest.getAnchoringTolerance();
            GeoVector translation = this.planElementsCreationRequest.getTranslation();
            IPlanDataProvider planLoader = this.planElementsCreationRequest.getPlanLoader();
            planAgentExtension.createPlanElements(planLoader, translation, anchoringTolerance);
        }
        this.updateHighlightsAndProjections(planAgentExtension);
    }

    public void updateHighlightsAndProjections(IPlanViewerExtension planAgentExtension) {
        if (!this.highlightRequests.isEmpty()) {
            planAgentExtension.highlightPlanElements(HighlightLevel.BUSINESS, this.highlightRequests);
        }
        if (!this.projectionRequests.isEmpty()) {
            planAgentExtension.project(this.projectionRequests);
        }
    }
}

