/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planagents;

import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.lib.eclipse.gui.dialogs.FileSystemErrorMessageDialogue;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;

public class PlanArchive {
    private final IPlanAgentProjectAgent projectAgent;
    private final IFilesManager filesManager;

    public PlanArchive(IPlanAgentProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.filesManager = projectAgent.getFilesManager();
    }

    public File getPlanFile(IPlan plan) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        assert (plan != null);
        FileID fileID = plan.getPlanFileID();
        return this.filesManager.getFile(fileID);
    }

    public void setPlanFile(IPlan plan, File source, boolean isUpdateMetaAttributes) throws EXModificationProblem {
        String originalFileName = String.valueOf(plan.getPlanName()) + OpenedPlan.getPlanFileExtension(plan.getPlantypeUID());
        try {
            FileResourceWithOverwrittenName fileResource = new FileResourceWithOverwrittenName(source, originalFileName);
            FileID newFileID = this.filesManager.loadFileIntoTemporaryStorage((IStreamResource)fileResource);
            IPlanRW planRW = (IPlanRW)plan;
            Attribute newAttribute = new Attribute(PlanAttributeTypeProvider.ATTRID_PLAN_FILE_DESCRIPTION, newFileID);
            LocksAndPermissionsTransactionController locksAndPermissionsTransactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            planRW.requestAttributeModificationPermission(newAttribute, locksAndPermissionsTransactionController);
            Collection<IModificationProblem> problems = locksAndPermissionsTransactionController.execute();
            if (problems.isEmpty()) {
                try {
                    planRW.setPlanFileID(newFileID, isUpdateMetaAttributes);
                }
                catch (EXNoPermission e) {
                    throw new RuntimeException(e);
                }
                catch (EXNoLock e) {
                    throw new RuntimeException(e);
                }
                PropertyChanges changes = new PropertyChanges(null, (Object)plan, null);
                this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IPlan.class);
            }
            this.filesManager.removeFileFromTemporaryStorage(newFileID);
            if (!problems.isEmpty()) {
                throw new EXModificationProblem(problems);
            }
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new EXModificationProblem(Collections.singleton(new ModificationProblem(FileSystemErrorMessageDialogue.getFileSystemErrorMessage(), Messages.getString("PlanArchive.Error.PlanFileCouldNotBeSet"))));
        }
    }
}

