/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planagents;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planagents.AbstractPlanAgentController;
import com.arcway.cockpit.frame.client.project.planagents.IInternalPlanAgentControllerExtension;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanArchive;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planagents.PlanElementsCreationRequest;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorControllerExtension;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.java.New;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.planagent.controllinginterface.planagent.EXPlanAgentCreationException;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FactoryInput;
import com.arcway.planagent.controllinginterface.planagent.IAbstractPlanAgentController;
import com.arcway.planagent.controllinginterface.planagent.INameAndDescriptionAndCommentAndAspectID;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgent;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentFactory;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInput;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInputExtension;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentExtensionTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanAgentTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeNotSupported;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentTypeDescription;
import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import com.arcway.planagent.controllinginterface.planviewer.IPlanViewerExtension;
import de.plans.lib.util.Ass;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PlanAgentManager
implements AbstractPlanAgentController.IPlanAgentManager {
    public static final String ATTRIBUTE_ID_TRANSLATION_PREFIX = "translation_";
    public static final String ATTRIBUTE_ID_TRANSLATION_NAME_PREIX = "translation_name_";
    public static final String ATTRIBUTE_ID_TRANSLATION_DESCRIPTION_PREFIX = "translation_description_";
    public static final String ATTRIBUTE_ID_TRANSLATION_COMMENT_PREFIX = "translation_comment_";
    private static final boolean ONLY_CURRENT_VERSIONS = true;
    private final Collection abstractPlanAgentControllers = new ArrayList();
    private IPlanAgentProjectAgent projectAgent;
    private PlanArchive planArchive;

    public static boolean isTranslationNameAttributeType(IAttributeType nameAttributeType) {
        return nameAttributeType.getHumanReadableIDWithoutPrefix().startsWith(ATTRIBUTE_ID_TRANSLATION_NAME_PREIX);
    }

    public static String getLanguageOfNameAttributeType(IAttributeType nameAttributeType) {
        return PlanAgentManager.isTranslationNameAttributeType(nameAttributeType) ? nameAttributeType.getHumanReadableIDWithoutPrefix().substring(ATTRIBUTE_ID_TRANSLATION_NAME_PREIX.length()) : null;
    }

    public static boolean isTranslationDescriptionAttributeType(IAttributeType nameAttributeType) {
        return nameAttributeType.getHumanReadableIDWithoutPrefix().startsWith(ATTRIBUTE_ID_TRANSLATION_DESCRIPTION_PREFIX);
    }

    public static String getLanguageOfDescriptionAttributeType(IAttributeType nameAttributeType) {
        return PlanAgentManager.isTranslationDescriptionAttributeType(nameAttributeType) ? nameAttributeType.getHumanReadableIDWithoutPrefix().substring(ATTRIBUTE_ID_TRANSLATION_DESCRIPTION_PREFIX.length()) : null;
    }

    public static boolean isTranslationCommentAttributeType(IAttributeType nameAttributeType) {
        return nameAttributeType.getHumanReadableIDWithoutPrefix().startsWith(ATTRIBUTE_ID_TRANSLATION_COMMENT_PREFIX);
    }

    public static String getLanguageOfCommentAttributeType(IAttributeType nameAttributeType) {
        return PlanAgentManager.isTranslationCommentAttributeType(nameAttributeType) ? nameAttributeType.getHumanReadableIDWithoutPrefix().substring(ATTRIBUTE_ID_TRANSLATION_COMMENT_PREFIX.length()) : null;
    }

    public static Map<IAttributeType, Tuple<IAttributeType, IAttributeType>> getValidNameAndDescriptionAndCommentTranslationAttributeTypes(IAttributeTypesProvider attributeTypesProvider) {
        final List<IAttributeType> nameAttributeTypes = PlanAgentManager.getValidNameAttributeTypes(attributeTypesProvider);
        Collection<IAttributeType> descriptionAttributeTypes = PlanAgentManager.getValidDescriptionAttributeTypes(attributeTypesProvider);
        Collection<IAttributeType> commentAttributeTypes = PlanAgentManager.getValidCommentAttributeTypes(attributeTypesProvider);
        TreeMap<IAttributeType, Tuple<IAttributeType, IAttributeType>> nameAndDescriptionAndCommentTranslationAttributeTypes = new TreeMap<IAttributeType, Tuple<IAttributeType, IAttributeType>>(new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType o1, IAttributeType o2) {
                int idx1 = nameAttributeTypes.indexOf(o1);
                int idx2 = nameAttributeTypes.indexOf(o2);
                return idx1 - idx2;
            }
        });
        for (IAttributeType nameCandidate : nameAttributeTypes) {
            if (!PlanAgentManager.isTranslationNameAttributeType(nameCandidate)) continue;
            String language = PlanAgentManager.getLanguageOfNameAttributeType(nameCandidate);
            IAttributeType descriptionAttributeType = PlanAgentManager.findDescriptionAttributeTypeOfLanguage(descriptionAttributeTypes, language);
            IAttributeType commentAttributeType = PlanAgentManager.findCommentAttributeTypeOfLanguage(commentAttributeTypes, language);
            nameAndDescriptionAndCommentTranslationAttributeTypes.put(nameCandidate, (Tuple<IAttributeType, IAttributeType>)new Tuple((Object)descriptionAttributeType, (Object)commentAttributeType));
        }
        return nameAndDescriptionAndCommentTranslationAttributeTypes;
    }

    private static final IAttributeType findDescriptionAttributeTypeOfLanguage(Collection<IAttributeType> descriptionAttributeTypes, String language) {
        IAttributeType found = null;
        for (IAttributeType candidate : descriptionAttributeTypes) {
            String descLanguage;
            if (!PlanAgentManager.isTranslationDescriptionAttributeType(candidate) || !(descLanguage = PlanAgentManager.getLanguageOfDescriptionAttributeType(candidate)).equals(language)) continue;
            found = candidate;
            break;
        }
        return found;
    }

    private static final IAttributeType findCommentAttributeTypeOfLanguage(Collection<IAttributeType> commentAttributeTypes, String language) {
        IAttributeType found = null;
        for (IAttributeType candidate : commentAttributeTypes) {
            String commentLanguage;
            if (!PlanAgentManager.isTranslationCommentAttributeType(candidate) || !(commentLanguage = PlanAgentManager.getLanguageOfCommentAttributeType(candidate)).equals(language)) continue;
            found = candidate;
            break;
        }
        return found;
    }

    public static Collection<IAttributeType> getValidNameAttributeTypesWithoutTranslations(IAttributeTypesProvider attributeTypesProvider) {
        List<IAttributeType> nameAttributeTypes = PlanAgentManager.getValidNameAttributeTypes(attributeTypesProvider);
        PlanAgentManager.removeTranslationAttributes(attributeTypesProvider, nameAttributeTypes);
        return nameAttributeTypes;
    }

    public static Collection<IAttributeType> getValidDescriptionAttributeTypesWithoutTranslations(IAttributeTypesProvider attributeTypesProvider) {
        Collection<IAttributeType> descriptionAttributeTypes = PlanAgentManager.getValidDescriptionAttributeTypes(attributeTypesProvider);
        PlanAgentManager.removeTranslationAttributes(attributeTypesProvider, descriptionAttributeTypes);
        return descriptionAttributeTypes;
    }

    public static Collection<IAttributeType> getValidCommentAttributeTypesWithoutTranslations(IAttributeTypesProvider attributeTypesProvider) {
        Collection<IAttributeType> commentAttributeTypes = PlanAgentManager.getValidCommentAttributeTypes(attributeTypesProvider);
        PlanAgentManager.removeTranslationAttributes(attributeTypesProvider, commentAttributeTypes);
        return commentAttributeTypes;
    }

    private static void removeTranslationAttributes(IAttributeTypesProvider attributeTypesProvider, Collection<IAttributeType> attributeTypes) {
        Map<IAttributeType, Tuple<IAttributeType, IAttributeType>> nameAndDescriptionAndCommentTranslationAttributeTypes = PlanAgentManager.getValidNameAndDescriptionAndCommentTranslationAttributeTypes(attributeTypesProvider);
        Set<IAttributeType> translationNameAttributeTypes = nameAndDescriptionAndCommentTranslationAttributeTypes.keySet();
        attributeTypes.removeAll(translationNameAttributeTypes);
        Collection<Tuple<IAttributeType, IAttributeType>> translationDescriptionAndCommentAttributeTypes = nameAndDescriptionAndCommentTranslationAttributeTypes.values();
        for (Tuple<IAttributeType, IAttributeType> descriptionAndCommentAttributeType : translationDescriptionAndCommentAttributeTypes) {
            attributeTypes.remove(descriptionAndCommentAttributeType.getT1());
            attributeTypes.remove(descriptionAndCommentAttributeType.getT2());
        }
    }

    public static List<IAttributeType> getValidNameAttributeTypes(IAttributeTypesProvider attributeTypesProvider) {
        ArrayList<IAttributeType> validNameAttributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : attributeTypesProvider.getAttributeTypes()) {
            if (!attributeType.isUserDefined() || !attributeType.displayToUser() || !attributeType.getDataType().getID().equals("string")) continue;
            validNameAttributeTypes.add(attributeType);
        }
        return validNameAttributeTypes;
    }

    public static Collection<IAttributeType> getValidDescriptionAttributeTypes(IAttributeTypesProvider attributeTypesProvider) {
        ArrayList<IAttributeType> validDescriptionAttributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : attributeTypesProvider.getAttributeTypes()) {
            if (!attributeType.isUserDefined() || !attributeType.displayToUser() || !attributeType.getDataType().getID().equals("string") && !attributeType.getDataType().getID().equals("text")) continue;
            validDescriptionAttributeTypes.add(attributeType);
        }
        return validDescriptionAttributeTypes;
    }

    public static Collection<IAttributeType> getValidCommentAttributeTypes(IAttributeTypesProvider attributeTypesProvider) {
        ArrayList<IAttributeType> validCommentAttributeTypes = new ArrayList<IAttributeType>();
        for (IAttributeType attributeType : attributeTypesProvider.getAttributeTypes()) {
            if (!attributeType.isUserDefined() || !attributeType.displayToUser() || !attributeType.getDataType().getID().equals("string") && !attributeType.getDataType().getID().equals("text")) continue;
            validCommentAttributeTypes.add(attributeType);
        }
        return validCommentAttributeTypes;
    }

    public PlanAgentManager() {
        assert (Ass.ert((boolean)true));
    }

    public void construct(IPlanAgentProjectAgent newProjectAgent) {
        assert (newProjectAgent != null);
        this.projectAgent = newProjectAgent;
        this.planArchive = new PlanArchive(this.projectAgent);
    }

    public void checkPlanAgentAvailability(String planAgentTypeID, String planTypeID) throws EXPlanAgentTypeUnknown, EXPlanAgentExtensionTypeUnknown, EXPlanTypeNotSupported, EXPlanTypeUnknown {
        PlanAgentExtensionMgr.getDefault().getPlanAgentTypeDescriptionAndCheckAvailability(planAgentTypeID, planTypeID);
    }

    public IPlanAgentExtension launchPlanAgent(IPlan plan, PlanDisplayParameters planDisplayParameters, String planAgentTypeID, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, Object launcherKey, IProgressDisplay pDisplay) throws EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        return this.launchPlanAgentInternal(plan, planDisplayParameters, planAgentTypeID, internalPlanAgentControllerExtension, factoryInput, inputExtension, launcherKey, pDisplay);
    }

    public IPlanAgentExtension launchPlanFactory(IPlanAddID planAddID, ISection targetSection, String planAgentTypeID, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, Object launcherKey, boolean planFileAlreadyStored, IProgressDisplay pDisplay) throws EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        return this.launchPlanAgentInternal(planAddID, targetSection, planAgentTypeID, internalPlanAgentControllerExtension, factoryInput, inputExtension, launcherKey, planFileAlreadyStored, pDisplay);
    }

    private IPlanAgentExtension launchPlanAgentInternal(IPlan plan, PlanDisplayParameters planDisplayParameters, String planAgentTypeID, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, Object launcherKey, IProgressDisplay pDisplay) throws EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        boolean planFileAlreadyStored;
        PlanAgentTypeDescription planAgentTypeDescription;
        assert (plan != null);
        assert (planAgentTypeID != null);
        assert (internalPlanAgentControllerExtension != null);
        try {
            planAgentTypeDescription = PlanAgentExtensionMgr.getDefault().getPlanAgentTypeDescriptionAndCheckAvailability(planAgentTypeID, plan.getPlantypeUID());
        }
        catch (EXPlanTypeUnknown e) {
            throw new EXPlanAgentLaunchException("No plan type known with ID " + e.getPlanTypeID(), e);
        }
        catch (EXPlanAgentTypeUnknown e) {
            throw new EXPlanAgentLaunchException("No plan agent found with ID " + e.getPlanAgentTypeID(), e);
        }
        catch (EXPlanAgentExtensionTypeUnknown e) {
            throw new EXPlanAgentLaunchException("No plan agent extension type found with ID " + e.getPlanAgentExtensionTypeID(), e);
        }
        catch (EXPlanTypeNotSupported e) {
            throw new EXPlanAgentLaunchException("No plan agent extension of type " + e.getPlanAgentExtensionTypeID() + " loaded for plan type " + e.getPlanTypeID(), e);
        }
        IPlanAgentFactory planAgentFactory = planAgentTypeDescription.getPlanAgentFactory();
        assert (planAgentFactory != null);
        OpenedPlan openedPlan = this.createOpenedPlan(plan, planDisplayParameters);
        IPlanAgentExtension planAgentExtension = this.launchPlanAgentInternal(openedPlan, planAgentFactory, internalPlanAgentControllerExtension, factoryInput, inputExtension, launcherKey, planFileAlreadyStored = false, pDisplay);
        if (planAgentExtension instanceof IPlanViewerExtension) {
            IPlanViewerExtension planViewerExtension = (IPlanViewerExtension)planAgentExtension;
            planDisplayParameters.execute(planViewerExtension);
        }
        return planAgentExtension;
    }

    private IPlanAgentExtension launchPlanAgentInternal(IPlanAddID planAddID, ISection targetSection, String planAgentTypeID, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, Object launcherKey, boolean planFileAlreadyStored, IProgressDisplay pDisplay) throws EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        PlanAgentTypeDescription planAgentTypeDescription;
        try {
            planAgentTypeDescription = PlanAgentExtensionMgr.getDefault().getPlanAgentTypeDescriptionForType(planAgentTypeID);
        }
        catch (EXPlanAgentTypeUnknown e) {
            throw new EXPlanAgentLaunchException("No plan agent found with ID " + e.getPlanAgentTypeID(), e);
        }
        IPlanAgentFactory planAgentFactory = planAgentTypeDescription.getPlanAgentFactory();
        assert (planAgentFactory != null);
        OpenedPlan openedPlan = this.createOpenedPlan(planAddID, targetSection);
        return this.launchPlanAgentInternal(openedPlan, planAgentFactory, internalPlanAgentControllerExtension, factoryInput, inputExtension, launcherKey, planFileAlreadyStored, pDisplay);
    }

    private IPlanAgentExtension launchPlanAgentInternal(OpenedPlan openedPlan, IPlanAgentFactory planAgentFactory, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, Object launcherKey, boolean planFileAlreadyStored, IProgressDisplay pDisplay) throws EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        IPlanAgent planAgent;
        AbstractPlanAgentController abstractPlanAgentController = new AbstractPlanAgentController(openedPlan, internalPlanAgentControllerExtension, this, this.projectAgent, launcherKey, planFileAlreadyStored);
        PlanAgentInput planAgentInput = new PlanAgentInput(openedPlan.getPlanUID(), openedPlan.getPlanTypeID(), openedPlan.getTempFile(), (IPlanInfo)openedPlan, (IAbstractPlanAgentController)abstractPlanAgentController);
        openedPlan.setAccessingMode(planAgentFactory.getInitMode(factoryInput, planAgentInput, inputExtension));
        try {
            planAgent = planAgentFactory.createPlanAgent(factoryInput, planAgentInput, inputExtension, pDisplay);
        }
        catch (EXPlanAgentCreationException pace) {
            throw new EXPlanAgentLaunchException(pace);
        }
        IPlanAgentExtension createdExtension = planAgent.getPlanAgentExtension();
        abstractPlanAgentController.setAbstractPlanAgent(planAgent.getAbstractPlanAgent());
        internalPlanAgentControllerExtension.setAbstractPlanAgentController(abstractPlanAgentController);
        internalPlanAgentControllerExtension.setPlanAgentExtension(createdExtension);
        this.abstractPlanAgentControllers.add(abstractPlanAgentController);
        return createdExtension;
    }

    private OpenedPlan createOpenedPlan(IPlan plan, PlanDisplayParameters planDisplayParameters) throws EXPlanAgentLaunchException {
        assert (plan != null);
        OpenedPlan openedPlan = new OpenedPlan(plan, planDisplayParameters, this.projectAgent);
        Throwable cause = null;
        try {
            openedPlan.loadContent();
        }
        catch (ServerNotAvailableException e) {
            cause = e;
        }
        catch (EXServerException e) {
            cause = e;
        }
        catch (UnknownServerException e) {
            cause = e;
        }
        catch (ExPrematureEndOfTransfer e) {
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            cause = e;
        }
        catch (LoginCanceledException e) {
            cause = e;
        }
        if (cause != null) {
            throw new EXPlanAgentLaunchException(cause.getLocalizedMessage(), cause);
        }
        return openedPlan;
    }

    private OpenedPlan createOpenedPlan(IPlanAddID planAddID, ISection targetSection) {
        return new OpenedPlan(planAddID, targetSection, this.projectAgent);
    }

    @Override
    public void planAgentClosed(AbstractPlanAgentController abstractPlanAgentController) {
        assert (abstractPlanAgentController != null);
        abstractPlanAgentController.closePlan();
        this.abstractPlanAgentControllers.remove(abstractPlanAgentController);
    }

    @Override
    public void setAccessingMode(AbstractPlanAgentController abstractController, int mode) throws EXWriteAccessDeniedException {
        assert (mode == 1 || mode == 2);
        assert (abstractController != null);
        assert (this.abstractPlanAgentControllers.contains(abstractController));
        abstractController.getOpenedPlan().setAccessingMode(mode);
    }

    public boolean isPlanWriteAccessed(IPlan plan) {
        assert (plan != null);
        boolean someOneHasWriteAccess = false;
        Iterator<AbstractPlanAgentController> i = this.getAllAbstractPlanAgentControllersByPlanUID(plan.getUID(), true).iterator();
        while (!someOneHasWriteAccess && i.hasNext()) {
            AbstractPlanAgentController abstractPlanAgentController = i.next();
            someOneHasWriteAccess |= abstractPlanAgentController.getOpenedPlan().isInWriteMode();
        }
        return someOneHasWriteAccess;
    }

    public void closeAllPlanAgents(IPlan plan, boolean versions) {
        assert (plan != null);
        Iterator<AbstractPlanAgentController> iterator = this.getAllAbstractPlanAgentControllersByPlanUID(plan.getUID(), versions).iterator();
        while (iterator.hasNext()) {
            AbstractPlanAgentController element;
            AbstractPlanAgentController abstractPlanAgentController = element = iterator.next();
            abstractPlanAgentController.getControllerExtension().closePlanAgent();
        }
    }

    public void closeAllPlanAgents() {
        for (IInternalPlanAgentControllerExtension controllerExtension : this.getAObjectForEachRelevantPlanAgent(IControllerFitCretereon.ALL_CONTROLLER_EXTENSIONS)) {
            controllerExtension.closePlanAgent();
        }
    }

    @Override
    public void planElementNamesChanged(AbstractPlanAgentController abstractController, Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newName) {
        assert (abstractController != null);
        OpenedPlan plan = abstractController.getOpenedPlan();
        this.uniqueOrLocalElementsChanged(plan.getPlanUID(), planElementUID2newName);
    }

    public void uniqueOrLocalElementsChanged(String planUID, Map<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newNames) {
        assert (planUID != null);
        assert (planElementUID2newNames != null);
        for (AbstractPlanAgentController abstractController : this.getAllAbstractPlanAgentControllersByPlanUID(planUID, true)) {
            HashMap planElementUID2planElementName = New.hashMap((int)planElementUID2newNames.size());
            for (Map.Entry<String, ? extends INameAndDescriptionAndCommentAndAspectID> planElementUID2newName : planElementUID2newNames.entrySet()) {
                String planElementUID = planElementUID2newName.getKey();
                INameAndDescriptionAndCommentAndAspectID planElementName = abstractController.getNameOfPlanElement(planElementUID);
                if (planElementName == null) {
                    planElementName = planElementUID2newName.getValue();
                }
                planElementUID2planElementName.put(planElementUID, planElementName);
            }
            if (planElementUID2planElementName.isEmpty()) continue;
            abstractController.planElementNamesChanged(planElementUID2planElementName);
        }
    }

    public void uniqueElementsChanged(String planUID, Collection<String> planElementUIDs) {
        assert (planUID != null);
        assert (planElementUIDs != null);
        for (AbstractPlanAgentController abstractController : this.getAllAbstractPlanAgentControllersByPlanUID(planUID, true)) {
            HashMap planElementUID2planElementName = New.hashMap((int)planElementUIDs.size());
            for (String planElementUID : planElementUIDs) {
                INameAndDescriptionAndCommentAndAspectID planElementName = abstractController.getNameOfPlanElement(planElementUID);
                if (planElementName == null) continue;
                planElementUID2planElementName.put(planElementUID, planElementName);
            }
            if (planElementUID2planElementName.isEmpty()) continue;
            abstractController.planElementNamesChanged(planElementUID2planElementName);
        }
    }

    private IUniqueElement getUEForPlanElement(String planUID, String planElementUID) {
        IUniqueElementOccurrence uniqueElementOccurence = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrence1(planUID, planElementUID);
        IUniqueElement uniqueElement = uniqueElementOccurence == null ? null : this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOfOccurrence(uniqueElementOccurence);
        return uniqueElement;
    }

    private Collection<AbstractPlanAgentController> getAllAbstractPlanAgentControllersByPlanUID(final String planUID, final boolean versions) {
        assert (planUID != null);
        return this.getAObjectForEachRelevantPlanAgent(new IControllerFitCretereon(){

            @Override
            public Object getRelevantObject(AbstractPlanAgentController abstractController) {
                OpenedPlan plan;
                if (!abstractController.getOpenedPlan().getPlanUID().equals(planUID)) {
                    abstractController = null;
                } else if (versions && (plan = abstractController.getOpenedPlan()).isHistoric()) {
                    abstractController = null;
                }
                return abstractController;
            }
        });
    }

    public Collection<? extends PlanEditorControllerExtension> getAllPlanAgentControllerExtensionsByLauncherKey(final Object launcherKey) {
        return this.getAObjectForEachRelevantPlanAgent(new IControllerFitCretereon(){

            @Override
            public Object getRelevantObject(AbstractPlanAgentController abstractController) {
                IInternalPlanAgentControllerExtension planAgentControllerExtension = null;
                if (abstractController.getLauncherKey() == launcherKey) {
                    planAgentControllerExtension = abstractController.getControllerExtension();
                }
                return planAgentControllerExtension;
            }
        });
    }

    public Collection getAObjectForEachRelevantPlanAgent(IControllerFitCretereon cretereon) {
        ArrayList<Object> allMatchingAbstractPlanAgentControllers = new ArrayList<Object>();
        for (AbstractPlanAgentController controller : this.abstractPlanAgentControllers) {
            Object relevantObject = cretereon.getRelevantObject(controller);
            if (relevantObject == null) continue;
            allMatchingAbstractPlanAgentControllers.add(relevantObject);
        }
        return allMatchingAbstractPlanAgentControllers;
    }

    public void createNewPlanFile(IPlan plan, IPlanFileFactory factory) throws IPlanFileFactory.EXCreatePlanException, EXModificationProblem {
        assert (plan != null);
        assert (factory != null);
        IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute = null;
        IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute = null;
        IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute = null;
        String individualVersionName = null;
        Map<String, String> planElementUID2individualNameReplacement = null;
        Map<String, String> planElementUID2individualDescriptionReplacement = null;
        Map<String, String> planElementUID2individualCommentReplacement = null;
        Collection<String> planElementUIDsOfPlanElementsToDelete = null;
        PlanElementsCreationRequest planElementsCreationRequest = null;
        PlanDisplayParameters planDisplayParameters = new PlanDisplayParameters(uniqueElementAttributeTypeIDofNameAttribute, uniqueElementAttributeTypeIDofDescriptionAttribute, uniqueElementAttributeTypeIDofCommentAttribute, individualVersionName, planElementUID2individualNameReplacement, planElementUID2individualDescriptionReplacement, planElementUID2individualCommentReplacement, planElementUIDsOfPlanElementsToDelete, planElementsCreationRequest);
        OpenedPlan openedPlan = new OpenedPlan(plan, planDisplayParameters, this.projectAgent);
        try {
            File tempFile = openedPlan.createTempFile();
            tempFile.createNewFile();
            factory.createPlan(tempFile, plan.getPlanName(), plan.getUID());
            openedPlan.storeContent(false);
            openedPlan.closePlan();
        }
        catch (IOException e) {
            throw new IPlanFileFactory.EXCreatePlanException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public PlanArchive getPlanArchive() {
        return this.planArchive;
    }

    public static class EXPlanAgentLaunchException
    extends Exception {
        public EXPlanAgentLaunchException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public EXPlanAgentLaunchException(Throwable arg0) {
            super(arg0.getMessage());
        }
    }

    public static interface IControllerFitCretereon {
        public static final IControllerFitCretereon ALL_ABSTRACT_CONTROLLERS = new IControllerFitCretereon(){

            @Override
            public Object getRelevantObject(AbstractPlanAgentController abstractController) {
                return abstractController;
            }
        };
        public static final IControllerFitCretereon ALL_CONTROLLER_EXTENSIONS = new IControllerFitCretereon(){

            @Override
            public Object getRelevantObject(AbstractPlanAgentController abstractController) {
                return abstractController.getControllerExtension();
            }
        };

        public Object getRelevantObject(AbstractPlanAgentController var1);
    }
}

