/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.planagents;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.EXModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataHelper;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanAddID;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.planagents.EXWriteAccessDeniedExceptionCausedByModificationProblems;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.PlanArchive;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planagents.PlanElementsCreationRequest;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IImageDataProvider;
import com.arcway.lib.graphics.image.ImageDataProviders;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.IPlanInfo;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import de.plans.fmca.client.PSCServices;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class OpenedPlan
implements IPlanInfo {
    private static final ILogger logger = Logger.getLogger(OpenedPlan.class);
    private static final int MODE_UNINITIALIZED = 0;
    private static final int MODE_READONLY = -1;
    private static final int MODE_READWRITE = -2;
    public static final int OBJECT_STATE_UNKNOWN = 1;
    public static final int OBEJCT_SHOULD_NOT_EXIST = 2;
    public static final int OBJECT_SHOULD_EXIST = 3;
    private final IPlanAgentProjectAgent projectAgent;
    private final String planUID;
    private String planTypeID;
    private IPlan plan;
    private FileID currentPlanFileID;
    private final PlanDisplayParameters planDisplayParameters;
    private File tempFile = null;
    private boolean deleteTempFileOnClose;
    private int accessingMode = 0;
    private ILocksAndPermissionsTransactionController transactionController = null;
    private ISection targetSection;
    private IPlanAddID planAddID;

    public OpenedPlan(IPlan plan, PlanDisplayParameters planDisplayParameters, IPlanAgentProjectAgent projectAgent) {
        assert (plan != null);
        assert (projectAgent != null);
        this.projectAgent = projectAgent;
        this.planUID = plan.getUID();
        this.planTypeID = plan.getPlantypeUID();
        this.plan = plan;
        this.planDisplayParameters = planDisplayParameters;
    }

    public OpenedPlan(IPlanAddID planAddID, ISection targetSection, IPlanAgentProjectAgent projectAgent) {
        assert (projectAgent != null);
        this.projectAgent = projectAgent;
        this.planUID = planAddID.getPlanUID();
        this.planTypeID = null;
        this.plan = null;
        this.targetSection = targetSection;
        this.planAddID = planAddID;
        IAttributeTypeID uniqueElementAttributeTypeIDofNameAttribute = null;
        IAttributeTypeID uniqueElementAttributeTypeIDofDescriptionAttribute = null;
        IAttributeTypeID uniqueElementAttributeTypeIDofCommentAttribute = null;
        String individualVersionName = null;
        Map<String, String> planElementUID2individualNameReplacement = null;
        Map<String, String> planElementUID2individualDescriptionReplacement = null;
        Map<String, String> planElementUID2individualCommentReplacement = null;
        Collection<String> planElementUIDsOfPlanElementsToDelete = null;
        PlanElementsCreationRequest planElementsCreationRequest = null;
        this.planDisplayParameters = new PlanDisplayParameters(uniqueElementAttributeTypeIDofNameAttribute, uniqueElementAttributeTypeIDofDescriptionAttribute, uniqueElementAttributeTypeIDofCommentAttribute, individualVersionName, planElementUID2individualNameReplacement, planElementUID2individualDescriptionReplacement, planElementUID2individualCommentReplacement, planElementUIDsOfPlanElementsToDelete, planElementsCreationRequest);
    }

    public void setAccessingMode(int accessingMode) throws EXWriteAccessDeniedException {
        assert (accessingMode == 1 || accessingMode == 2);
        if (accessingMode == 1) {
            this.releaseTemporaryLocks();
            this.accessingMode = -1;
        } else if (accessingMode == 2) {
            this.checkPermissionsAndFetchTemporaryLocks();
            this.accessingMode = -2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkPermissionsAndFetchTemporaryLocks() throws EXWriteAccessDeniedException {
        if (this.isHistoric()) {
            throw new EXWriteAccessDeniedException(Messages.getString("OpenedPlan.Error.WriteAccessDenied.OldVersion.Message"));
        }
        if (!this.planDisplayParameters.isCurrentVersion()) {
            throw new EXWriteAccessDeniedException(Messages.getString("OpenedPlan.Error.WriteAccessDenied.ReplacedName.Message"));
        }
        if (this.getPlan() != null) {
            if (this.projectAgent.getPlanAgentManager().isPlanWriteAccessed(this.getPlan())) {
                throw new EXWriteAccessDeniedException(Messages.getString("OpenedPlan.Error.WriteAccessDenied.IsAlreadyInWriteMode.Message"));
            }
            LocksAndPermissionsTransactionController transactionControllerTemp = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.projectAgent.getPlanAgentSectionManager().requestPlanEditPermission(this.getPlan(), transactionControllerTemp);
            Collection<IModificationProblem> modificationProblems = transactionControllerTemp.execute();
            if (!modificationProblems.isEmpty()) throw new EXWriteAccessDeniedExceptionCausedByModificationProblems(modificationProblems);
            this.transactionController = transactionControllerTemp;
            return;
        } else {
            IModificationProblem modProblem = this.projectAgent.getPlanAgentSectionManager().checkPlanAdditionPermission(this.getParentSection(), true);
            if (modProblem == null) return;
            throw new EXWriteAccessDeniedExceptionCausedByModificationProblems(Collections.singleton(modProblem));
        }
    }

    private void releaseTemporaryLocks() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
            this.transactionController = null;
        }
    }

    public void setPlan(IPlan plan) {
        assert (plan != null);
        assert (this.plan != null) : "the plan was not yet created";
        assert (this.plan.getUID().equals(plan.getUID())) : "the new plan has not the same UID";
        this.plan = plan;
    }

    public void setPlanTypeID(String planTypeID) {
        assert (planTypeID != null);
        assert (this.planTypeID == null) : "planTypeID is already determined";
        this.planTypeID = planTypeID;
    }

    public void createPlanRequest(File file) throws EXNoPermission {
        IPlan newPlan;
        assert (this.planTypeID != null) : "planTypeID was not set";
        this.plan = newPlan = this.projectAgent.getPlanAgentSectionManager().addPlan(this.planAddID, this.planTypeID);
        this.setTempFile(file, false);
    }

    private void setTempFile(File tempFile, boolean deleteTempFileOnClose) {
        assert (this.tempFile == null) : "createTempFile() or setTempFile() was called twice";
        assert (tempFile != null);
        assert (tempFile.exists());
        this.tempFile = tempFile;
        this.deleteTempFileOnClose = deleteTempFileOnClose;
    }

    public ISection getParentSection() {
        ISection parentSection = this.plan != null ? this.projectAgent.getPlanAgentSectionManager().getParentSection(this.plan) : this.targetSection;
        return parentSection;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public File createTempFile() {
        assert (this.tempFile == null) : "createTempFile() or setTempFile() was called twice";
        String extension = OpenedPlan.getPlanFileExtension(this.plan.getPlantypeUID());
        try {
            this.tempFile = SessionTempDirectoryManager.createSessionTempFile((String)"newplan", (String)extension);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            throw new RuntimeException(jeriE);
        }
        this.deleteTempFileOnClose = true;
        return this.tempFile;
    }

    public void closePlan() {
        this.releaseTemporaryLocks();
        if (this.tempFile != null && this.deleteTempFileOnClose) {
            try {
                FileHelper.deleteFileOrDirectory((File)this.tempFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                logger.debug("Unable to delete obsolete Plan Temp file", (Throwable)e);
            }
        }
    }

    public boolean loadContent() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        boolean contentHasChanged;
        assert (this.plan != null) : "the plan was not yet created";
        FileID newPlanFileID = this.plan.getPlanFileID();
        if (!newPlanFileID.equals(this.currentPlanFileID)) {
            this.currentPlanFileID = newPlanFileID;
            File tempTempFile = this.getPlanArchive().getPlanFile(this.plan);
            if (this.tempFile == null) {
                this.tempFile = tempTempFile;
                this.deleteTempFileOnClose = true;
            } else {
                try {
                    DataCopyHelper.copyFile((File)tempTempFile, (File)this.tempFile);
                    FileHelper.deleteExistingFileOrDirectory((File)tempTempFile);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.error("Could not load plan file.", (Throwable)e);
                }
            }
            contentHasChanged = true;
        } else {
            contentHasChanged = false;
        }
        return contentHasChanged;
    }

    private PlanArchive getPlanArchive() {
        return this.projectAgent.getPlanAgentManager().getPlanArchive();
    }

    public void storeContent(boolean isUpdateMetaAttributes) throws EXModificationProblem {
        assert (this.plan != null) : "the plan was not yet created";
        assert (!this.plan.isHistoricItem()) : "could not modify an old plan version";
        assert (this.tempFile != null) : "createTempFile() or setTempFile() was not called before";
        assert (this.tempFile.exists()) : "tempFile does not exist. loadContent() or setTempFile() was not called?";
        this.getPlanArchive().setPlanFile(this.plan, this.tempFile, isUpdateMetaAttributes);
        this.currentPlanFileID = this.plan.getPlanFileID();
    }

    public static String getPlanFileExtension(String planTypeID) {
        String extension;
        try {
            PlanTypeDescription planTypeDescription = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(planTypeID);
            extension = String.valueOf('.') + planTypeDescription.getFileExtension();
        }
        catch (EXPlanTypeUnknown e) {
            throw new RuntimeException(e);
        }
        return extension;
    }

    public boolean isInWriteMode() {
        assert (this.accessingMode != 0) : "setAccessingMode() was not called";
        return this.accessingMode != -1;
    }

    public IPlan getPlan() {
        return this.plan;
    }

    public String getPlanUID() {
        return this.planUID;
    }

    public String getProjectUID() {
        return this.projectAgent.getProjectUID();
    }

    public String getPlanTypeID() {
        return this.planTypeID;
    }

    public boolean isHistoric() {
        return this.plan != null && this.plan.isHistoricItem();
    }

    public String getVersion() {
        String label = null;
        if (this.planDisplayParameters.getIndividualVersionName() != null) {
            label = this.planDisplayParameters.getIndividualVersionName();
        } else {
            Locale locale = this.getTargetLocale();
            if (this.plan.getModificationCount() == 0) {
                label = Messages.getString("SectionManager.2", locale);
            } else {
                label = String.valueOf(Messages.getString("SectionManager.version", locale)) + " " + Integer.toString(this.plan.getModificationCount());
                if (!this.isHistoric() && ((SectionManager)this.projectAgent.getSectionManager()).isLocallyModified(this.plan.getUID())) {
                    label = String.valueOf(label) + " (" + Messages.getString("SectionManager.5", locale) + ")";
                }
            }
            String labelExtension = this.planDisplayParameters.calculateLabelExtension(this.getProjectUID());
            if (labelExtension != null) {
                label = label != null && label.length() > 0 ? String.valueOf(labelExtension) + ", " + label : labelExtension;
            }
        }
        return label;
    }

    public Integer getVersionInteger() {
        if (this.isHistoric()) {
            return this.plan.getModificationCount();
        }
        return null;
    }

    public PlanDisplayParameters getPlanDisplayParameters() {
        return this.planDisplayParameters;
    }

    public Boolean isCurrentVersion() {
        return !this.isHistoric() && this.planDisplayParameters.isCurrentVersion();
    }

    public String getFullQualifiedPlanNamePath() {
        return this.getPathName();
    }

    public String getFullQualifiedPlanNameName() {
        if (this.plan == null) {
            return null;
        }
        return this.plan.getPlanName();
    }

    public String getCreator() {
        if (this.plan == null) {
            return null;
        }
        return FrameDataHelper.getCreator(this.plan);
    }

    public Date getCreationDate() {
        if (this.plan != null) {
            return FrameDataHelper.getCreationDate(this.plan);
        }
        return null;
    }

    public String getModifier() {
        if (this.plan == null) {
            return null;
        }
        return FrameDataHelper.getLastEditor(this.plan);
    }

    public Date getModificationDate() {
        if (this.plan != null) {
            return FrameDataHelper.getLastEditDate(this.plan);
        }
        return null;
    }

    public String getProjectName() {
        return this.projectAgent.getProjectMetaDataManager().getProject().getName();
    }

    public String getCopyrightNotice() {
        return this.projectAgent.getProjectMetaDataManager().getProject().getCopyRight();
    }

    public IImageDataProvider getLogo() {
        IImageDataProvider imageDataProvider;
        ImageDescriptor imageDescriptor = this.projectAgent.getProjectLogo();
        if (imageDescriptor == null) {
            imageDataProvider = null;
        } else {
            ImageData imageData = imageDescriptor.getImageData();
            imageDataProvider = ImageDataProviders.createImageDataProvider((IImageData)new SWTImageData(imageData, imageData.type == 4, null));
        }
        return imageDataProvider;
    }

    private String getPathName() {
        String serverName;
        ServerConnection connection;
        String path = "";
        ISection section = this.getParentSection();
        while (section != null) {
            String sectionName;
            ISection parentSection = this.projectAgent.getPlanAgentSectionManager().getParentSection(section);
            if (parentSection != null && (sectionName = section.getSectionName()) != null) {
                path = String.valueOf(sectionName) + File.separator + path;
            }
            section = parentSection;
        }
        String projectName = this.projectAgent.getProjectMetaDataManager().getProject().getName();
        if (projectName != null) {
            path = String.valueOf(projectName) + File.separator + path;
        }
        if ((connection = PSCServices.getServiceFacade().getServerConnection(this.projectAgent.getServerID())) != null && (serverName = connection.getServerName()) != null) {
            path = String.valueOf(serverName) + "] " + File.separator + path;
            String userName = connection.getUserName();
            if (userName != null) {
                path = String.valueOf(userName) + "@" + path;
            }
            path = "[" + path;
        }
        return path;
    }

    public Map<String, String> getDefaultElementRoles() {
        Collection<? extends IUniqueElementOccurrence> uniqueElementOccurrences = this.projectAgent.getPlanAgentUniqueElementManager().getUniqueElementOccurrencesOfPlan(this.plan);
        HashMap<String, String> roles = new HashMap<String, String>((uniqueElementOccurrences.size() + 1) * 2);
        String planRole = String.valueOf(this.plan.getTypeID()) + ' ' + this.plan.getUID();
        roles.put(this.planUID, planRole);
        for (IUniqueElementOccurrence iUniqueElementOccurrence : uniqueElementOccurrences) {
            String planElementUID = iUniqueElementOccurrence.getPlanElementUID();
            String modelElementUID = iUniqueElementOccurrence.getElementUID();
            String planElementRole = "com.arcway.cockpit.uniqueelement " + modelElementUID;
            roles.put(planElementUID, planElementRole);
        }
        return roles;
    }

    public String getPlanName() {
        if (this.plan == null) {
            return this.planUID;
        }
        return this.plan.getPlanName();
    }

    public IPlanInfo.RestrictionClass getRestrictionClass() {
        return RESTRICTIONS_NONE;
    }

    public Locale getTargetLocale() {
        return new Locale(this.projectAgent.getProjectMetaDataManager().getProject().getLanguage());
    }

    public static class EXPlanContentNotAvailableException
    extends Exception {
        public EXPlanContentNotAvailableException(Throwable arg0) {
            super(arg0.getMessage());
        }

        public EXPlanContentNotAvailableException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }
    }
}

