/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.offlinemode;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.project.CockpitController;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IServerDataContainerProcessor;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FileMetaInformationItem;
import com.arcway.cockpit.frame.client.project.core.files.IFilesManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.FilesAsAttributeValuesHelper;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.FilesAsObjectTypeCategoryIconHelper;
import com.arcway.cockpit.frame.client.project.core.locking.ForeignLockChecker;
import com.arcway.cockpit.frame.client.project.core.locking.ILockManager;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequestSupressor;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IPermissionChecker;
import com.arcway.cockpit.frame.client.project.offlinemode.DTOfflineProjectProperties;
import com.arcway.cockpit.frame.client.project.offlinemode.IOfflineDataProvider;
import com.arcway.cockpit.frame.client.project.offlinemode.IOfflineModeManager;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineFrameServerProxy;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineFrameServerProxyDataContainer;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeDataFileManager;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineProjectProperties;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineModeNotAvailableException;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.EXXMLEncodingFailed;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.cockpitadapter.EOUserInformation;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.lib.util.gui.MultiStepProcessor;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OfflineModeManager
implements IOfflineModeManager,
IOfflineDataProvider {
    private static final ILogger logger = Logger.getLogger(OfflineModeManager.class);
    private static final String OFFLINE_DATA_FOLDER = "offlinedata";
    private static final String OFFLINE_PROJECT_PROPERTIES_FILE = "offlineprojectproperties.data";
    private static final String OFFLINE_PROJECT_PROPERTIES_XML_TAG = "offlineprojectproperties";
    private final IFrameProjectAgent projectAgent;
    private final OfflineModeDataFileManager dataFileManager;
    private final File offlineProjectPropertiesFile;

    public static File getOfflineDataRelatedFile(String fileName, File projectRootDirectory) {
        return new File(OfflineModeManager.getOfflineDataFolder(projectRootDirectory), fileName);
    }

    private static File getOfflineDataFolder(File projectRootDirectory) {
        return new File(projectRootDirectory + System.getProperty("file.separator") + OFFLINE_DATA_FOLDER);
    }

    public OfflineModeManager(IFrameProjectAgent projectAgent, File projectRoot) {
        this.projectAgent = projectAgent;
        this.dataFileManager = new OfflineModeDataFileManager(projectRoot, projectAgent);
        this.offlineProjectPropertiesFile = OfflineModeManager.getOfflineDataRelatedFile(OFFLINE_PROJECT_PROPERTIES_FILE, projectAgent.getProjectRoot());
    }

    @Override
    public void enterMode(final IWorkbenchPage currentPage) throws EXOfflineModeNotAvailableException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    OfflineModeManager.this.enterMode(currentPage, monitor);
                }
                catch (EXOfflineModeNotAvailableException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parentShell);
        progressDialog.setOpenOnRun(true);
        try {
            progressDialog.run(false, false, runnable);
        }
        catch (InvocationTargetException ite) {
            throw (EXOfflineModeNotAvailableException)ite.getTargetException();
        }
        catch (InterruptedException e) {
            throw new EXOfflineModeNotAvailableException(e);
        }
        progressDialog.getProgressMonitor().done();
    }

    private void enterMode(final IWorkbenchPage currentPage, IProgressMonitor progressMonitor) throws EXOfflineModeNotAvailableException {
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        final boolean[] blockingProjectLockRequestSucceeded = new boolean[]{true};
        ILocalClientProductLicenseManager localProductLicenseManager = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).getLocalProductLicenseManager();
        if (!localProductLicenseManager.hasProductLicense(ClientProductLicenseTypes.FULL_LICENSE)) {
            EXOfflineModeNotAvailableException exOMNA = new EXOfflineModeNotAvailableException(Messages.getString("OfflineModeManager.MissingLicense"));
            exOMNA.setExceptionLevel(3);
            throw exOMNA;
        }
        IPermissionChecker permissionChecker = this.projectAgent.getFramePermissionChecker();
        if (!permissionChecker.hasPermission(FramePermissionDefinitions.CHECK_OUT_PROJECT_FOR_OFFLINE_MODE, this.projectAgent) || !permissionChecker.hasPermission(FramePermissionDefinitions.OPEN_PROJECT_PERMISSION_TEMPLATE, this.projectAgent)) {
            EXOfflineModeNotAvailableException exOMNA = new EXOfflineModeNotAvailableException(Messages.getString("OfflineModeManager.EnterOffMode.NoPermission"));
            exOMNA.setExceptionLevel(3);
            throw exOMNA;
        }
        if (this.projectAgent.saveAllEditors(parentShell, Messages.getString("OfflineModeManager.EnterOffMode.SaveAndSwitchEditor"), true, true, false)) {
            this.projectAgent.switchAllEditorsIntoViewModeWithoutSaving(parentShell);
            JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(progressMonitor);
            MultiStepProcessor.ISubTask acquireData = new MultiStepProcessor.ISubTask(){

                public int getWeight() {
                    return 80;
                }

                public void process(IProgressDisplay subTaskProgressDisplay) throws Exception {
                    MultiStepProcessor.ISubTask initializeData = new MultiStepProcessor.ISubTask(){

                        public int getWeight() {
                            return 10;
                        }

                        public void process(IProgressDisplay subSubTaskProgressDisplay) throws Exception {
                            subSubTaskProgressDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.EnterOffMode.InitializeData"), 100, false);
                            subSubTaskProgressDisplay.reportQuantifiedProgress(20, Messages.getString("OfflineModeManager.EnterOffMode.SetBlockingProjectLock"));
                            ILockManager lockMgr = OfflineModeManager.this.projectAgent.getLockManager();
                            LockResult blockingProjectLockRequestResult = lockMgr.setBlockingProjectLock();
                            if (!blockingProjectLockRequestResult.wasSuccessful()) {
                                blockingProjectLockRequestSucceeded[0] = false;
                                Exception serverException = blockingProjectLockRequestResult.getPossibleServerException();
                                if (serverException != null) {
                                    throw new EXOfflineModeNotAvailableException(serverException);
                                }
                                Collection<EOLock> conflictingLocks = blockingProjectLockRequestResult.getConflictingLocks();
                                EOLock conflictingLock = conflictingLocks.iterator().next();
                                EXOfflineModeNotAvailableException exOMNA = new EXOfflineModeNotAvailableException(NLS.bind((String)Messages.getString("OfflineModeManager.UnableToSetBlockingProjectLock"), (Object)conflictingLock.getUserName(), (Object)conflictingLock.getClientName()));
                                exOMNA.setExceptionLevel(3);
                                throw exOMNA;
                            }
                            subSubTaskProgressDisplay.reportQuantifiedProgress(60, Messages.getString("OfflineModeManager.EnterOffMode.WriteOfflineData"));
                            IFrameServerProxy frameServerProxy = OfflineModeManager.this.projectAgent.getFrameServerProxy();
                            String projectName = OfflineModeManager.this.projectAgent.getProjectName();
                            String userName = frameServerProxy.getCurrentUser().getDisplayName();
                            OfflineModeManager.this.setOfflineProjectProperties(new OfflineProjectProperties(projectName, userName));
                            subSubTaskProgressDisplay.reportQuantifiedProgress(100, null);
                            subSubTaskProgressDisplay.endTask();
                        }

                        public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                            return null;
                        }
                    };
                    MultiStepProcessor.ISubTask getMainDataAndDownloadFiles = new MultiStepProcessor.ISubTask(){

                        public int getWeight() {
                            return 70;
                        }

                        public void process(final IProgressDisplay subSubTaskProgressDisplay) throws Exception {
                            OfflineModeManager.this.projectAgent.doWithCurrentServerDataContainer(new IServerDataContainerProcessor(){

                                @Override
                                public void processServerDataContainer_theClientIsOnSameState(final ServerDataContainer projectData) throws Exception {
                                    MultiStepProcessor.ISubTask getMainData = new MultiStepProcessor.ISubTask(){

                                        public int getWeight() {
                                            return 30;
                                        }

                                        public void process(IProgressDisplay subSubSubTaskProgressDisplay) throws Exception {
                                            subSubSubTaskProgressDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.EnterOffMode.WriteOfflineData"), 100, false);
                                            IFrameServerProxy frameServerProxy = OfflineModeManager.this.projectAgent.getFrameServerProxy();
                                            Collection<EOGroup> allServerGroups = frameServerProxy.getAllServerGroups();
                                            Collection<EOUser> allServerUser = frameServerProxy.getAllServerUsers();
                                            List<EOPermission> allPermissions = frameServerProxy.getAllPermissions();
                                            OfflineDataContainer offlineDataContainer = new OfflineDataContainer(projectData, OfflineModeManager.this.projectAgent.getUserData(true), allServerGroups, allServerUser, allPermissions);
                                            subSubSubTaskProgressDisplay.reportQuantifiedProgress(70, Messages.getString("OfflineModeManager.EnterOffMode.WriteOfflineData"));
                                            OfflineModeManager.this.dataFileManager.writeData(offlineDataContainer);
                                            subSubSubTaskProgressDisplay.reportQuantifiedProgress(100, null);
                                            subSubSubTaskProgressDisplay.endTask();
                                        }

                                        public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                                            return null;
                                        }
                                    };
                                    MultiStepProcessor.ISubTask getFiles = new MultiStepProcessor.ISubTask(){

                                        public int getWeight() {
                                            return 70;
                                        }

                                        public void process(IProgressDisplay subSubSubTaskProgressDisplay) throws Exception {
                                            try {
                                                OfflineModeManager.fillFileCacheForOfflineMode(OfflineModeManager.this.projectAgent, FilesAsAttributeValuesHelper.getAllFilesUsedAsAttributeValues(OfflineModeManager.this.projectAgent), subSubSubTaskProgressDisplay);
                                                OfflineModeManager.fillFileCacheForOfflineMode(OfflineModeManager.this.projectAgent, FilesAsObjectTypeCategoryIconHelper.getAllFilesUsedAsObjectTypeCategoryIcons(OfflineModeManager.this.projectAgent), subSubSubTaskProgressDisplay);
                                            }
                                            catch (Exception e) {
                                                Exception thrownEx = e instanceof ExPrematureEndOfTransfer && e.getCause() != null ? new EXOfflineModeNotAvailableException(e.getMessage(), e.getCause()) : e;
                                                throw thrownEx;
                                            }
                                        }

                                        public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                                            return null;
                                        }
                                    };
                                    MultiStepProcessor.ISubTask[] subTasks = new MultiStepProcessor.ISubTask[]{getMainData, getFiles};
                                    MultiStepProcessor.process((String)Messages.getString("OfflineModeManager.EnterOffMode.InitializeData"), (MultiStepProcessor.ISubTask[])subTasks, (IProgressDisplay)subSubTaskProgressDisplay);
                                }
                            });
                        }

                        public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                            return null;
                        }
                    };
                    MultiStepProcessor.ISubTask enterOfflineMode = new MultiStepProcessor.ISubTask(){

                        public int getWeight() {
                            return 10;
                        }

                        public void process(IProgressDisplay subSubTaskProgressDisplay) throws Exception {
                            subSubTaskProgressDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.EnterOffMode.WriteOfflineData"), 100, false);
                            OfflineModeManager.this.projectAgent.getCockpitController().enterOfflineMode();
                            subSubTaskProgressDisplay.reportQuantifiedProgress(100, null);
                            subSubTaskProgressDisplay.endTask();
                        }

                        public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                            return null;
                        }
                    };
                    MultiStepProcessor.ISubTask[] subTasks = new MultiStepProcessor.ISubTask[]{initializeData, getMainDataAndDownloadFiles, enterOfflineMode};
                    MultiStepProcessor.process((String)Messages.getString("OfflineModeManager.EnterOffMode.InitializeData"), (MultiStepProcessor.ISubTask[])subTasks, (IProgressDisplay)subTaskProgressDisplay);
                }

                public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                    return null;
                }
            };
            MultiStepProcessor.ISubTask closeOpenProject = new MultiStepProcessor.ISubTask(){

                public int getWeight() {
                    return 20;
                }

                public void process(IProgressDisplay subTaskProgressDisplay) throws Exception {
                    subTaskProgressDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.EnterOffMode.ReopenProject"), 100, false);
                    subTaskProgressDisplay.reportQuantifiedProgress(0, Messages.getString("OfflineModeManager.CloseProject"));
                    OfflineModeManager.this.projectAgent.close(null);
                    subTaskProgressDisplay.reportQuantifiedProgress(10, Messages.getString("OfflineModeManager.OpenProject"));
                    boolean triggerUserOnOpenActions = false;
                    OfflineModeManager.this.projectAgent.open(false, triggerUserOnOpenActions, currentPage);
                    subTaskProgressDisplay.reportQuantifiedProgress(100, null);
                    subTaskProgressDisplay.endTask();
                }

                public MultiStepProcessor.ISubTaskReverter getSubTaskReverter() {
                    return null;
                }
            };
            MultiStepProcessor.ISubTask[] subTasks = new MultiStepProcessor.ISubTask[]{acquireData, closeOpenProject};
            try {
                MultiStepProcessor.process((String)Messages.getString("OfflineModeManager.EnterOffMode"), (MultiStepProcessor.ISubTask[])subTasks, (IProgressDisplay)pDisplay);
            }
            catch (Exception e) {
                if (blockingProjectLockRequestSucceeded[0]) {
                    logger.error("Error switching into offline mode.", (Throwable)e);
                    File projectRoot = this.projectAgent.getProjectRoot();
                    this.dataFileManager.cleanUp();
                    OfflineFrameServerProxy.cleanUp(projectRoot);
                    CockpitController.leaveOfflineModeWithoutBackup(projectRoot);
                    this.offlineProjectPropertiesFile.delete();
                    ForeignLockChecker.cleanUp(projectRoot);
                    try {
                        LockRequestSupressor.markBlockingProjectLockAsInvalid(projectRoot);
                    }
                    catch (Throwable t) {
                        logger.error("Marking blocking project lock as invalid failed. During switching into offline mode an exception occured therefore the blocking project lock must be marked as invalid.", t);
                    }
                    this.projectAgent.close(null);
                }
                throw new EXOfflineModeNotAvailableException(e.getMessage(), e);
            }
        }
        EXOfflineModeNotAvailableException exOMNA = new EXOfflineModeNotAvailableException(Messages.getString("OfflineModeManager.EnterOffMode.ErrorSwitchingEditor"));
        exOMNA.setExceptionLevel(3);
        throw exOMNA;
    }

    @Override
    public void leaveMode(final IWorkbenchPage currentPage) throws EXOfflineMode {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    OfflineModeManager.this.leaveMode(currentPage, monitor);
                }
                catch (EXOfflineMode e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parentShell);
        progressDialog.setOpenOnRun(true);
        try {
            progressDialog.run(false, false, runnable);
        }
        catch (InvocationTargetException ite) {
            throw (EXOfflineMode)ite.getTargetException();
        }
        catch (InterruptedException e) {
            throw new EXOfflineMode(e);
        }
        progressDialog.getProgressMonitor().done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void leaveMode(IWorkbenchPage currentPage, IProgressMonitor progressMonitor) throws EXOfflineMode {
        boolean triggerUserOnOpenActions;
        Shell parentShell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        OfflineDataContainer offlineDataContainerBackup = null;
        boolean offlineDataContainerCleanedUp = false;
        OfflineFrameServerProxyDataContainer offlineFrameServerProxyBackup = null;
        boolean offlineFrameServerProxyCleanedUp = false;
        EOUserInformation offlineCockpitControllerBackup = null;
        boolean offlineCockpitControllerCleanedUp = false;
        OfflineProjectProperties offlineProjectPropertiesBackup = null;
        Throwable exception = null;
        JFaceProgressMonitorToProgressDisplayAdapter pDisplay = new JFaceProgressMonitorToProgressDisplayAdapter(progressMonitor);
        if (!this.projectAgent.saveAllEditors(parentShell, Messages.getString("OfflineModeManager.LeaveOffMode.SaveAndSwitchEditor"), true, true, false)) {
            EXOfflineMode exOM = new EXOfflineMode(Messages.getString("OfflineModeManager.LeaveOffMode.ErrorSwitchingEditor"));
            exOM.setExceptionLevel(3);
            throw exOM;
        }
        this.projectAgent.switchAllEditorsIntoViewModeWithoutSaving(parentShell);
        try {
            pDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.LeaveOffMode"), 100, false);
            pDisplay.reportQuantifiedProgress(0, Messages.getString("OfflineModeManager.LeaveOffMode.RemoveOfflineData"));
            offlineDataContainerBackup = this.dataFileManager.cleanUpWithBackup();
            offlineDataContainerCleanedUp = true;
            offlineFrameServerProxyBackup = OfflineFrameServerProxy.cleanUpWithBackup(this.projectAgent.getProjectRoot());
            offlineFrameServerProxyCleanedUp = true;
            offlineCockpitControllerBackup = this.projectAgent.getCockpitController().leaveOfflineModeWithBackup();
            offlineCockpitControllerCleanedUp = true;
            offlineProjectPropertiesBackup = this.getOfflineProjectProperties();
            this.offlineProjectPropertiesFile.delete();
            pDisplay.reportQuantifiedProgress(10, Messages.getString("OfflineModeManager.CloseProject"));
            this.projectAgent.close(null);
            pDisplay.reportQuantifiedProgress(50, Messages.getString("OfflineModeManager.OpenProject"));
            triggerUserOnOpenActions = false;
            boolean success = this.projectAgent.open(false, triggerUserOnOpenActions, currentPage);
            if (!success) throw new EXOfflineMode(Messages.getString("OfflineModeManager.LeaveOffMode.CouldNotOpenProject"));
            pDisplay.reportQuantifiedProgress(85, Messages.getString("OfflineModeManager.LeaveOffMode.AllocateSupressedPermissions"));
            IFrameServerProxy onlineFrameServerProxy = this.projectAgent.getFrameServerProxy();
            EOList<EOPermission> removedPermissions = offlineFrameServerProxyBackup.getRemovedPermissions();
            EOList<EOPermission> addedPermissions = offlineFrameServerProxyBackup.getAddedPermissions();
            onlineFrameServerProxy.updatePermissions((Collection<EOPermission>)addedPermissions, (Collection<EOPermission>)removedPermissions);
            pDisplay.reportQuantifiedProgress(90, Messages.getString("OfflineModeManager.LeaveOffMode.ReleaseBlockingProjectLock"));
            ILockManager lockMgr = this.projectAgent.getLockManager();
            lockMgr.releaseBlockingProjectLock();
            OfflineModeManager.getOfflineDataFolder(this.projectAgent.getProjectRoot()).delete();
            pDisplay.reportQuantifiedProgress(100, null);
            pDisplay.endTask();
        }
        catch (IOException e) {
            exception = e;
        }
        catch (EXDecoderException e) {
            exception = e;
        }
        catch (LoginCanceledException e) {
            exception = e;
        }
        catch (ServerNotAvailableException e) {
            exception = e;
        }
        catch (UnknownServerException e) {
            exception = e;
        }
        catch (EXServerException e) {
            exception = e;
        }
        catch (Throwable e) {
            exception = e;
        }
        if (exception == null) return;
        if (!(exception instanceof LoginCanceledException)) {
            logger.error("Exception while leaving offline mode.", exception);
        }
        if (offlineDataContainerCleanedUp) {
            this.dataFileManager.writeData(offlineDataContainerBackup);
        }
        if (offlineFrameServerProxyCleanedUp) {
            OfflineFrameServerProxy.restoreFromBackup(this.projectAgent.getProjectRoot(), offlineFrameServerProxyBackup);
        }
        if (offlineCockpitControllerCleanedUp) {
            CockpitController.enterOfflineMode(this.projectAgent.getProjectRoot(), offlineCockpitControllerBackup);
        }
        if (offlineProjectPropertiesBackup != null) {
            try {
                this.setOfflineProjectProperties(offlineProjectPropertiesBackup);
            }
            catch (FileNotFoundException e) {
                logger.error("Error while restoring offline project properties.", (Throwable)e);
            }
            catch (EXXMLEncodingFailed e) {
                logger.error("Error while restoring offline project properties.", (Throwable)e);
            }
        }
        if (!(exception instanceof LoginCanceledException)) {
            this.projectAgent.close(null);
            throw new EXOfflineMode(exception);
        }
        try {
            triggerUserOnOpenActions = false;
            this.projectAgent.open(false, triggerUserOnOpenActions, currentPage);
            return;
        }
        catch (LoginCanceledException e) {
            logger.error("Error while reopen project in offline mode after user has cancelled login.", (Throwable)e);
            throw new EXOfflineMode(e);
        }
        catch (ServerNotAvailableException e) {
            logger.error("Error while reopen project in offline mode after user has cancelled login.", (Throwable)e);
            throw new EXOfflineMode(e);
        }
        catch (UnknownServerException e) {
            logger.error("Error while reopen project in offline mode after user has cancelled login.", (Throwable)e);
            throw new EXOfflineMode(e);
        }
        catch (EXServerException e) {
            logger.error("Error while reopen project in offline mode after user has cancelled login.", (Throwable)e);
            throw new EXOfflineMode(e);
        }
        catch (ExProjectOpenAbortWithMessage e) {
            logger.error("Error while reopen project in offline mode after user has cancelled login.", (Throwable)e);
            throw new EXOfflineMode(e);
        }
    }

    @Override
    public IFrameServerProxy getAppropriateServerProxy() throws EXCorruptProjectData {
        IFrameServerProxy serverProxy = this.isInOfflineMode() ? new OfflineFrameServerProxy(this.projectAgent, this) : ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).createServerProxy(this.projectAgent);
        return serverProxy;
    }

    @Override
    public boolean isInOfflineMode() {
        return this.dataFileManager.offlineDataFileExists();
    }

    @Override
    public OfflineProjectProperties getOfflineProjectProperties() throws EXOfflineDataNotAvailable {
        try {
            FileInputStream inputStream = new FileInputStream(this.offlineProjectPropertiesFile);
            OfflineProjectProperties offlineProjectProperties = (OfflineProjectProperties)XMLCoDecForData.decodeIntoObject((InputStream)inputStream, (IDataType)DTOfflineProjectProperties.getInstance());
            return offlineProjectProperties;
        }
        catch (Exception e) {
            logger.error("Cannot get offline project properties.", (Throwable)e);
            throw new EXOfflineDataNotAvailable(e);
        }
    }

    private void setOfflineProjectProperties(OfflineProjectProperties offlineProjectProperties) throws EXXMLEncodingFailed, FileNotFoundException {
        FileOutputStream outputStream = new FileOutputStream(this.offlineProjectPropertiesFile);
        XMLCoDecForData.encodeIntoOutputStream((OutputStream)outputStream, (Object)offlineProjectProperties, (IDataType)DTOfflineProjectProperties.getInstance(), (String)OFFLINE_PROJECT_PROPERTIES_XML_TAG, null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION);
    }

    @Override
    public OfflineDataContainer getOfflineData() throws EXOfflineDataNotAvailable {
        try {
            return this.dataFileManager.readData();
        }
        catch (Exception e) {
            logger.error("Cannot get offline data.", (Throwable)e);
            throw new EXOfflineDataNotAvailable(e);
        }
    }

    private static void fillFileCacheForOfflineMode(IFrameProjectAgent projectAgent, Collection<FileID> filesToBeDownloaded, IProgressDisplay progressDisplay) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException, ExPrematureEndOfTransfer {
        IFilesManager filesForDataTypesManager = projectAgent.getFilesManager();
        progressDisplay.beginQuantifiedTask(Messages.getString("OfflineModeManager.PrepareOfflineMode.Files.Message"), filesToBeDownloaded.size(), true);
        int workSinceBeginning = 0;
        for (FileID fileID : filesToBeDownloaded) {
            FileMetaInformationItem metaInformation = filesForDataTypesManager.getFileMetaInformation(fileID);
            progressDisplay.reportQuantifiedProgress(workSinceBeginning, metaInformation.getOriginalFileName());
            filesForDataTypesManager.downloadFileIntoCache(fileID);
            ++workSinceBeginning;
        }
        progressDisplay.endTask();
    }
}

