/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.modules;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.LinkManager;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.loproviders.UniqueElementLinkedDataAccessFacade;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule2;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModuleFactory;
import com.arcway.cockpit.frame.client.project.modules.IGeneralModuleFacade;
import com.arcway.cockpit.frame.client.project.modules.IModuleLinkManager;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.ModuleDataManager;
import com.arcway.cockpit.frame.client.project.modules.ModuleInformation;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IProjectPermissionsGroup;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentModuleController;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOGenericCockpitDatabaseData;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.IPlatformAdapterModule;
import de.plans.lib.xml.encoding.EOList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchPage;

public class ModuleController
implements IPlanAgentModuleController,
IFrameDataManager {
    private static final ILogger logger = Logger.getLogger(ModuleController.class);
    private final List<ModuleInformation> moduleAgents = new ArrayList<ModuleInformation>();
    private IGeneralModuleFacade generalModuleFacade;
    private IFrameProjectAgent projectAgent;
    private IDataLabelProvider dataLabelProvider;

    public void construct(IFrameProjectAgent newProjectAgent) {
        assert (newProjectAgent != null);
        this.projectAgent = newProjectAgent;
        this.createModuleAgents();
    }

    private int getModuleCount() {
        return this.moduleAgents.size();
    }

    private IFMCAModule getModule(int index) {
        ModuleInformation moduleInformation = this.moduleAgents.get(index);
        return moduleInformation.getModuleFacade();
    }

    private void createModuleAgents() {
        if (ExtensionMgr.getGeneralModuleFacadeExtensionCount() > 1) {
            logger.warn("More than one cross module link manager registered. Ignoring all but one.");
        }
        this.generalModuleFacade = ExtensionMgr.getGeneralModuleFacade();
        int i = 0;
        while (i < ExtensionMgr.getModuleFactoriesCount()) {
            IFMCAModuleFactory factory = ExtensionMgr.getModuleFactory(i);
            ModuleInformation moduleInformation = new ModuleInformation(factory.getNewModule(this.projectAgent), factory.getModuleID(), ExtensionMgr.getModuleName(i), ExtensionMgr.getModuleDataName(i));
            this.moduleAgents.add(moduleInformation);
            ++i;
        }
    }

    public IPlatformAdapterModule[] getModulePlatformAdapterModules() {
        ArrayList<IPlatformAdapterModule> adapterModules = new ArrayList<IPlatformAdapterModule>();
        if (this.generalModuleFacade != null) {
            adapterModules.addAll(Arrays.asList(this.generalModuleFacade.getPlatformAdaptorModulesBasic(this.projectAgent.getProjectUID())));
        }
        int i = 0;
        while (i < this.getModuleCount()) {
            IPlatformAdapterModule[] adapterModulesOfModuleI;
            IFMCAModule module = this.getModule(i);
            IPlatformAdapterModule[] iPlatformAdapterModuleArray = adapterModulesOfModuleI = module.getPlatformAdapterModules();
            int n = adapterModulesOfModuleI.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformAdapterModule adapterModule = iPlatformAdapterModuleArray[n2];
                adapterModules.add(adapterModule);
                ++n2;
            }
            ++i;
        }
        if (this.generalModuleFacade != null) {
            adapterModules.addAll(Arrays.asList(this.generalModuleFacade.getPlatformAdaptorModulesAdvanced(this.projectAgent.getProjectUID())));
        }
        IPlatformAdapterModule[] adapterModulesAsArray = adapterModules.toArray(new IPlatformAdapterModule[0]);
        return adapterModulesAsArray;
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        int i = 0;
        while (i < this.moduleAgents.size()) {
            ModuleInformation moduleInformation = this.moduleAgents.get(i);
            moduleInformation.getModuleFacade().init(serverDataContainer);
            ++i;
        }
        LinkManager linkManager = administrator.getLinkDataManager();
        UniqueElementLinkedDataAccessFacade uniqueElementLinkedDataAccessFacade = administrator.getUniqueElementManager().getUniqueElementLinkedDataAccessProvider();
        linkManager.registerLinkedDataAccessFacade(uniqueElementLinkedDataAccessFacade);
        ILOLinkAccessFacade uniqueElementLinkAccessFacade = linkManager.getLinkableObjectLinkAccessFacade(uniqueElementLinkedDataAccessFacade.getDataTypeID());
        administrator.setUniqueElementLinkAccessFacade(uniqueElementLinkAccessFacade);
        if (this.generalModuleFacade != null) {
            this.generalModuleFacade.setLinkManager(this.projectAgent.getProjectUID(), linkManager);
        }
        this.registerLinkedDataAccessFacades(linkManager);
        this.registerLinkTypes(linkManager);
    }

    public void projectCreated() {
        for (ModuleInformation mi : this.moduleAgents) {
            mi.getModuleFacade().projectCreated();
        }
    }

    public void registerLinkedDataAccessFacades(IModuleLinkManager linkManager) {
        assert (linkManager != null) : "linkManager must not be null";
        if (this.generalModuleFacade != null) {
            this.generalModuleFacade.registerLinkedDataAccessFacadesWithFrameLinkManager(this.projectAgent.getProjectUID());
        }
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            moduleInformation.getModuleFacade().registerLinkedDataAccessFacades(linkManager);
        }
    }

    public void registerLinkTypes(IModuleLinkManager linkManager) {
        assert (linkManager != null) : "linkManager must not be null";
        if (this.generalModuleFacade != null) {
            this.generalModuleFacade.registerLinkTypesWithFrameLinkManager(this.projectAgent.getProjectUID());
        }
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            moduleInformation.getModuleFacade().registerLinkTypes(linkManager);
        }
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            moduleInformation.getModuleFacade().finishInitialization(administrator.getModuleprojectAgent());
        }
    }

    @Override
    public void projectButtonPressed(ProjectionIdentifier projectionID, IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        assert (projectionID != null);
        assert (projectionReceiver != null);
        for (ModuleInformation mi : this.moduleAgents) {
            if (mi.getModuleFacade().canHandleProjection(projectionID) && mi.getModuleFacade().startProjection(projectionID, projectionReceiver, page)) break;
        }
    }

    public void stopProjectionButtonPressed(IProjectionReceiver projectionReceiver) {
        assert (projectionReceiver != null);
        for (ModuleInformation mi : this.moduleAgents) {
            if (mi.getModuleFacade().stopProjection(projectionReceiver)) break;
        }
    }

    @Override
    public boolean hasLocalModifications() {
        for (ModuleInformation moduleAgent : this.moduleAgents) {
            if (!this.hasDataChanges(moduleAgent)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDataChanges(String dataName) {
        int index = ExtensionMgr.getModuleIndexByDataName(dataName);
        if (index == -1) {
            return false;
        }
        return this.hasDataChanges(this.moduleAgents.get(index));
    }

    private boolean hasDataChanges(ModuleInformation module) {
        return module.getModuleFacade().hasChangesForProject() || this.projectAgent.getModuleLinkManager().hasProjectWideChangesForModule(module.getModuleID());
    }

    public EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> getCreatedOrModifiedDataChanges() {
        EOList listOfModuleChanges = new EOList();
        int i = 0;
        while (i < this.getModuleCount()) {
            IFMCAModule module = this.getModule(i);
            EOFrameDataModification<? extends EOGenericCockpitDatabaseData> moduleChanges = module.getCreatedOrModifiedChangesForProject();
            listOfModuleChanges.add(moduleChanges);
            ++i;
        }
        return listOfModuleChanges;
    }

    public EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> getDeletedDataChanges() {
        EOList listOfModuleChanges = new EOList();
        int i = 0;
        while (i < this.getModuleCount()) {
            IFMCAModule module = this.getModule(i);
            EOFrameDataModification<? extends EOGenericCockpitDatabaseData> moduleChanges = module.getDeletedChangesForProject();
            listOfModuleChanges.add(moduleChanges);
            ++i;
        }
        return listOfModuleChanges;
    }

    public List<ModuleInformation> getAllModuleInformation() {
        ArrayList<ModuleInformation> moduleInformations = new ArrayList<ModuleInformation>(this.moduleAgents);
        return moduleInformations;
    }

    public IFMCAModule getModuleByName(String moduleName) {
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            if (!moduleInformation.getModuleName().equals(moduleName)) continue;
            return moduleInformation.getModuleFacade();
        }
        return null;
    }

    public IModuleProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public boolean hasModulesThatProvideCommitableData() {
        return ExtensionMgr.isModuleDataRegistered();
    }

    public List<String> getCommitableData() {
        List<String> dataNames = ExtensionMgr.getModuleDataNames();
        ArrayList<String> correctDataNames = new ArrayList<String>();
        for (String name : dataNames) {
            if (name.equals("")) continue;
            correctDataNames.add(name);
        }
        return correctDataNames;
    }

    public void distributeSynchronousResponses(EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> responses) {
        if (responses == null) {
            return;
        }
        for (EOFrameDataModification respPackage : responses) {
            IFMCAModule module = this.getModule(respPackage.getRole());
            if (module == null) continue;
            module.handleResponse((EOFrameDataModification<? extends EOGenericCockpitDatabaseData>)respPackage);
        }
    }

    public void finishSynchronousResponse() {
        for (ModuleInformation module : this.getAllModuleInformation()) {
            module.getModuleFacade().finishServerResponse();
        }
    }

    public void distributeAsynchronousResponses(EOList<EOFrameDataModification<? extends EOGenericCockpitDatabaseData>> responses) {
        if (responses == null) {
            return;
        }
        for (EOFrameDataModification respPackage : responses) {
            IFMCAModule module = this.getModule(respPackage.getRole());
            if (module == null) continue;
            module.handleServerUpdate((EOFrameDataModification<? extends EOGenericCockpitDatabaseData>)respPackage);
        }
    }

    public void finishedAsynchronousUpdate() {
        for (ModuleInformation module : this.getAllModuleInformation()) {
            module.getModuleFacade().finishServerUpdate();
        }
    }

    private String getModuleID(IFMCAModule module) {
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            if (!moduleInformation.getModuleFacade().equals(module)) continue;
            return moduleInformation.getModuleID();
        }
        return "";
    }

    public IFMCAModule getModule(String moduleID) {
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            if (!moduleInformation.getModuleID().equals(moduleID)) continue;
            return moduleInformation.getModuleFacade();
        }
        return null;
    }

    public Collection<IProjectPermissionsGroup> getAllProjectPermissionTemplates1(IFrameProjectAgent p_projectAgent) {
        ArrayList<IProjectPermissionsGroup> templateProviders = new ArrayList<IProjectPermissionsGroup>();
        for (ModuleInformation mi : this.getAllModuleInformation()) {
            IProjectPermissionsGroup p = mi.getModuleFacade().getPermissionTemplateProvider(p_projectAgent);
            if (p == null) continue;
            templateProviders.add(p);
        }
        return templateProviders;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("ModuleController.module_controller");
    }

    @Override
    public void discardLocalModifications() {
        for (ModuleInformation mi : this.moduleAgents) {
            mi.getModuleFacade().discardLocalModifications1();
        }
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        for (ModuleInformation mi : this.moduleAgents) {
            if (!mi.getModuleFacade().handlesDataType(cockpitDataTypeID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        for (ModuleInformation mi : this.moduleAgents) {
            IFMCAModule2 module = mi.getModuleFacade();
            for (String typeID : module.getAllDataTypeIDs()) {
                ICockpitProjectData item = module.getCockpitProjectData(typeID, cockpitDataUID);
                if (item == null) continue;
                return item;
            }
        }
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.createDataLabelProvider();
        }
        return this.dataLabelProvider;
    }

    private void createDataLabelProvider() {
        this.dataLabelProvider = new IDataLabelProvider(){

            public Image getImageOfType(String dataTypeID) {
                return ModuleController.this.findModule(dataTypeID).getDataLabelProvider().getImageForType((Object)dataTypeID);
            }

            public String getTypeDisplayName(String dataTypeID) {
                return ModuleController.this.findModule(dataTypeID).getDataLabelProvider().getDisplayNameForType((Object)dataTypeID);
            }

            public Image getImage(Object element) {
                if (element instanceof ICockpitProjectData) {
                    ICockpitProjectData data = (ICockpitProjectData)element;
                    return ModuleController.this.findModule(data.getTypeID()).getDataLabelProvider().getImageForItem(element);
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ICockpitProjectData) {
                    ICockpitProjectData data = (ICockpitProjectData)element;
                    return ModuleController.this.findModule(data.getTypeID()).getDataLabelProvider().getLabelForItem(element);
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    private IFMCAModule findModule(String dataTypeID) {
        for (ModuleInformation mi : this.moduleAgents) {
            IFMCAModule2 module = mi.getModuleFacade();
            if (!module.handlesDataType(dataTypeID)) continue;
            return module;
        }
        return null;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        ArrayList<ILocalModificationContainer> modEntries = new ArrayList<ILocalModificationContainer>();
        for (String dataName : this.getCommitableData()) {
            ILocalModificationContainer modItem;
            ModuleInformation mi;
            IFMCAModule2 module;
            int index = ExtensionMgr.getModuleIndexByDataName(dataName);
            if (index <= -1 || !(module = (mi = this.moduleAgents.get(index)).getModuleFacade()).hasChangesForProject() || (modItem = module.getLocalModification(displayableOnly)) == null) continue;
            modEntries.add(modItem);
        }
        if (!modEntries.isEmpty()) {
            ILocalModificationContainer[] items = new ILocalModificationContainer[modEntries.size()];
            int nr = 0;
            for (ILocalModificationContainer item : modEntries) {
                items[nr++] = item;
            }
            return items;
        }
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> clazz) {
        HashMap<IAttributeTypeDataType, Collection<IAttribute>> attributes = new HashMap<IAttributeTypeDataType, Collection<IAttribute>>();
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            Map<IAttributeTypeDataType, Collection<IAttribute>> attrs = moduleInformation.getModuleFacade().getAllAttributesOfType(clazz);
            if (attrs == null) continue;
            for (Map.Entry<IAttributeTypeDataType, Collection<IAttribute>> entry : attrs.entrySet()) {
                IAttributeTypeDataType currentDataType = entry.getKey();
                Collection<IAttribute> newAttributesOfCurrentDataType = entry.getValue();
                ArrayList<IAttribute> existingAttributesOfCurrentDataType = (ArrayList<IAttribute>)attributes.get(currentDataType);
                if (existingAttributesOfCurrentDataType == null) {
                    existingAttributesOfCurrentDataType = new ArrayList<IAttribute>();
                    attributes.put(currentDataType, existingAttributesOfCurrentDataType);
                }
                existingAttributesOfCurrentDataType.addAll(newAttributesOfCurrentDataType);
            }
        }
        return attributes;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        for (ModuleInformation moduleInformation : this.moduleAgents) {
            Collection<IAttributeType> types = moduleInformation.getModuleFacade().getAllAttributeTypes(dataTypeClass);
            if (types == null) continue;
            attributeTypes.addAll(types);
        }
        return attributeTypes;
    }

    public IFMCAModule getModuleForData(ICockpitProjectData data) {
        for (ModuleInformation mi : this.moduleAgents) {
            IFMCAModule2 module = mi.getModuleFacade();
            if (!module.handlesDataType(data.getTypeID())) continue;
            return module;
        }
        return null;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("not implemented", "not implemented"));
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        IFMCAModule module = this.getModuleForData((ICockpitProjectData)child);
        IAttributeOwner parent = module.getParent((ICockpitProjectData)child);
        if (parent == null) {
            parent = this.projectAgent.getProjectMetaDataManager().getProject();
        }
        return parent;
    }

    public Collection<IAttributeOwner> getChildren(IAttributeOwner parent) {
        ArrayList<IAttributeOwner> children = new ArrayList<IAttributeOwner>();
        if (parent == null) {
            for (ModuleInformation mi : this.moduleAgents) {
                IFMCAModule2 module = mi.getModuleFacade();
                Collection<IAttributeOwner> moduleChildren = module.getChildren(null);
                if (moduleChildren == null) continue;
                children.addAll(moduleChildren);
            }
        } else {
            IFMCAModule module = this.getModuleForData((ICockpitProjectData)parent);
            children.addAll(module.getChildren((ICockpitProjectData)parent));
        }
        return children;
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not add data."));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Permission was not requested!");
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        throw new UnsupportedOperationException();
    }

    public ModuleDataManager createModuleDataManager(String dataTypeID) {
        for (ModuleInformation mi : this.moduleAgents) {
            if (!mi.getModuleFacade().handlesDataType(dataTypeID)) continue;
            return new ModuleDataManager(mi, dataTypeID, this.projectAgent);
        }
        return null;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        for (ModuleInformation mi : this.moduleAgents) {
            IFMCAModule2 module = mi.getModuleFacade();
            module.visitAllAttributeOwnerRWs(visitor);
        }
    }

    public void destruct() {
        if (this.generalModuleFacade != null) {
            this.generalModuleFacade.projectClosed(this.projectAgent.getProjectUID());
        }
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        throw new UnsupportedOperationException();
    }
}

