/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.modules;

import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementsContextMenuActionProvider;
import com.arcway.cockpit.frame.client.project.modules.ContextMenuFrameContext;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElement;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.plugin.ContextMenuContext;
import com.arcway.planagent.controllinginterface.planeditor.plugin.IContextMenuActionProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;

public class ContextMenuMgr
implements IContextMenuActionProvider {
    private static final ILogger logger = Logger.getLogger(ContextMenuMgr.class);

    public List<Object> getActions(ContextMenuContext editorContext) {
        assert (editorContext.getWorkbenchPart() instanceof IEditorPart);
        IExternalPlanEditorControllerExtension ctrl = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects((IEditorPart)editorContext.getWorkbenchPart());
        ArrayList<Object> contextMenuActions = new ArrayList<Object>();
        if (ctrl != null) {
            ArrayList<IPlanElement> selectedPlanElements = null;
            ArrayList<IUniqueElement> selectedUniqueElements = null;
            IPlanAgentProjectAgent projectAgent = ctrl.getProjectAgent();
            ContextMenuFrameContext context = new ContextMenuFrameContext(editorContext.getWorkbenchPart());
            if (logger.isTraceEnabled()) {
                logger.trace("getActions(ContextMenuContext context = " + context + ") - start");
            }
            selectedPlanElements = new ArrayList<IPlanElement>();
            boolean someSelectedElementsAreLocal = false;
            selectedUniqueElements = new ArrayList<IUniqueElement>();
            ISelectionProvider provider = editorContext.getSelectionProvider();
            ISelection selection = provider.getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection currentSelection = (IStructuredSelection)selection;
                List objects = currentSelection.toList();
                for (Object obj : objects) {
                    if (!(obj instanceof IPlanAgentPlanElement)) continue;
                    IPlanAgentPlanElement planAgentPlanElement = (IPlanAgentPlanElement)obj;
                    PlanElement planElement = new PlanElement(planAgentPlanElement, ctrl.getPlanUID(), projectAgent.getProjectUID());
                    selectedPlanElements.add(planElement);
                    IUniqueElement ce = ctrl.findUniqueElement(planAgentPlanElement);
                    if (ce != null) {
                        selectedUniqueElements.add(ce);
                        continue;
                    }
                    someSelectedElementsAreLocal = true;
                }
                List<IAction> uniqueElementsActions = UniqueElementsContextMenuActionProvider.getActions(context, selectedPlanElements, selectedUniqueElements, someSelectedElementsAreLocal);
                if (!uniqueElementsActions.isEmpty()) {
                    for (IAction ueAction : uniqueElementsActions) {
                        if (!ueAction.isEnabled()) continue;
                        contextMenuActions.add(ueAction);
                    }
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getActions(ContextMenuContext) - end");
        }
        return contextMenuActions;
    }
}

