/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.modules;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class ContextMenuEntry
extends Action {
    private final IActionDelegate actionDelegate;
    private final Collection selectedElements = new ArrayList();
    private final Class objectClass;
    private String submenuName;

    public ContextMenuEntry(IActionDelegate actionDelegate, Class objectClass, String submenuName, String label, String toolTip, ImageDescriptor image) {
        assert (actionDelegate != null);
        this.actionDelegate = actionDelegate;
        this.objectClass = objectClass;
        this.submenuName = submenuName;
        this.setText(label);
        this.setToolTipText(toolTip);
        if (image != null) {
            this.setImageDescriptor(image);
        }
    }

    protected void setSelection(Collection selectedUniqueElements) {
        this.selectedElements.clear();
        if (this.objectClass.isAssignableFrom(IUniqueElement.class)) {
            this.selectedElements.addAll(selectedUniqueElements);
        }
        this.actionDelegate.selectionChanged((IAction)this, (ISelection)new ElementsSelection());
    }

    public String getSubmenuName() {
        if (this.submenuName != null && this.submenuName.trim().equals("")) {
            this.submenuName = null;
        }
        if (this.submenuName != null && this.submenuName.indexOf("/") >= 0) {
            this.submenuName = this.submenuName.substring(0, this.submenuName.indexOf("/"));
        }
        return this.submenuName;
    }

    public void run() {
        this.actionDelegate.run((IAction)this);
    }

    private class ElementsSelection
    implements IStructuredSelection {
        private ElementsSelection() {
        }

        public Object getFirstElement() {
            if (!ContextMenuEntry.this.selectedElements.isEmpty()) {
                return ContextMenuEntry.this.selectedElements.iterator().next();
            }
            return null;
        }

        public Iterator iterator() {
            return ContextMenuEntry.this.selectedElements.iterator();
        }

        public int size() {
            return ContextMenuEntry.this.selectedElements.size();
        }

        public Object[] toArray() {
            return ContextMenuEntry.this.selectedElements.toArray();
        }

        public List toList() {
            return new ArrayList(ContextMenuEntry.this.selectedElements);
        }

        public boolean isEmpty() {
            return ContextMenuEntry.this.selectedElements.isEmpty();
        }
    }
}

