/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version4;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version4.HistoricProjectDumpView_4_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version4.HistoricProjectFileView_4_;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.Collections;
import java.util.List;

public class UCReqLinkMigrator
implements ICockpitMigrator {
    public static final String KEY = "UCReqLinkMigrator";
    private static final String OLD_LINKTYPEID = "crossmodulelink-genericmodule-requirementsmodule3--cml-usecase-derivedrequirement";
    private static final String NEW_LINKTYPEID = "crossmodulelink-genericmodule-cml_uc_req--cml-usecase-derivedrequirement";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 4;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_4_ historicView = (HistoricProjectDumpView_4_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    EncodableObjectBase linkData = historicView.readLinks_3(currentProject);
                    if (linkData instanceof EOList) {
                        this.migrateLinks((EOList)linkData);
                        continue;
                    }
                    throw new MigrationFailedException("Link data is not of type EOList<EOLink>: " + linkData.getClass().getName());
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_4_ historicView = (HistoricProjectFileView_4_)projectFile;
        try {
            EOList<? extends EncodableObjectBase> linkData = historicView.getDataList("links");
            this.migrateLinks(linkData);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            throw new MigrationFailedException("Can't access project file.", pfaE);
        }
    }

    private void migrateLinks(EOList<?> linkData) {
        if (linkData != null) {
            for (EncodableObjectBase linkObject : linkData) {
                EOLink_V0 link;
                if (!(linkObject instanceof EOLink_V0) || !(link = (EOLink_V0)linkObject).getLinkTypeID().equals(OLD_LINKTYPEID)) continue;
                link.setLinkTypeID(NEW_LINKTYPEID);
            }
        }
    }
}

