/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3.planmigrators;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.planmigrators.PlanMigratorsHelper_V0;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.List;

public class PlanDataMigratorProjectFile
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(PlanDataMigratorProjectFile.class);
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.plandatamigratorprojectfile";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("LocalLinkMigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) {
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) {
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        block12: {
            try {
                File planFileDirectory;
                HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
                try {
                    File filesRoot = new File(projectFileView_3_.getRootDirectoryOfUnzippedProjectFile(), "files");
                    FileHelper.ensureDirectoryExistance((File)filesRoot);
                    planFileDirectory = new File(filesRoot, "file");
                    FileHelper.ensureDirectoryExistance((File)planFileDirectory);
                }
                catch (JvmExternalResourceInteractionException e) {
                    logger.error("Cannot ensure existence of plan files directory.", (Throwable)e);
                    throw new MigrationFailedException(e);
                }
                EOList<? extends EncodableObjectBase> baseList = projectFileView_3_.getDataList("plans");
                if (baseList == null) break block12;
                for (EncodableObjectBase element : baseList) {
                    if (!(element instanceof EOPlan_V0)) continue;
                    EOPlan_V0 plan = (EOPlan_V0)element;
                    final String planFileID = plan.getUID();
                    File[] planFiles = projectFileView_3_.getRootDirectoryOfUnzippedProjectFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(planFileID);
                        }
                    });
                    int highestVersionNumber = 0;
                    File planFileWithHighestVersionNumber = null;
                    if (planFiles != null) {
                        File[] fileArray = planFiles;
                        int n = planFiles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int currentVersionNumber;
                            File planFile = fileArray[n2];
                            String fileExtension = de.plans.lib.util.FileHelper.getFileType((File)planFile);
                            try {
                                currentVersionNumber = Integer.parseInt(fileExtension);
                            }
                            catch (NumberFormatException e) {
                                currentVersionNumber = 0;
                            }
                            if (currentVersionNumber >= highestVersionNumber) {
                                highestVersionNumber = currentVersionNumber;
                                planFileWithHighestVersionNumber = planFile;
                            }
                            ++n2;
                        }
                    }
                    if (planFileWithHighestVersionNumber == null) continue;
                    String originalFileName = PlanMigratorsHelper_V0.createOriginalPlanFileName(plan);
                    PlanMigratorsHelper_V0.migrateEOPlan(plan, highestVersionNumber, originalFileName);
                    try {
                        File targetPlanFilePosition = new File(planFileDirectory, planFileID);
                        FileHelper.ensureDirectoryExistance((File)targetPlanFilePosition.getParentFile());
                        FileHelper.moveFile(planFileWithHighestVersionNumber, (File)targetPlanFilePosition);
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        logger.error("cannot move plan file", (Throwable)e);
                    }
                }
            }
            catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
                logger.error("Can not migrate project file.", (Throwable)pfaE);
                throw new MigrationFailedException(pfaE);
            }
        }
    }
}

