/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version3;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricServerDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UnnecessaryPermissionMigrator
implements ICockpitMigrator {
    private static final ILogger LOGGER = Logger.getLogger(UnnecessaryPermissionMigrator.class);
    public static final String KEY = "frame.UnnecessaryAttributePermissionMigrator";
    private static final String OPERATION_PREFIX_MODIFY_ATTRIBUTE = "modifyAttribute_";
    private static final String OPERATION_MODIFY_ALL_ATTRIBUTES = "modifyAllAttributes";
    private static final int OWNER_TYPE_GROUP = 1;
    private static final String GROUP_NAME_ADMINS = "Administrators";
    private static final int OWNER_TYPE_USER = 0;
    private static final String USER_NAME_ADMIN = "Administrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 3;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return V0_EOFactory.getDefault();
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
        HistoricServerDumpView_3_ historicView = (HistoricServerDumpView_3_)serverDump;
        EOList<EOPermission> permissions = historicView.getPermissionList();
        if (permissions != null) {
            this.migratePermissions((Collection<EOPermission>)permissions);
        }
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_3_ historicView = (HistoricProjectDumpView_3_)projectDump;
        try {
            for (EOProject_V0 currentProject : historicView.getAllProjects()) {
                EOList<EOPermission> permissions = historicView.readPermissions(currentProject);
                this.migratePermissions((Collection<EOPermission>)permissions);
            }
        }
        catch (EXDecoderException eDE) {
            throw new MigrationFailedException(eDE);
        }
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            HistoricProjectFileView_3_ projectFileView_3_ = (HistoricProjectFileView_3_)projectFile;
            EOList<? extends EncodableObjectBase> permissions = projectFileView_3_.getDataList("permissions");
            this.migratePermissions((Collection<EOPermission>)permissions);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            LOGGER.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    private void migratePermissions(Collection<EOPermission> permissions) {
        permissions.removeAll(UnnecessaryPermissionMigrator.findUnnecessaryAdminPermissions(permissions));
        permissions.removeAll(UnnecessaryPermissionMigrator.findUnnecessaryAttributePermissions(permissions));
    }

    public static Collection<EOPermission> findUnnecessaryAttributePermissions(Collection<EOPermission> permissions) {
        HashSet<EOPermission> permissionsToRemove = new HashSet<EOPermission>();
        HashSet<String> cockpitDataTypeAndOperandAndOwner_withModifyAllAttributePermission = new HashSet<String>();
        SetMap map_cockpitDataTypeAndOperandAndOwner_attributePermissions = new SetMap();
        for (EOPermission permission : permissions) {
            if (permission.getOperation().equals(OPERATION_MODIFY_ALL_ATTRIBUTES)) {
                cockpitDataTypeAndOperandAndOwner_withModifyAllAttributePermission.add(UnnecessaryPermissionMigrator.getPermissionsCockpitDataTypeAndOperandAndOwner(permission));
                continue;
            }
            if (!permission.getOperation().startsWith(OPERATION_PREFIX_MODIFY_ATTRIBUTE)) continue;
            map_cockpitDataTypeAndOperandAndOwner_attributePermissions.add((Object)UnnecessaryPermissionMigrator.getPermissionsCockpitDataTypeAndOperandAndOwner(permission), (Object)permission);
        }
        for (String cockpitDataTypeAndOperandAndOwner : cockpitDataTypeAndOperandAndOwner_withModifyAllAttributePermission) {
            Set unnecessaryAttributePermissions = map_cockpitDataTypeAndOperandAndOwner_attributePermissions.get((Object)cockpitDataTypeAndOperandAndOwner);
            if (unnecessaryAttributePermissions == null) continue;
            permissionsToRemove.addAll(unnecessaryAttributePermissions);
        }
        return permissionsToRemove;
    }

    public static Collection<EOPermission> findUnnecessaryAdminPermissions(Collection<EOPermission> permissions) {
        HashSet<EOPermission> permissionsToRemove = new HashSet<EOPermission>();
        for (EOPermission permission : permissions) {
            if (permission.getOwnerType() == 0 && permission.getOwnerID().equals(USER_NAME_ADMIN)) {
                permissionsToRemove.add(permission);
                continue;
            }
            if (permission.getOwnerType() != 1 || !permission.getOwnerID().equals(GROUP_NAME_ADMINS)) continue;
            permissionsToRemove.add(permission);
        }
        return permissionsToRemove;
    }

    private static String getPermissionsCockpitDataTypeAndOperandAndOwner(EOPermission permission) {
        return String.valueOf(permission.getOperation2()) + "\n" + permission.getOperandType() + "\n" + permission.getOperandUID() + "\n" + permission.getOwnerType() + "\n" + permission.getOwnerID();
    }
}

