/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOUniqueElement_V0;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.MigratorHelper_V0;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.uniqueelementtypemigrator.IUniqueElementTypeForTypeMigration;
import com.arcway.cockpit.frame.shared.UniqueElementNormalizer;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class UniqueElementTypeMigratorDataPath {
    private static final ILogger logger = Logger.getLogger(UniqueElementTypeMigratorDataPath.class);
    private static final String ATTR_HUMAN_READABLE_ID_DISPLAY_NAME = "displayName";
    private static final String ATTR_HUMAN_READABLE_ID_ELEMENT_TYPE = "elementType";
    private static final String ATTR_TAG_DISPLAY_NAME = "frame.uniqueElement.displayName";
    private static final String ATTR_TAG_ELEMENT_TYPE = "frame.uniqueElement.elementType";
    private static final String OLD_ATTR_TAG_DISPLAY_NAME = "displayname";
    private static final String OLD_ATTR_TAG_ELEMENT_TYPE = "elementtype";

    public static void migrateUniqueElementList(EOList<EOUniqueElement_V0> uniqueElementList, IUniqueElementTypeForTypeMigration[] typeDescriptions, Locale projectLanguage) {
        WrappedUniqueElement wrappedUniqueElement;
        HashMap<String, String> sourceTypeID2targetTypeID = new HashMap<String, String>(typeDescriptions.length);
        HashMap<String, Integer> sourceTypeID2FormerUniqueElementTypePriorityAsInteger = new HashMap<String, Integer>(typeDescriptions.length);
        HashMap<String, String> sourceTypeID2FormerUniqueElementTypeNameAsString = new HashMap<String, String>(typeDescriptions.length);
        IUniqueElementTypeForTypeMigration[] iUniqueElementTypeForTypeMigrationArray = typeDescriptions;
        int n = typeDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            IUniqueElementTypeForTypeMigration typeDescription = iUniqueElementTypeForTypeMigrationArray[n2];
            String sourceTypeID = typeDescription.getFormerUniqueElementTypeID();
            String targetTypeID = typeDescription.getCurrentUniqueElementTypeID();
            Integer formerUniqueElementTypePriority = typeDescription.getUniqueElementTypePriority();
            IMap_<Locale, String> typeNamesInSingular = typeDescription.getNamesInSingular();
            Locale nearestLocale = LocaleHelper.findNearestLocale((ICollection_)typeNamesInSingular.keySet(), (Locale)projectLanguage);
            String formerUniqueElementTypeName = (String)typeNamesInSingular.getByKey((Object)nearestLocale);
            sourceTypeID2targetTypeID.put(sourceTypeID, targetTypeID);
            sourceTypeID2FormerUniqueElementTypePriorityAsInteger.put(sourceTypeID, formerUniqueElementTypePriority);
            sourceTypeID2FormerUniqueElementTypeNameAsString.put(sourceTypeID, formerUniqueElementTypeName);
            ++n2;
        }
        HashMap targetTypeID2Name2SortedSetOfWrappedUEs = new HashMap(typeDescriptions.length);
        for (EOUniqueElement_V0 uniqueElement : uniqueElementList) {
            String sourceTypeID = UniqueElementTypeMigratorDataPath.getElementTypeID(uniqueElement);
            if (sourceTypeID != null) {
                String formerUniqueElementName;
                String canonicalUniqueElementName;
                String targetTypeID = (String)sourceTypeID2targetTypeID.get(sourceTypeID);
                if (targetTypeID == null) {
                    targetTypeID = sourceTypeID;
                    logger.warn("unique element migrator recognized unknown UE type " + sourceTypeID + " (UE-UID: " + uniqueElement.getUID() + ")");
                }
                if ((canonicalUniqueElementName = UniqueElementNormalizer.normalizeValue((String)(formerUniqueElementName = UniqueElementTypeMigratorDataPath.getDisplayName(uniqueElement)))) != null) {
                    TreeSet<WrappedUniqueElement> sortedSetOfWrappedUEs;
                    String formerUniqueElementTypeName;
                    Integer formerUniqueElementTypePriority = (Integer)sourceTypeID2FormerUniqueElementTypePriorityAsInteger.get(sourceTypeID);
                    if (formerUniqueElementTypePriority == null) {
                        formerUniqueElementTypePriority = new Integer(10000);
                    }
                    if ((formerUniqueElementTypeName = (String)sourceTypeID2FormerUniqueElementTypeNameAsString.get(sourceTypeID)) == null) {
                        formerUniqueElementTypeName = "unknown Type";
                    }
                    wrappedUniqueElement = new WrappedUniqueElement(uniqueElement, formerUniqueElementTypePriority, formerUniqueElementTypeName, formerUniqueElementName);
                    HashMap<String, TreeSet<WrappedUniqueElement>> name2SortedSetOfWrappedUEs = (HashMap<String, TreeSet<WrappedUniqueElement>>)targetTypeID2Name2SortedSetOfWrappedUEs.get(targetTypeID);
                    if (name2SortedSetOfWrappedUEs == null) {
                        name2SortedSetOfWrappedUEs = new HashMap<String, TreeSet<WrappedUniqueElement>>();
                        targetTypeID2Name2SortedSetOfWrappedUEs.put(targetTypeID, name2SortedSetOfWrappedUEs);
                    }
                    if ((sortedSetOfWrappedUEs = (TreeSet<WrappedUniqueElement>)name2SortedSetOfWrappedUEs.get(canonicalUniqueElementName)) == null) {
                        sortedSetOfWrappedUEs = new TreeSet<WrappedUniqueElement>();
                        name2SortedSetOfWrappedUEs.put(canonicalUniqueElementName, sortedSetOfWrappedUEs);
                    }
                    sortedSetOfWrappedUEs.add(wrappedUniqueElement);
                    continue;
                }
                logger.error("unique element migrator recognized UE with empty name (UE-UID: " + uniqueElement.getUID() + ")");
                continue;
            }
            logger.error("unique element migrator recognized UE type null (UE-UID: " + uniqueElement.getUID() + ")");
        }
        for (Map.Entry entryWithTargetTypeID2Name2SortedSetOfWrappedUEs : targetTypeID2Name2SortedSetOfWrappedUEs.entrySet()) {
            String targetTypeID = (String)entryWithTargetTypeID2Name2SortedSetOfWrappedUEs.getKey();
            Map name2SortedSetOfWrappedUEs = (Map)entryWithTargetTypeID2Name2SortedSetOfWrappedUEs.getValue();
            for (Map.Entry entryWithName2SortedSetOfWrappedUEs : name2SortedSetOfWrappedUEs.entrySet()) {
                SortedSet sortedSetOfWrappedUEs = (SortedSet)entryWithName2SortedSetOfWrappedUEs.getValue();
                Iterator k = sortedSetOfWrappedUEs.iterator();
                if (k.hasNext()) {
                    wrappedUniqueElement = (WrappedUniqueElement)k.next();
                    UniqueElementTypeMigratorDataPath.setElementType(wrappedUniqueElement.uniqueElement, targetTypeID);
                }
                while (k.hasNext()) {
                    wrappedUniqueElement = (WrappedUniqueElement)k.next();
                    UniqueElementTypeMigratorDataPath.setElementType(wrappedUniqueElement.uniqueElement, targetTypeID);
                    int iteration = 1;
                    boolean nameMigrated = false;
                    while (!nameMigrated) {
                        String displayNameWithTypePostfix = UniqueElementTypeMigratorDataPath.getDisplayNameWithTypePostfix(wrappedUniqueElement, iteration);
                        String canonicalDisplayNameWithTypePostfix = UniqueElementNormalizer.normalizeValue((String)displayNameWithTypePostfix);
                        if (name2SortedSetOfWrappedUEs.get(canonicalDisplayNameWithTypePostfix) == null) {
                            UniqueElementTypeMigratorDataPath.setDisplayName(wrappedUniqueElement.uniqueElement, displayNameWithTypePostfix);
                            nameMigrated = true;
                        }
                        ++iteration;
                    }
                }
            }
        }
    }

    private static String getDisplayNameWithTypePostfix(WrappedUniqueElement wrappedUniqueElement, int iteration) {
        String formerUniqueElementName = wrappedUniqueElement.formerUniqueElementName;
        String formerUniqueElementTypeName = wrappedUniqueElement.formerUniqueElementTypeName;
        String displayNameWithTypePostfix = String.valueOf(formerUniqueElementName) + " (" + formerUniqueElementTypeName + ")";
        if (iteration != 1) {
            displayNameWithTypePostfix = String.valueOf(displayNameWithTypePostfix) + " " + iteration;
        }
        return displayNameWithTypePostfix;
    }

    private static String getDisplayName(EOUniqueElement_V0 eoUniqueElement) {
        String stringValue = MigratorHelper_V0.getStringAttribute(eoUniqueElement, ATTR_TAG_DISPLAY_NAME, OLD_ATTR_TAG_DISPLAY_NAME);
        if (stringValue == null) {
            logger.warn("Cannot read UE attribute (UE-UID: " + eoUniqueElement.getUID() + ", " + ATTR_TAG_DISPLAY_NAME + ")");
        }
        return stringValue;
    }

    private static String getElementTypeID(EOUniqueElement_V0 eoUniqueElement) {
        String stringValue = MigratorHelper_V0.getStringAttribute(eoUniqueElement, ATTR_TAG_ELEMENT_TYPE, OLD_ATTR_TAG_ELEMENT_TYPE);
        if (stringValue == null) {
            logger.warn("Cannot read UE attribute (UE-UID: " + eoUniqueElement.getUID() + ", " + ATTR_TAG_ELEMENT_TYPE + ")");
        }
        return stringValue;
    }

    private static void setDisplayName(EOUniqueElement_V0 eoUniqueElement, String newUnqiueElementName) {
        UniqueElementTypeMigratorDataPath.setStringAttribute(eoUniqueElement, ATTR_TAG_DISPLAY_NAME, ATTR_HUMAN_READABLE_ID_DISPLAY_NAME, OLD_ATTR_TAG_DISPLAY_NAME, newUnqiueElementName);
    }

    private static void setElementType(EOUniqueElement_V0 eoUniqueElement, String newElementType) {
        UniqueElementTypeMigratorDataPath.setStringAttribute(eoUniqueElement, ATTR_TAG_ELEMENT_TYPE, ATTR_HUMAN_READABLE_ID_ELEMENT_TYPE, OLD_ATTR_TAG_ELEMENT_TYPE, newElementType);
    }

    private static void setStringAttribute(EOUniqueElement_V0 eoUniqueElement, String attributeTypeIDasString, String humanReadableID, String oldAttributeID, String newValue) {
        EOAttributeTypeID_V0 attributeTypeID = new EOAttributeTypeID_V0(attributeTypeIDasString, humanReadableID);
        EOAttribute_V0 attributeWithNewValue = new EOAttribute_V0();
        attributeWithNewValue.setAttributeTypeID(attributeTypeID);
        attributeWithNewValue.setValueAsEO((EOEncodableObject)new EOString(newValue));
        eoUniqueElement.addAttribute(attributeWithNewValue);
        eoUniqueElement.clearOldAttribute(oldAttributeID);
    }

    private static class WrappedUniqueElement
    implements Comparable<WrappedUniqueElement> {
        private final EOUniqueElement_V0 uniqueElement;
        private final int formerUniqueElementTypePriority;
        private final String formerUniqueElementTypeName;
        private final String formerUniqueElementName;

        public WrappedUniqueElement(EOUniqueElement_V0 uniqueElement, int formerUniqueElementTypePriority, String formerUniqueElementTypeName, String formerUniqueElementName) {
            this.uniqueElement = uniqueElement;
            this.formerUniqueElementTypePriority = formerUniqueElementTypePriority;
            this.formerUniqueElementTypeName = formerUniqueElementTypeName;
            this.formerUniqueElementName = formerUniqueElementName;
        }

        public int hashCode() {
            return this.uniqueElement.getUID().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof WrappedUniqueElement)) {
                return false;
            }
            WrappedUniqueElement otherWrappedUniqueElement = (WrappedUniqueElement)obj;
            WrappedUniqueElement thisWrappedUniqueElement = this;
            return thisWrappedUniqueElement.uniqueElement.getUID().equals(otherWrappedUniqueElement.uniqueElement.getUID());
        }

        @Override
        public int compareTo(WrappedUniqueElement o) {
            assert (o != null);
            WrappedUniqueElement otherWrappedUniqueElement = o;
            WrappedUniqueElement thisWrappedUniqueElement = this;
            if (thisWrappedUniqueElement.uniqueElement.getUID().equals(otherWrappedUniqueElement.uniqueElement.getUID())) {
                return 0;
            }
            int priorityDifference = thisWrappedUniqueElement.formerUniqueElementTypePriority - otherWrappedUniqueElement.formerUniqueElementTypePriority;
            if (priorityDifference != 0) {
                return priorityDifference;
            }
            return thisWrappedUniqueElement.uniqueElement.getUID().compareTo(otherWrappedUniqueElement.uniqueElement.getUID());
        }
    }
}

