/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.projectlogomigrator;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileDescription_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;

public class ProjectLogoMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(ProjectLogoMigrator.class);
    private static final String OLD_LOGO_FILENAME = "logo";
    private static final String ORIGINAL_FILENAME_FOR_LOGO = "Logo";
    private static final String FILE_TYPE_IMAGE = "image";
    private static final int INITIAL_FILE_VERSION = 1;

    @Override
    public String getKey() {
        return "CockpitLogoMigrator";
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return null;
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateProjectFile(projectFile);
    }

    private void migrateProjectFile(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        HistoricProjectFileView_0_ historicView = (HistoricProjectFileView_0_)projectFile;
        try {
            String newFileUID = UUIDGenerator.getUniqueID();
            EOProject_V0 project = historicView.getProjectMetaData();
            File logoFile = new File(historicView.getRootDirectoryOfUnzippedProjectFile(), OLD_LOGO_FILENAME);
            if (logoFile.exists()) {
                File imageFilesDirectory = this.getImageFilesDirectory(historicView.getRootDirectoryOfUnzippedProjectFile());
                File newLogoFile = new File(imageFilesDirectory, newFileUID);
                FileHelper.moveFile((File)logoFile, (File)newLogoFile);
                this.addLogoAttributeToProject(project, newFileUID);
            }
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can't migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't migrate project file.", (Throwable)jeriE);
            throw new MigrationFailedException(jeriE);
        }
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            try {
                for (EOProject_V0 currentProject : projects) {
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File logoFile = new File(projectDirectory, OLD_LOGO_FILENAME);
                    if (!logoFile.exists()) continue;
                    String newFileUID = UUIDGenerator.getUniqueID();
                    File imageFilesDirectory = this.getImageFilesDirectory(projectDirectory);
                    File newLogoFileDirectory = new File(imageFilesDirectory, "versions_" + newFileUID);
                    FileHelper.ensureDirectoryExistance((File)newLogoFileDirectory);
                    File newLogoFile = new File(newLogoFileDirectory, Integer.toString(1));
                    FileHelper.moveFile((File)logoFile, (File)newLogoFile);
                    EOFileHistoryItem_V0 fileHistoryItem = new EOFileHistoryItem_V0(newFileUID, currentProject.getProjectUID(), FILE_TYPE_IMAGE, "", 1, "", new Timestamp(System.currentTimeMillis()), "restored", ORIGINAL_FILENAME_FOR_LOGO);
                    EOList versionInformation = new EOList();
                    versionInformation.add((EncodableObjectBase)fileHistoryItem);
                    File newLogoVersionFile = new File(newLogoFileDirectory, "versions1");
                    versionInformation.writeToFile(newLogoVersionFile);
                    this.addLogoAttributeToProject(currentProject, newFileUID);
                }
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                logger.error("Can't migrate dump.", (Throwable)jeriE);
                throw new MigrationFailedException(jeriE);
            }
            catch (IOException ioE) {
                logger.error("Can't migrate dump.", (Throwable)ioE);
                throw new MigrationFailedException(ioE);
            }
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) {
    }

    private void addLogoAttributeToProject(EOProject_V0 project, String newLogoFileID) {
        EOAttribute_V0 logoAttribute = new EOAttribute_V0();
        EOAttributeTypeID_V0 logoAttributeTypeID = new EOAttributeTypeID_V0("frame.project.logo", OLD_LOGO_FILENAME);
        logoAttribute.setAttributeTypeID(logoAttributeTypeID);
        EOFileID_V0 fileID = new EOFileID_V0(newLogoFileID, Integer.toString(1));
        EOFileDescription_V0 fileDescription = new EOFileDescription_V0(fileID, ORIGINAL_FILENAME_FOR_LOGO);
        logoAttribute.setValueAsEO((EOEncodableObject)fileDescription);
        project.addAttribute(logoAttribute);
    }

    private File getImageFilesDirectory(File projectDirectory) throws JvmExternalResourceInteractionException {
        File filesDirectory = new File(projectDirectory, "files");
        FileHelper.ensureDirectoryExistance((File)filesDirectory);
        File imageFilesDirectory = new File(filesDirectory, FILE_TYPE_IMAGE);
        FileHelper.ensureDirectoryExistance((File)imageFilesDirectory);
        return imageFilesDirectory;
    }
}

