/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.planmigrators;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class PlanModCountMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.planmodcountmigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version3.internalplanversionidmigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            for (EOProject_V0 currentProject : projects) {
                this.migrateProjectDump(historicView, currentProject);
            }
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void migrateProjectDump(HistoricProjectDumpView_0_ historicView, EOProject_V0 currentProject) throws MigrationFailedException {
        block5: {
            try {
                EncodableObjectBase frameDataBase = historicView.readDataFile(currentProject, "plans.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), PSCPlainMessageDataFactory.getDefault()}));
                if (frameDataBase != null && frameDataBase instanceof EOList) {
                    EOList dataList = (EOList)frameDataBase;
                    for (Object o : dataList) {
                        if (o instanceof EOPlan_V0) {
                            EOPlan_V0 eoPlan = (EOPlan_V0)((Object)o);
                            this.migrateModCount(eoPlan, historicView, currentProject);
                            continue;
                        }
                        throw new MigrationFailedException("The file plans.xml contains elements not of expected type EOPLan_V0: " + o.getClass().getName());
                    }
                    historicView.writeDataFile(currentProject, "plans.xml", null, frameDataBase);
                    break block5;
                }
                throw new MigrationFailedException("The file plans.xml does not exist or contains elements not of expected type EOList: " + (frameDataBase != null ? frameDataBase.getClass().getName() : ""));
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
        }
    }

    private void migrateModCount(EOPlan_V0 eoPlan, HistoricProjectDumpView_0_ historicView, EOProject_V0 currentProject) throws MigrationFailedException {
        if (eoPlan.getModCount() == 0) {
            eoPlan.setModCount(this.getHighestVersionNumber(eoPlan, historicView, currentProject));
        }
    }

    private int getHighestVersionNumber(EOPlan_V0 eoPlan, HistoricProjectDumpView_0_ historicView, EOProject_V0 currentProject) throws MigrationFailedException {
        int highestVersionNumber = 1;
        File projectDirectory = historicView.getProjectDirectory(currentProject);
        String childPath = "plans" + System.getProperty("file.separator") + eoPlan.getUID();
        File concretePlanFileDirectory = new File(projectDirectory, childPath);
        try {
            EncodableObjectBase encodableObject = historicView.readDataFile(concretePlanFileDirectory, "history.xml", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
            if (encodableObject == null || !(encodableObject instanceof EOList)) {
                String message = "Plan versions file does not exits or contains an element not of type EOList. Current plan file directory '" + concretePlanFileDirectory.getPath() + "'";
                throw new MigrationFailedException(message);
            }
            EOList fileHistoryItems = (EOList)encodableObject;
            EOFileHistoryItem_V0.sortFileHistoryItemListByVersionNumberOnly((List<EOFileHistoryItem_V0>)fileHistoryItems);
            EOList sortedHistoryItems = fileHistoryItems;
            highestVersionNumber = ((EOFileHistoryItem_V0)sortedHistoryItems.get(sortedHistoryItems.size() - 1)).getVersionNumber();
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
        return highestVersionNumber;
    }
}

