/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.planmigrators;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.io.FileFilter;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;

public class MissingPlanHistoryMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.missingplanhistorymigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version0.FileVersionsInDumpMigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    File[] singlePlanFiles;
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File plansDirectory = new File(projectDirectory, "plans");
                    if (!plansDirectory.exists()) continue;
                    File[] fileArray = singlePlanFiles = plansDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile();
                        }
                    });
                    int n = singlePlanFiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File singlePlanFile = fileArray[n2];
                        EOFileHistoryItem_V0 historyItem = this.createHistoryItem(singlePlanFile.getName(), currentProject.getProjectUID());
                        this.moveAndRenamePlanFile(plansDirectory, singlePlanFile, historyItem, historicView);
                        ++n2;
                    }
                }
            }
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private EOFileHistoryItem_V0 createHistoryItem(String fileUID, String projectUID) {
        EOFileHistoryItem_V0 historyItem = new EOFileHistoryItem_V0();
        historyItem.setProjectUID(projectUID);
        historyItem.setAuthor("unknown");
        historyItem.setCreationDate(new Timestamp(System.currentTimeMillis()));
        historyItem.setFileTypeID("planFile");
        historyItem.setFileUID(fileUID);
        historyItem.setModificationComment("Restored from dump.");
        historyItem.setVersionNumber(1);
        return historyItem;
    }

    private void moveAndRenamePlanFile(File plansDirectory, File singlePlanFile, EOFileHistoryItem_V0 historyItem, HistoricProjectDumpView_0_ historicView) throws JvmExternalResourceInteractionException {
        File temporarilyRenamedSinglePlanFile = new File(plansDirectory, String.valueOf(singlePlanFile.getName()) + "_temp");
        FileHelper.moveFile((File)singlePlanFile, (File)temporarilyRenamedSinglePlanFile);
        File planDirectory = new File(plansDirectory, historyItem.getFileUID());
        FileHelper.ensureDirectoryExistance((File)planDirectory);
        File targetPlanFile = new File(planDirectory, String.valueOf(historyItem.getFileUID()) + "_v_" + historyItem.getVersionNumber());
        FileHelper.moveFile((File)temporarilyRenamedSinglePlanFile, (File)targetPlanFile);
        EOList historyItems = new EOList();
        historyItems.add((EncodableObjectBase)historyItem);
        historicView.writeDataFile(planDirectory, "history.xml", (EncodableObjectBase)historyItems);
    }
}

