/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0.planmigrators;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class InternalPlanVersionIDMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(InternalPlanVersionIDMigrator.class);
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version3.internalplanversionidmigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version3.missingplanhistorymigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    File[] planDirectories;
                    File projectDirectory = historicView.getProjectDirectory(currentProject);
                    File plansDirectory = new File(projectDirectory, "plans");
                    if (!plansDirectory.exists()) continue;
                    File[] fileArray = planDirectories = plansDirectory.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    });
                    int n = planDirectories.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EOList sortedHistoryItems;
                        File planDirectory = fileArray[n2];
                        EncodableObjectBase encodableObject = historicView.readDataFile(planDirectory, "history.xml", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()}));
                        if (encodableObject != null && encodableObject instanceof EOList) {
                            EOList fileHistoryItems = (EOList)encodableObject;
                            EOFileHistoryItem_V0.sortFileHistoryItemListByVersionNumberOnly((List<EOFileHistoryItem_V0>)fileHistoryItems);
                            sortedHistoryItems = fileHistoryItems;
                            if (!this.isHistoryNonEmptyAndContinuousAndStartsWithVersion0or1((EOList<EOFileHistoryItem_V0>)sortedHistoryItems)) {
                                logger.error("restorePlan()- Version history of plan is damaged. Current plan directory '" + planDirectory.getPath() + "'");
                            }
                            boolean adjustHistoryToStartWithVersion1 = false;
                            EOFileHistoryItem_V0 historyItemWithLowestVersion = (EOFileHistoryItem_V0)sortedHistoryItems.get(0);
                            if (historyItemWithLowestVersion.getVersionNumber() == 0) {
                                adjustHistoryToStartWithVersion1 = true;
                            }
                            ListIterator listItr = sortedHistoryItems.listIterator(sortedHistoryItems.size());
                            while (listItr.hasPrevious()) {
                                EOFileHistoryItem_V0 historyItem = (EOFileHistoryItem_V0)((Object)listItr.previous());
                                if (!adjustHistoryToStartWithVersion1) continue;
                                int incrementedVersionNumber = historyItem.getVersionNumber() + 1;
                                this.incrementVersionFileName(planDirectory, historyItem, incrementedVersionNumber);
                                historyItem.setVersionNumber(incrementedVersionNumber);
                            }
                        } else {
                            String message = "Plan versions file does not exits or contains an element not of type EOList. Current plan directory '" + planDirectory.getPath() + "'";
                            throw new MigrationFailedException(message);
                        }
                        historicView.writeDataFile(planDirectory, "history.xml", (EncodableObjectBase)sortedHistoryItems);
                        ++n2;
                    }
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private boolean isHistoryNonEmptyAndContinuousAndStartsWithVersion0or1(EOList<EOFileHistoryItem_V0> history) {
        boolean historyOk;
        if (history == null || history.isEmpty() || ((EOFileHistoryItem_V0)history.get(0)).getVersionNumber() != 0 && ((EOFileHistoryItem_V0)history.get(0)).getVersionNumber() != 1) {
            historyOk = false;
        } else {
            Iterator i = history.iterator();
            historyOk = true;
            int lastInternalVersionNumber = ((EOFileHistoryItem_V0)((Object)i.next())).getVersionNumber();
            while (i.hasNext()) {
                if (lastInternalVersionNumber + 1 == ((EOFileHistoryItem_V0)((Object)i.next())).getVersionNumber()) {
                    ++lastInternalVersionNumber;
                    continue;
                }
                historyOk = false;
            }
        }
        return historyOk;
    }

    private void incrementVersionFileName(File directory, EOFileHistoryItem_V0 historyItem, int incrementedVersionNumber) throws JvmExternalResourceInteractionException {
        File versionFile = new File(directory, String.valueOf(historyItem.getFileUID()) + "_v_" + historyItem.getVersionNumber());
        File targetVersionFile = new File(directory, String.valueOf(historyItem.getFileUID()) + "_v_" + incrementedVersionNumber);
        FileHelper.moveFile((File)versionFile, (File)targetVersionFile);
    }
}

