/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOPlan_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOSection_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class SectionsAndPlansFileMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version0.sectionsandplansfilemigrator";
    private static final MultiplexEncodableObjectFactory EO_FACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault()});

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version0.missingdumpfilesmigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        try {
            HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
            List<EOProject_V0> projects = historicView.getAllProjects();
            if (projects != null) {
                for (EOProject_V0 currentProject : projects) {
                    File sectionsAndPlansFile = new File(historicView.getProjectDirectory(currentProject), "sectionsAndPlans.xml");
                    if (!sectionsAndPlansFile.exists()) continue;
                    EncodableObjectBase encodableObject = historicView.readDataFile(currentProject, "sectionsAndPlans.xml", null, (IEncodableObjectFactory)EO_FACTORY);
                    if (encodableObject != null && encodableObject instanceof EOSection_V0) {
                        EOList eoSections = new EOList();
                        EOList eoPlans = new EOList();
                        EOSection_V0 rootSection = (EOSection_V0)encodableObject;
                        this.restoreOldDumpOfSectionAndPlans(rootSection, (EOList<EOSection_V0>)eoSections, (EOList<EOPlan_V0>)eoPlans);
                        rootSection.cleanUpOldSectionFormatWrapper();
                        eoSections.add((EncodableObjectBase)rootSection);
                        historicView.writeDataFile(currentProject, "sections.xml", null, (EncodableObjectBase)eoSections);
                        historicView.writeDataFile(currentProject, "plans.xml", null, (EncodableObjectBase)eoPlans);
                        File sectionsAndPlanFile = new File(historicView.getProjectDirectory(currentProject), "sectionsAndPlans.xml");
                        FileHelper.deleteExistingFileOrDirectory((File)sectionsAndPlanFile);
                        continue;
                    }
                    throw new MigrationFailedException("The file sectionsAndPlans.xml does not exist or contains elements not of expected type EOSection_V0.");
                }
            }
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException(e);
        }
        catch (JvmExternalResourceInteractionException e) {
            throw new MigrationFailedException(e);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    private void restoreOldDumpOfSectionAndPlans(EOSection_V0 section, EOList<EOSection_V0> eoSections, EOList<EOPlan_V0> eoPlans) {
        for (EOPlan_V0 plan : section.getOldSectionFormatWrapper().getPlans()) {
            eoPlans.add((EncodableObjectBase)plan);
        }
        for (EOSection_V0 childSection : section.getOldSectionFormatWrapper().getChildSections()) {
            this.restoreOldDumpOfSectionAndPlans(childSection, eoSections, eoPlans);
            childSection.cleanUpOldSectionFormatWrapper();
            eoSections.add((EncodableObjectBase)childSection);
        }
    }
}

