/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class MissingDumpFilesMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version0.missingdumpfilesmigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version0.moduledumpdirectorymigrator");
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            for (EOProject_V0 currentProject : projects) {
                File platformLogFile;
                File commonModuleDataFileLogs;
                File commonModuleDataDirectory;
                File commonModuleDataFile;
                File commonFrameDataFile;
                File userDefAttributesDataFile;
                File stakholderRoleLinksDataFile;
                File stakholderRolesDataFile;
                File projectDirectory = historicView.getProjectDirectory(currentProject);
                File stakholdersDataFile = new File(projectDirectory, "Stakeholders.xml");
                if (!stakholdersDataFile.exists()) {
                    historicView.writeDataFile(projectDirectory, "Stakeholders.xml", (EncodableObjectBase)new EOList());
                }
                if (!(stakholderRolesDataFile = new File(projectDirectory, "Roles.xml")).exists()) {
                    historicView.writeDataFile(projectDirectory, "Roles.xml", (EncodableObjectBase)new EOList());
                }
                if (!(stakholderRoleLinksDataFile = new File(projectDirectory, "StakeholdersRoles.xml")).exists()) {
                    historicView.writeDataFile(projectDirectory, "StakeholdersRoles.xml", (EncodableObjectBase)new EOList());
                }
                if (!(userDefAttributesDataFile = new File(projectDirectory, "userDefinedAttributeTypes.xml")).exists()) {
                    historicView.writeDataFile(projectDirectory, "userDefinedAttributeTypes.xml", (EncodableObjectBase)new EOList());
                }
                if (!(commonFrameDataFile = new File(projectDirectory, "frameData.xml")).exists()) {
                    historicView.writeDataFile(projectDirectory, "frameData.xml", (EncodableObjectBase)new EOList());
                }
                if (!(commonModuleDataFile = new File(commonModuleDataDirectory = new File(projectDirectory, "cmm"), "cmm_data.xml")).exists()) {
                    historicView.writeDataFile(commonModuleDataDirectory, "cmm_data.xml", (EncodableObjectBase)new EOList());
                }
                if (!(commonModuleDataFileLogs = new File(commonModuleDataDirectory, "cmm_data_log.xml")).exists()) {
                    historicView.writeDataFile(commonModuleDataDirectory, "cmm_data_log.xml", (EncodableObjectBase)new EOList());
                }
                if ((platformLogFile = new File(projectDirectory, "modificationLog.xml")).exists()) continue;
                historicView.writeDataFile(projectDirectory, "modificationLog.xml", (EncodableObjectBase)new EOList());
            }
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }
}

