/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class FrameDumpDirectoryMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(FrameDumpDirectoryMigrator.class);
    public static final String KEY = "FrameDumpDirectoryMigrator";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.emptyList();
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) {
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView dumpDirectory) {
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView dumpDirectory) throws MigrationFailedException {
        HistoricServerDumpView_0_ historicView = (HistoricServerDumpView_0_)dumpDirectory;
        try {
            File rootDirectory = historicView.getRootDirectoryOfUnzippedServerDumpFile();
            File oldFrameModuleDirectory = new File(rootDirectory, "com.arcway.cockpit.frame.server.RHDumpRequestHandler");
            if (oldFrameModuleDirectory.exists()) {
                File newFrameModuleDirectory = new File(rootDirectory, "COCKPIT_FRAME");
                FileHelper.ensureDirectoryExistance((File)newFrameModuleDirectory);
                FileHelper.copyDirectoryContent((File)oldFrameModuleDirectory, (File)newFrameModuleDirectory);
                FileHelper.deleteExistingFileOrDirectory((File)oldFrameModuleDirectory);
            }
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't migrate server dump.", (Throwable)jeriE);
            throw new MigrationFailedException(jeriE);
        }
    }
}

