/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileHistoryItem_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileVersionsInDumpMigrator
implements ICockpitMigrator {
    public static final String KEY = "com.arcway.cockpit.frame.client.project.migration.migrators.version0.FileVersionsInDumpMigrator";
    private static final IEncodableObjectFactory EOFACTORY = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{MessageDataFactoryForBasicEOs.getDefault(), V0_EOFactory.getDefault()});
    private static final String FILES_DIRECTORY = "files";
    private static final XMLDecoder xmlDecoder = new XMLDecoder();

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version0.sectionsandplansfilemigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return null;
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) throws MigrationFailedException {
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        List<EOProject_V0> projects = historicView.getAllProjects();
        if (projects != null) {
            try {
                this.migrateProjects(historicView, projects);
            }
            catch (EXDecoderException e) {
                throw new MigrationFailedException(e);
            }
            catch (JvmExternalResourceInteractionException e) {
                throw new MigrationFailedException(e);
            }
            catch (FileNotFoundException e) {
                throw new MigrationFailedException(e);
            }
        }
    }

    private void migrateProjects(HistoricProjectDumpView_0_ historicView, List<EOProject_V0> projects) throws EXDecoderException, JvmExternalResourceInteractionException, FileNotFoundException {
        for (EOProject_V0 currentProject : projects) {
            this.migrateFiles(historicView, currentProject);
        }
    }

    private void migrateFiles(HistoricProjectDumpView_0_ historicView, EOProject_V0 currentProject) throws EXDecoderException, JvmExternalResourceInteractionException, FileNotFoundException {
        File projectDirectory = historicView.getProjectDirectory(currentProject);
        File filesDirectory = new File(projectDirectory, FILES_DIRECTORY);
        if (filesDirectory.exists()) {
            File[] fileTypeDirectories;
            File[] fileArray = fileTypeDirectories = filesDirectory.listFiles();
            int n = fileTypeDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File fileTypeDirectory = fileArray[n2];
                this.migrateFileType(fileTypeDirectory);
                ++n2;
            }
        }
    }

    private void migrateFileType(File fileTypeDirectory) throws EXDecoderException, JvmExternalResourceInteractionException, FileNotFoundException {
        File[] fileDirectories;
        File[] fileArray = fileDirectories = fileTypeDirectory.listFiles();
        int n = fileDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File fileDirectory = fileArray[n2];
            this.migrateFile(fileDirectory);
            ++n2;
        }
    }

    private void migrateFile(File fileDirectory) throws EXDecoderException, JvmExternalResourceInteractionException, FileNotFoundException {
        File historyFile_old = new File(fileDirectory, "versions");
        if (historyFile_old.exists()) {
            EOList historyItems = (EOList)xmlDecoder.decodeXML((InputStream)new FileInputStream(historyFile_old), EOFACTORY, true);
            ArrayList<FileMover> fileMovers = new ArrayList<FileMover>(historyItems.size());
            for (EOFileHistoryItem_V0 historyItem : historyItems) {
                String oldFilename = historyItem.getExternalVersionID();
                String newFilename = Integer.toString(historyItem.getVersionNumber());
                fileMovers.add(new FileMover(fileDirectory, oldFilename, newFilename));
            }
            for (FileMover fileMover : fileMovers) {
                fileMover.moveToTarget();
            }
            File historyFile_new = new File(fileDirectory, "versions1");
            FileHelper.moveFile((File)historyFile_old, (File)historyFile_new);
        }
    }

    private class FileMover {
        private final File tempFile;
        private final File targetFile;

        private FileMover(File directory, String sourceFileName, String targetFileName) throws JvmExternalResourceInteractionException {
            String tempFilename = UUIDGenerator.getUniqueID();
            File sourceFile = new File(directory, sourceFileName);
            this.tempFile = new File(directory, tempFilename);
            this.targetFile = new File(directory, targetFileName);
            FileHelper.moveFile((File)sourceFile, (File)this.tempFile);
        }

        private void moveToTarget() throws JvmExternalResourceInteractionException {
            FileHelper.moveFile((File)this.tempFile, (File)this.targetFile);
        }
    }
}

