/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.version0;

import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOSection_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_;
import com.arcway.cockpit.frame.client.project.migration.migrators.version0.MigratorHelper_V0;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class EditSectionPermissionMigrator
implements ICockpitMigrator {
    private static final ILogger logger = Logger.getLogger(EditSectionPermissionMigrator.class);
    public static final String KEY = "frame.EditSectionPermissionMigrator";
    public static final String OPERATION_MODIFY_FOLDERS = "modifyFolders";
    public static final String OPERAND_TYPE_PROJECT = "project";
    public static final String OPERAND_TYPE_SECTION = "section";

    @Override
    public String getKey() {
        return KEY;
    }

    @Override
    public int getSourceVersion() {
        return 0;
    }

    @Override
    public List<String> getRequiredPreceedingMigrators() {
        return Collections.singletonList("com.arcway.cockpit.frame.client.project.migration.migrators.version0.sectionsandplansfilemigrator");
    }

    @Override
    public IEncodableObjectFactory getRequiredEOFactoryForProjectFileMainData() {
        return V0_EOFactory.getDefault();
    }

    @Override
    public void migrateACT(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        this.migrateACTOrACP(projectFile);
    }

    @Override
    public void migrateProjectDump(IHistoricProjectDumpView projectDump) throws MigrationFailedException {
        HistoricProjectDumpView_0_ historicView = (HistoricProjectDumpView_0_)projectDump;
        try {
            for (EOProject_V0 currentProject : historicView.getAllProjects()) {
                EOList<EOPermission> permissions = historicView.readPermissions(currentProject);
                EncodableObjectBase sectionsEO = historicView.readDataFile(currentProject, "sections.xml", null, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory.getDefault(), PSCPlainMessageDataFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
                EOList sections = null;
                if (!(sectionsEO instanceof EOList)) {
                    String error = "Sections file does not contain an EOList: " + sectionsEO.getClass().getName();
                    logger.error(error);
                    throw new MigrationFailedException(error);
                }
                sections = (EOList)sectionsEO;
                this.migratePermissions((Collection<?>)permissions, (Collection<?>)sections);
            }
        }
        catch (EXDecoderException eDE) {
            throw new MigrationFailedException(eDE);
        }
    }

    @Override
    public void migrateServerDump(IHistoricServerDumpView serverDump) {
        HistoricServerDumpView_0_ historicView = (HistoricServerDumpView_0_)serverDump;
        EOList<EOPermission> permissions = historicView.getPermissionList();
        HashSet<EOPermission> permissionsToRemove = new HashSet<EOPermission>();
        for (EOPermission permission : permissions) {
            if (!permission.getOperation().equals(OPERATION_MODIFY_FOLDERS) || !permission.getOperandType().equals(OPERAND_TYPE_PROJECT)) continue;
            permissionsToRemove.add(permission);
        }
        permissions.removeAll(permissionsToRemove);
    }

    private void migrateACTOrACP(IHistoricProjectFileView projectFile) throws MigrationFailedException {
        try {
            HistoricProjectFileView_0_ projectFileView_0_ = (HistoricProjectFileView_0_)projectFile;
            EOList<? extends EncodableObjectBase> permissions = projectFileView_0_.getDataList("permissions");
            EOList<? extends EncodableObjectBase> sections = projectFileView_0_.getDataList("sections");
            this.migratePermissions((Collection<?>)permissions, (Collection<?>)sections);
        }
        catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
            logger.error("Can not migrate project file.", (Throwable)pfaE);
            throw new MigrationFailedException(pfaE);
        }
    }

    private void migratePermissions(Collection<?> permissions, Collection<?> sections) {
        HashSet<EOPermission> permissionsToMigrate = new HashSet<EOPermission>();
        for (Object eo : permissions) {
            if (eo instanceof EOPermission) {
                EOPermission permission = (EOPermission)eo;
                if (!permission.getOperation().equals(OPERATION_MODIFY_FOLDERS) || !permission.getOperandType().equals(OPERAND_TYPE_PROJECT)) continue;
                permissionsToMigrate.add(permission);
                continue;
            }
            logger.warn("Permissions list contains object which is not of type EOPermission: " + eo.getClass().getName());
        }
        if (!permissionsToMigrate.isEmpty()) {
            EOSection_V0 rootSection = null;
            for (Object eo : sections) {
                if (eo instanceof EOSection_V0) {
                    EOSection_V0 section = (EOSection_V0)((Object)eo);
                    if (!MigratorHelper_V0.isRootSection(section)) continue;
                    rootSection = section;
                    break;
                }
                logger.warn("Permissions list contains object which is not of type EOPermission: " + eo.getClass().getName());
            }
            if (rootSection != null) {
                for (EOPermission permission : permissionsToMigrate) {
                    permission.setOperandType(OPERAND_TYPE_SECTION);
                    permission.setOperandUID(rootSection.getUID());
                }
            } else {
                logger.warn("Couldn't find root section for migrating \"edit section\" permissions. Deleting the permissions.");
                permissions.removeAll(permissionsToMigrate);
            }
        }
    }
}

