/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.migrators.special;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.FileHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UserGroupDataMigrationMap {
    private static final ILogger LOGGER = Logger.getLogger(UserGroupDataMigrationMap.class);
    private static final String TAG_UserNameMapping = "UserNameMapping";
    private static final String TAG_GroupNameMapping = "GroupNameMapping";
    private final Map<String, String> usernameMapping = new LinkedHashMap<String, String>();
    private final Map<String, String> groupnameMapping = new LinkedHashMap<String, String>();

    public UserGroupDataMigrationMap(File dumpFile) throws MigrationFailedException {
        String key;
        try {
            File usersAndGroupsMappings = new File(dumpFile.getParentFile(), String.valueOf(FileHelper.getFileNameWithoutExtension((String)dumpFile.getName())) + ".UserAndGroupMappings".toLowerCase());
            if (usersAndGroupsMappings.canRead()) {
                Document document = UserGroupDataMigrationMap.readXmlFile(usersAndGroupsMappings);
                NodeList childNodes = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < childNodes.getLength()) {
                    Node childNode = childNodes.item(i);
                    switch (childNode.getNodeType()) {
                        case 1: {
                            String tagName = ((Element)childNode).getTagName();
                            if (TAG_UserNameMapping.equals(tagName) || TAG_GroupNameMapping.equals(tagName)) break;
                            throw new MigrationFailedException("Unexpected UserAndGroupMappings file format: found illegal tag \"" + tagName + "\", allowed toplevel-childs-tags are: " + TAG_UserNameMapping + ", " + TAG_GroupNameMapping);
                        }
                        case 8: {
                            break;
                        }
                        case 3: {
                            if (childNode.getTextContent().trim().length() <= 0) break;
                            throw new MigrationFailedException("Unexpected UserAndGroupMappings file format: found illegal text: \"" + childNode.getTextContent() + "\"");
                        }
                        default: {
                            throw new MigrationFailedException("Unexpected UserAndGroupMappings file format: found illegal Node of type " + childNode.getNodeType() + "TextContent: \"" + childNode.getTextContent() + "\"");
                        }
                    }
                    ++i;
                }
                NodeList userNameMappingElements = document.getElementsByTagName(TAG_UserNameMapping);
                UserGroupDataMigrationMap.parseMappings(userNameMappingElements, this.usernameMapping);
                NodeList groupNameMappingElements = document.getElementsByTagName(TAG_GroupNameMapping);
                UserGroupDataMigrationMap.parseMappings(groupNameMappingElements, this.groupnameMapping);
            }
        }
        catch (ParserConfigurationException e) {
            throw new MigrationFailedException("Problem while reading UserGroupDataMigrationMap file", e);
        }
        catch (SAXException e) {
            throw new MigrationFailedException("Problem while reading UserGroupDataMigrationMap file", e);
        }
        catch (IOException e) {
            throw new MigrationFailedException("Problem while reading UserGroupDataMigrationMap file", e);
        }
        int longestKeysLength = 0;
        ArrayList<String> allkeys = new ArrayList<String>(this.usernameMapping.size() + this.groupnameMapping.size());
        allkeys.addAll(this.usernameMapping.keySet());
        allkeys.addAll(this.groupnameMapping.keySet());
        for (String key2 : allkeys) {
            longestKeysLength = Math.max(longestKeysLength, key2.length());
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < longestKeysLength) {
            sb.append(' ');
            ++i;
        }
        String lkws = sb.toString();
        String LINE_DELIM = System.getProperty("line.separator", "\n");
        StringBuilder sb2 = new StringBuilder();
        sb2.append(String.valueOf(UserGroupDataMigrationMap.class.getName()) + " - read the following Mappings:").append(LINE_DELIM);
        sb2.append("Username Mappings:").append(LINE_DELIM);
        for (Map.Entry<String, String> entry : this.usernameMapping.entrySet()) {
            key = entry.getKey();
            sb2.append("    \"").append(key).append("\"").append(lkws.substring(key.length())).append(" => \"").append(entry.getValue()).append("\"").append(LINE_DELIM);
        }
        sb2.append("Groupname Mappings:").append(LINE_DELIM);
        for (Map.Entry<String, String> entry : this.groupnameMapping.entrySet()) {
            key = entry.getKey();
            sb2.append("    \"").append(key).append("\"").append(lkws.substring(key.length())).append(" => \"").append(entry.getValue()).append("\"").append(LINE_DELIM);
        }
        LOGGER.info(sb2.substring(0, sb2.length() - LINE_DELIM.length()));
    }

    public String translateUsername(String username) {
        String translatedUsername = this.usernameMapping.get(username);
        if (translatedUsername != null) {
            return translatedUsername;
        }
        return username;
    }

    public String translateGroupname(String groupname) {
        String translatedGroupname = this.groupnameMapping.get(groupname);
        if (translatedGroupname != null) {
            return translatedGroupname;
        }
        return groupname;
    }

    public boolean isIdentityMapping() {
        return this.usernameMapping.isEmpty() && this.groupnameMapping.isEmpty();
    }

    private static Document readXmlFile(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    private static void parseMappings(NodeList mappingElements, Map<String, String> mappingTable) throws MigrationFailedException {
        int i = 0;
        while (i < mappingElements.getLength()) {
            NodeList childNodes;
            NodeList childNodes2;
            Element userNameMappingElement = (Element)mappingElements.item(i);
            NodeList oldnameElements = userNameMappingElement.getElementsByTagName("oldName");
            String oldname = null;
            if (oldnameElements.getLength() == 1 && (childNodes2 = oldnameElements.item(0).getChildNodes()).getLength() == 1) {
                Node childNode = childNodes2.item(0);
                oldname = childNode.getTextContent();
            }
            NodeList newnameElements = userNameMappingElement.getElementsByTagName("newName");
            String newname = null;
            if (oldnameElements.getLength() == 1 && (childNodes = newnameElements.item(0).getChildNodes()).getLength() == 1) {
                Node childNode = childNodes.item(0);
                newname = childNode.getTextContent();
            }
            if (oldname == null) {
                throw new MigrationFailedException("Illegal oldname \"" + oldname + "\" specification.");
            }
            if (newname == null || newname.length() == 0 || newname.length() > 63 || !newname.equals(newname.trim())) {
                throw new MigrationFailedException("Illegal newname \"" + newname + "\" specification ( (0 < length <= 63) && (newname = newname.trim()) ).");
            }
            if (mappingTable.containsKey(oldname)) {
                throw new MigrationFailedException("Two rename specifications for the same oldname \"" + oldname + "\"");
            }
            if (mappingTable.containsValue(newname)) {
                throw new MigrationFailedException("Two rename specifications mapping to the same newname \"" + newname + "\"");
            }
            mappingTable.put(oldname, newname);
            ++i;
        }
    }
}

