/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0;

import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class HistoricProjectFileView_0_
implements IHistoricProjectFileView {
    private static final ILogger logger = Logger.getLogger(HistoricProjectFileView_0_.class);
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_UNIQUE_ELEMENT_RELATIONSHIPS = "uniqueElementContainment";
    public static final String TAG_STAKEHOLDERS = "stakeholders";
    public static final String TAG_STAKEHOLDER_ROLES = "stakeholder roles";
    public static final String TAG_STAKEHOLDER_ROLE_CONNECTIONS = "stakeholder role connections";
    public static final String TAG_UNIQUE_ELEMENTS = "unique elements";
    public static final String TAG_UNIQUE_ELEMENT_OCCURENCES = "unique element occurences";
    public static final String TAG_SECTIONS = "sections";
    public static final String TAG_PLANS = "plans";
    public static final String TAG_LINKS = "links";
    public static final String TAG_REMAINING_PERMISSIONS = "remainingPermissions";
    public static final String TAG_PERMISSIONS = "permissions";
    public static final String TAG_MODULE_DATA = "module data";
    public static final String TAG_FRAME_DATA = "frame_data";
    public static final String TAG_SERVER_USERS_AND_GROUPS = "serverusersandgroups";
    public static final String TAG_USER_DEFINED_ATTRIBUTE_TYPES = "userDefinedAttributeTypes";
    private final ProjectFileAccess projectFile;
    private final IEncodableObjectFactory eoFactory;
    private EOList<EOList<? extends EncodableObjectBase>> mainData;

    public HistoricProjectFileView_0_(ProjectFileAccess projectFile, IEncodableObjectFactory eoFactory) {
        this.projectFile = projectFile;
        this.eoFactory = new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{this.getBaseEOFactory(), eoFactory});
    }

    protected IEncodableObjectFactory getBaseEOFactory() {
        return V0_EOFactory.getDefault();
    }

    public File getRootDirectoryOfUnzippedProjectFile() throws ProjectFileAccess.ProjectFileAccessException {
        File root = this.projectFile.getRootDirectoryOfUnzippedProjectFile();
        if (root != null && root.exists() && root.isDirectory()) {
            return root;
        }
        return null;
    }

    public EOList<EOList<? extends EncodableObjectBase>> getMainData() throws ProjectFileAccess.ProjectFileAccessException {
        if (this.mainData == null) {
            this.readMainData();
        }
        return this.mainData;
    }

    public EOList<? extends EncodableObjectBase> getDataList(String tag) throws ProjectFileAccess.ProjectFileAccessException {
        if (this.mainData == null) {
            this.readMainData();
        }
        if (this.mainData != null) {
            for (EOList dataList : this.mainData) {
                if (!dataList.getRole().equals(tag)) continue;
                return dataList;
            }
        }
        return null;
    }

    public EOProject_V0 getProjectMetaData() throws ProjectFileAccess.ProjectFileAccessException {
        EOList<? extends EncodableObjectBase> projectMetaDataList = this.getDataList(TAG_METADATA);
        if (projectMetaDataList != null && !projectMetaDataList.isEmpty() && projectMetaDataList.get(0) instanceof EOProject_V0) {
            return (EOProject_V0)projectMetaDataList.get(0);
        }
        return null;
    }

    public File getFilesRoot() throws ProjectFileAccess.ProjectFileAccessException {
        File filesRoot;
        File root = this.getRootDirectoryOfUnzippedProjectFile();
        if (root != null && (filesRoot = new File(this.getRootDirectoryOfUnzippedProjectFile(), "files")).exists() && filesRoot.isDirectory()) {
            return filesRoot;
        }
        return null;
    }

    public File getDirectoryWithFilesOfType(String fileTypeID) throws ProjectFileAccess.ProjectFileAccessException {
        File filesDirectory;
        File filesRoot = this.getFilesRoot();
        if (filesRoot != null && (filesDirectory = new File(filesRoot, fileTypeID)).exists() && filesDirectory.isDirectory()) {
            return filesDirectory;
        }
        return null;
    }

    public Collection<File> getAllDirectoriesWithFiles() throws ProjectFileAccess.ProjectFileAccessException {
        ArrayList<File> fileDirectories = new ArrayList<File>();
        File filesRoot = this.getFilesRoot();
        if (filesRoot != null) {
            File[] potentialFileDirectories;
            File[] fileArray = potentialFileDirectories = filesRoot.listFiles();
            int n = potentialFileDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File potentialFileDirectory = fileArray[n2];
                if (potentialFileDirectory.exists() && potentialFileDirectory.isDirectory()) {
                    fileDirectories.add(potentialFileDirectory);
                }
                ++n2;
            }
        }
        return fileDirectories;
    }

    private void readMainData() throws ProjectFileAccess.ProjectFileAccessException {
        File root = this.getRootDirectoryOfUnzippedProjectFile();
        if (root != null) {
            try {
                File mainDataFile = new File(root, "maindata");
                XMLFileAccessor mainDataXMLFileAccessor = new XMLFileAccessor(mainDataFile, this.eoFactory);
                this.mainData = (EOList)mainDataXMLFileAccessor.read();
            }
            catch (EXDecoderException exDE) {
                logger.error("Exception when reading main data from project file.", (Throwable)exDE);
                this.mainData = null;
                throw new ProjectFileAccess.ProjectFileAccessException((Exception)((Object)exDE));
            }
            catch (IOException ioE) {
                logger.error("Exception when reading main data from project file.", (Throwable)ioE);
                this.mainData = null;
                throw new ProjectFileAccess.ProjectFileAccessException(ioE);
            }
        }
    }

    @Override
    public void closeView() throws ProjectFileAccess.ProjectFileAccessException {
        if (this.mainData != null) {
            File root = this.getRootDirectoryOfUnzippedProjectFile();
            if (root != null) {
                try {
                    File mainDataFile = new File(root, "maindata");
                    if (mainDataFile.exists()) {
                        FileHelper.deleteExistingFileOrDirectory((File)mainDataFile);
                    }
                    XMLFileAccessor mainDataXMLFileAccessor = new XMLFileAccessor(mainDataFile, this.eoFactory);
                    mainDataXMLFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOList<? extends EncodableObjectBase>>>(){

                        public EOList<EOList<? extends EncodableObjectBase>> getFileContent() {
                            return HistoricProjectFileView_0_.this.mainData;
                        }
                    });
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.error("Exception when writing back main data from project file.", (Throwable)jeriE);
                    throw new ProjectFileAccess.ProjectFileAccessException((Exception)((Object)jeriE));
                }
            } else {
                logger.error("Exception when writing back main data from project file - root directory unavailable.");
            }
        }
    }
}

