/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_dumps.version0;

import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class HistoricServerDumpView_0_
implements IHistoricServerDumpView {
    private static final ILogger logger = Logger.getLogger(HistoricServerDumpView_0_.class);
    private static final String FILENAME_PERMISSIONS = "pscPermissionTable.xml";
    private static final XMLDecoder xmlDecoder = new XMLDecoder();
    private final ServerDumpFileAccess_ForClient serverDump;
    private EOList<EOPermission> permissions;

    public HistoricServerDumpView_0_(ServerDumpFileAccess_ForClient serverDump) {
        this.serverDump = serverDump;
    }

    public File getRootDirectoryOfUnzippedServerDumpFile() {
        return this.serverDump.getRootDirectoryOfUnzippedServerDumpFile();
    }

    public EOList<EOPermission> getPermissionList() {
        if (this.permissions == null) {
            this.permissions = this.readPermissionFile();
        }
        return this.permissions;
    }

    @Override
    public void closeView() throws DumpFileAccessException {
        if (this.permissions != null) {
            File root = this.serverDump.getRootDirectoryOfUnzippedServerDumpFile();
            if (root != null) {
                try {
                    File permissionsFile = new File(root, FILENAME_PERMISSIONS);
                    if (permissionsFile.exists()) {
                        FileHelper.deleteExistingFileOrDirectory((File)permissionsFile);
                    }
                    XMLFileAccessor permissionsXMLFileAccessor = new XMLFileAccessor(permissionsFile, null);
                    permissionsXMLFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOPermission>>(){

                        public EOList<EOPermission> getFileContent() {
                            return HistoricServerDumpView_0_.this.permissions;
                        }
                    });
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.error("Exception when writing back permissions from server dump.", (Throwable)jeriE);
                    throw new DumpFileAccessException((Exception)((Object)jeriE));
                }
            } else {
                logger.error("Exception when writing back permissions from server dump - root directory unavailable.");
            }
        }
    }

    private EOList<EOPermission> readPermissionFile() {
        File permissionFile = new File(this.getRootDirectoryOfUnzippedServerDumpFile(), FILENAME_PERMISSIONS);
        EncodableObjectBase eo = this.readEOFromFile(permissionFile);
        if (eo instanceof EOList) {
            return (EOList)eo;
        }
        logger.error("Unexpected format of permissions in server dump file.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncodableObjectBase readEOFromFile(File sourceFile) {
        try {
            XMLDecoder xMLDecoder = xmlDecoder;
            synchronized (xMLDecoder) {
                return xmlDecoder.decodeXML((InputStream)new FileInputStream(sourceFile), (IEncodableObjectFactory)PSCPlainMessageDataFactory.getDefault(), true);
            }
        }
        catch (FileNotFoundException e) {
            logger.error("Exception when reading permissions from server dump file.", (Throwable)e);
            return null;
        }
        catch (EXDecoderException e) {
            logger.error("Exception when reading permissions from server dump file.", (Throwable)e);
            return null;
        }
    }
}

