/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_dumps;

import com.arcway.cockpit.frame.shared.ProjectDumpFileAccess;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.dump.DumpFileHelper;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class ProjectDumpFileAccess_ForClient
extends ProjectDumpFileAccess {
    private static final ILogger logger = Logger.getLogger(ProjectDumpFileAccess_ForClient.class);
    private static final String UNZIP_DIRECTORY_NAME = "cockpit_projectdump_tmp";

    public ProjectDumpFileAccess_ForClient(File projectDumpFile) throws DumpFileAccessException {
        super(projectDumpFile);
        this.init();
    }

    public void saveToTarget(File targetFile) throws DumpFileAccessException {
        if (this.isCreatedFromProjectDumpFile()) {
            try {
                File versionFile = new File(this.getRootDirectoryOfUnzippedProjectDumpFile(), "versions.xml");
                if (versionFile.exists()) {
                    FileHelper.deleteExistingFileOrDirectory((File)versionFile);
                }
                EOVersionFileContent versions = new EOVersionFileContent("cockpit.project-dump", Collections.emptyMap());
                versions.putVersion("COCKPIT_FRAME", Integer.valueOf(7));
                versions.writeToFile(versionFile);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                logger.error("Can't update version file.", (Throwable)jeriE);
                throw new DumpFileAccessException((Exception)((Object)jeriE));
            }
            catch (IOException ioE) {
                logger.error("Can't update version file.", (Throwable)ioE);
                throw new DumpFileAccessException((Exception)ioE);
            }
        } else {
            throw new DumpFileAccessException("This project dump file access may not be saved to a file, since it has been created from a project dump directory in a server dump");
        }
        this.rezipToTarget(targetFile);
        this.dispose_internal();
    }

    protected File createRootDirectoryOfUnzippedProjectDumpFile() throws DumpFileAccessException {
        try {
            return SessionTempDirectoryManager.createSessionTempSubDirectory((String)UNZIP_DIRECTORY_NAME);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't create a temp directory for extracting a project dump file.", (Throwable)jeriE);
            throw new DumpFileAccessException((Exception)((Object)jeriE));
        }
    }

    protected EncodableObjectBase readVersionFromFile(File sourceFile) throws DumpFileAccessException {
        try {
            return DumpFileHelper.readVersionsFromFile((File)sourceFile);
        }
        catch (EXDecoderException exDE) {
            throw new DumpFileAccessException((Exception)((Object)exDE));
        }
        catch (IOException ioE) {
            throw new DumpFileAccessException((Exception)ioE);
        }
    }

    private void rezipToTarget(File targetFile) throws DumpFileAccessException {
        try {
            if (targetFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory((File)targetFile);
            }
            Zip.createZipFile((File)this.getRootDirectoryOfUnzippedProjectDumpFile(), (File)targetFile);
        }
        catch (IOException ioE) {
            logger.error("Can't rezip project dump file to target directory (" + targetFile.getAbsolutePath() + ").", (Throwable)ioE);
            throw new DumpFileAccessException((Exception)ioE);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't rezip project dump file to target directory (" + targetFile.getAbsolutePath() + "). Can't delete existing target file.", (Throwable)jeriE);
            throw new DumpFileAccessException((Exception)((Object)jeriE));
        }
    }

    public static void extractProjectDump(ServerDumpFileAccess_ForClient serverDumpAccess, EOProject selectedProject, File targetFile) throws DumpFileAccessException {
        SessionTempDirectoryManager.SessionTempDirectory tempDirectory = null;
        try {
            try {
                tempDirectory = SessionTempDirectoryManager.createSessionTempSubDirectory((String)"prjdex");
                File generatedProjectsFile = new File((File)tempDirectory, "projects.xml");
                File generatedVersionsFile = new File((File)tempDirectory, "versions.xml");
                File frameModuleDirectory = serverDumpAccess.getModuleDirectory("COCKPIT_FRAME");
                if (frameModuleDirectory == null) {
                    throw new DumpFileAccessException("Invalid Server Dump: File does not contain the frame module directory (COCKPIT_FRAME)");
                }
                File projectDataDirectory = new File(frameModuleDirectory, selectedProject.getUID());
                EOList projects = new EOList("projects");
                projects.add((EncodableObjectBase)selectedProject);
                projects.writeToFile(generatedProjectsFile);
                EOVersionFileContent versions = new EOVersionFileContent("cockpit.project-dump", Collections.emptyMap());
                versions.putVersion("COCKPIT_FRAME", Integer.valueOf(7));
                versions.putVersion("cmm", Integer.valueOf(3));
                versions.writeToFile(generatedVersionsFile);
                ArrayList<File> projectDumpIngredients = new ArrayList<File>(3);
                projectDumpIngredients.add(generatedProjectsFile);
                projectDumpIngredients.add(generatedVersionsFile);
                projectDumpIngredients.add(projectDataDirectory);
                Zip.createZipFile(projectDumpIngredients, (File)targetFile);
            }
            catch (IOException ioE) {
                logger.error("Can't rezip project dump file to target directory (" + targetFile.getAbsolutePath() + ").", (Throwable)ioE);
                throw new DumpFileAccessException((Exception)ioE);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                logger.error("Can't rezip project dump file to target directory (" + targetFile.getAbsolutePath() + "). Can't delete existing target file.", (Throwable)jeriE);
                throw new DumpFileAccessException((Exception)((Object)jeriE));
            }
        }
        finally {
            try {
                if (tempDirectory != null) {
                    FileHelper.deleteFileOrDirectory((File)tempDirectory);
                }
            }
            catch (JvmExternalResourceInteractionException jeri) {
                logger.warn("Problem while deleting obsolete temp files.", (Throwable)jeri);
            }
        }
    }
}

