/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version5;

import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOAttribute_V5;
import com.arcway.cockpit.frame.client.project.migration.access_both.version5.EOCockpitProjectData_V5;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EOFrameData_V5
extends EOCockpitProjectData_V5 {
    public static final String XML_NAME = "frame.frameData";
    private Collection<EOAttribute_V5> attributes = new ArrayList<EOAttribute_V5>();
    private final Map oldAttributes = new HashMap();
    private final Collection oldChildren = new ArrayList();

    public EOFrameData_V5 copy() {
        EOFrameData_V5 copy = new EOFrameData_V5(this.getTag());
        copy.setUID(this.getUID());
        copy.setProjectUID(this.getProjectUID());
        copy.setTypeID(this.getTypeID());
        copy.setModCount(this.getModCount());
        copy.setCommitCount(this.getCommitCount());
        for (EOAttribute_V5 attribute : this.getAttributes()) {
            copy.addAttribute(attribute);
        }
        return copy;
    }

    public EOFrameData_V5() {
        super(XML_NAME);
    }

    public EOFrameData_V5(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOFrameData_V5(EOFrameData_V5 frameData, String xmlName) {
        super(xmlName, frameData);
        this.attributes = new ArrayList<EOAttribute_V5>();
        for (EOAttribute_V5 eoAttribute : frameData.getAttributes()) {
            this.attributes.add(new EOAttribute_V5(eoAttribute));
        }
    }

    public EOFrameData_V5(String xmlName) {
        super(xmlName);
    }

    public EOFrameData_V5(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    public void addAttribute(EOAttribute_V5 attribute) {
        Iterator<EOAttribute_V5> i = this.attributes.iterator();
        while (i.hasNext()) {
            EOAttribute_V5 contained = i.next();
            if (!contained.getAttributeTypeUID().getEOAttributeTypeID().equals(attribute.getAttributeTypeUID().getEOAttributeTypeID())) continue;
            i.remove();
            break;
        }
        this.attributes.add(attribute);
    }

    public Collection<EOAttribute_V5> getAttributes() {
        return this.attributes;
    }

    public String getOldAttributeValue(String name) {
        return (String)this.oldAttributes.get(name);
    }

    public Map getOldAttributes() {
        return this.oldAttributes;
    }

    public void clearOldAttribute(String name) {
        this.oldAttributes.remove(name);
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean isAttributeOfSuperType = super.setAttributeFromXML(name, value);
        if (!isAttributeOfSuperType) {
            this.oldAttributes.put(name, value);
            return true;
        }
        return true;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttributesToXML(writeContext);
        for (String name : this.oldAttributes.keySet()) {
            String value = (String)this.oldAttributes.get(name);
            this.appendAttrToXML(writeContext, name, value);
        }
    }

    @Override
    protected boolean hasChildren() {
        return super.hasChildren() || !this.attributes.isEmpty() || !this.oldChildren.isEmpty();
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        super.writeChildrenToXML(writeContext, depth);
        for (EOAttribute_V5 attribute : this.attributes) {
            attribute.writeXMLBody(writeContext, depth);
        }
        for (EncodableObjectBase eo : this.oldChildren) {
            eo.writeXMLBody(writeContext, depth);
        }
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean isChildOfSuperType = super.addChildFromXML(newChild);
        if (!isChildOfSuperType) {
            if (newChild instanceof EOAttribute_V5) {
                this.attributes.add((EOAttribute_V5)newChild);
                return true;
            }
            this.oldChildren.add(newChild);
            return true;
        }
        return true;
    }

    public Collection getOldChildren() {
        return this.oldChildren;
    }

    @Deprecated
    public void setOldAttributes(Map attributes) {
        this.oldAttributes.clear();
        for (String name : attributes.keySet()) {
            String value = (String)attributes.get(name);
            this.oldAttributes.put(name, value);
        }
    }

    @Deprecated
    public void setOldChildren(Collection children) {
        this.oldChildren.clear();
        for (Object child : children) {
            this.oldChildren.add(child);
        }
    }
}

